/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho.dyld;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.macho.dyld.DyldCacheSlideInfoCommon;
import ghidra.app.util.bin.format.macho.dyld.DyldFixup;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class DyldCacheSlideInfo3
extends DyldCacheSlideInfoCommon {
    private static final int DYLD_CACHE_SLIDE_V3_PAGE_ATTR_NO_REBASE = 65535;
    private int pageSize;
    private int pageStartsCount;
    private long authValueAdd;
    private short[] pageStarts;

    public int getPageSize() {
        return this.pageSize;
    }

    public int getPageStartsCount() {
        return this.pageStartsCount;
    }

    public long getAuthValueAdd() {
        return this.authValueAdd;
    }

    public short[] getPageStarts() {
        return this.pageStarts;
    }

    public DyldCacheSlideInfo3(BinaryReader reader, long mappingAddress, long mappingSize, long mappingFileOffset) throws IOException {
        super(reader, mappingAddress, mappingSize, mappingFileOffset);
        this.pageSize = reader.readNextInt();
        this.pageStartsCount = reader.readNextInt();
        reader.readNextInt();
        this.authValueAdd = reader.readNextLong();
        this.pageStarts = reader.readNextShortArray(this.pageStartsCount);
    }

    @Override
    public List<DyldFixup> getSlideFixups(BinaryReader reader, int pointerSize, MessageLog log, TaskMonitor monitor) throws IOException, CancelledException {
        ArrayList<DyldFixup> fixups = new ArrayList<DyldFixup>();
        monitor.initialize((long)this.pageStartsCount, "Getting DYLD Cache V3 slide fixups...");
        for (int index = 0; index < this.pageStartsCount; ++index) {
            monitor.increment();
            long segmentOffset = this.pageSize * index;
            int pageEntry = Short.toUnsignedInt(this.pageStarts[index]);
            if (pageEntry == 65535) continue;
            long pageOffset = pageEntry / 8 * 8;
            fixups.addAll(this.processPointerChain(segmentOffset, pageOffset, reader, monitor));
        }
        return fixups;
    }

    private List<DyldFixup> processPointerChain(long segmentOffset, long pageOffset, BinaryReader reader, TaskMonitor monitor) throws IOException, CancelledException {
        ArrayList<DyldFixup> fixups = new ArrayList<DyldFixup>(1024);
        long delta = -1L;
        while (delta != 0L) {
            monitor.checkCancelled();
            long dataOffset = segmentOffset + pageOffset;
            long chainValue = reader.readLong(dataOffset);
            boolean isAuthenticated = chainValue >>> 63 != 0L;
            delta = (chainValue & 0x3FF8000000000000L) >> 51;
            if (isAuthenticated) {
                long offsetFromSharedCacheBase = chainValue & 0xFFFFFFFFL;
                chainValue = offsetFromSharedCacheBase + this.authValueAdd;
            } else {
                long top8Bits = chainValue & 0x7F80000000000L;
                long bottom43Bits = chainValue & 0x7FFFFFFFFFFL;
                chainValue = top8Bits << 13 | bottom43Bits;
            }
            fixups.add(new DyldFixup(dataOffset, chainValue, 8, null, null));
            pageOffset += delta * 8L;
        }
        return fixups;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType("dyld_cache_slide_info3", 0);
        struct.add(DWORD, "version", "currently 3");
        struct.add(DWORD, "page_size", "currently 4096 (may also be 16384)");
        struct.add(DWORD, "page_starts_count", "");
        struct.add(DWORD, "pad", "");
        struct.add(QWORD, "auth_value_add", "");
        struct.add((DataType)new ArrayDataType(WORD, this.pageStartsCount, 1), "page_starts", "");
        struct.setCategoryPath(new CategoryPath("/MachO"));
        return struct;
    }
}

