/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.omf.omf;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.format.omf.OmfException;
import ghidra.app.util.bin.format.omf.OmfIndex;
import ghidra.app.util.bin.format.omf.OmfString;
import ghidra.app.util.bin.format.omf.OmfUtils;
import ghidra.app.util.bin.format.omf.omf.OmfExternalSymbol;
import ghidra.app.util.bin.format.omf.omf.OmfRecordTypes;
import ghidra.app.util.bin.format.omf.omf.OmfSymbol;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.Integer3DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class OmfComdefRecord
extends OmfExternalSymbol {
    private List<Reference> refs = new ArrayList<Reference>();

    public OmfComdefRecord(BinaryReader reader, boolean isStatic) throws IOException {
        super(reader, isStatic);
    }

    @Override
    public void parseData() throws IOException, OmfException {
        while (this.dataReader.getPointerIndex() < this.dataEnd) {
            OmfString name = OmfUtils.readString(this.dataReader);
            OmfIndex typeIndex = OmfUtils.readIndex(this.dataReader);
            byte dataType = this.dataReader.readNextByte();
            int byteLength = 0;
            if (dataType == 97) {
                OmfCommunalLength numElements = new OmfCommunalLength(this.dataReader);
                OmfCommunalLength elSize = new OmfCommunalLength(this.dataReader);
                byteLength = numElements.value * elSize.value;
                this.refs.add(new Reference(name, typeIndex, numElements, elSize));
            } else {
                OmfCommunalLength communalLength = new OmfCommunalLength(this.dataReader);
                byteLength = communalLength.value;
                this.refs.add(new Reference(name, typeIndex, communalLength, null));
            }
            this.symbols.add(new OmfSymbol(name.str(), typeIndex.value(), 0L, dataType, byteLength));
        }
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType(OmfRecordTypes.getName(this.recordType), 0);
        struct.add(BYTE, "type", null);
        struct.add(WORD, "length", null);
        for (Reference ref : this.refs) {
            struct.add(ref.name.toDataType(), "name", null);
            struct.add(ref.typeIndex.toDataType(), "type_index", null);
            struct.add(BYTE, "data_type", null);
            struct.add(ref.communalLength1.toDataType(), "communal_length", null);
            if (ref.communalLength2 == null) continue;
            struct.add(ref.communalLength2.toDataType(), "communal_length", null);
        }
        struct.add(BYTE, "checksum", null);
        struct.setCategoryPath(new CategoryPath("/OMF"));
        return struct;
    }

    private static class OmfCommunalLength
    implements StructConverter {
        private int numBytes;
        private int value;

        public OmfCommunalLength(BinaryReader reader) throws OmfException, IOException {
            long origIndex = reader.getPointerIndex();
            int b = reader.readNextUnsignedByte();
            if (b <= 128) {
                this.value = b;
            } else if (b == 129) {
                this.value = reader.readNextUnsignedShort();
            } else if (b == 132) {
                this.value = reader.readNextUnsignedShort();
                int hithird = reader.readNextUnsignedByte();
                this.value += hithird << 16;
            } else if (b == 136) {
                this.value = reader.readNextInt();
            } else {
                throw new OmfException("Illegal communal length encoding");
            }
            this.numBytes = (int)(reader.getPointerIndex() - origIndex);
        }

        @Override
        public DataType toDataType() throws DuplicateNameException, IOException {
            StructureDataType struct = new StructureDataType(OmfCommunalLength.class.getSimpleName(), 0);
            switch (this.numBytes) {
                case 1: {
                    struct.add(BYTE, "value", null);
                    break;
                }
                case 3: {
                    struct.add(BYTE, "type", null);
                    struct.add(WORD, "value", null);
                    break;
                }
                case 4: {
                    struct.add(BYTE, "type", null);
                    struct.add((DataType)Integer3DataType.dataType, "value", null);
                    break;
                }
                case 5: {
                    struct.add(BYTE, "type", null);
                    struct.add(DWORD, "value", null);
                }
            }
            struct.setCategoryPath(new CategoryPath("/OMF"));
            return struct;
        }
    }

    private record Reference(OmfString name, OmfIndex typeIndex, OmfCommunalLength communalLength1, OmfCommunalLength communalLength2) {
    }
}

