/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.omf.omf51;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.omf.OmfException;
import ghidra.app.util.bin.format.omf.OmfRecord;
import ghidra.app.util.bin.format.omf.OmfString;
import ghidra.app.util.bin.format.omf.OmfUtils;
import ghidra.app.util.bin.format.omf.omf51.Omf51RecordTypes;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class Omf51ModuleEnd
extends OmfRecord {
    private OmfString moduleName;
    private byte regMsk;

    public Omf51ModuleEnd(BinaryReader reader) throws IOException {
        super(reader);
    }

    @Override
    public void parseData() throws IOException, OmfException {
        this.moduleName = OmfUtils.readString(this.dataReader);
        this.dataReader.readNextByte();
        this.dataReader.readNextByte();
        this.regMsk = this.dataReader.readNextByte();
        this.dataReader.readNextByte();
    }

    public byte getRegisterMask() {
        return this.regMsk;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType(Omf51RecordTypes.getName(this.recordType), 0);
        struct.add(BYTE, "type", null);
        struct.add(WORD, "length", null);
        struct.add(this.moduleName.toDataType(), "name", null);
        struct.add(WORD, "padding", null);
        struct.add(BYTE, "REG MSK", null);
        struct.add(BYTE, "padding", null);
        struct.add(BYTE, "checksum", null);
        struct.setCategoryPath(new CategoryPath("/OMF"));
        return struct;
    }
}

