/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.omf.omf51;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.format.omf.AbstractOmfRecordFactory;
import ghidra.app.util.bin.format.omf.OmfException;
import ghidra.app.util.bin.format.omf.OmfRecord;
import ghidra.app.util.bin.format.omf.OmfUnknownRecord;
import ghidra.app.util.bin.format.omf.OmfUnsupportedRecord;
import ghidra.app.util.bin.format.omf.omf166.Omf166DepList;
import ghidra.app.util.bin.format.omf.omf51.Omf51ModuleEnd;
import ghidra.app.util.bin.format.omf.omf51.Omf51ModuleHeader;
import ghidra.app.util.bin.format.omf.omf51.Omf51RecordTypes;
import java.io.IOException;
import java.util.List;

public class Omf51RecordFactory
extends AbstractOmfRecordFactory {
    public Omf51RecordFactory(ByteProvider provider) {
        super(new BinaryReader(provider, true));
    }

    @Override
    public OmfRecord readNextRecord() throws IOException, OmfException {
        int type = Byte.toUnsignedInt(this.reader.peekNextByte());
        OmfRecord record = switch (type) {
            case 2 -> new Omf51ModuleHeader(this.reader);
            case 4 -> new Omf51ModuleEnd(this.reader);
            case 112 -> new Omf166DepList(this.reader);
            case 6, 8, 14, 16, 18, 22, 24, 38, 40, 42, 44 -> new OmfUnsupportedRecord(this.reader, Omf51RecordTypes.class);
            default -> new OmfUnknownRecord(this.reader);
        };
        record.parseData();
        return record;
    }

    @Override
    public List<Integer> getStartRecordTypes() {
        return List.of(Integer.valueOf(2), Integer.valueOf(112));
    }

    @Override
    public int getEndRecordType() {
        return 4;
    }
}

