/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe;

import ghidra.app.cmd.data.CreateArrayCmd;
import ghidra.app.util.bin.format.pe.LoadConfigDirectory;
import ghidra.app.util.bin.format.pe.NTHeader;
import ghidra.app.util.bin.format.pe.PeUtils;
import ghidra.app.util.importer.MessageLog;
import ghidra.app.util.opinion.AbstractProgramLoader;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.ByteDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.IBO32DataType;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.util.exception.InvalidInputException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;

public class ControlFlowGuard {
    public static String GuardCFFunctionTableName = "GuardCFFunctionTable";
    public static String GuardCFAddressTakenIatTableName = "GuardCFAddressTakenIatTable";
    public static String GuardCfgTableEntryName = "GuardCfgTableEntry";

    public static void markup(LoadConfigDirectory lcd, Program program, MessageLog log, NTHeader ntHeader) {
        ControlFlowGuard.markupCfgFunction("_guard_check_icall", "ControlFlowGuard check", lcd::getCfgCheckFunctionPointer, program, ntHeader, log);
        ControlFlowGuard.markupCfgFunction("_guard_dispatch_icall", "ControlFlowGuard dispatch", lcd::getCfgDispatchFunctionPointer, program, ntHeader, log);
        ControlFlowGuard.markupCfgFunctionTable(lcd, program, log);
        ControlFlowGuard.markupCfgAddressTakenIatEntryTable(lcd, program, log);
        ControlFlowGuard.markupCfgFunction("_guard_ss_verify_failure", "ReturnFlowGuard failure", lcd::getRfgFailureRoutine, program, ntHeader, log);
        ControlFlowGuard.markupCfgFunction("_guard_ss_verify_failure_default", "ReturnFlowGuard default failure", lcd::getRfgFailureRoutineFunctionPointer, program, ntHeader, log);
        ControlFlowGuard.markupCfgFunction("_guard_ss_verify_sp_default", "ReturnFlowGuard verify stack pointer", lcd::getRfgVerifyStackPointerFunctionPointer, program, ntHeader, log);
    }

    private static void markupCfgFunctionTable(LoadConfigDirectory lcd, Program program, MessageLog log) {
        int IMAGE_GUARD_CF_FUNCTION_TABLE_SIZE_MASK = -268435456;
        int IMAGE_GUARD_CF_FUNCTION_TABLE_SIZE_SHIFT = 28;
        long tablePointer = lcd.getCfgFunctionTablePointer();
        long functionCount = lcd.getCfgFunctionCount();
        if (tablePointer == 0L || functionCount <= 0L) {
            return;
        }
        Address tableAddr = program.getAddressFactory().getDefaultAddressSpace().getAddress(tablePointer);
        try {
            program.getSymbolTable().createLabel(tableAddr, GuardCFFunctionTableName, SourceType.IMPORTED);
        }
        catch (InvalidInputException e) {
            log.appendMsg("Unable to label ControlFlowGuard function table: " + e.getMessage());
        }
        LoadConfigDirectory.GuardFlags guardFlags = lcd.getCfgGuardFlags();
        int n = (guardFlags.getFlags() & 0xF0000000) >> 28;
        IBO32DataType ibo32 = new IBO32DataType();
        ByteDataType byteType = ByteDataType.dataType;
        CategoryPath categoryPath = new CategoryPath(CategoryPath.ROOT, new String[]{"CFG"});
        StructureDataType GuardCfgTableEntryType = (StructureDataType)program.getDataTypeManager().getDataType(categoryPath, GuardCfgTableEntryName);
        if (GuardCfgTableEntryType == null) {
            GuardCfgTableEntryType = new StructureDataType(categoryPath, GuardCfgTableEntryName, 0);
            GuardCfgTableEntryType.setPackingEnabled(false);
            GuardCfgTableEntryType.add((DataType)ibo32, "Offset", "");
            if (n > 0) {
                ArrayDataType padType = new ArrayDataType((DataType)byteType, n / byteType.getLength(), byteType.getLength());
                GuardCfgTableEntryType.add((DataType)padType, "Pad", "");
            }
        }
        CreateArrayCmd cmd = new CreateArrayCmd(tableAddr, (int)functionCount, (DataType)GuardCfgTableEntryType, GuardCfgTableEntryType.getLength());
        cmd.applyTo(program);
        Data tableData = program.getListing().getDataAt(tableAddr);
        ControlFlowGuard.createCfgFunctions(program, tableData, log);
    }

    private static void createCfgFunctions(Program program, Data tableData, MessageLog log) {
        if (tableData == null) {
            log.appendMsg("Couldn't find Control Flow Guard tables.");
            return;
        }
        if (!tableData.isArray() || tableData.getNumComponents() < 1) {
            log.appendMsg("Control Flow Guard table seems to be empty.");
            return;
        }
        for (Address target : ControlFlowGuard.getFunctionAddressesFromTable(program, tableData)) {
            AbstractProgramLoader.markAsFunction(program, null, target);
        }
    }

    private static List<Address> getFunctionAddressesFromTable(Program program, Data table) {
        ArrayList<Address> list = new ArrayList<Address>();
        for (int i = 0; i < table.getNumComponents(); ++i) {
            Data entry = table.getComponent(i);
            Data iboData = entry.getComponent(0);
            Object value = iboData.getValue();
            if (!(value instanceof Address)) continue;
            Address addr = (Address)value;
            list.add(addr);
        }
        return list;
    }

    private static void markupCfgAddressTakenIatEntryTable(LoadConfigDirectory lcd, Program program, MessageLog log) {
        long tablePointer = lcd.getGuardAddressIatTableTablePointer();
        long functionCount = lcd.getGuardAddressIatTableCount();
        if (tablePointer == 0L || functionCount <= 0L) {
            return;
        }
        try {
            Data d;
            Address tableAddr = program.getAddressFactory().getDefaultAddressSpace().getAddress(tablePointer);
            program.getSymbolTable().createLabel(tableAddr, GuardCFAddressTakenIatTableName, SourceType.IMPORTED);
            IBO32DataType ibo32 = new IBO32DataType();
            for (long i = 0L; i < functionCount && (d = PeUtils.createData(program, tableAddr.add(i * (long)ibo32.getLength()), (DataType)ibo32, log)) != null; ++i) {
            }
        }
        catch (AddressOutOfBoundsException | InvalidInputException e) {
            log.appendMsg("Unable to label ControlFlowGuard IAT table: " + e.getMessage());
        }
    }

    private static void markupCfgFunction(String label, String description, Supplier<Long> functionPointerGetter, Program program, NTHeader ntHeader, MessageLog log) {
        Address functionAddr;
        if (functionPointerGetter.get() == 0L) {
            return;
        }
        AddressSpace space = program.getAddressFactory().getDefaultAddressSpace();
        Memory mem = program.getMemory();
        SymbolTable symbolTable = program.getSymbolTable();
        boolean is64bit = ntHeader.getOptionalHeader().is64bit();
        Address functionPointerAddr = space.getAddress(functionPointerGetter.get().longValue());
        PeUtils.createData(program, functionPointerAddr, (DataType)PointerDataType.dataType, log);
        try {
            functionAddr = space.getAddress(is64bit ? mem.getLong(functionPointerAddr) : (long)mem.getInt(functionPointerAddr));
        }
        catch (MemoryAccessException e) {
            log.appendMsg("Failed to read %s function pointer address at %s".formatted(description, functionPointerAddr));
            return;
        }
        try {
            symbolTable.createLabel(functionAddr, label, SourceType.IMPORTED);
        }
        catch (AddressOutOfBoundsException | InvalidInputException e) {
            log.appendMsg("Unable to apply label '%s' to %s function at %s: %s".formatted(label, description, functionAddr, e.getMessage()));
        }
        if (program.getListing().getDefinedDataAt(functionAddr) == null) {
            AbstractProgramLoader.markAsFunction(program, null, functionAddr);
        } else {
            log.appendMsg("Unable to mark %s as function at %s. Data is already defined there.".formatted(description, functionAddr));
        }
    }
}

