/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe.cli.tables;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.MemoryByteProvider;
import ghidra.app.util.bin.format.pe.NTHeader;
import ghidra.app.util.bin.format.pe.PeUtils;
import ghidra.app.util.bin.format.pe.cli.blobs.CliAbstractSig;
import ghidra.app.util.bin.format.pe.cli.blobs.CliBlob;
import ghidra.app.util.bin.format.pe.cli.blobs.CliSigMethodDef;
import ghidra.app.util.bin.format.pe.cli.methods.CliMethodDef;
import ghidra.app.util.bin.format.pe.cli.methods.CliMethodExtraSections;
import ghidra.app.util.bin.format.pe.cli.streams.CliAbstractStream;
import ghidra.app.util.bin.format.pe.cli.streams.CliStreamMetadata;
import ghidra.app.util.bin.format.pe.cli.tables.CliAbstractTable;
import ghidra.app.util.bin.format.pe.cli.tables.CliAbstractTableRow;
import ghidra.app.util.bin.format.pe.cli.tables.CliTableParam;
import ghidra.app.util.bin.format.pe.cli.tables.CliTableTypeDef;
import ghidra.app.util.bin.format.pe.cli.tables.CliTableTypeRef;
import ghidra.app.util.bin.format.pe.cli.tables.CliTypeTable;
import ghidra.app.util.bin.format.pe.cli.tables.flags.CliFlags;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.database.function.OverlappingFunctionException;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.lang.PrototypeModel;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionManager;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.ParameterImpl;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.Variable;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.SymbolUtilities;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.util.Msg;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public class CliTableMethodDef
extends CliAbstractTable {
    private static final int CLITABLEMETHODDEF_PINVOKE_JUMP_LENGTH = 6;
    private static final String CLITABLEMETHODDEF_CLRCALL_CONVENTION = "__clrcall";

    public CliTableMethodDef(BinaryReader reader, CliStreamMetadata stream, CliTypeTable tableId) throws IOException {
        super(reader, stream, tableId);
        CliMethodDefRow lastRow = null;
        for (int i = 0; i < this.numRows; ++i) {
            CliMethodDefRow row = new CliMethodDefRow(reader.readNextInt(), reader.readNextShort(), reader.readNextShort(), this.readStringIndex(reader), this.readBlobIndex(reader), this.readTableIndex(reader, CliTypeTable.Param));
            this.rows.add(row);
            this.strings.add(row.nameIndex);
            if (lastRow != null) {
                lastRow.nextRowParamIndex = row.paramIndex;
            }
            lastRow = row;
        }
        reader.setPointerIndex(this.readerOffset);
    }

    @Override
    public void markup(Program program, boolean isBinary, TaskMonitor monitor, MessageLog log, NTHeader ntHeader) throws DuplicateNameException, CodeUnitInsertionException, IOException {
        int methodRowIndex = 0;
        for (CliAbstractTableRow method : this.rows) {
            Address addr;
            ++methodRowIndex;
            CliMethodDefRow methodRow = (CliMethodDefRow)method;
            if (methodRow.RVA == 0) continue;
            Address startAddr = addr = PeUtils.getMarkupAddress(program, isBinary, ntHeader, methodRow.RVA);
            Address endAddr = addr;
            if (methodRow.isPInvokeImpl() && methodRow.isNative()) {
                endAddr = startAddr.add(5L);
            } else {
                BinaryReader reader = new BinaryReader(new MemoryByteProvider(program.getMemory(), addr), !program.getMemory().isBigEndian());
                CliMethodDef methodDef = new CliMethodDef(addr, reader);
                DataType methodDefDataType = methodDef.toDataType();
                PeUtils.createData(program, addr, methodDefDataType, log);
                endAddr = startAddr = addr.add((long)methodDefDataType.getLength());
                if (methodDef.getMethodSize() > 0) {
                    endAddr = startAddr.add((long)(methodDef.getMethodSize() - 1));
                }
                if (methodDef.hasMoreSections()) {
                    int extraSectionOffset = methodDefDataType.getLength() + methodDef.getMethodSize();
                    extraSectionOffset = (extraSectionOffset + 3) / 4 * 4;
                    reader.setPointerIndex(extraSectionOffset);
                    CliMethodExtraSections extraSections = new CliMethodExtraSections(reader);
                    Address extraSectionAddr = addr.add((long)extraSectionOffset);
                    PeUtils.createData(program, extraSectionAddr, extraSections.toDataType(), log);
                }
            }
            AddressSet funcAddrSet = new AddressSet(startAddr, endAddr);
            String funcName = null;
            if (methodRow.nameIndex > 0) {
                funcName = SymbolUtilities.replaceInvalidChars((String)this.metadataStream.getStringsStream().getString(methodRow.nameIndex), (boolean)true);
            }
            CliBlob blob = this.metadataStream.getBlobStream().getBlob(methodRow.sigIndex);
            Address sigAddr = CliAbstractStream.getStreamMarkupAddress(program, isBinary, monitor, log, ntHeader, this.metadataStream.getBlobStream(), methodRow.sigIndex);
            CliSigMethodDef methodSig = new CliSigMethodDef(blob);
            this.metadataStream.getBlobStream().updateBlob(methodSig, sigAddr, program);
            DataType returnType = methodSig.getReturnType().getExecutionDataType();
            short maxSequence = 0;
            int stackOffset = 0;
            CliAbstractSig.CliParam[] paramTypes = methodSig.getParamTypes();
            int paramCount = paramTypes.length;
            CliTableParam paramTable = (CliTableParam)this.metadataStream.getTable(CliTypeTable.Param);
            HashMap<Integer, ParameterImpl> parameterList = new HashMap<Integer, ParameterImpl>();
            ParameterImpl staticParameter = null;
            if (methodRow.isStatic() && paramCount > 0) {
                CliAbstractSig.CliTypePtr ptrToValueType;
                CliAbstractSig.CliParam staticParam = paramTypes[0];
                String paramName = "";
                if (staticParam.getType() instanceof CliAbstractSig.CliTypePtr && (ptrToValueType = (CliAbstractSig.CliTypePtr)staticParam.getType()).getType() instanceof CliAbstractSig.CliTypeValueType) {
                    CliAbstractSig.CliTypeValueType valueType = (CliAbstractSig.CliTypeValueType)ptrToValueType.getType();
                    CliTypeTable tableType = valueType.getTable();
                    int rowIndex = valueType.getRowIndex();
                    int paramNameStringIndex = 0;
                    CliAbstractTable table = this.metadataStream.getTable(tableType);
                    CliAbstractTableRow row = table.getRow(rowIndex);
                    if (tableType.id() == CliTypeTable.TypeDef.id()) {
                        CliTableTypeDef.CliTypeDefRow typeDefRow = (CliTableTypeDef.CliTypeDefRow)row;
                        paramNameStringIndex = typeDefRow.typeNameIndex;
                    } else if (tableType.id() == CliTypeTable.TypeRef.id()) {
                        CliTableTypeRef.CliTypeRefRow typeRefRow = (CliTableTypeRef.CliTypeRefRow)row;
                        paramNameStringIndex = typeRefRow.typeNameIndex;
                    }
                    if (paramNameStringIndex > 0) {
                        paramName = this.metadataStream.getStringsStream().getString(paramNameStringIndex);
                        paramName = SymbolUtilities.replaceInvalidChars((String)paramName, (boolean)true);
                        DataType dataType = staticParam.getExecutionDataType();
                        try {
                            staticParameter = new ParameterImpl(paramName, dataType, stackOffset, program);
                        }
                        catch (InvalidInputException e) {
                            Msg.warn((Object)this, (Object)("Error processing parameter \"" + paramName + "\" in function \"" + funcName + "\": " + e.getMessage()));
                        }
                        stackOffset += dataType.getLength();
                        --paramCount;
                    }
                }
            }
            for (int i = 0; i < paramCount; ++i) {
                CliTableParam.CliParamRow paramRow = (CliTableParam.CliParamRow)paramTable.getRow(methodRow.paramIndex + i);
                if (paramRow.sequence > maxSequence) {
                    maxSequence = paramRow.sequence;
                }
                String paramName = SymbolUtilities.replaceInvalidChars((String)this.metadataStream.getStringsStream().getString(paramRow.nameIndex), (boolean)true);
                DataType dataType = paramTypes[i].getExecutionDataType();
                if (paramRow.sequence == 0) {
                    returnType = dataType;
                    continue;
                }
                try {
                    parameterList.put(Integer.valueOf(paramRow.sequence), new ParameterImpl(paramName, dataType, stackOffset, program));
                }
                catch (InvalidInputException e) {
                    Msg.warn((Object)this, (Object)("Error processing parameter \"" + paramName + "\" in function \"" + funcName + "\": " + e.getMessage()));
                }
                stackOffset += dataType.getLength();
            }
            ParameterImpl[] parameters = new ParameterImpl[maxSequence];
            parameterList.forEach((key, value) -> {
                parameters[key.intValue() - 1] = value;
            });
            if (methodRow.isStatic() && staticParameter != null) {
                for (int i = 0; i < parameters.length; ++i) {
                    if (parameters[i] != null) continue;
                    ParameterImpl param = null;
                    try {
                        param = new ParameterImpl(staticParameter.getName() + i, staticParameter.getDataType(), staticParameter.getStackOffset(), staticParameter.getProgram());
                    }
                    catch (InvalidInputException e1) {
                        Msg.warn((Object)this, (Object)("Couldn't clone " + staticParameter.getName() + " implied static function parameter in function : " + funcName + "in position " + i));
                    }
                    parameters[i] = param;
                }
            }
            FunctionManager funcMgr = program.getFunctionManager();
            try {
                Function func = funcMgr.getFunctionAt(startAddr);
                if (func == null) {
                    func = funcMgr.createFunction(funcName, startAddr, (AddressSetView)funcAddrSet, SourceType.ANALYSIS);
                }
                func.setReturnType(returnType, SourceType.ANALYSIS);
                func.updateFunction(null, null, Function.FunctionUpdateType.DYNAMIC_STORAGE_ALL_PARAMS, true, SourceType.ANALYSIS, (Variable[])parameters);
                this.markToPreventIncorrectProcessorDisassembly(program, methodRow, startAddr, endAddr);
            }
            catch (CodeUnitInsertionException func) {
            }
            catch (NullPointerException e) {
                Msg.warn((Object)this, (Object)("Error processing function \"" + funcName + "\" (" + methodRowIndex + "): Bad parameters provided"));
            }
            catch (InvalidInputException e) {
                Msg.warn((Object)this, (Object)("Error processing function \" (\" + methodRowIndex + \")" + funcName + "\": Invalid function"));
            }
            catch (OverlappingFunctionException e) {
                String err = "Error processing function \" (\" + methodRowIndex + \")" + funcName + "\": Overlapping function (" + String.valueOf(startAddr) + ", " + String.valueOf(endAddr) + ": ";
                Function existingFuncA = funcMgr.getFunctionContaining(startAddr);
                Function existingFuncB = funcMgr.getFunctionContaining(endAddr);
                if (existingFuncA != null && existingFuncB == null) {
                    err = err + existingFuncA.getName();
                } else if (existingFuncA == null && existingFuncB != null) {
                    err = err + existingFuncB.getName();
                } else if (existingFuncA != null && existingFuncA == existingFuncB) {
                    err = err + existingFuncA.getName();
                }
                err = err + ")";
                Msg.warn((Object)this, (Object)err);
            }
            catch (DuplicateNameException e) {
                Object paramNames = "";
                for (int i = 0; i < parameters.length - 1; ++i) {
                    paramNames = (String)paramNames + parameters[i].getName() + ", ";
                }
                paramNames = (String)paramNames + parameters[parameters.length - 1].getName();
                Msg.warn((Object)this, (Object)("Error processing function \"" + funcName + "\" (" + methodRowIndex + "): Duplicate parameter name (" + (String)paramNames + ")"));
            }
        }
    }

    private void markToPreventIncorrectProcessorDisassembly(Program program, CliMethodDefRow methodRow, Address startAddr, Address endAddr) throws CodeUnitInsertionException {
        Listing listing;
        Data data;
        PrototypeModel cliCallingConvention = program.getLanguage().getDefaultCompilerSpec().getCallingConvention(CLITABLEMETHODDEF_CLRCALL_CONVENTION);
        if ((cliCallingConvention == null && !methodRow.isNative() || cliCallingConvention != null && methodRow.isNative()) && (data = (listing = program.getListing()).getDefinedDataAt(startAddr)) == null) {
            int codeLength = (int)endAddr.subtract(startAddr) + 1;
            ArrayDataType codeDT = new ArrayDataType(BYTE, codeLength, 1);
            data = listing.createData(startAddr, (DataType)codeDT);
            data.setComment(1, methodRow.isManaged() ? ".NET CLR Managed Code" : "Native Code");
        }
    }

    public StructureDataType getRowDataType() {
        StructureDataType rowDt = new StructureDataType(new CategoryPath("/PE/CLI/Metadata/Tables"), "MethodDef Row", 0);
        rowDt.add(DWORD, "RVA", null);
        rowDt.add((DataType)CliFlags.CliEnumMethodImplAttributes.dataType, "ImplFlags", "Bitmask of type MethodImplAttributes");
        rowDt.add((DataType)CliFlags.CliEnumMethodAttributes.dataType, "Flags", "Bitmask of type MethodAttribute");
        rowDt.add(this.metadataStream.getStringIndexDataType(), "Name", "index into String heap");
        rowDt.add(this.metadataStream.getBlobIndexDataType(), "Signature", "index into Blob heap");
        rowDt.add(this.metadataStream.getTableIndexDataType(CliTypeTable.Param), "ParamList", "index into Param table");
        return rowDt;
    }

    private String commaifyList(List<?> list) {
        Object commaSeparated = "";
        for (Object item : list) {
            commaSeparated = (String)commaSeparated + String.valueOf(item) + ", ";
        }
        if (list.size() > 0) {
            commaSeparated = ((String)commaSeparated).substring(0, ((String)commaSeparated).length() - 2);
        }
        return commaSeparated;
    }

    public class CliMethodDefRow
    extends CliAbstractTableRow {
        public int RVA;
        public short ImplFlags;
        public short Flags;
        public int nameIndex;
        public int sigIndex;
        private int paramIndex;
        private static final int NEXT_ROW_PARAM_INIT_VALUE = -1;
        private int nextRowParamIndex = -1;
        private static final int METHODIMPLATTRIBUTES_CODETYPE_IL = 0;
        private static final int METHODIMPLATTRIBUTES_CODETYPE_NATIVE = 1;
        private static final int METHODIMPLATTRIBUTES_CODETYPE_OPTIL = 2;
        private static final int METHODIMPLATTRIBUTES_CODETYPE_RUNTIME = 3;
        private static final int METHODIMPLATTRIBUTES_MANAGED_MANAGED = 0;
        private static final int METHODIMPLATTRIBUTES_MANAGED_UNMANAGED = 4;
        private static final int METHODIMPLATTRIBUTES_FORWARDREF = 16;
        private static final int METHODIMPLATTRIBUTES_PRESERVESIG = 128;
        private static final int METHODIMPLATTRIBUTES_INTERNALCALL = 4096;
        private static final int METHODIMPLATTRIBUTES_SYNCHRONIZED = 32;
        private static final int METHODIMPLATTRIBUTES_NOINLINING = 8;
        private static final int METHODIMPLATTRIBUTES_AGGRESSIVEINLINING = 4096;
        private static final int METHODIMPLATTRIBUTES_MAXMETHODIMPLVAL = 65535;
        private static final int METHODATTRIBUTES_MEMBERACCESS_COMPILERCONTROLLED = 0;
        private static final int METHODATTRIBUTES_MEMBERACCESS_PRIVATE = 1;
        private static final int METHODATTRIBUTES_MEMBERACCESS_FAMANDASSEM = 2;
        private static final int METHODATTRIBUTES_MEMBERACCESS_ASSEM = 3;
        private static final int METHODATTRIBUTES_MEMBERACCESS_FAMILY = 4;
        private static final int METHODATTRIBUTES_MEMBERACCESS_FAMORASSEM = 5;
        private static final int METHODATTRIBUTES_MEMBERACCESS_PUBLIC = 6;
        private static final int METHODATTRIBUTES_STATIC = 16;
        private static final int METHODATTRIBUTES_FINAL = 32;
        private static final int METHODATTRIBUTES_VIRTUAL = 64;
        private static final int METHODATTRIBUTES_HIDEBYSIG = 128;
        private static final int METHODATTRIBUTES_VTABLELAYOUT_REUSESLOT = 0;
        private static final int METHODATTRIBUTES_VTABLELAYOUT_NEWSLOT = 256;
        private static final int METHODATTRIBUTES_STRICT = 512;
        private static final int METHODATTRIBUTES_ABSTRACT = 1024;
        private static final int METHODATTRIBUTES_SPECIALNAME = 2048;
        private static final int METHODATTRIBUTES_PINVOKEIMPL = 8192;
        private static final int METHODATTRIBUTES_UNMANAGEDEXPORT = 8;
        private static final int METHODATTRIBUTES_RTSPECIALNAME = 4096;
        private static final int METHODATTRIBUTES_HASSECURITY = 16384;
        private static final int METHODATTRIBUTES_REQUIRESECOBJECT = 32768;

        public CliMethodDefRow(int rva, short implFlags, short flags, int nameIndex, int sigIndex, int paramIndex) {
            this.RVA = rva;
            this.ImplFlags = implFlags;
            this.Flags = flags;
            this.nameIndex = nameIndex;
            this.sigIndex = sigIndex;
            this.paramIndex = paramIndex;
            this.nextRowParamIndex = -1;
        }

        @Override
        public String getRepresentation() {
            String paramsStr;
            String methodRep = "error retrieving method representation";
            CliBlob blob = CliTableMethodDef.this.metadataStream.getBlobStream().getBlob(this.sigIndex);
            try {
                CliSigMethodDef methodSig = new CliSigMethodDef(blob);
                methodRep = methodSig.getRepresentation();
            }
            catch (IOException methodSig) {
                // empty catch block
            }
            if (this.nextRowParamIndex == -1) {
                this.nextRowParamIndex = CliTableMethodDef.this.metadataStream.getTable(CliTypeTable.Param).getNumRows() + 1;
            }
            if (this.nextRowParamIndex == this.paramIndex) {
                paramsStr = "";
            } else {
                String[] params = new String[this.nextRowParamIndex - this.paramIndex];
                for (int i = 0; i < params.length; ++i) {
                    params[i] = CliTableMethodDef.this.getRowRepresentationSafe(CliTypeTable.Param, this.paramIndex + i);
                }
                paramsStr = CliTableMethodDef.this.commaifyList(Arrays.asList(params));
            }
            return String.format("%s %s Params: %s [RVA %x] Impl: %s Attr: %s", CliTableMethodDef.this.metadataStream.getStringsStream().getString(this.nameIndex), methodRep, paramsStr, this.RVA, CliFlags.CliEnumMethodImplAttributes.dataType.getName(this.ImplFlags & 0xFFFF), CliFlags.CliEnumMethodAttributes.dataType.getName(this.Flags & 0xFFFF));
        }

        @Override
        public String getRepresentation(CliStreamMetadata stream) {
            String paramsStr;
            String methodRep = "error retrieving method representation";
            CliBlob blob = stream.getBlobStream().getBlob(this.sigIndex);
            try {
                CliSigMethodDef methodSig = new CliSigMethodDef(blob);
                methodRep = methodSig.getRepresentation(stream);
            }
            catch (IOException methodSig) {
                // empty catch block
            }
            if (this.nextRowParamIndex == -1) {
                this.nextRowParamIndex = CliTableMethodDef.this.metadataStream.getTable(CliTypeTable.Param).getNumRows() + 1;
            }
            if (this.nextRowParamIndex == this.paramIndex) {
                paramsStr = "";
            } else {
                String[] params = new String[this.nextRowParamIndex - this.paramIndex];
                for (int i = 0; i < params.length; ++i) {
                    params[i] = CliTableMethodDef.this.getRowShortRepSafe(CliTypeTable.Param, this.paramIndex + i);
                }
                paramsStr = CliTableMethodDef.this.commaifyList(Arrays.asList(params));
            }
            return String.format("%s %s Params: %s [RVA %x] Impl: %s Attr: %s", stream.getStringsStream().getString(this.nameIndex), methodRep, paramsStr, this.RVA, CliFlags.CliEnumMethodImplAttributes.dataType.getName(this.ImplFlags & 0xFFFF), CliFlags.CliEnumMethodAttributes.dataType.getName(this.Flags & 0xFFFF));
        }

        boolean isStatic() {
            return (this.Flags & 0x10) == 16;
        }

        boolean isPInvokeImpl() {
            return (this.Flags & 0x2000) == 8192;
        }

        boolean isNative() {
            return (this.ImplFlags & 1) == 1;
        }

        boolean isManaged() {
            return (this.ImplFlags & 0) == 0;
        }
    }
}

