/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe.debug;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteArrayConverter;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.format.pe.OffsetValidator;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.DataConverter;
import ghidra.util.Msg;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;
import java.io.RandomAccessFile;

public class DebugDirectory
implements StructConverter,
ByteArrayConverter {
    public static final String NAME = "IMAGE_DEBUG_DIRECTORY";
    public static final int IMAGE_SIZEOF_DEBUG_DIRECTORY = 28;
    private int characteristics;
    private int timeDateStamp;
    private short majorVersion;
    private short minorVersion;
    private int type;
    private int sizeOfData;
    private int addressOfRawData;
    private int pointerToRawData;
    private String description;
    private byte[] blobBytes;
    private long index = 0L;

    DebugDirectory(BinaryReader reader, long index, OffsetValidator validator) throws IOException {
        long oldIndex = reader.getPointerIndex();
        reader.setPointerIndex(index);
        this.characteristics = reader.readNextInt();
        this.timeDateStamp = reader.readNextInt();
        this.majorVersion = reader.readNextShort();
        this.minorVersion = reader.readNextShort();
        this.type = reader.readNextInt();
        this.sizeOfData = reader.readNextInt();
        this.addressOfRawData = reader.readNextInt();
        this.pointerToRawData = reader.readNextInt();
        if (this.type < 0 || this.type > 20 || this.sizeOfData < 0) {
            Msg.error((Object)this, (Object)"Invalid DebugDirectory");
            this.sizeOfData = 0;
            reader.setPointerIndex(oldIndex);
            return;
        }
        if (this.sizeOfData > 0) {
            if (!validator.checkPointer(this.pointerToRawData)) {
                Msg.error((Object)this, (Object)("Invalid pointerToRawData " + this.pointerToRawData));
                this.sizeOfData = 0;
                reader.setPointerIndex(oldIndex);
                return;
            }
            this.blobBytes = reader.readByteArray(this.pointerToRawData, this.sizeOfData);
        }
        this.index = index;
        reader.setPointerIndex(oldIndex);
    }

    public int getCharacteristics() {
        return this.characteristics;
    }

    public int getTimeDateStamp() {
        return this.timeDateStamp;
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public int getType() {
        return this.type;
    }

    public int getSizeOfData() {
        return this.sizeOfData;
    }

    public int getAddressOfRawData() {
        return this.addressOfRawData;
    }

    public int getPointerToRawData() {
        return this.pointerToRawData;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String desc) {
        this.description = desc;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException {
        StructureDataType struct = new StructureDataType(NAME, 0);
        struct.add(DWORD, "Characteristics", null);
        struct.add(DWORD, "TimeDateStamp", null);
        struct.add(WORD, "MajorVersion", null);
        struct.add(WORD, "MinorVersion", null);
        struct.add(DWORD, "Type", null);
        struct.add(DWORD, "SizeOfData", null);
        struct.add(DWORD, "AddressOfRawData", null);
        struct.add(DWORD, "PointerToRawData", null);
        struct.setCategoryPath(new CategoryPath("/PE"));
        return struct;
    }

    public void writeHeader(RandomAccessFile raf, DataConverter dc) throws IOException {
        raf.seek(this.index);
        raf.write(dc.getBytes(this.characteristics));
        raf.write(dc.getBytes(this.timeDateStamp));
        raf.write(dc.getBytes(this.majorVersion));
        raf.write(dc.getBytes(this.minorVersion));
        raf.write(dc.getBytes(this.type));
        raf.write(dc.getBytes(this.sizeOfData));
        raf.write(dc.getBytes(this.addressOfRawData));
        raf.write(dc.getBytes(this.pointerToRawData));
    }

    @Override
    public byte[] toBytes(DataConverter dc) {
        if (this.blobBytes == null) {
            return new byte[0];
        }
        return this.blobBytes;
    }

    public void updatePointers(int offset, int postOffset) {
        Msg.debug((Object)this, (Object)(this.index + "+" + offset + " " + this.pointerToRawData + "+" + postOffset));
        this.index += (long)offset;
        this.pointerToRawData += postOffset;
    }
}

