/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.cparser.CPP;

import ghidra.app.util.cparser.CPP.PreProcessor;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeConflictHandler;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.EnumDataType;
import ghidra.program.util.AddressEvaluator;
import ghidra.util.Msg;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

public class DefineTable {
    private static final String VARARG_ELLIPSIS = "...";
    private static final int ARBITRARY_MAX_REPLACEMENTS = 900000;
    Hashtable<String, PreProcessor.PPToken> defs = new Hashtable();
    Hashtable<String, Vector<PreProcessor.PPToken>> args = new Hashtable();
    Hashtable lookupTable = new Hashtable();
    private static final String VALUE = "value";

    public PreProcessor.PPToken get(String string) {
        return this.defs.get(string);
    }

    public Vector<PreProcessor.PPToken> getArgs(String currKey) {
        return this.args.get(currKey);
    }

    public String getDefineAt(StringBuffer buf, int pos) {
        Hashtable findTable = this.lookupTable;
        String found = null;
        while (findTable != null && pos < buf.length()) {
            String value;
            char ch;
            Character chObj;
            if ((findTable = (Hashtable)findTable.get(chObj = Character.valueOf(ch = buf.charAt(pos++)))) == null || (value = (String)findTable.get(VALUE)) == null) continue;
            found = value;
        }
        return found;
    }

    public void put(String string, PreProcessor.PPToken val) {
        this.defs.put(string, val);
        Hashtable<Object, Object> findTable = this.lookupTable;
        Character chObj = null;
        int pos = 0;
        int len = string.length();
        while (pos < len) {
            char ch;
            Hashtable<Object, Object> node;
            if ((node = (Hashtable<Object, Object>)findTable.get(chObj = Character.valueOf(ch = string.charAt(pos++)))) == null) {
                node = new Hashtable<Object, Object>();
                findTable.put(chObj, node);
                findTable = node;
                continue;
            }
            findTable = node;
        }
        findTable.put(VALUE, string);
    }

    public void putArg(String string, Vector<PreProcessor.PPToken> val) {
        this.args.put(string, val);
    }

    public boolean containsKey(String def) {
        return this.defs.containsKey(def);
    }

    public int size() {
        return this.defs.size();
    }

    public PreProcessor.PPToken remove(String string) {
        PreProcessor.PPToken token = this.defs.remove(string);
        Hashtable findTable = this.lookupTable;
        Character chObj = null;
        int pos = 0;
        int len = string.length();
        while (pos < len) {
            char ch;
            if ((findTable = (Hashtable)findTable.get(chObj = Character.valueOf(ch = string.charAt(pos++)))) != null) continue;
            return token;
        }
        findTable.remove(VALUE);
        return token;
    }

    public boolean isArg(String string) {
        return this.args.containsKey(string);
    }

    public Vector<PreProcessor.PPToken> removeArg(String string) {
        return this.args.remove(string);
    }

    public String toString(String string) {
        StringBuffer buf = new StringBuffer(string);
        PreProcessor.PPToken token = this.defs.get(string);
        Vector<PreProcessor.PPToken> argVector = this.getArgs(string);
        if (argVector != null) {
            buf.append("(");
            for (int i = 0; i < argVector.size(); ++i) {
                PreProcessor.PPToken arg = argVector.get(i);
                buf.append(arg);
                if (i + 1 >= argVector.size()) continue;
                buf.append(", ");
            }
            buf.append(" )");
        }
        buf.append(" = " + token.toString());
        return buf.toString();
    }

    public Iterator<String> getDefineNames() {
        return this.defs.keySet().iterator();
    }

    public String getValue(String defName) {
        PreProcessor.PPToken token = this.defs.get(defName);
        if (token == null) {
            return null;
        }
        return token.image;
    }

    public boolean isNumeric(String defName) {
        PreProcessor.PPToken token = this.defs.get(defName);
        if (token == null) {
            return false;
        }
        return token.kind == 119 || token.kind == 120;
    }

    public String getDefinitionPath(String defName) {
        PreProcessor.PPToken token = this.defs.get(defName);
        if (token == null) {
            return null;
        }
        return token.getPath();
    }

    private String macroSub(String image, int pos, ArrayList<String> initialList) {
        int replaceCount = 0;
        StringBuffer buf = new StringBuffer(image);
        int lastReplPos = pos;
        boolean initialListSupplied = initialList != null;
        ArrayList<String> sublist = new ArrayList<String>();
        if (initialList != null) {
            sublist.addAll(initialList);
        }
        while (pos < buf.length() && replaceCount < 900000) {
            String defName;
            if (pos == lastReplPos) {
                sublist = new ArrayList();
                if (initialList != null) {
                    sublist.addAll(initialList);
                }
            }
            if (this.shouldReplace(buf, defName = this.getDefineAt(buf, pos), pos)) {
                int replPos = this.replace(buf, defName, pos, sublist, initialListSupplied);
                if (replPos == -1) {
                    ++pos;
                    continue;
                }
                lastReplPos = replPos;
                ++replaceCount;
                continue;
            }
            ++pos;
        }
        if (replaceCount >= 900000) {
            System.err.println(" replace " + image + " hit limit");
        }
        return buf.toString();
    }

    private boolean shouldReplace(StringBuffer buf, String defName, int pos) {
        if (defName == null) {
            return false;
        }
        int currIndex = buf.indexOf(defName, pos);
        if (currIndex < 0) {
            return false;
        }
        if (currIndex > 0 && (Character.isJavaIdentifierStart(buf.charAt(currIndex - 1)) || Character.isJavaIdentifierPart(buf.charAt(currIndex - 1)))) {
            return false;
        }
        int afterIndex = currIndex + defName.length();
        if (afterIndex < buf.length() && (Character.isJavaIdentifierStart(buf.charAt(afterIndex)) || Character.isJavaIdentifierPart(buf.charAt(afterIndex)))) {
            return false;
        }
        String replacementString = this.defs.get((Object)defName).image;
        return !replacementString.equals(defName);
    }

    int replace(StringBuffer buf, String currKey, int fromIndex, ArrayList<String> sublist, boolean initialList) {
        int currIndex;
        String replacementString = null;
        if (sublist == null) {
            sublist = new ArrayList();
        }
        if ((currIndex = buf.indexOf(currKey, fromIndex)) < 0) {
            return -1;
        }
        if (currIndex > 0 && (Character.isJavaIdentifierStart(buf.charAt(currIndex - 1)) || Character.isJavaIdentifierPart(buf.charAt(currIndex - 1)))) {
            return -1;
        }
        int afterIndex = currIndex + currKey.length();
        if (afterIndex < buf.length() && (Character.isJavaIdentifierStart(buf.charAt(afterIndex)) || Character.isJavaIdentifierPart(buf.charAt(afterIndex)))) {
            return -1;
        }
        replacementString = this.defs.get((Object)currKey).image;
        if (replacementString.equals(currKey)) {
            return -1;
        }
        Vector<PreProcessor.PPToken> argv = this.getArgs(currKey);
        int replacedSubpieceLen = currKey.length();
        if (argv == null && sublist.contains(currKey)) {
            if (!initialList) {
                System.err.println("DONT Replace " + currKey + " in: " + String.valueOf(buf));
            }
            return -1;
        }
        if (argv != null) {
            String parms = this.getParams(buf, currIndex + currKey.length(), '\u0000');
            int parmslen = parms.length();
            if (parmslen < 2) {
                return -1;
            }
            if (!(parms = parms.trim()).startsWith("(") || !parms.endsWith(")")) {
                return -1;
            }
            parms = parms.substring(1, parms.length() - 1);
            replacementString = this.subParams(replacementString, currKey, parms, argv);
            replacementString = this.joinPdPd(replacementString);
            replacedSubpieceLen += parmslen;
        }
        sublist.add(currKey);
        buf.replace(currIndex, currIndex + replacedSubpieceLen, replacementString);
        return currIndex + replacementString.length();
    }

    String subParams(String replString, String defName, String parms, Vector<PreProcessor.PPToken> argv) {
        String substString = replString;
        ArrayList<Integer> beginPos = new ArrayList<Integer>();
        ArrayList<Integer> endPos = new ArrayList<Integer>();
        ArrayList<String> subValue = new ArrayList<String>();
        int index = 0;
        int pos = 0;
        StringBuffer argsfound = new StringBuffer();
        boolean isVarArg = false;
        boolean hadVarArgs = false;
        while (pos < parms.length() || index < argv.size()) {
            String argValue = "";
            int origPos = pos;
            if (pos < parms.length()) {
                argValue = this.getParams(new StringBuffer(parms), pos, ',');
            }
            pos += argValue.length() + 1;
            if (index >= argv.size()) {
                Msg.error((Object)this, (Object)("Define parameter mismatch for macro " + defName + "(" + parms + ") Expected " + argv.size() + " arguments.   badarg(" + index + ") " + argValue + " args processed : " + String.valueOf(argsfound)));
                return replString;
            }
            String curArgName = argv.elementAt((int)index).image;
            if (index == argv.size() - 1 && VARARG_ELLIPSIS.equals(curArgName)) {
                isVarArg = true;
                curArgName = "__VA_ARGS__";
                argValue = this.getParams(new StringBuffer(parms), origPos, '\u0000');
                pos += argValue.length() + 1;
            }
            ++index;
            argValue = argValue.trim();
            argsfound.append(argValue);
            argsfound.append(", ");
            if (isVarArg && argValue.length() != 0) {
                hadVarArgs = true;
            }
            int curpos = -1;
            do {
                Integer loc;
                int insertLoc;
                int afterIndex;
                if ((curpos = substString.indexOf(curArgName, curpos + 1)) < 0 || curpos > 0 && (Character.isJavaIdentifierStart(substString.charAt(curpos - 1)) || Character.isJavaIdentifierPart(substString.charAt(curpos - 1))) || (afterIndex = curpos + curArgName.length()) < substString.length() && (Character.isJavaIdentifierStart(substString.charAt(afterIndex)) || Character.isJavaIdentifierPart(substString.charAt(afterIndex)))) continue;
                Integer begin = curpos;
                for (insertLoc = 0; insertLoc < beginPos.size() && (loc = (Integer)beginPos.get(insertLoc)).compareTo(begin) <= 0; ++insertLoc) {
                }
                beginPos.add(insertLoc, begin);
                endPos.add(insertLoc, curpos + curArgName.length());
                subValue.add(insertLoc, argValue);
            } while (curpos >= 0);
        }
        StringBuffer buf = new StringBuffer();
        int listSize = beginPos.size();
        int startpos = 0;
        for (int i = 0; i < listSize; ++i) {
            int begin = (Integer)beginPos.get(i);
            int end = (Integer)endPos.get(i);
            String value = (String)subValue.get(i);
            buf.append(substString.substring(startpos, begin));
            buf.append(value);
            startpos = end;
        }
        buf.append(substString.substring(startpos));
        if (isVarArg) {
            this.replace_VaOpt(buf, hadVarArgs);
        }
        substString = buf.toString();
        return substString;
    }

    private void replace_VaOpt(StringBuffer buf, boolean hadVarArgs) {
        int optIdx = buf.indexOf("__VA_OPT__");
        if (optIdx < 0) {
            return;
        }
        int lparen = buf.indexOf("(", optIdx + 1);
        if (lparen < 0) {
            return;
        }
        int rparen = buf.indexOf(")", lparen + 1);
        if (rparen < 0) {
            return;
        }
        String replarg = buf.substring(lparen + 1, rparen);
        if (hadVarArgs) {
            buf.replace(optIdx, rparen + 1, replarg);
        } else {
            buf.replace(optIdx, rparen + 1, "");
        }
    }

    public String getParams(StringBuffer buf, int start, char endChar) {
        int len = buf.length();
        int depth = 0;
        int pos = start;
        if (pos >= len) {
            return "";
        }
        char ch = buf.charAt(pos);
        int lastChar = 0;
        boolean hitQuote = false;
        boolean hitTick = false;
        while (pos < len) {
            if ((ch = buf.charAt(pos++)) == '\"' && lastChar != 92) {
                boolean bl = hitQuote = !hitQuote;
            }
            if (ch == '\'' && lastChar != 92) {
                boolean bl = hitTick = !hitTick;
            }
            if (!hitQuote && !hitTick && ch == endChar && depth == 0) {
                --pos;
                break;
            }
            if (!hitQuote && !hitTick && ch == ')') {
                if (--depth == 0 && endChar == '\u0000') break;
                if (depth < 0) {
                    --pos;
                    break;
                }
            }
            if (!hitQuote && !hitTick && ch == '(') {
                ++depth;
            }
            lastChar = ch;
        }
        return buf.substring(start, pos);
    }

    public String expand(String image, boolean join) {
        return this.expand(image, join, null);
    }

    public String expand(String image, boolean join, ArrayList<String> list) {
        image = this.macroSub((String)image, 0, list);
        if (join) {
            image = this.joinPdPd((String)image);
        }
        if (((String)image).length() > 0 && ((String)image).charAt(0) == '#') {
            image = "\"" + ((String)image).substring(1) + "\"";
        }
        return image;
    }

    private String joinPdPd(String image) {
        int currIndex = image.length();
        StringBuffer buf = new StringBuffer(image);
        do {
            if ((currIndex = image.lastIndexOf("##", currIndex)) < 0) continue;
            boolean inString = false;
            int quotePos = image.length();
            do {
                if ((quotePos = image.lastIndexOf("\"", quotePos)) <= currIndex || quotePos < 0) continue;
                boolean bl = inString = !inString;
            } while (--quotePos > currIndex);
            int afterIndex = currIndex + 2;
            while (currIndex > 0 && image.charAt(currIndex - 1) == ' ') {
                --currIndex;
            }
            while (afterIndex < image.length() && image.charAt(afterIndex) == ' ') {
                ++afterIndex;
            }
            if (!inString) {
                buf.replace(currIndex, afterIndex, "");
                --currIndex;
                continue;
            }
            currIndex -= 2;
        } while (currIndex > 0);
        image = buf.toString();
        return image;
    }

    public void populateDefineEquates(DataTypeManager[] openDTMgrs, DataTypeManager dtMgr) {
        int transactionID = dtMgr.startTransaction("Add Equates");
        Iterator<String> iter = this.getDefineNames();
        while (iter.hasNext()) {
            String defName = iter.next();
            String strValue = this.expandDefine(defName);
            if (strValue == null) continue;
            strValue = DefineTable.stripCast(strValue);
            long value = 0L;
            Long lvalue = DefineTable.getCValue(strValue);
            if (lvalue == null) {
                try {
                    lvalue = AddressEvaluator.evaluateToLong((String)strValue);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (lvalue == null) continue;
            }
            value = lvalue;
            this.populateDefineEquate(openDTMgrs, dtMgr, "defines", "define_", defName, value);
        }
        dtMgr.endTransaction(transactionID, true);
    }

    public void populateDefineEquate(DataTypeManager[] openDTMgrs, DataTypeManager dtMgr, String category, String prefix, String defName, long value) {
        String enumName = prefix + defName;
        EnumDataType enuum = new EnumDataType(enumName, 8);
        enuum.add(defName, value);
        enuum.setLength(enuum.getMinimumPossibleLength());
        String defPath = this.getDefinitionPath(defName);
        String currentCategoryName = DefineTable.getFileName(defPath);
        CategoryPath path = DefineTable.getCategory(currentCategoryName);
        path = new CategoryPath(path, new String[]{category});
        enuum.setCategoryPath(path);
        DataType dt = this.resolveDataType(openDTMgrs, path, (DataType)enuum);
        dtMgr.addDataType(dt, DataTypeConflictHandler.DEFAULT_HANDLER);
    }

    private DataType resolveDataType(DataTypeManager[] openDTMgrs, CategoryPath path, DataType dt) {
        if (openDTMgrs == null) {
            return dt;
        }
        for (int i = 0; i < openDTMgrs.length; ++i) {
            DataType candidateDT = openDTMgrs[i].getDataType(dt.getCategoryPath(), dt.getName());
            if (candidateDT == null || !candidateDT.isEquivalent(candidateDT)) continue;
            return candidateDT;
        }
        return dt;
    }

    public String expandDefine(String defName) {
        String strExpanded;
        if (this.isArg(defName)) {
            return null;
        }
        String strValue = this.getValue(defName);
        ArrayList<String> list = new ArrayList<String>();
        list.add(defName);
        strValue = strExpanded = this.expand(strValue, true, list);
        return strValue;
    }

    public static Long getCValue(String strValue) {
        try {
            int start = 0;
            int radix = 10;
            strValue = strValue.toLowerCase();
            if (strValue.startsWith("0x")) {
                start = 2;
                radix = 16;
            } else if (strValue.startsWith("0")) {
                start = 1;
                radix = 8;
            }
            if (strValue.endsWith("ul") || strValue.endsWith("ll")) {
                strValue = strValue.substring(0, strValue.length() - 2);
            } else if (strValue.endsWith("l") || strValue.endsWith("u")) {
                strValue = strValue.substring(0, strValue.length() - 1);
            }
            if (start != 0) {
                strValue = strValue.substring(start);
            }
            return Long.parseLong(strValue, radix);
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    private static CategoryPath getCategory(String catName) {
        CategoryPath rootCat = CategoryPath.ROOT;
        if (catName == null || catName.length() == 0) {
            return rootCat;
        }
        return new CategoryPath(rootCat, new String[]{catName});
    }

    private static String getFileName(String path) {
        if (path == null) {
            return null;
        }
        int slashpos = path.lastIndexOf(47);
        if (slashpos < 0) {
            slashpos = path.lastIndexOf(92);
        }
        if (slashpos < 0) {
            return path;
        }
        return path.substring(slashpos + 1);
    }

    private static String stripCast(String strValue) {
        int procLen;
        strValue = ((String)strValue).trim();
        for (int pos = 0; pos < ((String)strValue).length(); pos += procLen) {
            procLen = 1;
            int startPos = ((String)strValue).indexOf(40, pos);
            if (startPos == -1) {
                return strValue;
            }
            pos = startPos;
            int endParen = ((String)strValue).indexOf(41, pos + 1);
            if (endParen != -1) {
                boolean isValid;
                char ch;
                String subStr = ((String)strValue).substring(pos + 1, endParen);
                if (subStr.length() <= 0) continue;
                int subPos = 0;
                subStr = subStr.trim();
                for (isValid = Character.isJavaIdentifierStart(subStr.charAt(0)); isValid && subPos < subStr.length(); isValid |= Character.isJavaIdentifierPart(ch)) {
                    ch = subStr.charAt(subPos++);
                }
                if (!isValid) continue;
                strValue = ((String)strValue).substring(0, pos) + ((String)strValue).substring(endParen + 1);
                procLen = 0;
                continue;
            }
            return strValue;
        }
        return strValue;
    }
}

