/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.cparser.CPP;

import ghidra.app.util.cparser.CPP.DefineTable;
import ghidra.app.util.cparser.CPP.ParseException;
import ghidra.app.util.cparser.CPP.PreProcessorConstants;
import ghidra.app.util.cparser.CPP.PreProcessorTokenManager;
import ghidra.app.util.cparser.CPP.SimpleCharStream;
import ghidra.app.util.cparser.CPP.Token;
import ghidra.app.util.cparser.CPP.TokenMgrError;
import ghidra.program.util.AddressEvaluator;
import ghidra.util.Msg;
import ghidra.util.task.TaskMonitor;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;

public class PreProcessor
implements PreProcessorConstants {
    int shift;
    boolean emitExecSwitch = true;
    HashSet<String> files = new HashSet();
    Stack<String> fileStack = new Stack();
    Stack<PPToken> execStack = new Stack();
    Vector<String> pathList = new Vector();
    int ifDepth = 0;
    DefineTable defs = new DefineTable();
    PrintStream outputStream = System.out;
    private HashMap<String, Integer> alreadyDone;
    private StringBuilder parseMessages = new StringBuilder();
    private boolean parseSuccess = false;
    private TaskMonitor monitor = null;
    private int verboseLevel = 0;
    public PreProcessorTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    private int jj_gen;
    private final int[] jj_la1 = new int[44];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private static int[] jj_la1_2;
    private static int[] jj_la1_3;
    private static int[] jj_la1_4;
    private static int[] jj_la1_5;
    private static int[] jj_la1_6;
    private final JJCalls[] jj_2_rtns = new JJCalls[52];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    public int verboseLevel() {
        int vl = this.verboseLevel;
        return vl;
    }

    public String curFileStackTop() {
        return this.fileStack.empty() ? "" : this.fileStack.peek().toString();
    }

    public DefineTable getDefinitions() {
        return this.defs;
    }

    public PPToken getDef(PPToken def) {
        PPToken pt;
        if (this.verboseLevel == 6 || this.verboseLevel == 5 || this.verboseLevel == 4 || this.verboseLevel == 3) {
            this.println("Defs: containsKey: " + def.image + " = " + this.defs.containsKey(def.image));
        }
        if ((pt = this.defs.get(def.image)) != null && pt.image.length() > 0) {
            String expanded = this.defs.expand(pt.image, false);
            pt = new PPToken(pt);
            pt.image = expanded;
        } else {
            pt = def;
        }
        return pt;
    }

    public String getDef(String name) {
        PPToken pt = this.defs.get(name);
        String val = name;
        if (pt != null && pt.image.length() > 0) {
            val = this.defs.expand(pt.image, false);
        }
        return val;
    }

    private void setDef(PPToken def) {
        if (this.verboseLevel == 3 || this.verboseLevel == 6) {
            this.println(this.curFileStackTop() + "'" + def.beginLine + ": Defining: " + def.image);
        }
        if (this.emitExecSwitch) {
            this.defs.put(def.image, new PPToken(""));
        }
    }

    private void setDef(PPToken key, PPToken val) {
        if (this.verboseLevel == 4 || this.verboseLevel == 6) {
            this.println(this.curFileStackTop() + "'" + key.beginLine + ": Defining text: " + key.image + " = " + val.image);
        }
        if (this.emitExecSwitch) {
            val.image = val.image.trim();
            val.setPath(this.curFileStackTop());
            this.defs.put(key.image, val);
        }
    }

    private void setArg(PPToken key, Vector val) {
        if (this.verboseLevel == 4 || this.verboseLevel == 6) {
            this.print(this.curFileStackTop() + "'" + key.beginLine + ": Defining text: " + key.image + " (");
            for (int i = 0; i < val.size(); ++i) {
                if (i == 0) {
                    this.print(((PPToken)val.elementAt((int)i)).image);
                    continue;
                }
                if (i < val.size() - 1) {
                    this.print("," + ((PPToken)val.elementAt((int)i)).image);
                    continue;
                }
                this.println("," + ((PPToken)val.elementAt((int)i)).image + ")");
            }
        }
        if (this.emitExecSwitch) {
            this.defs.putArg(key.image, val);
        }
    }

    private void setMacro(PPToken key, Vector marg, PPToken val) {
        if (this.verboseLevel == 5 || this.verboseLevel == 6) {
            this.println(this.curFileStackTop() + "'" + key.beginLine + ": Defining text: " + key.image + " = " + val.image);
        }
        if (this.emitExecSwitch) {
            this.setDef(key, val);
        }
        if (this.verboseLevel == 5 || this.verboseLevel == 6) {
            this.println("\t" + this.curFileStackTop() + "'" + key.beginLine + ": Defining text: " + key.image + " (");
            for (int i = 0; i < marg.size(); ++i) {
                if (i == 0) {
                    this.print(((PPToken)marg.elementAt((int)i)).image);
                    continue;
                }
                if (i < marg.size() - 1) {
                    this.print("," + ((PPToken)marg.elementAt((int)i)).image);
                    continue;
                }
                this.println("," + ((PPToken)marg.elementAt((int)i)).image + ")");
            }
        }
        if (this.emitExecSwitch && marg != null) {
            this.setArg(key, marg);
        }
    }

    private void UnDefine(PPToken def) {
        if (this.isArg(def)) {
            this.Forget(def);
        }
        if (this.isDef(def) && this.emitExecSwitch) {
            this.defs.remove(def.image);
        }
    }

    private void Forget(PPToken val) {
        if (this.emitExecSwitch) {
            this.defs.removeArg(val.image);
        }
    }

    private void localPlace(PPToken inc, boolean xsym) throws ParseException {
        String def = inc.image;
        File incFile = null;
        FileInputStream fis = null;
        String srcPath = null;
        try {
            if (srcPath == null) {
                srcPath = "." + File.separator;
            }
            if ((incFile = new File(srcPath + def)).exists()) {
                fis = new FileInputStream(incFile);
            } else {
                incFile = new File(srcPath + def.toLowerCase());
                if (incFile.exists()) {
                    fis = new FileInputStream(incFile);
                }
            }
        }
        catch (FileNotFoundException fene) {
            this.addParseMessage(incFile.getName(), fene.getMessage());
        }
        if (fis == null) {
            this.standardPlace(inc, xsym);
        } else {
            if (this.verboseLevel == 2) {
                this.print("Line " + inc.beginLine + ": " + this.curFileStackTop() + " => ");
            }
            this.swapFileStreams(incFile, fis);
        }
    }

    private void swapFileStreams(File incFile, FileInputStream fis) throws ParseException {
        if (this.verboseLevel == 2) {
            this.print(incFile.getAbsolutePath() + "\n");
        } else if (this.verboseLevel == 1) {
            this.println("Parsing stream " + incFile.getAbsolutePath() + " ... ");
        }
        PreProcessor parser = null;
        try {
            int pos = -1;
            int count = 0;
            do {
                if ((pos = this.fileStack.indexOf(incFile.getAbsolutePath(), pos + 1)) >= 0) {
                    ++count;
                }
                if (count <= 5) continue;
                this.addParseMessage(incFile.getAbsolutePath(), "Error: Possible infinite inclusion recursion detected: \n" + String.valueOf(this.fileStack));
                return;
            } while (pos != -1);
            Integer val = this.alreadyDone.get(incFile.getAbsolutePath());
            if (val == null) {
                val = 0;
            }
            val = val + 1;
            this.alreadyDone.put(incFile.getAbsolutePath(), val);
            this.fileStack.push(incFile.getAbsolutePath());
            parser = new PreProcessor(this);
            parser.ReInit(fis);
            parser.Input();
            this.fileStack.pop();
        }
        catch (ParseException e) {
            this.addParseMessage(incFile.getName(), "ERROR parsing Included File: " + e.getMessage());
            throw e;
        }
        catch (TokenMgrError e) {
            this.addParseMessage(incFile.getName(), "ERROR parsing Included File: " + e.getMessage());
            throw e;
        }
    }

    private void standardPlace(PPToken inc, boolean xsym) throws ParseException {
        this.includeFile(inc, xsym);
    }

    private boolean isNDef(PPToken def) {
        if (this.verboseLevel == 6) {
            this.print("Line " + def.beginLine + ": " + this.curFileStackTop() + " Check isNDef " + def.image);
        }
        if (!this.defs.containsKey(def.image)) {
            if (this.verboseLevel == 6) {
                this.println("True");
            }
            return true;
        }
        if (this.verboseLevel == 6) {
            this.println("False");
        }
        return false;
    }

    public boolean isDef(PPToken def) {
        if (this.verboseLevel == 6) {
            this.print("Line " + def.beginLine + ": " + this.curFileStackTop() + " Check isDef " + def.image);
        }
        if (this.defs.containsKey(def.image)) {
            if (this.verboseLevel == 6) {
                this.println("True");
            }
            return true;
        }
        if (this.verboseLevel == 6) {
            this.println("False");
        }
        return false;
    }

    public boolean isArg(PPToken arg) {
        if (this.verboseLevel == 6) {
            this.print("Line " + arg.beginLine + ": " + this.curFileStackTop() + " Check isArg " + arg.image);
        }
        if (this.defs.isArg(arg.image)) {
            if (this.verboseLevel == 6) {
                this.println("True");
            }
            return true;
        }
        if (this.verboseLevel == 6) {
            this.println("False");
        }
        return false;
    }

    void bufAppendWithComment(PPToken buf, Token u) {
        if (this.emitExecSwitch) {
            buf.append(u.image, true);
        } else {
            buf.append("//// " + u.image, false);
        }
    }

    private void includeFile(PPToken inc, boolean xsym) throws ParseException {
        String ft = inc.image;
        String fn = new String(ft);
        if ((fn = fn.trim()).startsWith("\"") && fn.indexOf(34, 1) > 0) {
            fn = fn.substring(1, fn.indexOf(34, 1));
        }
        if (fn.startsWith("<") && fn.indexOf(62, 1) > 0) {
            fn = fn.substring(1, fn.indexOf(62, 1));
        }
        FileInputStream fis = null;
        File iFile = null;
        boolean alreadyIncluded = this.addFile(fn);
        for (int i = 0; i < this.pathList.size() && ((iFile = this.getFile(this.pathList.elementAt(i), fn, xsym)) != null && iFile.getAbsolutePath().equals(this.fileStack.peek()) || (fis = this.getFIS(iFile)) == null); ++i) {
        }
        if (fis == null) {
            iFile = new File((String)this.fileStack.lastElement());
            iFile = this.getFile(iFile.getParent(), fn, xsym);
            fis = this.getFIS(iFile);
        }
        if (fis == null) {
            this.addParseMessage(null, "WARNING: No path to #include " + ft + "    Assuming not needed!\nUse -I option");
            this.addParseMessage(null, "    Current Include Path: ");
            for (String element : this.fileStack) {
                this.addParseMessage(null, "     :   " + element);
            }
        } else {
            if (this.verboseLevel == 2) {
                this.print("Line " + inc.beginLine + ": " + this.curFileStackTop() + " => ");
            }
            StringBuffer pad = new StringBuffer();
            for (String element : this.fileStack) {
                pad.append("   ");
            }
            if (!alreadyIncluded) {
                this.addParseMessage(null, "      " + String.valueOf(pad) + String.valueOf(iFile));
            }
            this.swapFileStreams(iFile, fis);
            if (this.verboseLevel == 1) {
                this.addParseMessage(null, "Include depth " + this.fileStack.size() + ": Done!");
            }
        }
    }

    private File getFile(String parent, String filename) {
        return this.getFile(parent, filename, true);
    }

    private File getFile(String parent, String filename, boolean possibleXsym) {
        File file = this.findFile(parent, filename, possibleXsym);
        if (file != null) {
            return file;
        }
        file = this.findFile(parent, filename.toLowerCase(), possibleXsym);
        if (file != null) {
            return file;
        }
        file = this.findFile(parent.toLowerCase(), filename.toLowerCase(), possibleXsym);
        if (file != null) {
            return file;
        }
        file = this.findFile(parent.toUpperCase(), filename.toUpperCase(), possibleXsym);
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private File findFile(String parent, String filename, boolean possibleXsym) {
        Object child;
        File iFile;
        block18: {
            File frameFile;
            File[] listOfFiles;
            iFile = null;
            iFile = new File(parent + File.separator + filename);
            if (iFile.exists()) {
                return iFile;
            }
            File sameiFile = new File(parent + File.separator + new File(filename).getName());
            if (sameiFile.exists()) {
                return sameiFile;
            }
            File folder = new File(parent);
            if (folder.isDirectory() && (listOfFiles = folder.listFiles()) != null) {
                for (File file : listOfFiles) {
                    if (!file.isFile() || filename.compareToIgnoreCase(file.getName()) != 0) continue;
                    return file;
                }
            }
            if (!possibleXsym) return null;
            child = "";
            do {
                if (iFile == null) return null;
                if (iFile.getParent() == null) return null;
                child = ((String)child).length() <= 0 ? iFile.getName() : iFile.getName() + File.separator + (String)child;
                iFile = iFile.getParentFile();
                if (iFile.exists()) break block18;
            } while (!(frameFile = new File(iFile.getAbsolutePath() + ".framework" + File.separator + iFile.getName())).exists());
            iFile = frameFile;
        }
        if (!iFile.isFile()) {
            if (!iFile.getName().equals("..")) return null;
            return this.getFile(iFile.getParent(), (String)child);
        }
        FileInputStream fis = this.getFIS(iFile);
        if (fis == null) {
            return null;
        }
        String nPath = "";
        try {
            try {
                BufferedReader br = new BufferedReader(new InputStreamReader(fis));
                String str = br.readLine();
                if (str == null || !str.equals("XSym")) {
                    File subFile = this.getFile(iFile.getParent() + File.separator + "Headers", (String)child, true);
                    if (subFile != null) {
                        File file = subFile;
                        return file;
                    }
                    File file = this.getFile(iFile.getParent(), (String)child, true);
                    return file;
                }
                str = br.readLine();
                str = br.readLine();
                nPath = br.readLine();
                if (nPath.length() <= 0) {
                    File file = null;
                    return file;
                }
                iFile = new File(iFile.getParent() + File.separator + nPath + File.separator + (String)child);
                File file = this.getFile(iFile.getParent(), iFile.getName(), true);
                return file;
            }
            finally {
                fis.close();
            }
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private FileInputStream getFIS(File iFile) {
        if (iFile == null) {
            return null;
        }
        FileInputStream fis = null;
        try {
            File lowerFile;
            if (iFile.exists()) {
                fis = new FileInputStream(iFile);
            }
            if (fis == null && (lowerFile = new File(iFile.getParent(), iFile.getName().toLowerCase())).exists()) {
                fis = new FileInputStream(lowerFile);
            }
        }
        catch (FileNotFoundException fene) {
            this.addParseMessage(null, fene.getMessage() + " " + String.valueOf(iFile));
        }
        return fis;
    }

    private boolean addFile(String file) {
        if (this.files.contains(file)) {
            return true;
        }
        this.files.add(file);
        return false;
    }

    private void printCommentedLines(boolean emitSwitch, String line, String state) {
        StringBuffer buf = new StringBuffer("///");
        buf.append(emitSwitch ? " " : "/");
        buf.append(line);
        if (emitSwitch) {
            buf.append(" ===" + state);
        }
        buf.append("\n");
        this.print(buf.toString());
    }

    private void print(String text) {
        this.outputStream.print(text);
    }

    private void println(String text) {
        this.outputStream.println(" " + text);
    }

    private void printFiles() {
        Iterator<String> eFiles = this.files.iterator();
        while (eFiles.hasNext()) {
            this.addParseMessage(null, "PreProcessor: " + eFiles.next());
        }
    }

    private int getopt(String[] args) throws ParseException {
        int i;
        int argc = args.length;
        block14: for (i = 0; i < argc; ++i) {
            String argString = args[i];
            switch (argString.charAt(0)) {
                case '-': {
                    String optValue = "";
                    if (argString.length() > 2) {
                        optValue = argString.substring(2);
                    } else if (i < args.length - 1) {
                        optValue = args[++i];
                    }
                    switch (argString.charAt(1)) {
                        case 'I': {
                            this.addIncludePath(optValue);
                            continue block14;
                        }
                        case 'D': {
                            Token k;
                            StringTokenizer parms = new StringTokenizer(optValue, "=");
                            if (parms.hasMoreTokens()) {
                                String key = parms.nextToken();
                                String val = parms.hasMoreTokens() ? parms.nextToken() : "";
                                if (this.verboseLevel == 3 || this.verboseLevel == 6) {
                                    this.addParseMessage(null, "Predefining " + key + " to " + val);
                                }
                                k = new Token();
                                Token v = new Token();
                                k.image = key;
                                v.image = val;
                                v.kind = this.getNumericType(val);
                                k.kind = 121;
                                PPToken ppk = new PPToken(k);
                                PPToken ppv = new PPToken(v);
                                this.setDef(ppk, ppv);
                                if (this.verboseLevel != 3 && this.verboseLevel != 6) continue block14;
                                this.addParseMessage(null, "Defs: containsKey: " + key + " = " + this.defs.containsKey(key) + " " + this.defs.size());
                                continue block14;
                            }
                            if (this.verboseLevel == 3 || this.verboseLevel == 6) {
                                this.addParseMessage(null, "Predefining " + optValue);
                            }
                            k = new Token();
                            k.image = argString.substring(2);
                            PPToken ppk = new PPToken(k);
                            k.kind = 121;
                            this.setDef(ppk);
                            continue block14;
                        }
                        case 'U': {
                            this.defs.remove(optValue);
                            continue block14;
                        }
                        case 'v': {
                            try {
                                this.verboseLevel = Integer.parseInt(optValue, 10);
                                continue block14;
                            }
                            catch (NumberFormatException nfe) {
                                this.addParseMessage(null, "Verbose Level Error: " + nfe.getMessage());
                                throw new ParseException("Bad verbosity level " + optValue);
                            }
                        }
                        case 'O': {
                            try {
                                this.setOutputStream(new FileOutputStream(optValue));
                                continue block14;
                            }
                            catch (FileNotFoundException exc) {
                                this.addParseMessage(null, "Couldn't create file " + optValue);
                                throw new ParseException("Couldn't create file " + optValue);
                            }
                        }
                        default: {
                            this.addParseMessage(null, "Unknown option: " + argString);
                            throw new ParseException("Unknown option: " + argString);
                        }
                    }
                }
                default: {
                    return i;
                }
            }
        }
        return i;
    }

    public void addIncludePath(String path) {
        this.pathList.addElement(path);
    }

    public void addIncludePaths(String[] paths) {
        if (paths == null || paths.length < 1) {
            return;
        }
        for (String path : paths) {
            this.addIncludePath(path);
        }
    }

    public int getNumericType(String val) {
        try {
            Double.parseDouble(val);
            return 120;
        }
        catch (NumberFormatException nfe) {
            try {
                if (val.endsWith("L") || val.endsWith("l") || val.endsWith("U")) {
                    val = val.substring(0, val.length() - 1);
                }
                if (val.startsWith("0x") || val.startsWith("0X")) {
                    Integer.parseInt(val.substring(2), 16);
                } else {
                    Integer.parseInt(val);
                }
                return 119;
            }
            catch (NumberFormatException numberFormatException) {
                return 121;
            }
        }
    }

    public Double getDoubleValue(String val) {
        double value = 0.0;
        try {
            value = Double.parseDouble(val);
        }
        catch (NumberFormatException nfe) {
            value = this.getLongValue(val).doubleValue();
        }
        return value;
    }

    private BigInteger getLongValue(String str) throws NumberFormatException {
        try {
            if (str.endsWith("L") || str.endsWith("l") || str.endsWith("U")) {
                str = str.substring(0, str.length() - 1);
            }
            if (str.startsWith("--")) {
                str = str.substring(2, str.length());
            }
            if (str.startsWith("0x") || str.startsWith("0X")) {
                return new BigInteger(str.substring(2), 16);
            }
            return new BigInteger(str);
        }
        catch (NumberFormatException numberFormatException) {
            throw new NumberFormatException("Couldn't parse number: '" + str + "'");
        }
    }

    private void addParseMessage(String filename, String message) {
        if (filename != null) {
            this.parseMessages.append("   In file " + filename + "\n");
        }
        this.parseMessages.append(message + "\n");
    }

    public String getParseMessages() {
        return this.parseMessages.toString();
    }

    public boolean didParseSucceed() {
        return this.parseSuccess;
    }

    public void setArgs(String[] args) throws ParseException {
        this.shift = this.getopt(args);
    }

    public void setOutputStream(OutputStream fos) {
        this.outputStream = new PrintStream(fos);
    }

    public boolean parse(String filename) throws ParseException {
        if (this.verboseLevel == 1) {
            this.addParseMessage(null, "PreProcessor:  Reading from file " + filename + " . . .");
        }
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(filename);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        if (fis == null) {
            for (int i = 0; i < this.pathList.size(); ++i) {
                File iFile = this.getFile(this.pathList.elementAt(i), filename);
                fis = this.getFIS(iFile);
                if (fis == null) continue;
                filename = iFile.getAbsolutePath();
                break;
            }
        }
        if (fis == null) {
            String msg = "PreProcessor:  File " + filename + " not found.";
            this.addParseMessage(null, msg);
            Msg.error((Object)this, (Object)msg);
            return false;
        }
        this.fileStack.push(filename);
        this.alreadyDone = new HashMap();
        this.ReInit(fis);
        try {
            this.Input();
            this.fileStack.pop();
            if (this.fileStack.size() == 0 && this.verboseLevel == 1) {
                this.addParseMessage(null, "PreProcessor:  Java program parsed successfully.");
            }
        }
        catch (ParseException e) {
            this.addParseMessage(filename, "PreProcessor Parse Error:  " + e.getMessage());
            throw e;
        }
        catch (TokenMgrError e) {
            this.addParseMessage(filename, "PreProcessor Token Error:  " + e.getMessage());
            throw e;
        }
        return true;
    }

    PreProcessor(PreProcessor parent) {
        this(System.in);
        this.defs = parent.defs;
        this.execStack = parent.execStack;
        this.files = parent.files;
        this.fileStack = parent.fileStack;
        this.ifDepth = parent.ifDepth;
        this.outputStream = parent.outputStream;
        this.pathList = parent.pathList;
        this.shift = parent.shift;
        this.alreadyDone = parent.alreadyDone;
        this.verboseLevel = parent.verboseLevel;
    }

    public PreProcessor(String[] args) throws ParseException {
        this(System.in);
        this.shift = this.getopt(args);
        if (args.length - this.shift == 0) {
            if (this.verboseLevel == 1) {
                this.addParseMessage(null, "PreProcessor:  Reading from standard input . . .");
            }
            this.fileStack.push("stdin");
        } else {
            while (args.length - this.shift >= 1) {
                this.parse(args[this.shift]);
                ++this.shift;
            }
        }
    }

    public PreProcessor(String filename) throws ParseException {
        this(System.in);
        try {
            FileInputStream fis = new FileInputStream(filename);
            this.ReInit(fis);
        }
        catch (FileNotFoundException e) {
            this.addParseMessage(null, "PreProcessor:  File " + filename + " not found.");
            this.addParseMessage(null, "Usage is one of:");
            this.addParseMessage(null, "         java PreProcessor < inputfile ...");
            this.addParseMessage(null, "OR");
            this.addParseMessage(null, "         java PreProcessor inputfile ...");
            return;
        }
    }

    public PreProcessor() throws ParseException {
        this(System.in);
    }

    public void setMonitor(TaskMonitor monitor) {
        this.monitor = monitor;
    }

    public static void main(String[] args) {
        try {
            PreProcessor preProcessor = new PreProcessor(args);
        }
        catch (ParseException e) {
            System.out.println("PreProcessor:  Encountered errors during parse.");
            System.out.println("PreProcessor: " + e.getMessage());
        }
    }

    public final void Input() throws ParseException {
        PPToken b;
        int conditionDepth = this.execStack.size();
        PPToken ppt = new PPToken("\n#line 1: \"" + this.curFileStackTop() + "\"\n");
        ppt.emit(false);
        block3: do {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 0: 
                case 7: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 88: 
                case 89: 
                case 90: 
                case 91: 
                case 92: 
                case 93: 
                case 119: 
                case 124: 
                case 136: 
                case 137: 
                case 138: 
                case 144: 
                case 146: 
                case 147: 
                case 148: 
                case 154: 
                case 158: 
                case 161: 
                case 162: 
                case 164: 
                case 167: 
                case 171: 
                case 172: 
                case 178: 
                case 179: 
                case 180: 
                case 181: {
                    break;
                }
                default: {
                    this.jj_la1[0] = this.jj_gen;
                    break block3;
                }
            }
            b = this.TranslationUnit();
            if (this.monitor == null || !this.monitor.isCancelled()) continue;
            throw new ParseException("Parsing Canceled");
        } while (b.getTruth());
        if (conditionDepth != this.execStack.size()) {
            this.addParseMessage(null, "Imbalance in sequence/nesting of compile-time conditions/logic in input file " + this.curFileStackTop());
            this.addParseMessage(null, "              " + String.valueOf(this.execStack));
            while (conditionDepth != this.execStack.size() && this.execStack.size() > 0) {
                PPToken olde = this.execStack.pop();
                this.emitExecSwitch = olde.getEmitSave();
            }
        }
    }

    public final PPToken TranslationUnit() throws ParseException {
        PPToken b;
        while ((b = this.Group()).getTruth() && this.jj_2_1(2)) {
        }
        return b;
    }

    public final void NoMas() throws ParseException {
        this.jj_consume_token(0);
    }

    public final PPToken Group() throws ParseException {
        if (this.jj_2_3(2)) {
            PPToken b = this.GroupPart();
            return b;
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: {
                PPToken b;
                do {
                    if ((b = this.IFSection()).getTruth()) continue;
                    return b;
                } while (this.jj_2_2(2));
                return b;
            }
        }
        this.jj_la1[1] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final PPToken GroupPart() throws ParseException {
        PPToken u = new PPToken("");
        Token v = new Token();
        v.image = "";
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 7: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 124: 
            case 137: 
            case 148: 
            case 154: 
            case 158: 
            case 162: 
            case 172: 
            case 179: 
            case 180: {
                PPToken t;
                do {
                    t = this.Text();
                    if (this.emitExecSwitch) {
                        t.emit(true);
                    } else {
                        t.emit(false);
                    }
                    t.image = "";
                    u.image = "";
                } while (this.jj_2_4(2));
                t.setTruth(true);
                return t;
            }
        }
        this.jj_la1[2] = this.jj_gen;
        if (this.jj_2_6(3)) {
            PPToken t = this.IFSection();
            return t;
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 0: 
            case 119: 
            case 136: 
            case 138: 
            case 144: 
            case 146: 
            case 147: 
            case 161: 
            case 164: 
            case 167: 
            case 171: 
            case 178: 
            case 181: {
                PPToken t = this.ControlLine();
                return t;
            }
        }
        this.jj_la1[3] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final PPToken ControlLine() throws ParseException {
        PPToken t = new PPToken("");
        Object u = null;
        Vector vals = new Vector();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 119: 
            case 136: 
            case 138: 
            case 144: 
            case 146: 
            case 147: 
            case 161: 
            case 164: 
            case 167: 
            case 171: 
            case 178: 
            case 181: {
                if (this.jj_2_7(2)) {
                    this.Define();
                } else {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 136: 
                        case 138: 
                        case 144: 
                        case 146: {
                            this.Include();
                            break;
                        }
                        case 171: {
                            this.UnDef();
                            break;
                        }
                        case 147: {
                            this.Pragma();
                            break;
                        }
                        case 161: {
                            this.Error();
                            break;
                        }
                        case 164: {
                            this.Warning();
                            break;
                        }
                        case 167: {
                            this.Info();
                            break;
                        }
                        case 119: 
                        case 181: {
                            this.LineInfo();
                            break;
                        }
                        default: {
                            this.jj_la1[4] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                }
                if (vals != null && vals.size() == 0) {
                    vals = null;
                }
                t.setTruth(true);
                return t;
            }
            case 0: {
                this.NoMas();
                t.setTruth(false);
                return t;
            }
        }
        this.jj_la1[5] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final PPToken IFSection() throws ParseException {
        PPToken ifg = this.IFGroup();
        PPToken group = this.GroupPart();
        return group;
    }

    public final PPToken IFGroup() throws ParseException {
        PPToken t;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 88: {
                PPToken e = this.If();
                t = this.IfCondition();
                e.setEmitSave(this.emitExecSwitch);
                e.setTruth(t.getTruth());
                this.execStack.push(e);
                this.printCommentedLines(this.emitExecSwitch, "#if " + t.image, "" + t.getTruth());
                if (this.emitExecSwitch) {
                    this.emitExecSwitch = e.getTruth();
                }
                if (this.verboseLevel != 6 && this.verboseLevel != 7) break;
                this.println("[" + this.execStack.size() + "]If " + t.getTruth() + " : " + this.emitExecSwitch);
                break;
            }
            case 89: {
                PPToken e = this.ElIf();
                t = this.ElseIfCondition();
                e.setTruth(t.getTruth());
                if (this.execStack.size() == 0) {
                    this.addParseMessage(null, this.curFileStackTop() + "'" + t.beginLine + "Unbalanced IF directive detected");
                    throw new ParseException(this.curFileStackTop() + "'" + t.beginLine + "Unbalanced IF directive detected");
                }
                PPToken olde = this.execStack.pop();
                this.emitExecSwitch = olde.getEmitSave();
                this.printCommentedLines(this.emitExecSwitch, "#else if " + t.image, "" + t.getTruth());
                e.setEmitSave(this.emitExecSwitch);
                this.emitExecSwitch = !olde.getTruth() && this.emitExecSwitch ? e.getTruth() : false;
                if (olde.getTruth()) {
                    e.setTruth(true);
                }
                this.execStack.push(e);
                if (this.verboseLevel != 6 && this.verboseLevel != 7) break;
                this.println("[" + this.execStack.size() + "]ElIf " + t.getTruth() + " : " + this.emitExecSwitch);
                break;
            }
            case 92: {
                PPToken e = this.IfDef();
                t = this.IfDefExpr();
                t.setEmitSave(this.emitExecSwitch);
                this.execStack.push(t);
                this.printCommentedLines(this.emitExecSwitch, "#ifdef " + t.image, "" + t.getTruth());
                if (this.emitExecSwitch) {
                    this.emitExecSwitch = t.getTruth();
                }
                if (this.verboseLevel != 6 && this.verboseLevel != 7) break;
                this.println("[" + this.execStack.size() + "]IfDef " + t.getTruth() + " : " + this.emitExecSwitch);
                break;
            }
            case 93: {
                PPToken e = this.IfNDef();
                t = this.IfNDefExpr();
                t.setEmitSave(this.emitExecSwitch);
                this.execStack.push(t);
                this.printCommentedLines(this.emitExecSwitch, "#ifndef " + t.image, "" + t.getTruth());
                if (this.emitExecSwitch) {
                    this.emitExecSwitch = t.getTruth();
                }
                if (this.verboseLevel != 6 && this.verboseLevel != 7) break;
                this.println("[" + this.execStack.size() + "]IfNDef " + t.getTruth() + " : " + this.emitExecSwitch);
                break;
            }
            case 90: {
                t = this.Else();
                if (this.execStack.size() == 0) {
                    this.addParseMessage(null, this.curFileStackTop() + "'" + t.beginLine + "Unbalanced IF directive detected");
                    throw new ParseException(this.curFileStackTop() + "'" + t.beginLine + "Unbalanced IF directive detected");
                }
                PPToken olde = this.execStack.pop();
                this.emitExecSwitch = olde.getEmitSave();
                this.printCommentedLines(this.emitExecSwitch, "#else", "" + t.getTruth());
                t.setEmitSave(this.emitExecSwitch);
                if (this.emitExecSwitch && olde.getTruth()) {
                    this.emitExecSwitch = false;
                }
                this.execStack.push(t);
                if (this.verboseLevel != 6 && this.verboseLevel != 7) break;
                this.println("[" + this.execStack.size() + "]" + this.curFileStackTop() + "'" + t.beginLine + ": Else now " + t.getTruth() + " : " + this.emitExecSwitch);
                break;
            }
            case 91: {
                t = this.EndIf();
                if (this.execStack.size() == 0) {
                    this.addParseMessage(null, this.curFileStackTop() + "'" + t.beginLine + "Unbalanced IF directive detected");
                    throw new ParseException(this.curFileStackTop() + "'" + t.beginLine + "Unbalanced IF directive detected");
                }
                PPToken olde = this.execStack.pop();
                boolean newExecSwitch = olde.getEmitSave();
                this.printCommentedLines(newExecSwitch, "#endif", "" + this.emitExecSwitch);
                this.emitExecSwitch = newExecSwitch;
                if (this.verboseLevel != 6 && this.verboseLevel != 7) break;
                this.println("[" + this.execStack.size() + "]" + this.curFileStackTop() + "'" + t.beginLine + ": Endif  : " + this.emitExecSwitch);
                break;
            }
            default: {
                this.jj_la1[6] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return t;
    }

    public final PPToken IfCondition() throws ParseException {
        PPToken t = this.CompoundConditionalExpression();
        return t;
    }

    public final PPToken ElseIfCondition() throws ParseException {
        PPToken t = this.CompoundConditionalExpression();
        return t;
    }

    public final PPToken Include() throws ParseException {
        PPToken pt;
        Token t;
        int conditionDepth = this.execStack.size();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 146: {
                t = this.jj_consume_token(146);
                pt = new PPToken(t);
                if (!this.emitExecSwitch) break;
                this.localPlace(pt, true);
                this.println("\n#line " + t.beginLine + ": \"" + this.curFileStackTop() + "\"");
                break;
            }
            case 144: {
                t = this.jj_consume_token(144);
                pt = new PPToken(t);
                if (!this.emitExecSwitch) break;
                this.standardPlace(pt, true);
                this.println("\n#line " + t.beginLine + ": \"" + this.curFileStackTop() + "\"");
                break;
            }
            case 138: {
                t = this.jj_consume_token(138);
                pt = new PPToken(t);
                pt.image = this.defs.expand(pt.image, true);
                if (!this.emitExecSwitch) break;
                this.standardPlace(pt, true);
                this.println("\n#line " + t.beginLine + ": \"" + this.curFileStackTop() + "\"");
                break;
            }
            case 136: {
                t = this.jj_consume_token(136);
                pt = new PPToken(t);
                if (!this.emitExecSwitch) break;
                this.localPlace(pt, true);
                this.println("\n#line " + t.beginLine + ": \"" + this.curFileStackTop() + "\"");
                break;
            }
            default: {
                this.jj_la1[7] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (conditionDepth != this.execStack.size()) {
            this.addParseMessage(null, "Imbalance in sequence/nesting of compile-time conditions/logic in included file " + t.image);
            this.addParseMessage(null, "              " + String.valueOf(this.execStack));
            while (conditionDepth != this.execStack.size() && this.execStack.size() > 0) {
                PPToken olde = this.execStack.pop();
                this.emitExecSwitch = olde.getEmitSave();
            }
        }
        return pt;
    }

    public final PPToken LineInfo() throws ParseException {
        Token t;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 181: {
                t = this.jj_consume_token(181);
                break;
            }
            case 119: {
                t = this.jj_consume_token(119);
                t.image = "#line " + t.image + ": \"" + this.curFileStackTop() + "\"";
                this.println(t.image);
                this.token_source.SwitchTo(0);
                break;
            }
            default: {
                this.jj_la1[8] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return new PPToken(t);
    }

    public final PPToken Define() throws ParseException {
        PPToken pt;
        Token t;
        Token u = null;
        PPToken v = null;
        PPToken w = null;
        PPToken x = null;
        Vector<PPToken> dargs = null;
        if (this.jj_2_10(2)) {
            t = this.jj_consume_token(178);
            if (this.jj_2_8(2)) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 198: 
                    case 199: 
                    case 200: {
                        u = new Token();
                        if (dargs == null) {
                            dargs = new Vector();
                        }
                        block28: while (true) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 198: 
                                case 199: {
                                    break;
                                }
                                default: {
                                    this.jj_la1[9] = this.jj_gen;
                                    break block28;
                                }
                            }
                            u = this.MacroArgs();
                            dargs.add((PPToken)u);
                        }
                        this.jj_consume_token(200);
                        break;
                    }
                    case 191: 
                    case 192: 
                    case 193: 
                    case 197: 
                    case 208: 
                    case 209: 
                    case 217: {
                        u = this.MacroVals();
                        break;
                    }
                    default: {
                        this.jj_la1[10] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 191: 
                    case 192: 
                    case 193: 
                    case 197: 
                    case 208: 
                    case 209: 
                    case 217: {
                        block29: while (true) {
                            w = this.MacroVals();
                            if (x == null) {
                                if (dargs != null) {
                                    x = w;
                                } else {
                                    x = u;
                                    x.image = x.image + w.image;
                                }
                            } else {
                                x.image = x.image + w.image;
                            }
                            v = x;
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 191: 
                                case 192: 
                                case 193: 
                                case 197: 
                                case 208: 
                                case 209: 
                                case 217: {
                                    continue block29;
                                }
                            }
                            break;
                        }
                        this.jj_la1[11] = this.jj_gen;
                        break;
                    }
                    default: {
                        this.jj_la1[12] = this.jj_gen;
                        break;
                    }
                }
            }
        } else if (this.jj_2_11(2)) {
            t = this.jj_consume_token(178);
            u = this.MacroArgs();
            if (dargs == null) {
                dargs = new Vector<PPToken>();
            }
            dargs.add((PPToken)u);
            if (this.jj_2_9(2)) {
                v = this.Define();
            }
        } else if (this.jj_2_12(2)) {
            t = this.jj_consume_token(178);
            block13 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 198: 
                case 199: {
                    block30: while (true) {
                        u = this.MacroArgs();
                        if (dargs == null) {
                            dargs = new Vector();
                        }
                        dargs.add((PPToken)u);
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 198: 
                            case 199: {
                                continue block30;
                            }
                        }
                        break;
                    }
                    this.jj_la1[13] = this.jj_gen;
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 191: 
                        case 192: 
                        case 193: 
                        case 197: 
                        case 208: 
                        case 209: 
                        case 217: {
                            v = this.MacroVals();
                            break block13;
                        }
                    }
                    this.jj_la1[14] = this.jj_gen;
                    break;
                }
                default: {
                    this.jj_la1[15] = this.jj_gen;
                    break;
                }
            }
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 178: {
                    t = this.jj_consume_token(178);
                    block31: while (true) {
                        this.jj_consume_token(67);
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 67: {
                                continue block31;
                            }
                        }
                        break;
                    }
                    this.jj_la1[16] = this.jj_gen;
                    u = this.Define();
                    break;
                }
                default: {
                    this.jj_la1[17] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        if (!this.isDef(pt = new PPToken(t))) {
            if (u != null && v != null) {
                PPToken pv = new PPToken((Token)v);
                this.setMacro(pt, dargs, pv);
                this.printCommentedLines(this.emitExecSwitch, "#define " + pt.image + "(" + String.valueOf(dargs) + ")  " + pv.image, "DEFINED");
            } else if (u == null && v == null) {
                this.setDef(pt);
                this.printCommentedLines(this.emitExecSwitch, "#define " + pt.image, "DEFINED");
            } else if (v != null) {
                PPToken pv = new PPToken((Token)v);
                this.setDef(pt, pv);
                this.printCommentedLines(this.emitExecSwitch, "#define " + pt.image + "  " + pv.image, "DEFINED");
            } else if (u != null) {
                if (dargs != null) {
                    PPToken pv = new PPToken("");
                    this.setMacro(pt, dargs, pv);
                    this.printCommentedLines(this.emitExecSwitch, "#define " + pt.image + "(" + String.valueOf(dargs) + ")  " + pv.image, "DEFINED");
                } else {
                    PPToken pu = new PPToken(u);
                    this.setDef(pt, pu);
                    this.printCommentedLines(this.emitExecSwitch, "#define " + pt.image + "  " + pu.image, "DEFINED");
                }
            }
        } else if (this.verboseLevel == 5 || this.verboseLevel == 6) {
            this.println("PreProcessor: " + this.curFileStackTop() + "'" + t.beginLine + ": " + t.image + " aready defined. Undefine first.");
        }
        return pt;
    }

    public final PPToken UnDef() throws ParseException {
        Token t = this.jj_consume_token(171);
        PPToken pt = new PPToken(t);
        if (this.isDef(pt)) {
            this.UnDefine(pt);
        }
        return pt;
    }

    public final PPToken MacroArgs() throws ParseException {
        Object u = null;
        return new PPToken(switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 198 -> this.jj_consume_token(198);
            case 199 -> this.jj_consume_token(199);
            default -> {
                this.jj_la1[18] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        });
    }

    public final PPToken MacroVals() throws ParseException {
        Token u = new Token();
        u.image = "";
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 191: 
            case 192: 
            case 193: 
            case 197: {
                u = this.Values();
                break;
            }
            case 208: 
            case 209: 
            case 217: {
                Token t;
                do {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 208: {
                            t = this.jj_consume_token(208);
                            u.image = u.image + t.image;
                            break;
                        }
                        case 209: {
                            t = this.jj_consume_token(209);
                            t.image = "/";
                            break;
                        }
                        case 217: {
                            t = this.jj_consume_token(217);
                            u.image = u.image + "\"" + t.image + "\"";
                            break;
                        }
                        default: {
                            this.jj_la1[19] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                } while (this.jj_2_13(2));
                if (!this.jj_2_15(2)) break;
                while (true) {
                    t = this.Values();
                    u.image = u.image + t.image;
                    if (!this.jj_2_14(2)) break block0;
                }
            }
            default: {
                this.jj_la1[20] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return new PPToken(u);
    }

    public final PPToken Pragma() throws ParseException {
        Token u = null;
        do {
            Token t = this.jj_consume_token(147);
            if (u == null) {
                u = t;
                continue;
            }
            u.image = u.image + t.image;
        } while (this.jj_2_16(2));
        PPToken pt = new PPToken(u);
        if (this.emitExecSwitch) {
            this.println("#pragma " + this.defs.expand(u.image, true));
        }
        return pt;
    }

    public final PPToken IfDef() throws ParseException {
        Token t = this.jj_consume_token(92);
        PPToken pt = new PPToken(t);
        if (this.verboseLevel() == 7) {
            this.print(this.curFileStackTop() + "'" + t.beginLine + ": " + t.image + ": ");
        }
        pt.setTruth(this.isDef(pt));
        return pt;
    }

    public final PPToken IfDefExpr() throws ParseException {
        Token t = this.jj_consume_token(153);
        PPToken pt = new PPToken(t);
        if (this.verboseLevel() == 7) {
            this.print(this.curFileStackTop() + "'" + t.beginLine + ": " + t.image + ": ");
        }
        pt.setTruth(this.isDef(pt));
        return pt;
    }

    public final PPToken IfNDef() throws ParseException {
        Token t = this.jj_consume_token(93);
        PPToken pt = new PPToken(t);
        if (this.verboseLevel == 6 || this.verboseLevel == 7) {
            this.print(this.curFileStackTop() + "'" + t.beginLine + " IFNDEF: ");
        }
        pt.setTruth(this.isNDef(pt));
        return pt;
    }

    public final PPToken IfNDefExpr() throws ParseException {
        Token t = this.jj_consume_token(157);
        PPToken pt = new PPToken(t);
        if (this.verboseLevel() == 7) {
            this.print(this.curFileStackTop() + "'" + t.beginLine + ": " + t.image + ": ");
        }
        pt.setTruth(this.isNDef(pt));
        return pt;
    }

    public final PPToken Error() throws ParseException {
        Token t = this.jj_consume_token(161);
        if (this.emitExecSwitch) {
            this.addParseMessage(null, this.curFileStackTop() + "'" + t.beginLine + " Compiler Error:");
            this.addParseMessage(null, t.image);
        }
        return new PPToken(t);
    }

    public final PPToken Warning() throws ParseException {
        Token t = this.jj_consume_token(164);
        if (this.emitExecSwitch) {
            this.addParseMessage(null, this.curFileStackTop() + "'" + t.beginLine + " Warning: ");
            this.addParseMessage(null, t.image);
        }
        return new PPToken(t);
    }

    public final PPToken Info() throws ParseException {
        Token t = this.jj_consume_token(167);
        if (this.emitExecSwitch) {
            Msg.info((Object)this, (Object)(this.curFileStackTop() + "'" + t.beginLine + " Info: "));
            Msg.info((Object)this, (Object)t.image);
        }
        return new PPToken(t);
    }

    public final PPToken EndIf() throws ParseException {
        Token t = this.jj_consume_token(91);
        return new PPToken(t);
    }

    public final PPToken Else() throws ParseException {
        Token t = this.jj_consume_token(90);
        return new PPToken(t);
    }

    public final PPToken If() throws ParseException {
        Token t = this.jj_consume_token(88);
        if (this.verboseLevel == 6 || this.verboseLevel == 7) {
            this.print(this.curFileStackTop() + "'" + t.beginLine + " IF: ");
        }
        return new PPToken(t);
    }

    public final PPToken ElIf() throws ParseException {
        Token t = this.jj_consume_token(89);
        if (this.verboseLevel == 6 || this.verboseLevel == 7) {
            this.print(this.curFileStackTop() + "'" + t.beginLine + " ElseIf: ");
        }
        return new PPToken(t);
    }

    public final PPToken Values() throws ParseException {
        Token t;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 191: {
                t = this.jj_consume_token(191);
                t.kind = this.getNumericType(t.image);
                break;
            }
            case 197: {
                t = this.QuotedValue();
                break;
            }
            case 192: {
                t = this.jj_consume_token(192);
                t.image = "/";
                break;
            }
            case 193: {
                t = this.jj_consume_token(193);
                break;
            }
            default: {
                this.jj_la1[21] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        PPToken pt = new PPToken(t);
        pt.join();
        return pt;
    }

    public final PPToken QuotedValue() throws ParseException {
        Token t = new Token();
        t.image = "\"";
        Token u = this.jj_consume_token(197);
        t.image = t.image + u.image;
        t.image = t.image + "\"";
        return new PPToken(t);
    }

    public final PPToken Text() throws ParseException {
        Token t = new Token();
        PPToken buf = new PPToken("");
        t.image = "";
        if (this.jj_2_32(3)) {
            while (true) {
                Token u;
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 68: {
                        u = this.jj_consume_token(68);
                        this.bufAppendWithComment(buf, u);
                        while (this.jj_2_17(2)) {
                            PPToken nl = this.NewLines();
                            if (this.emitExecSwitch) {
                                buf.append(nl.image, true);
                                continue;
                            }
                            buf.append((u.image.length() == 0 ? "//// " : "") + nl.image, false);
                        }
                        break;
                    }
                    case 70: {
                        u = this.jj_consume_token(70);
                        this.bufAppendWithComment(buf, u);
                        break;
                    }
                    default: {
                        this.jj_la1[22] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                if (this.jj_2_18(2)) {
                    u = this.NewLines();
                    this.bufAppendWithComment(buf, u);
                }
                block4 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 70: 
                    case 71: {
                        while (true) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 71: {
                                    u = this.QuotedText();
                                    this.bufAppendWithComment(buf, u);
                                    if (!this.jj_2_19(2)) break;
                                    u = this.NewLines();
                                    this.bufAppendWithComment(buf, u);
                                    break;
                                }
                                case 70: {
                                    u = this.jj_consume_token(70);
                                    this.bufAppendWithComment(buf, u);
                                    break;
                                }
                                default: {
                                    this.jj_la1[23] = this.jj_gen;
                                    this.jj_consume_token(-1);
                                    throw new ParseException();
                                }
                            }
                            if (this.jj_2_20(2)) {
                                t = this.NewLines();
                                if (this.emitExecSwitch) {
                                    buf.append(t.image, true);
                                } else {
                                    buf.append("//// " + u.image, false);
                                }
                            }
                            if (this.jj_2_21(2)) {
                                u = this.jj_consume_token(70);
                                this.bufAppendWithComment(buf, u);
                            }
                            if (this.jj_2_22(2)) {
                                u = this.NewLines();
                                this.bufAppendWithComment(buf, u);
                            }
                            if (!this.jj_2_23(2)) break block4;
                        }
                    }
                    default: {
                        this.jj_la1[24] = this.jj_gen;
                    }
                }
                if (this.jj_2_25(2)) {
                    u = this.jj_consume_token(70);
                    this.bufAppendWithComment(buf, u);
                    while (this.jj_2_24(2)) {
                        u = this.NewLines();
                        this.bufAppendWithComment(buf, u);
                    }
                }
                if (this.jj_2_26(2)) {
                    continue;
                }
                break;
            }
        } else {
            block11 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 70: 
                case 71: {
                    while (true) {
                        Token u;
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 71: {
                                u = this.QuotedText();
                                this.bufAppendWithComment(buf, u);
                                if (!this.jj_2_27(2)) break;
                                u = this.NewLines();
                                this.bufAppendWithComment(buf, u);
                                break;
                            }
                            case 70: {
                                u = this.jj_consume_token(70);
                                this.bufAppendWithComment(buf, u);
                                break;
                            }
                            default: {
                                this.jj_la1[25] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                        if (this.jj_2_28(2)) {
                            t = this.NewLines();
                            if (this.emitExecSwitch) {
                                buf.append(t.image, true);
                            } else {
                                buf.append("//// " + u.image, false);
                            }
                        }
                        if (this.jj_2_29(2)) {
                            u = this.jj_consume_token(70);
                            this.bufAppendWithComment(buf, u);
                        }
                        if (this.jj_2_30(2)) {
                            u = this.NewLines();
                            this.bufAppendWithComment(buf, u);
                        }
                        if (!this.jj_2_31(2)) break block11;
                    }
                }
                case 7: 
                case 69: 
                case 124: 
                case 137: 
                case 148: 
                case 154: 
                case 158: 
                case 162: 
                case 172: 
                case 179: 
                case 180: {
                    PPToken u = this.NewLines();
                    this.bufAppendWithComment(buf, u);
                    break;
                }
                default: {
                    this.jj_la1[26] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        return buf;
    }

    public final PPToken NewLines() throws ParseException {
        return new PPToken(switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 69 -> this.jj_consume_token(69);
            case 7 -> this.jj_consume_token(7);
            case 162 -> this.jj_consume_token(162);
            case 180 -> this.jj_consume_token(180);
            case 148 -> this.jj_consume_token(148);
            case 154 -> this.jj_consume_token(154);
            case 158 -> this.jj_consume_token(158);
            case 124 -> this.jj_consume_token(124);
            case 172 -> this.jj_consume_token(172);
            case 179 -> this.jj_consume_token(179);
            case 137 -> this.jj_consume_token(137);
            default -> {
                this.jj_la1[27] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        });
    }

    public final PPToken QuotedText() throws ParseException {
        Token t = null;
        Token r = null;
        block3: while (true) {
            t = this.jj_consume_token(71);
            if (r == null) {
                r = t;
            } else {
                r.image = r.image.substring(0, r.image.length()) + t.image.substring(1);
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 71: {
                    continue block3;
                }
            }
            break;
        }
        this.jj_la1[28] = this.jj_gen;
        return new PPToken(r);
    }

    public final PPToken CompoundConditionalExpression() throws ParseException {
        PPToken t;
        if (this.jj_2_34(2)) {
            t = this.ConditionalExpression();
        } else {
            block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 88: 
                case 90: 
                case 94: 
                case 95: 
                case 96: 
                case 97: 
                case 98: 
                case 112: 
                case 113: 
                case 119: 
                case 120: 
                case 121: 
                case 122: {
                    if (this.jj_2_33(2)) {
                        t = this.CompoundOrExpression();
                        break;
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 88: 
                        case 90: 
                        case 94: 
                        case 95: 
                        case 96: 
                        case 97: 
                        case 98: 
                        case 112: 
                        case 113: 
                        case 119: 
                        case 120: 
                        case 121: 
                        case 122: {
                            t = this.CompoundAndExpression();
                            break block0;
                        }
                    }
                    this.jj_la1[29] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
                default: {
                    this.jj_la1[30] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        return new PPToken(t);
    }

    public final PPToken CompoundAndExpression() throws ParseException {
        PPToken t = this.ConditionalExpression();
        while (this.jj_2_35(2)) {
            PPToken u = this.LogAnd();
            if (this.verboseLevel() == 7) {
                this.print(u.image);
            }
            PPToken v = this.ConditionalExpression();
            t.setTruth(t.getTruth() && v.getTruth());
            if (this.verboseLevel() != 7) continue;
            this.print(": ");
        }
        return t;
    }

    public final PPToken CompoundOrExpression() throws ParseException {
        PPToken t = this.ConditionalExpression();
        while (this.jj_2_36(2)) {
            PPToken u = this.LogOr();
            if (this.verboseLevel() == 7) {
                this.print(u.image);
            }
            PPToken v = this.ConditionalExpression();
            t.setTruth(t.getTruth() || v.getTruth());
            if (this.verboseLevel() != 7) continue;
            this.print(": ");
        }
        return t;
    }

    public final PPToken ConditionalExpression() throws ParseException {
        PPToken t = this.LogicalOrExpression();
        while (this.jj_2_37(2)) {
            PPToken u = this.Qmark();
            PPToken i = this.LogicalOrExpression();
            u = this.ElseMark();
            PPToken e = this.LogicalOrExpression();
            if (t.getTruth()) {
                t = i;
                continue;
            }
            t = e;
        }
        return t;
    }

    public final PPToken LogicalOrExpression() throws ParseException {
        PPToken t = this.LogicalAndExpression();
        while (this.jj_2_38(2)) {
            PPToken u = this.LogOr();
            if (this.verboseLevel() == 7) {
                this.print(u.image);
            }
            PPToken v = this.LogicalAndExpression();
            t.setTruth(t.getTruth() || v.getTruth());
            if (this.verboseLevel() != 7) continue;
            this.print(": ");
        }
        return t;
    }

    public final PPToken LogicalAndExpression() throws ParseException {
        PPToken t = this.EqualityExpression();
        while (this.jj_2_39(2)) {
            PPToken u = this.LogAnd();
            if (this.verboseLevel() == 7) {
                this.print(u.image);
            }
            PPToken v = this.EqualityExpression();
            t.setTruth(t.getTruth() && v.getTruth());
            if (this.verboseLevel() != 7) continue;
            this.print(": ");
        }
        return t;
    }

    public final PPToken EqualityExpression() throws ParseException {
        PPToken t = this.InEqualityExpression();
        while (this.jj_2_40(2)) {
            PPToken u = this.EqualTo();
            if (this.verboseLevel() == 7) {
                this.print(u.image);
            }
            PPToken v = this.InEqualityExpression();
            try {
                t.setTruth(t.compareTo(v) == 0);
            }
            catch (NumberFormatException exc) {
                t.setTruth(false);
            }
            if (this.verboseLevel() != 7) continue;
            this.print(": ");
        }
        return t;
    }

    public final PPToken InEqualityExpression() throws ParseException {
        PPToken t = this.RelationalExpression();
        while (this.jj_2_41(2)) {
            PPToken u = this.NotEqualTo();
            if (this.verboseLevel() == 7) {
                this.print(u.image);
            }
            PPToken v = this.RelationalExpression();
            try {
                t.setTruth(t.compareTo(v) != 0);
            }
            catch (NumberFormatException exc) {
                t.setTruth(true);
            }
            if (this.verboseLevel() != 7) continue;
            this.print(": ");
        }
        return t;
    }

    public final PPToken RelationalExpression() throws ParseException {
        PPToken t = this.LessExpression();
        while (this.jj_2_42(2)) {
            PPToken u = this.LessThan();
            if (this.verboseLevel() == 7) {
                this.print(u.image);
            }
            PPToken v = this.LessExpression();
            try {
                t.setTruth(t.compareTo(v) < 0);
            }
            catch (NumberFormatException exc) {
                t.setTruth(false);
            }
            if (this.verboseLevel() != 7) continue;
            this.print(": ");
        }
        return t;
    }

    public final PPToken LessExpression() throws ParseException {
        PPToken t = this.LessThanOrEqualExpression();
        while (this.jj_2_43(2)) {
            PPToken u = this.LessThan();
            if (this.verboseLevel() == 7) {
                this.print(u.image);
            }
            PPToken v = this.LessThanOrEqualExpression();
            try {
                t.setTruth(t.compareTo(v) < 0);
            }
            catch (NumberFormatException exc) {
                t.setTruth(false);
            }
            if (this.verboseLevel() != 7) continue;
            this.print(": ");
        }
        return t;
    }

    public final PPToken LessThanOrEqualExpression() throws ParseException {
        PPToken t = this.GreaterThanOrEqualExpression();
        block5: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 103: {
                    break;
                }
                default: {
                    this.jj_la1[31] = this.jj_gen;
                    break block5;
                }
            }
            PPToken u = this.LessThanOrEqual();
            if (this.verboseLevel() == 7) {
                this.print(u.image);
            }
            PPToken v = this.GreaterThanOrEqualExpression();
            try {
                t.setTruth(t.compareTo(v) <= 0);
            }
            catch (NumberFormatException exc) {
                t.setTruth(false);
            }
            if (this.verboseLevel() != 7) continue;
            this.print(": ");
        }
        return t;
    }

    public final PPToken GreaterThanOrEqualExpression() throws ParseException {
        PPToken t = this.GreaterThanExpression();
        block5: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 104: {
                    break;
                }
                default: {
                    this.jj_la1[32] = this.jj_gen;
                    break block5;
                }
            }
            PPToken u = this.GreaterThanOrEqual();
            if (this.verboseLevel() == 7) {
                this.print(u.image);
            }
            PPToken v = this.GreaterThanExpression();
            try {
                t.setTruth(t.compareTo(v) >= 0);
            }
            catch (NumberFormatException exc) {
                t.setTruth(false);
            }
            if (this.verboseLevel() != 7) continue;
            this.print(": ");
        }
        return t;
    }

    public final PPToken GreaterThanExpression() throws ParseException {
        PPToken t = this.Expression();
        block5: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 102: {
                    break;
                }
                default: {
                    this.jj_la1[33] = this.jj_gen;
                    break block5;
                }
            }
            PPToken u = this.GreaterThan();
            if (this.verboseLevel() == 7) {
                this.print(u.image);
            }
            PPToken v = this.Expression();
            try {
                t.setTruth(t.compareTo(v) > 0);
            }
            catch (NumberFormatException exc) {
                t.setTruth(false);
            }
            if (this.verboseLevel() != 7) continue;
            this.print(": ");
        }
        return t;
    }

    public final PPToken LogOr() throws ParseException {
        Token t = this.jj_consume_token(108);
        return new PPToken(t);
    }

    public final PPToken LogAnd() throws ParseException {
        Token t = this.jj_consume_token(109);
        return new PPToken(t);
    }

    public final PPToken EqualTo() throws ParseException {
        Token t = this.jj_consume_token(99);
        return new PPToken(t);
    }

    public final PPToken NotEqualTo() throws ParseException {
        Token t = this.jj_consume_token(100);
        return new PPToken(t);
    }

    public final PPToken LessThan() throws ParseException {
        Token t = this.jj_consume_token(101);
        return new PPToken(t);
    }

    public final PPToken LessThanOrEqual() throws ParseException {
        Token t = this.jj_consume_token(103);
        return new PPToken(t);
    }

    public final PPToken GreaterThan() throws ParseException {
        Token t = this.jj_consume_token(102);
        return new PPToken(t);
    }

    public final PPToken GreaterThanOrEqual() throws ParseException {
        Token t = this.jj_consume_token(104);
        return new PPToken(t);
    }

    public final PPToken Qmark() throws ParseException {
        Token t = this.jj_consume_token(117);
        return new PPToken(t);
    }

    public final PPToken ElseMark() throws ParseException {
        Token t = this.jj_consume_token(118);
        return new PPToken(t);
    }

    public final PPToken Assertion() throws ParseException {
        PPToken pt = null;
        boolean checkDefined = false;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 95: {
                Token t = this.jj_consume_token(95);
                if (this.verboseLevel() == 7) {
                    this.print(t.image);
                }
                pt = this.Expression();
                pt.setTruth(this.isDef(pt = new PPToken(pt)) || pt.kind == 120 || pt.kind == 119);
                return pt;
            }
            case 96: 
            case 97: 
            case 98: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 98: {
                        Token t = this.jj_consume_token(98);
                        break;
                    }
                    case 96: {
                        Token t = this.jj_consume_token(96);
                        break;
                    }
                    case 97: {
                        Token t = this.jj_consume_token(97);
                        if (this.verboseLevel() != 7) break;
                        this.print(t.image);
                        break;
                    }
                    default: {
                        this.jj_la1[34] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                this.jj_consume_token(122);
                pt = this.Expression();
                this.jj_consume_token(123);
                return pt;
            }
        }
        this.jj_la1[35] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final PPToken Expression() throws ParseException {
        PPToken obj = null;
        obj = this.InclusiveORExpression();
        return obj;
    }

    public final PPToken InclusiveORExpression() throws ParseException {
        PPToken obj = null;
        PPToken obj2 = null;
        Token op = null;
        obj = this.ExclusiveORExpression();
        while (this.jj_2_44(2)) {
            op = this.jj_consume_token(106);
            obj2 = this.ExclusiveORExpression();
            obj = obj.computeBinary(op, obj2);
        }
        return obj;
    }

    public final PPToken ExclusiveORExpression() throws ParseException {
        PPToken obj = null;
        PPToken obj2 = null;
        Token op = null;
        obj = this.ANDExpression();
        while (this.jj_2_45(2)) {
            op = this.jj_consume_token(107);
            obj2 = this.ANDExpression();
            obj = obj.computeBinary(op, obj2);
        }
        return obj;
    }

    public final PPToken ANDExpression() throws ParseException {
        PPToken obj = null;
        PPToken obj2 = null;
        Token op = null;
        obj = this.ShiftExpression();
        while (this.jj_2_46(2)) {
            op = this.jj_consume_token(105);
            obj2 = this.ShiftExpression();
            obj = obj.computeBinary(op, obj2);
        }
        return obj;
    }

    public final PPToken ShiftExpression() throws ParseException {
        PPToken obj = null;
        PPToken obj2 = null;
        Token op = null;
        obj = this.AdditiveExpression();
        while (this.jj_2_47(2)) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 110: {
                    op = this.jj_consume_token(110);
                    break;
                }
                case 111: {
                    op = this.jj_consume_token(111);
                    break;
                }
                default: {
                    this.jj_la1[36] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            obj2 = this.AdditiveExpression();
            obj = obj.computeBinary(op, obj2);
        }
        return obj;
    }

    public final PPToken AdditiveExpression() throws ParseException {
        PPToken obj = null;
        PPToken obj2 = null;
        Token op = null;
        obj = this.MultiplicativeExpression();
        while (this.jj_2_48(2)) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 113: {
                    op = this.jj_consume_token(113);
                    break;
                }
                case 112: {
                    op = this.jj_consume_token(112);
                    break;
                }
                default: {
                    this.jj_la1[37] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            obj2 = this.MultiplicativeExpression();
            obj = obj.computeBinary(op, obj2);
        }
        return obj;
    }

    public final PPToken MultiplicativeExpression() throws ParseException {
        PPToken obj = null;
        PPToken obj2 = null;
        Token op = null;
        obj = this.UnaryExpression();
        while (this.jj_2_49(2)) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 116: {
                    op = this.jj_consume_token(116);
                    break;
                }
                case 114: {
                    op = this.jj_consume_token(114);
                    break;
                }
                case 115: {
                    op = this.jj_consume_token(115);
                    break;
                }
                default: {
                    this.jj_la1[38] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            obj2 = this.UnaryExpression();
            obj = obj.computeBinary(op, obj2);
        }
        return obj;
    }

    public final PPToken UnaryExpression() throws ParseException {
        PPToken obj = null;
        Token op = null;
        if (this.jj_2_50(3)) {
            obj = this.LogNegation();
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 113: {
                    this.jj_consume_token(113);
                    obj = this.LogNegation();
                    break;
                }
                case 112: {
                    op = this.jj_consume_token(112);
                    obj = this.LogNegation();
                    obj = obj.computeUnary(op);
                    break;
                }
                default: {
                    this.jj_la1[39] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        return obj;
    }

    public final PPToken LogNegation() throws ParseException {
        PPToken pt = null;
        boolean negate = false;
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 94: {
                    break;
                }
                default: {
                    this.jj_la1[40] = this.jj_gen;
                    break block3;
                }
            }
            Token t = this.jj_consume_token(94);
            negate = true;
            if (this.verboseLevel() != 7) continue;
            this.print(t.image);
        }
        pt = this.ValueExpression();
        if (negate) {
            pt.setContra(true);
        }
        return pt;
    }

    public final PPToken ValueExpression() throws ParseException {
        PPToken tv = null;
        Object u = null;
        Vector<PPToken> dargs = new Vector<PPToken>();
        if (this.jj_2_52(2)) {
            PPToken pt;
            Token t = switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 119 -> this.jj_consume_token(119);
                case 120 -> this.jj_consume_token(120);
                case 90 -> this.jj_consume_token(90);
                case 88 -> this.jj_consume_token(88);
                default -> {
                    this.jj_la1[41] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            };
            if (this.verboseLevel() == 7) {
                this.print(t.image);
            }
            if ((pt = new PPToken(t)).compareToZero() == 0) {
                pt.setTruth(false);
            } else {
                pt.setTruth(true);
            }
            return pt;
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 122: {
                this.jj_consume_token(122);
                PPToken pt = this.CompoundConditionalExpression();
                this.jj_consume_token(123);
                return pt;
            }
            case 95: 
            case 96: 
            case 97: 
            case 98: {
                PPToken pt = this.Assertion();
                return pt;
            }
            case 121: {
                Token t = this.jj_consume_token(121);
                if (this.jj_2_51(4)) {
                    this.jj_consume_token(122);
                    block14: while (true) {
                        tv = this.Expression();
                        dargs.add(tv);
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 88: 
                            case 90: 
                            case 94: 
                            case 95: 
                            case 96: 
                            case 97: 
                            case 98: 
                            case 112: 
                            case 113: 
                            case 119: 
                            case 120: 
                            case 121: 
                            case 122: {
                                continue block14;
                            }
                        }
                        break;
                    }
                    this.jj_la1[42] = this.jj_gen;
                    this.jj_consume_token(123);
                }
                if (this.verboseLevel() == 7) {
                    this.print(t.image);
                }
                PPToken pt = new PPToken(t);
                if (dargs.size() > 0) {
                    pt.image = pt.image + "(";
                    Enumeration denum = dargs.elements();
                    int index = 0;
                    while (denum.hasMoreElements()) {
                        PPToken atok = (PPToken)denum.nextElement();
                        if (index++ != 0) {
                            pt.image = pt.image + ",";
                        }
                        pt.image = pt.image + atok.image;
                    }
                    pt.image = pt.image + ")";
                    pt.image = this.defs.expand(pt.image, true);
                    Long val = AddressEvaluator.evaluateToLong((String)pt.image);
                    if (val != null) {
                        pt.image = val.toString();
                        pt.kind = 119;
                        pt.setTruth(true);
                        if (val == 0L) {
                            pt.setTruth(false);
                        }
                        return pt;
                    }
                }
                pt.setTruth(this.isDef(pt));
                if (pt.getTruth()) {
                    tv = this.getDef(pt);
                    if (!pt.image.equals(tv.image)) {
                        tv.image = this.defs.expand(tv.image, true);
                        tv.kind = this.getNumericType(tv.image);
                    }
                    Long val = AddressEvaluator.evaluateToLong((String)tv.image);
                    pt.setTruth(true);
                    if (val != null) {
                        pt.image = val.toString();
                        pt.kind = 119;
                        if (val == 0L) {
                            pt.setTruth(false);
                        }
                    }
                }
                return pt;
            }
        }
        this.jj_la1[43] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(1, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_3(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_3();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(2, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_4(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_4();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(3, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_5(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_5();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(4, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_6(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_6();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(5, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_7(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_7();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(6, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_8(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_8();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(7, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_9(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_9();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(8, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_10(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_10();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(9, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_11(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_11();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(10, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_12(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_12();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(11, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_13(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_13();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(12, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_14(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_14();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(13, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_15(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_15();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(14, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_16(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_16();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(15, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_17(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_17();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(16, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_18(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_18();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(17, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_19(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_19();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(18, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_20(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_20();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(19, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_21(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_21();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(20, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_22(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_22();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(21, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_23(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_23();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(22, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_24(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_24();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(23, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_25(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_25();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(24, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_26(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_26();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(25, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_27(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_27();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(26, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_28(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_28();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(27, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_29(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_29();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(28, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_30(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_30();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(29, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_31(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_31();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(30, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_32(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_32();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(31, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_33(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_33();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(32, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_34(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_34();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(33, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_35(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_35();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(34, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_36(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_36();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(35, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_37(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_37();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(36, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_38(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_38();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(37, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_39(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_39();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(38, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_40(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_40();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(39, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_41(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_41();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(40, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_42(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_42();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(41, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_43(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_43();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(42, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_44(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_44();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(43, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_45(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_45();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(44, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_46(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_46();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(45, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_47(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_47();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(46, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_48(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_48();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(47, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_49(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_49();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(48, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_50(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_50();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(49, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_51(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_51();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(50, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_52(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_52();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(51, xla);
        }
    }

    private boolean jj_3_48() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(113)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(112)) {
                return true;
            }
        }
        return this.jj_3R_80();
    }

    private boolean jj_3_46() {
        if (this.jj_scan_token(105)) {
            return true;
        }
        return this.jj_3R_78();
    }

    private boolean jj_3R_53() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(69)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(7)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(162)) {
                    this.jj_scanpos = xsp;
                    if (this.jj_scan_token(180)) {
                        this.jj_scanpos = xsp;
                        if (this.jj_scan_token(148)) {
                            this.jj_scanpos = xsp;
                            if (this.jj_scan_token(154)) {
                                this.jj_scanpos = xsp;
                                if (this.jj_scan_token(158)) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_scan_token(124)) {
                                        this.jj_scanpos = xsp;
                                        if (this.jj_scan_token(172)) {
                                            this.jj_scanpos = xsp;
                                            if (this.jj_scan_token(179)) {
                                                this.jj_scanpos = xsp;
                                                if (this.jj_scan_token(137)) {
                                                    return true;
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3_27() {
        return this.jj_3R_53();
    }

    private boolean jj_3R_60() {
        return this.jj_scan_token(70);
    }

    private boolean jj_3R_79() {
        Token xsp;
        if (this.jj_3R_80()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_48());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_107() {
        if (this.jj_3R_125()) {
            return true;
        }
        return this.jj_3R_126();
    }

    private boolean jj_3R_59() {
        if (this.jj_3R_98()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_27()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_55() {
        return this.jj_scan_token(70);
    }

    private boolean jj_3R_54() {
        if (this.jj_3R_98()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_19()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3_19() {
        return this.jj_3R_53();
    }

    private boolean jj_3_30() {
        return this.jj_3R_53();
    }

    private boolean jj_3R_89() {
        return this.jj_3R_53();
    }

    private boolean jj_3_45() {
        if (this.jj_scan_token(107)) {
            return true;
        }
        return this.jj_3R_77();
    }

    private boolean jj_3_29() {
        return this.jj_scan_token(70);
    }

    private boolean jj_3_47() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(110)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(111)) {
                return true;
            }
        }
        return this.jj_3R_79();
    }

    private boolean jj_3_28() {
        return this.jj_3R_53();
    }

    private boolean jj_3_44() {
        if (this.jj_scan_token(106)) {
            return true;
        }
        return this.jj_3R_76();
    }

    private boolean jj_3R_57() {
        return this.jj_scan_token(70);
    }

    private boolean jj_3R_78() {
        Token xsp;
        if (this.jj_3R_79()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_47());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3_17() {
        return this.jj_3R_53();
    }

    private boolean jj_3_22() {
        return this.jj_3R_53();
    }

    private boolean jj_3_21() {
        return this.jj_scan_token(70);
    }

    private boolean jj_3_24() {
        return this.jj_3R_53();
    }

    private boolean jj_3_31() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_59()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_60()) {
                return true;
            }
        }
        xsp = this.jj_scanpos;
        if (this.jj_3_28()) {
            this.jj_scanpos = xsp;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3_29()) {
            this.jj_scanpos = xsp;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3_30()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_56() {
        Token xsp;
        if (this.jj_scan_token(68)) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_17());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3_20() {
        return this.jj_3R_53();
    }

    private boolean jj_3R_88() {
        Token xsp;
        if (this.jj_3_31()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_31());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3_25() {
        Token xsp;
        if (this.jj_scan_token(70)) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_24());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_106() {
        if (this.jj_3R_123()) {
            return true;
        }
        return this.jj_3R_124();
    }

    private boolean jj_3_23() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_54()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_55()) {
                return true;
            }
        }
        xsp = this.jj_scanpos;
        if (this.jj_3_20()) {
            this.jj_scanpos = xsp;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3_21()) {
            this.jj_scanpos = xsp;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3_22()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_58() {
        Token xsp;
        if (this.jj_3_23()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_23());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_77() {
        Token xsp;
        if (this.jj_3R_78()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_46());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3_18() {
        return this.jj_3R_53();
    }

    private boolean jj_3_26() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_56()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_57()) {
                return true;
            }
        }
        xsp = this.jj_scanpos;
        if (this.jj_3_18()) {
            this.jj_scanpos = xsp;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_58()) {
            this.jj_scanpos = xsp;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3_25()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3_32() {
        Token xsp;
        if (this.jj_3_26()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_26());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_105() {
        if (this.jj_3R_121()) {
            return true;
        }
        return this.jj_3R_122();
    }

    private boolean jj_3R_85() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_105()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_106()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_107()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_108()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_109()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_110()) {
                                return true;
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_42() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_32()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_88()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_89()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_76() {
        Token xsp;
        if (this.jj_3R_77()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_45());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_153() {
        return this.jj_scan_token(97);
    }

    private boolean jj_3R_114() {
        return this.jj_scan_token(197);
    }

    private boolean jj_3R_40() {
        return this.jj_3R_85();
    }

    private boolean jj_3R_120() {
        Token xsp;
        if (this.jj_3R_76()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_44());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_132() {
        return this.jj_scan_token(0);
    }

    private boolean jj_3_5() {
        return this.jj_3R_40();
    }

    private boolean jj_3R_97() {
        return this.jj_scan_token(192);
    }

    private boolean jj_3R_141() {
        return this.jj_3R_151();
    }

    private boolean jj_3R_96() {
        return this.jj_3R_114();
    }

    private boolean jj_3R_140() {
        return this.jj_3R_150();
    }

    private boolean jj_3R_139() {
        return this.jj_3R_149();
    }

    private boolean jj_3R_138() {
        return this.jj_3R_148();
    }

    private boolean jj_3R_95() {
        return this.jj_scan_token(191);
    }

    private boolean jj_3R_137() {
        return this.jj_3R_147();
    }

    private boolean jj_3R_52() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_95()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_96()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_97()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_scan_token(193)) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_136() {
        return this.jj_3R_146();
    }

    private boolean jj_3R_135() {
        return this.jj_3R_145();
    }

    private boolean jj_3R_104() {
        return this.jj_3R_120();
    }

    private boolean jj_3_7() {
        return this.jj_3R_43();
    }

    private boolean jj_3R_131() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_7()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_135()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_136()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_137()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_138()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_139()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3R_140()) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_3R_141()) {
                                        return true;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_111() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_131()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_132()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_87() {
        return this.jj_3R_111();
    }

    private boolean jj_3_6() {
        Token xsp;
        if (this.jj_3_5()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_5());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_144() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(98)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(96)) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_153()) {
                    return true;
                }
            }
        }
        if (this.jj_scan_token(122)) {
            return true;
        }
        return this.jj_3R_104();
    }

    private boolean jj_3R_123() {
        return this.jj_scan_token(89);
    }

    private boolean jj_3R_143() {
        if (this.jj_scan_token(95)) {
            return true;
        }
        return this.jj_3R_104();
    }

    private boolean jj_3R_134() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_143()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_144()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_121() {
        return this.jj_scan_token(88);
    }

    private boolean jj_3_4() {
        return this.jj_3R_42();
    }

    private boolean jj_3R_41() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_86()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_6()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_87()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_86() {
        Token xsp;
        if (this.jj_3_4()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_4());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3_2() {
        return this.jj_3R_40();
    }

    private boolean jj_3R_129() {
        return this.jj_scan_token(90);
    }

    private boolean jj_3R_84() {
        Token xsp;
        if (this.jj_3_2()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_2());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_39() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_3()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_84()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_3() {
        return this.jj_3R_41();
    }

    private boolean jj_3R_65() {
        return this.jj_scan_token(117);
    }

    private boolean jj_3R_130() {
        return this.jj_scan_token(91);
    }

    private boolean jj_3R_164() {
        return this.jj_scan_token(104);
    }

    private boolean jj_3_1() {
        return this.jj_3R_39();
    }

    private boolean jj_3R_51() {
        return this.jj_scan_token(217);
    }

    private boolean jj_3R_165() {
        return this.jj_scan_token(102);
    }

    private boolean jj_3R_150() {
        return this.jj_scan_token(167);
    }

    private boolean jj_3R_162() {
        return this.jj_scan_token(103);
    }

    private boolean jj_3R_149() {
        return this.jj_scan_token(164);
    }

    private boolean jj_3R_73() {
        return this.jj_scan_token(101);
    }

    private boolean jj_3R_71() {
        return this.jj_scan_token(100);
    }

    private boolean jj_3R_148() {
        return this.jj_scan_token(161);
    }

    private boolean jj_3R_69() {
        return this.jj_scan_token(99);
    }

    private boolean jj_3R_45() {
        return this.jj_3R_92();
    }

    private boolean jj_3R_63() {
        return this.jj_scan_token(109);
    }

    private boolean jj_3R_50() {
        return this.jj_scan_token(209);
    }

    private boolean jj_3R_128() {
        return this.jj_scan_token(157);
    }

    private boolean jj_3R_64() {
        return this.jj_scan_token(108);
    }

    private boolean jj_3R_127() {
        return this.jj_scan_token(93);
    }

    private boolean jj_3R_163() {
        return this.jj_3R_165();
    }

    private boolean jj_3R_126() {
        return this.jj_scan_token(153);
    }

    private boolean jj_3R_116() {
        Token xsp;
        if (this.jj_3R_104()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_163());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3_14() {
        return this.jj_3R_52();
    }

    private boolean jj_3R_49() {
        return this.jj_scan_token(208);
    }

    private boolean jj_3R_125() {
        return this.jj_scan_token(92);
    }

    private boolean jj_3R_161() {
        return this.jj_3R_164();
    }

    private boolean jj_3_16() {
        return this.jj_scan_token(147);
    }

    private boolean jj_3R_147() {
        Token xsp;
        if (this.jj_3_16()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_16());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_99() {
        Token xsp;
        if (this.jj_3R_116()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_161());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3_15() {
        Token xsp;
        if (this.jj_3_14()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_14());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3_13() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_49()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_50()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_51()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_113() {
        Token xsp;
        if (this.jj_3_13()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_13());
        xsp = this.jj_scanpos = xsp;
        if (this.jj_3_15()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_91() {
        return this.jj_3R_47();
    }

    private boolean jj_3R_112() {
        return this.jj_3R_52();
    }

    private boolean jj_3R_92() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_112()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_113()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_160() {
        return this.jj_3R_162();
    }

    private boolean jj_3R_47() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(198)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(199)) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_75() {
        Token xsp;
        if (this.jj_3R_99()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_160());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_146() {
        return this.jj_scan_token(171);
    }

    private boolean jj_3_43() {
        if (this.jj_3R_73()) {
            return true;
        }
        return this.jj_3R_75();
    }

    private boolean jj_3R_74() {
        Token xsp;
        if (this.jj_3R_75()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_43());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3_42() {
        if (this.jj_3R_73()) {
            return true;
        }
        return this.jj_3R_74();
    }

    private boolean jj_3R_72() {
        Token xsp;
        if (this.jj_3R_74()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_42());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_94() {
        return this.jj_3R_47();
    }

    private boolean jj_3R_48() {
        Token xsp;
        if (this.jj_3R_94()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_94());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_90() {
        Token xsp;
        if (this.jj_scan_token(178)) {
            return true;
        }
        if (this.jj_scan_token(67)) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_scan_token(67));
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3_9() {
        return this.jj_3R_43();
    }

    private boolean jj_3_12() {
        if (this.jj_scan_token(178)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_48()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_44() {
        Token xsp;
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_91());
        this.jj_scanpos = xsp;
        return this.jj_scan_token(200);
    }

    private boolean jj_3_41() {
        if (this.jj_3R_71()) {
            return true;
        }
        return this.jj_3R_72();
    }

    private boolean jj_3_11() {
        if (this.jj_scan_token(178)) {
            return true;
        }
        return this.jj_3R_47();
    }

    private boolean jj_3R_70() {
        Token xsp;
        if (this.jj_3R_72()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_41());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_93() {
        return this.jj_3R_92();
    }

    private boolean jj_3R_46() {
        Token xsp;
        if (this.jj_3R_93()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_93());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3_8() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_44()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_45()) {
                return true;
            }
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_46()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3_10() {
        if (this.jj_scan_token(178)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_8()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_43() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_10()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_11()) {
                this.jj_scanpos = xsp;
                if (this.jj_3_12()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_90()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3_40() {
        if (this.jj_3R_69()) {
            return true;
        }
        return this.jj_3R_70();
    }

    private boolean jj_3R_68() {
        Token xsp;
        if (this.jj_3R_70()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_40());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_158() {
        return this.jj_scan_token(119);
    }

    private boolean jj_3R_83() {
        return this.jj_3R_104();
    }

    private boolean jj_3R_151() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(181)) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_158()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_39() {
        if (this.jj_3R_63()) {
            return true;
        }
        return this.jj_3R_68();
    }

    private boolean jj_3R_67() {
        Token xsp;
        if (this.jj_3R_68()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_39());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3_38() {
        if (this.jj_3R_64()) {
            return true;
        }
        return this.jj_3R_67();
    }

    private boolean jj_3R_66() {
        Token xsp;
        if (this.jj_3R_67()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_38());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3_51() {
        Token xsp;
        if (this.jj_scan_token(122)) {
            return true;
        }
        if (this.jj_3R_83()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_83());
        this.jj_scanpos = xsp;
        return this.jj_scan_token(123);
    }

    private boolean jj_3R_157() {
        return this.jj_scan_token(136);
    }

    private boolean jj_3_37() {
        if (this.jj_3R_65()) {
            return true;
        }
        return this.jj_3R_66();
    }

    private boolean jj_3R_156() {
        return this.jj_scan_token(138);
    }

    private boolean jj_3R_62() {
        Token xsp;
        if (this.jj_3R_66()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_37());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_119() {
        if (this.jj_scan_token(121)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_51()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_155() {
        return this.jj_scan_token(144);
    }

    private boolean jj_3R_118() {
        return this.jj_3R_134();
    }

    private boolean jj_3_36() {
        if (this.jj_3R_64()) {
            return true;
        }
        return this.jj_3R_62();
    }

    private boolean jj_3R_117() {
        if (this.jj_scan_token(122)) {
            return true;
        }
        if (this.jj_3R_133()) {
            return true;
        }
        return this.jj_scan_token(123);
    }

    private boolean jj_3R_154() {
        return this.jj_scan_token(146);
    }

    private boolean jj_3R_145() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_154()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_155()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_156()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_157()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_61() {
        Token xsp;
        if (this.jj_3R_62()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_36());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3_52() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(119)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(120)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(90)) {
                    this.jj_scanpos = xsp;
                    if (this.jj_scan_token(88)) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_124() {
        return this.jj_3R_133();
    }

    private boolean jj_3R_103() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_52()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_117()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_118()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_119()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_152() {
        return this.jj_3R_159();
    }

    private boolean jj_3_35() {
        if (this.jj_3R_63()) {
            return true;
        }
        return this.jj_3R_62();
    }

    private boolean jj_3R_122() {
        return this.jj_3R_133();
    }

    private boolean jj_3R_159() {
        Token xsp;
        if (this.jj_3R_62()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_35());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_102() {
        return this.jj_scan_token(94);
    }

    private boolean jj_3_33() {
        return this.jj_3R_61();
    }

    private boolean jj_3R_82() {
        Token xsp;
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_102());
        this.jj_scanpos = xsp;
        return this.jj_3R_103();
    }

    private boolean jj_3R_142() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_33()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_152()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_101() {
        if (this.jj_scan_token(112)) {
            return true;
        }
        return this.jj_3R_82();
    }

    private boolean jj_3_50() {
        return this.jj_3R_82();
    }

    private boolean jj_3_34() {
        return this.jj_3R_62();
    }

    private boolean jj_3R_100() {
        if (this.jj_scan_token(113)) {
            return true;
        }
        return this.jj_3R_82();
    }

    private boolean jj_3R_133() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_34()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_142()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_110() {
        return this.jj_3R_130();
    }

    private boolean jj_3R_81() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_50()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_100()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_101()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_115() {
        return this.jj_scan_token(71);
    }

    private boolean jj_3R_98() {
        Token xsp;
        if (this.jj_3R_115()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_115());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_109() {
        return this.jj_3R_129();
    }

    private boolean jj_3_49() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(116)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(114)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(115)) {
                    return true;
                }
            }
        }
        return this.jj_3R_81();
    }

    private boolean jj_3R_80() {
        Token xsp;
        if (this.jj_3R_81()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_49());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_108() {
        if (this.jj_3R_127()) {
            return true;
        }
        return this.jj_3R_128();
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{129, 0, 128, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    }

    private static void jj_la1_init_1() {
        jj_la1_1 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    }

    private static void jj_la1_init_2() {
        jj_la1_2 = new int[]{0x3F0000F0, 0x3F000000, 240, 0, 0, 0, 0x3F000000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 0, 0, 80, 192, 192, 192, 224, 32, 128, -989855744, -989855744, 0, 0, 0, 0, Integer.MIN_VALUE, 0, 0, 0, 0, 0x40000000, 0x5000000, -989855744, Integer.MIN_VALUE};
    }

    private static void jj_la1_init_3() {
        jj_la1_3 = new int[]{0x10800000, 0, 0x10000000, 0x800000, 0x800000, 0x800000, 0, 0, 0x800000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x10000000, 0x10000000, 0, 126025735, 126025735, 128, 256, 64, 7, 7, 49152, 196608, 0x1C0000, 196608, 0, 0x1800000, 126025735, 0x6000007};
    }

    private static void jj_la1_init_4() {
        jj_la1_4 = new int[]{1142753024, 0, 1141899776, 853248, 853248, 853248, 0, 328960, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1141899776, 1141899776, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    }

    private static void jj_la1_init_5() {
        jj_la1_5 = new int[]{3938454, 0, 1576964, 2361490, 2099346, 2361490, 0, 0, 0x200000, 0, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, 0, Integer.MIN_VALUE, 0, 0, 262144, 0, 0, Integer.MIN_VALUE, Integer.MIN_VALUE, 0, 0, 0, 0, 1576964, 1576964, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    }

    private static void jj_la1_init_6() {
        jj_la1_6 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 192, 33751523, 0x2030023, 0x2030023, 192, 0x2030023, 192, 0, 0, 192, 0x2030000, 0x2030023, 35, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    }

    public PreProcessor(InputStream stream) {
        this(stream, null);
    }

    public PreProcessor(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new PreProcessorTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 44; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 44; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public PreProcessor(Reader stream) {
        int i;
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new PreProcessorTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 44; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(Reader stream) {
        int i;
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 44; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public PreProcessor(PreProcessorTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 44; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(PreProcessorTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 44; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            block1: for (int[] oldentry : this.jj_expentries) {
                if (oldentry.length != this.jj_expentry.length) continue;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (oldentry[i] != this.jj_expentry[i]) continue block1;
                }
                this.jj_expentries.add(this.jj_expentry);
                break;
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[221];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 44; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) != 0) {
                    la1tokens[32 + j] = true;
                }
                if ((jj_la1_2[i] & 1 << j) != 0) {
                    la1tokens[64 + j] = true;
                }
                if ((jj_la1_3[i] & 1 << j) != 0) {
                    la1tokens[96 + j] = true;
                }
                if ((jj_la1_4[i] & 1 << j) != 0) {
                    la1tokens[128 + j] = true;
                }
                if ((jj_la1_5[i] & 1 << j) != 0) {
                    la1tokens[160 + j] = true;
                }
                if ((jj_la1_6[i] & 1 << j) == 0) continue;
                la1tokens[192 + j] = true;
            }
        }
        for (i = 0; i < 221; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 52; ++i) {
            try {
                JJCalls p = this.jj_2_rtns[i];
                do {
                    if (p.gen <= this.jj_gen) continue;
                    this.jj_la = p.arg;
                    this.jj_lastpos = this.jj_scanpos = p.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                            break;
                        }
                        case 1: {
                            this.jj_3_2();
                            break;
                        }
                        case 2: {
                            this.jj_3_3();
                            break;
                        }
                        case 3: {
                            this.jj_3_4();
                            break;
                        }
                        case 4: {
                            this.jj_3_5();
                            break;
                        }
                        case 5: {
                            this.jj_3_6();
                            break;
                        }
                        case 6: {
                            this.jj_3_7();
                            break;
                        }
                        case 7: {
                            this.jj_3_8();
                            break;
                        }
                        case 8: {
                            this.jj_3_9();
                            break;
                        }
                        case 9: {
                            this.jj_3_10();
                            break;
                        }
                        case 10: {
                            this.jj_3_11();
                            break;
                        }
                        case 11: {
                            this.jj_3_12();
                            break;
                        }
                        case 12: {
                            this.jj_3_13();
                            break;
                        }
                        case 13: {
                            this.jj_3_14();
                            break;
                        }
                        case 14: {
                            this.jj_3_15();
                            break;
                        }
                        case 15: {
                            this.jj_3_16();
                            break;
                        }
                        case 16: {
                            this.jj_3_17();
                            break;
                        }
                        case 17: {
                            this.jj_3_18();
                            break;
                        }
                        case 18: {
                            this.jj_3_19();
                            break;
                        }
                        case 19: {
                            this.jj_3_20();
                            break;
                        }
                        case 20: {
                            this.jj_3_21();
                            break;
                        }
                        case 21: {
                            this.jj_3_22();
                            break;
                        }
                        case 22: {
                            this.jj_3_23();
                            break;
                        }
                        case 23: {
                            this.jj_3_24();
                            break;
                        }
                        case 24: {
                            this.jj_3_25();
                            break;
                        }
                        case 25: {
                            this.jj_3_26();
                            break;
                        }
                        case 26: {
                            this.jj_3_27();
                            break;
                        }
                        case 27: {
                            this.jj_3_28();
                            break;
                        }
                        case 28: {
                            this.jj_3_29();
                            break;
                        }
                        case 29: {
                            this.jj_3_30();
                            break;
                        }
                        case 30: {
                            this.jj_3_31();
                            break;
                        }
                        case 31: {
                            this.jj_3_32();
                            break;
                        }
                        case 32: {
                            this.jj_3_33();
                            break;
                        }
                        case 33: {
                            this.jj_3_34();
                            break;
                        }
                        case 34: {
                            this.jj_3_35();
                            break;
                        }
                        case 35: {
                            this.jj_3_36();
                            break;
                        }
                        case 36: {
                            this.jj_3_37();
                            break;
                        }
                        case 37: {
                            this.jj_3_38();
                            break;
                        }
                        case 38: {
                            this.jj_3_39();
                            break;
                        }
                        case 39: {
                            this.jj_3_40();
                            break;
                        }
                        case 40: {
                            this.jj_3_41();
                            break;
                        }
                        case 41: {
                            this.jj_3_42();
                            break;
                        }
                        case 42: {
                            this.jj_3_43();
                            break;
                        }
                        case 43: {
                            this.jj_3_44();
                            break;
                        }
                        case 44: {
                            this.jj_3_45();
                            break;
                        }
                        case 45: {
                            this.jj_3_46();
                            break;
                        }
                        case 46: {
                            this.jj_3_47();
                            break;
                        }
                        case 47: {
                            this.jj_3_48();
                            break;
                        }
                        case 48: {
                            this.jj_3_49();
                            break;
                        }
                        case 49: {
                            this.jj_3_50();
                            break;
                        }
                        case 50: {
                            this.jj_3_51();
                            break;
                        }
                        case 51: {
                            this.jj_3_52();
                        }
                    }
                } while ((p = p.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        this.jj_rescan = false;
    }

    private void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static {
        PreProcessor.jj_la1_init_0();
        PreProcessor.jj_la1_init_1();
        PreProcessor.jj_la1_init_2();
        PreProcessor.jj_la1_init_3();
        PreProcessor.jj_la1_init_4();
        PreProcessor.jj_la1_init_5();
        PreProcessor.jj_la1_init_6();
    }

    class PPToken
    extends Token {
        private String path = null;
        boolean truth;
        boolean contradict;
        boolean emitExecSave;
        int comparison;
        ArrayList<StringBuffer> appendList = new ArrayList();
        ArrayList<Boolean> expandList = new ArrayList();

        public PPToken(PPToken ptk) {
            this.kind = ptk.kind;
            this.image = ptk.image;
            this.beginLine = ptk.beginLine;
            this.truth = ptk.truth;
            this.comparison = ptk.comparison;
            this.contradict = ptk.contradict;
        }

        public PPToken(Token tk) {
            this.kind = tk.kind;
            this.image = tk.image;
            this.beginLine = tk.beginLine;
            this.comparison = 0;
            this.truth = false;
            this.contradict = false;
        }

        public PPToken(Token tk, boolean truth) {
            this.kind = tk.kind;
            this.image = tk.image;
            this.beginLine = tk.beginLine;
            this.comparison = 0;
            this.truth = truth;
            this.contradict = false;
        }

        public PPToken(String val) {
            this.kind = 0;
            this.image = val;
            this.beginLine = 0;
            this.comparison = 0;
            this.truth = false;
            this.contradict = false;
        }

        void append(String str, boolean expand) {
            int endIndex;
            if (this.image != null & this.image.length() > 0) {
                this.appendList.add(new StringBuffer(this.image));
                this.expandList.add(true);
                this.image = null;
            }
            if ((endIndex = this.appendList.size() - 1) >= 0 && (str.strip().length() == 0 || expand == this.expandList.get(endIndex))) {
                StringBuffer lastStr = this.appendList.get(endIndex);
                lastStr.append(str);
                return;
            }
            this.appendList.add(new StringBuffer(str));
            this.expandList.add(expand);
        }

        void setTruth(boolean truth) {
            this.truth = truth;
            this.contradict = false;
        }

        void setContra(boolean truth) {
            this.contradict = truth;
        }

        void setKind(int kind) {
            this.kind = kind;
        }

        void setLine(int line) {
            this.beginLine = line;
        }

        void setEmitSave(boolean truth) {
            this.emitExecSave = truth;
        }

        void setPath(String path) {
            this.path = path;
        }

        String getPath() {
            return this.path;
        }

        public boolean equals(Object t) {
            if (t.getClass() == this.getClass()) {
                return this.image.equals(((PPToken)t).image);
            }
            try {
                if (t.getClass() == Class.forName("CPP.Token")) {
                    return this.image.equals(((Token)t).image);
                }
                if (t.getClass() == Class.forName("java.lang.String")) {
                    return this.image.equals((String)t);
                }
            }
            catch (ClassNotFoundException e) {
                PreProcessor.this.addParseMessage(null, "PPToken.equals: " + e.getMessage());
            }
            return false;
        }

        double Double() {
            return Double.parseDouble(this.image);
        }

        int Integer() {
            return Integer.parseInt(this.image);
        }

        void fixupNumericValue(PPToken val) {
            int cpos;
            int opos = val.image.indexOf(40);
            if (opos >= 0 && (cpos = val.image.lastIndexOf(41)) >= 0 && cpos != opos + 1) {
                val.image = val.image.substring(opos + 1, cpos - 1).trim();
            }
            val.image = PreProcessor.this.defs.expand(val.image, true);
            val.kind = PreProcessor.this.getNumericType(val.image);
        }

        int compareToZero() {
            try {
                switch (this.kind) {
                    case 64: 
                    case 120: {
                        Double thisFP = new Double(this.image);
                        Double zeroFP = new Double(0.0);
                        this.comparison = thisFP.compareTo(zeroFP);
                        break;
                    }
                    case 59: 
                    case 119: {
                        BigInteger value = PreProcessor.this.getLongValue(this.image);
                        this.comparison = value.compareTo(BigInteger.ZERO);
                        break;
                    }
                    case 121: 
                    case 178: 
                    case 191: {
                        if (PreProcessor.this.isDef(this)) {
                            PPToken pPToken = PreProcessor.this.getDef(this);
                        }
                        break;
                    }
                    default: {
                        PreProcessor.this.addParseMessage(null, "Cannot compareToZero Token: " + this.image + " kind " + this.kind);
                        break;
                    }
                }
            }
            catch (Exception e) {
                PreProcessor.this.addParseMessage(null, "CMP2Zero:Numeric Conversion Error: " + e.getMessage());
            }
            return this.comparison;
        }

        int compareTo(PPToken that) {
            PPToken replVal;
            Double thisFP = new Double(0.0);
            Double thatFP = new Double(0.0);
            String thisVal = null;
            String thatVal = null;
            try {
                switch (this.kind) {
                    case 64: 
                    case 120: {
                        thisFP = new Double(this.image);
                        break;
                    }
                    case 59: 
                    case 119: {
                        thisFP = new Double(PreProcessor.this.getLongValue(this.image).doubleValue());
                        break;
                    }
                    default: {
                        replVal = PreProcessor.this.getDef(this);
                        if (replVal == null) {
                            replVal = new PPToken(this);
                        }
                        thisVal = replVal.image;
                        this.fixupNumericValue(replVal);
                        thisFP = PreProcessor.this.getDoubleValue(replVal.image);
                        break;
                    }
                }
            }
            catch (NumberFormatException e) {
                thisFP = null;
            }
            catch (Exception e) {
                thisFP = null;
            }
            try {
                switch (that.kind) {
                    case 64: 
                    case 120: {
                        thatFP = new Double(that.image);
                        break;
                    }
                    case 59: 
                    case 119: {
                        thatFP = new Double(PreProcessor.this.getLongValue(that.image).doubleValue());
                        break;
                    }
                    default: {
                        replVal = PreProcessor.this.getDef(that);
                        if (replVal == null) {
                            replVal = new PPToken(that);
                        }
                        thatVal = replVal.image;
                        this.fixupNumericValue(replVal);
                        thatFP = PreProcessor.this.getDoubleValue(replVal.image);
                        break;
                    }
                }
            }
            catch (NumberFormatException e) {
                thatFP = null;
            }
            catch (Exception e) {
                thatFP = null;
            }
            if (this.image.equals(that.image)) {
                return 0;
            }
            if (this.image.equals(thatVal)) {
                return 0;
            }
            if (thisVal != null && thisVal.equals(that.image)) {
                return 0;
            }
            if (thisVal != null && thisVal.equals(thatVal)) {
                return 0;
            }
            if (thisFP != null && thatFP != null) {
                this.comparison = thisFP.compareTo(thatFP);
            } else if (thisFP != null && thatFP == null) {
                this.comparison = 1;
            } else if (thisFP == null && thatFP != null) {
                this.comparison = -1;
            } else if (thisVal != null && thatVal != null) {
                this.comparison = thisVal.compareTo(thatVal);
            }
            return this.comparison;
        }

        PPToken computeBinary(Token op, PPToken val2) {
            BigInteger tvalue = BigInteger.ZERO;
            BigInteger result = BigInteger.ZERO;
            BigInteger vvalue = BigInteger.ZERO;
            try {
                tvalue = PreProcessor.this.getLongValue(PreProcessor.this.getDef((PPToken)this).image);
                vvalue = PreProcessor.this.getLongValue(PreProcessor.this.getDef((PPToken)val2).image);
            }
            catch (Exception exception) {
                // empty catch block
            }
            switch (op.kind) {
                case 112: {
                    result = tvalue.subtract(vvalue);
                    break;
                }
                case 113: {
                    result = tvalue.add(vvalue);
                    break;
                }
                case 116: {
                    result = tvalue.multiply(vvalue);
                    break;
                }
                case 105: {
                    result = tvalue.and(vvalue);
                    break;
                }
                case 106: {
                    result = tvalue.or(vvalue);
                    break;
                }
                case 111: {
                    result = tvalue.shiftRight(vvalue.intValue());
                    break;
                }
                case 110: {
                    result = tvalue.shiftLeft(vvalue.intValue());
                }
            }
            PPToken t = new PPToken(result.toString());
            t.kind = 119;
            t.setTruth(result != BigInteger.ZERO);
            return t;
        }

        PPToken computeUnary(Token op) {
            BigInteger tvalue = BigInteger.ZERO;
            BigInteger result = BigInteger.ZERO;
            try {
                tvalue = PreProcessor.this.getLongValue(PreProcessor.this.getDef((PPToken)this).image);
            }
            catch (Exception exception) {
                // empty catch block
            }
            switch (op.kind) {
                case 112: {
                    result = tvalue.negate();
                    break;
                }
                case 94: {
                    result = BigInteger.ZERO.equals(tvalue) ? BigInteger.ZERO : BigInteger.ONE;
                }
            }
            PPToken t = new PPToken(result.toString());
            t.kind = 119;
            t.setTruth(!BigInteger.ZERO.equals(result));
            return t;
        }

        boolean getEmitSave() {
            return this.emitExecSave;
        }

        boolean getTruth() {
            if (!this.contradict) {
                return this.truth;
            }
            return !this.truth;
        }

        void join() {
            StringBuffer buf = new StringBuffer(this.image);
            int pos = this.image.length();
            while (pos > 0) {
                if ((pos = this.image.lastIndexOf("\\\n", pos)) >= 0) {
                    buf.replace(pos, pos + 2, " ");
                    --pos;
                    continue;
                }
                if ((pos = this.image.lastIndexOf("\\\r\n", pos)) >= 0) {
                    buf.replace(pos, pos + 3, " ");
                    --pos;
                    continue;
                }
                if ((pos = this.image.lastIndexOf("\\\r", pos)) < 0) continue;
                buf.replace(pos, pos + 2, " ");
                --pos;
            }
            this.image = buf.toString();
        }

        void emit(boolean expand) {
            if (expand && this.appendList.isEmpty()) {
                this.image = PreProcessor.this.defs.expand(this.image, true);
            } else {
                int cnt = 0;
                for (StringBuffer string : this.appendList) {
                    if (expand && this.expandList.get(cnt++).booleanValue()) {
                        this.image = this.image + PreProcessor.this.defs.expand(string.toString(), true);
                        continue;
                    }
                    this.image = this.image + String.valueOf(string);
                }
            }
            if (this.image.length() == 1 && this.image.startsWith("\n")) {
                this.image = !PreProcessor.this.emitExecSwitch ? "////\n" : "\n";
            }
            PreProcessor.this.print(this.image);
        }
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }
}

