/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.importer;

import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.importer.MessageLog;
import ghidra.formats.gfilesystem.FSRL;
import ghidra.formats.gfilesystem.FileSystemService;
import ghidra.formats.gfilesystem.GFile;
import ghidra.formats.gfilesystem.RefdFile;
import ghidra.framework.Platform;
import ghidra.framework.main.AppInfo;
import ghidra.framework.model.Project;
import ghidra.framework.options.SaveState;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;

public class LibrarySearchPathManager {
    private static final String LIBRARY_SEARCH_PATH_STATE_NAME = "Library Search Paths";
    private static Set<String> pathSet = LibrarySearchPathManager.initialize();

    public static synchronized String[] getLibraryPaths() {
        String[] paths = new String[pathSet.size()];
        pathSet.toArray(paths);
        return paths;
    }

    public static synchronized List<FSRL> getLibraryFsrlList(ByteProvider provider, MessageLog log, TaskMonitor monitor) throws CancelledException {
        FileSystemService fsService = FileSystemService.getInstance();
        ArrayList<FSRL> fsrlList = new ArrayList<FSRL>();
        for (String path : pathSet) {
            FSRL fsrl;
            block14: {
                monitor.checkCancelled();
                path = path.trim();
                fsrl = null;
                try {
                    if (path.equals(".")) {
                        FSRL providerFsrl = provider.getFSRL();
                        if (providerFsrl == null) break block14;
                        try (RefdFile fileRef = fsService.getRefdFile(providerFsrl, monitor);){
                            GFile parentFile = fileRef.file.getParentFile();
                            fsrl = parentFile.getFSRL();
                            break block14;
                        }
                    }
                    fsrl = FSRL.fromString(path);
                }
                catch (MalformedURLException e) {
                    try {
                        File f = new File(path);
                        if (f.exists() && f.isAbsolute()) {
                            fsrl = fsService.getLocalFSRL(f.getCanonicalFile());
                        }
                    }
                    catch (IOException e2) {
                        log.appendException((Throwable)e2);
                    }
                }
                catch (IOException e) {
                    log.appendException((Throwable)e);
                }
            }
            if (fsrl == null) continue;
            fsrlList.add(fsrl);
        }
        return fsrlList;
    }

    public static synchronized void setLibraryPaths(String[] paths) {
        pathSet.clear();
        pathSet.addAll(Arrays.asList(paths));
        LibrarySearchPathManager.saveState();
    }

    public static synchronized boolean addPath(String path) {
        if (pathSet.contains(path)) {
            return false;
        }
        pathSet.add(path);
        LibrarySearchPathManager.saveState();
        return true;
    }

    public static synchronized void reset() {
        pathSet = LibrarySearchPathManager.loadDefaultPaths();
        LibrarySearchPathManager.saveState();
    }

    private LibrarySearchPathManager() {
    }

    private static synchronized Set<String> initialize() {
        Set<String> set = LibrarySearchPathManager.loadFromSavedState();
        if (set == null) {
            set = LibrarySearchPathManager.loadDefaultPaths();
        }
        return set;
    }

    private static synchronized Set<String> loadDefaultPaths() {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        set.add(".");
        Platform.CURRENT_PLATFORM.getAdditionalLibraryPaths().forEach(p -> set.add((String)p));
        String libpath = System.getProperty("java.library.path");
        String libpathSep = System.getProperty("path.separator");
        StringTokenizer nizer = new StringTokenizer(libpath, libpathSep);
        while (nizer.hasMoreTokens()) {
            String path = nizer.nextToken();
            set.add(path);
        }
        return set;
    }

    private static synchronized Set<String> loadFromSavedState() {
        String[] paths;
        SaveState saveState;
        Project project = AppInfo.getActiveProject();
        if (project != null && (saveState = project.getSaveableData("LOADER_OPTIONS")) != null && (paths = saveState.getStrings(LIBRARY_SEARCH_PATH_STATE_NAME, null)) != null) {
            return new LinkedHashSet<String>(Arrays.asList(paths));
        }
        return null;
    }

    private static synchronized void saveState() {
        Project project = AppInfo.getActiveProject();
        if (project != null) {
            SaveState saveState = project.getSaveableData("LOADER_OPTIONS");
            if (saveState == null) {
                saveState = new SaveState();
                project.setSaveableData("LOADER_OPTIONS", saveState);
            }
            saveState.putStrings(LIBRARY_SEARCH_PATH_STATE_NAME, pathSet.toArray(new String[0]));
        }
    }
}

