/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.opinion;

import ghidra.app.util.Option;
import ghidra.app.util.OptionUtils;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.importer.DomainFolderOption;
import ghidra.app.util.importer.LibrarySearchPathDummyOption;
import ghidra.app.util.importer.LibrarySearchPathManager;
import ghidra.app.util.importer.MessageLog;
import ghidra.app.util.opinion.AbstractProgramLoader;
import ghidra.app.util.opinion.LoadException;
import ghidra.app.util.opinion.LoadSpec;
import ghidra.app.util.opinion.Loaded;
import ghidra.app.util.opinion.LoaderTier;
import ghidra.formats.gfilesystem.FSRL;
import ghidra.formats.gfilesystem.FileSystemRef;
import ghidra.formats.gfilesystem.FileSystemService;
import ghidra.formats.gfilesystem.GFile;
import ghidra.formats.gfilesystem.GFileSystem;
import ghidra.formats.gfilesystem.RefdFile;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainFolder;
import ghidra.framework.model.DomainObject;
import ghidra.framework.model.Project;
import ghidra.framework.model.ProjectData;
import ghidra.program.model.address.Address;
import ghidra.program.model.lang.CompilerSpec;
import ghidra.program.model.lang.CompilerSpecID;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.LanguageCompilerSpecPair;
import ghidra.program.model.lang.LanguageID;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.ExternalManager;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.TaskMonitor;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.ObjectUtils;

public abstract class AbstractLibrarySupportLoader
extends AbstractProgramLoader {
    public static final String LINK_EXISTING_OPTION_NAME = "Link Existing Project Libraries";
    static final boolean LINK_EXISTING_OPTION_DEFAULT = true;
    public static final String LINK_SEARCH_FOLDER_OPTION_NAME = "Project Library Search Folder";
    static final String LINK_SEARCH_FOLDER_OPTION_DEFAULT = "";
    public static final String LOAD_LIBRARY_OPTION_NAME = "Load Libraries From Disk";
    static final boolean LOAD_LIBRARY_OPTION_DEFAULT = false;
    public static final String LIBRARY_SEARCH_PATH_DUMMY_OPTION_NAME = "Library Search Paths";
    public static final String DEPTH_OPTION_NAME = "Recursive Library Load Depth";
    static final int DEPTH_OPTION_DEFAULT = 1;
    public static final String LIBRARY_DEST_FOLDER_OPTION_NAME = "Library Destination Folder";
    static final String LIBRARY_DEST_FOLDER_OPTION_DEFAULT = "";

    protected abstract void load(ByteProvider var1, LoadSpec var2, List<Option> var3, Program var4, TaskMonitor var5, MessageLog var6) throws CancelledException, IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List<Loaded<Program>> loadProgram(ByteProvider provider, String loadedName, Project project, String projectFolderPath, LoadSpec loadSpec, List<Option> options, MessageLog log, Object consumer, TaskMonitor monitor) throws CancelledException, IOException {
        ArrayList<Loaded<Program>> loadedProgramList = new ArrayList<Loaded<Program>>();
        ArrayList<String> libraryNameList = new ArrayList<String>();
        boolean success = false;
        try {
            Program program = this.doLoad(provider, loadedName, loadSpec, libraryNameList, options, consumer, log, monitor);
            loadedProgramList.add(new Loaded<Program>(program, loadedName, projectFolderPath));
            log.appendMsg("------------------------------------------------\n");
            List<Loaded<Program>> libraries = this.loadLibraries(provider, program, project, projectFolderPath, loadSpec, options, log, consumer, libraryNameList, monitor);
            loadedProgramList.addAll(libraries);
            success = true;
            ArrayList<Loaded<Program>> arrayList = loadedProgramList;
            return arrayList;
        }
        finally {
            if (!success) {
                this.release(loadedProgramList, consumer);
            }
        }
    }

    @Override
    protected void loadProgramInto(ByteProvider provider, LoadSpec loadSpec, List<Option> options, MessageLog log, Program program, TaskMonitor monitor) throws CancelledException, LoadException, IOException {
        LanguageCompilerSpecPair pair = loadSpec.getLanguageCompilerSpec();
        LanguageID languageID = program.getLanguageID();
        CompilerSpecID compilerSpecID = program.getCompilerSpec().getCompilerSpecID();
        if (!pair.languageID.equals((Object)languageID) || !pair.compilerSpecID.equals((Object)compilerSpecID)) {
            String message = provider.getAbsolutePath() + " does not have the same language/compiler spec as program " + program.getName();
            log.appendMsg(message);
            throw new LoadException(message);
        }
        log.appendMsg("Loading " + provider.getAbsolutePath() + "...");
        this.load(provider, loadSpec, options, program, monitor, log);
        log.appendMsg("--------------------------------------------------------------------\n");
    }

    @Override
    protected void postLoadProgramFixups(List<Loaded<Program>> loadedPrograms, Project project, List<Option> options, MessageLog messageLog, TaskMonitor monitor) throws CancelledException, IOException {
        if (loadedPrograms.isEmpty()) {
            return;
        }
        if (this.isLinkExistingLibraries(options) || this.isLoadLibraries(options)) {
            String projectFolderPath = loadedPrograms.get(0).getProjectFolderPath();
            ArrayList<DomainFolder> searchFolders = new ArrayList<DomainFolder>();
            String destPath = this.getLibraryDestinationFolderPath(project, projectFolderPath, options);
            DomainFolder destSearchFolder = this.getLibraryDestinationSearchFolder(project, destPath, options);
            DomainFolder linkSearchFolder = this.getLinkSearchFolder(project, projectFolderPath, options);
            if (destSearchFolder != null) {
                searchFolders.add(destSearchFolder);
            }
            if (linkSearchFolder != null) {
                searchFolders.add(linkSearchFolder);
            }
            this.fixupExternalLibraries(loadedPrograms, searchFolders, messageLog, monitor);
        }
    }

    @Override
    public LoaderTier getTier() {
        return LoaderTier.GENERIC_TARGET_LOADER;
    }

    @Override
    public int getTierPriority() {
        return 50;
    }

    @Override
    public List<Option> getDefaultOptions(ByteProvider provider, LoadSpec loadSpec, DomainObject domainObject, boolean loadIntoProgram) {
        List<Option> list = super.getDefaultOptions(provider, loadSpec, domainObject, loadIntoProgram);
        list.add(new Option(LINK_EXISTING_OPTION_NAME, true, Boolean.class, "-loader-linkExistingProjectLibraries"));
        list.add(new DomainFolderOption(LINK_SEARCH_FOLDER_OPTION_NAME, "-loader-projectLibrarySearchFolder"));
        list.add(new Option(LOAD_LIBRARY_OPTION_NAME, false, Boolean.class, "-loader-loadLibraries"));
        list.add(new LibrarySearchPathDummyOption(LIBRARY_SEARCH_PATH_DUMMY_OPTION_NAME));
        list.add(new Option(DEPTH_OPTION_NAME, 1, Integer.class, "-loader-libraryLoadDepth"));
        list.add(new DomainFolderOption(LIBRARY_DEST_FOLDER_OPTION_NAME, "-loader-libraryDestinationFolder"));
        return list;
    }

    @Override
    public String validateOptions(ByteProvider provider, LoadSpec loadSpec, List<Option> options, Program program) {
        if (options != null) {
            for (Option option : options) {
                String name = option.getName();
                if (name.equals(LINK_EXISTING_OPTION_NAME) || name.equals(LOAD_LIBRARY_OPTION_NAME)) {
                    if (Boolean.class.isAssignableFrom(option.getValueClass())) continue;
                    return "Invalid type for option: " + name + " - " + String.valueOf(option.getValueClass());
                }
                if (name.equals(DEPTH_OPTION_NAME)) {
                    if (Integer.class.isAssignableFrom(option.getValueClass())) continue;
                    return "Invalid type for option: " + name + " - " + String.valueOf(option.getValueClass());
                }
                if (!name.equals(LINK_SEARCH_FOLDER_OPTION_NAME) && !name.equals(LIBRARY_DEST_FOLDER_OPTION_NAME)) continue;
                if (!String.class.isAssignableFrom(option.getValueClass())) {
                    return "Invalid type for option: " + name + " - " + String.valueOf(option.getValueClass());
                }
                String value = (String)option.getValue();
                if (value.isEmpty() || value.startsWith("/")) continue;
                return "Invalid absolute project path for option: " + name;
            }
        }
        return super.validateOptions(provider, loadSpec, options, program);
    }

    protected boolean isLinkExistingLibraries(List<Option> options) {
        return OptionUtils.getOption(LINK_EXISTING_OPTION_NAME, options, true);
    }

    protected DomainFolder getLinkSearchFolder(Project project, String projectFolderPath, List<Option> options) {
        if (!this.shouldSearchAllPaths(options) && !this.isLinkExistingLibraries(options)) {
            return null;
        }
        if (project == null) {
            return null;
        }
        String linkSearchFolderPath = OptionUtils.getOption(LINK_SEARCH_FOLDER_OPTION_NAME, options, "");
        ProjectData projectData = project.getProjectData();
        if (linkSearchFolderPath.isBlank()) {
            if (projectFolderPath == null) {
                return null;
            }
            return projectData.getFolder(projectFolderPath);
        }
        return projectData.getFolder(FilenameUtils.separatorsToUnix((String)linkSearchFolderPath));
    }

    protected boolean isLoadLibraries(List<Option> options) {
        return OptionUtils.getOption(LOAD_LIBRARY_OPTION_NAME, options, false);
    }

    protected int getLibraryLoadDepth(List<Option> options) {
        return OptionUtils.getOption(DEPTH_OPTION_NAME, options, 1);
    }

    protected String getLibraryDestinationFolderPath(Project project, String projectFolderPath, List<Option> options) {
        if (project == null) {
            return null;
        }
        String libraryDestinationFolderPath = OptionUtils.getOption(LIBRARY_DEST_FOLDER_OPTION_NAME, options, "");
        if (libraryDestinationFolderPath.isBlank()) {
            return projectFolderPath;
        }
        return FilenameUtils.separatorsToUnix((String)libraryDestinationFolderPath);
    }

    protected DomainFolder getLibraryDestinationSearchFolder(Project project, String libraryDestinationFolderPath, List<Option> options) {
        if (project == null || libraryDestinationFolderPath == null) {
            return null;
        }
        if (!this.isLoadLibraries(options)) {
            return null;
        }
        return project.getProjectData().getFolder(libraryDestinationFolderPath);
    }

    protected boolean shouldSearchAllPaths(List<Option> options) {
        return false;
    }

    protected boolean isCaseInsensitiveLibraryFilenames() {
        return false;
    }

    protected boolean isOptionalLibraryFilenameExtensions() {
        return false;
    }

    protected ByteProvider createLibraryByteProvider(FSRL libFsrl, LoadSpec loadSpec, MessageLog log, TaskMonitor monitor) throws IOException, CancelledException {
        return FileSystemService.getInstance().getByteProvider(libFsrl, true, monitor);
    }

    protected void processLibrary(Program library, String libraryName, FSRL libraryFsrl, ByteProvider provider, LoadSpec loadSpec, List<Option> options, MessageLog log, TaskMonitor monitor) throws IOException, CancelledException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Loaded<Program>> loadLibraries(ByteProvider provider, Program program, Project project, String projectFolderPath, LoadSpec desiredLoadSpec, List<Option> options, MessageLog log, Object consumer, List<String> libraryNameList, TaskMonitor monitor) throws CancelledException, IOException {
        ArrayList<Loaded<Program>> arrayList;
        List<FileSystemSearchPath> searchPaths;
        List<FileSystemSearchPath> customSearchPaths;
        block15: {
            ArrayList<Loaded<Program>> loadedPrograms = new ArrayList<Loaded<Program>>();
            TreeSet<String> processed = new TreeSet<String>(this.getLibraryNameComparator());
            Queue<UnprocessedLibrary> unprocessed = this.createUnprocessedQueue(libraryNameList, this.getLibraryLoadDepth(options));
            boolean loadLibraries = this.isLoadLibraries(options);
            customSearchPaths = this.getCustomLibrarySearchPaths(provider, options, log, monitor);
            searchPaths = this.getLibrarySearchPaths(provider, options, log, monitor);
            DomainFolder linkSearchFolder = this.getLinkSearchFolder(project, projectFolderPath, options);
            String libraryDestFolderPath = this.getLibraryDestinationFolderPath(project, projectFolderPath, options);
            DomainFolder libraryDestFolder = this.getLibraryDestinationSearchFolder(project, libraryDestFolderPath, options);
            boolean success = false;
            try {
                while (!unprocessed.isEmpty()) {
                    Loaded<Program> loadedLibrary;
                    monitor.checkCancelled();
                    UnprocessedLibrary unprocessedLibrary = unprocessed.remove();
                    String libraryName = unprocessedLibrary.name();
                    int depth = unprocessedLibrary.depth();
                    if (depth == 0 || processed.contains(libraryName)) continue;
                    processed.add(libraryName);
                    if (libraryDestFolder != null && this.findLibrary(libraryName, libraryDestFolder) != null) {
                        log.appendMsg("Found %s in %s...".formatted(libraryName, libraryDestFolder));
                        log.appendMsg("------------------------------------------------\n");
                        continue;
                    }
                    if (linkSearchFolder != null && this.findLibrary(libraryName, linkSearchFolder) != null) {
                        log.appendMsg("Found %s in %s...".formatted(libraryName, linkSearchFolder));
                        log.appendMsg("------------------------------------------------\n");
                        continue;
                    }
                    if (customSearchPaths.isEmpty() && searchPaths.isEmpty()) continue;
                    boolean loaded = false;
                    if (!customSearchPaths.isEmpty()) {
                        log.appendMsg("Searching %d custom path%s for library %s...".formatted(customSearchPaths.size(), customSearchPaths.size() > 1 ? "s" : "", libraryName));
                        loadedLibrary = this.loadLibraryFromSearchPaths(libraryName, provider, customSearchPaths, libraryDestFolderPath, unprocessed, depth, desiredLoadSpec, options, log, consumer, monitor);
                        if (loadedLibrary != null) {
                            loaded = true;
                            loadedPrograms.add(loadedLibrary);
                        }
                    }
                    if (!loaded && !searchPaths.isEmpty()) {
                        log.appendMsg("Searching %d path%s for library %s...".formatted(searchPaths.size(), searchPaths.size() > 1 ? "s" : "", libraryName));
                        loadedLibrary = this.loadLibraryFromSearchPaths(libraryName, provider, searchPaths, libraryDestFolderPath, unprocessed, depth, desiredLoadSpec, options, log, consumer, monitor);
                        if (loadedLibrary != null) {
                            if (loadLibraries) {
                                loaded = true;
                                loadedPrograms.add(loadedLibrary);
                            } else {
                                loadedLibrary.release(consumer);
                            }
                        }
                    } else if (loaded) {
                        log.appendMsg("Saving library to: " + ((Loaded)loadedPrograms.get(loadedPrograms.size() - 1)).toString());
                    } else {
                        log.appendMsg("Library not saved to project.");
                    }
                    log.appendMsg("------------------------------------------------\n");
                }
                success = true;
                arrayList = loadedPrograms;
                if (success) break block15;
            }
            catch (Throwable throwable) {
                if (!success) {
                    this.release(loadedPrograms, consumer);
                }
                Stream.of(customSearchPaths, searchPaths).flatMap(Collection::stream).forEach(fsSearchPath -> {
                    if (!fsSearchPath.fsRef().isClosed()) {
                        fsSearchPath.fsRef().close();
                    }
                });
                throw throwable;
            }
            this.release(loadedPrograms, consumer);
        }
        Stream.of(customSearchPaths, searchPaths).flatMap(Collection::stream).forEach(fsSearchPath -> {
            if (!fsSearchPath.fsRef().isClosed()) {
                fsSearchPath.fsRef().close();
            }
        });
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Loaded<Program> loadLibraryFromSearchPaths(String libraryName, ByteProvider provider, List<FileSystemSearchPath> fsSearchPaths, String libraryDestFolderPath, Queue<UnprocessedLibrary> unprocessed, int depth, LoadSpec desiredLoadSpec, List<Option> options, MessageLog log, Object consumer, TaskMonitor monitor) throws CancelledException, IOException {
        String libraryPath;
        libraryName = libraryName.trim();
        Program library = null;
        if (libraryDestFolderPath != null && (libraryPath = FilenameUtils.getPath((String)libraryName)) != null && !libraryPath.isEmpty()) {
            if (!((String)libraryDestFolderPath).endsWith("/")) {
                libraryDestFolderPath = (String)libraryDestFolderPath + "/";
            }
            libraryDestFolderPath = (String)libraryDestFolderPath + libraryPath;
        }
        String simpleLibraryName = FilenameUtils.getName((String)libraryName);
        boolean success = false;
        try {
            List<FSRL> candidateLibraryFsrls = this.findLibrary(this.getCheckedPath(libraryName), fsSearchPaths, log, monitor);
            if (candidateLibraryFsrls.isEmpty()) {
                log.appendMsg("Library not found.");
                Loaded<Program> loaded = null;
                return loaded;
            }
            for (FSRL candidateLibraryFsrl : candidateLibraryFsrls) {
                monitor.checkCancelled();
                ArrayList<String> newLibraryList = new ArrayList<String>();
                library = this.loadLibrary(simpleLibraryName, candidateLibraryFsrl, desiredLoadSpec, newLibraryList, options, consumer, log, monitor);
                for (String newLibraryName : newLibraryList) {
                    unprocessed.add(new UnprocessedLibrary(newLibraryName, depth - 1));
                }
                if (library == null) continue;
                this.processLibrary(library, libraryName, candidateLibraryFsrl, provider, desiredLoadSpec, options, log, monitor);
                success = true;
                Loaded<Program> loaded = new Loaded<Program>(library, simpleLibraryName, (String)libraryDestFolderPath);
                return loaded;
            }
        }
        catch (InvalidInputException e) {
            log.appendMsg("Cannot load library with invalid name: \"" + libraryName + "\"");
        }
        finally {
            if (!success && library != null) {
                library.release(consumer);
            }
        }
        return null;
    }

    private DomainFile findLibrary(String libraryPath, DomainFolder folder) {
        if (folder == null) {
            return null;
        }
        String projectPath = this.concatenatePaths(folder.getPathname(), libraryPath);
        DomainFile ret = folder.getProjectData().getFile(FilenameUtils.separatorsToUnix((String)projectPath));
        if (ret != null) {
            return ret;
        }
        String libraryName = FilenameUtils.getName((String)libraryPath);
        ret = folder.getFile(libraryName);
        if (ret != null) {
            return ret;
        }
        boolean noExtension = FilenameUtils.getExtension((String)libraryName).equals("");
        Comparator<String> comparator = this.getLibraryNameComparator();
        for (DomainFile file : folder.getFiles()) {
            String candidateName = file.getName();
            if (this.isOptionalLibraryFilenameExtensions() && noExtension) {
                candidateName = FilenameUtils.getBaseName((String)candidateName);
            }
            if (comparator.compare(candidateName, libraryName) != 0) continue;
            return file;
        }
        return null;
    }

    private List<FSRL> findLibrary(Path libraryPath, List<FileSystemSearchPath> fsSearchPaths, MessageLog log, TaskMonitor monitor) throws CancelledException {
        ArrayList<FSRL> results = new ArrayList<FSRL>();
        FileSystemService fsService = FileSystemService.getInstance();
        Path libraryParentPath = libraryPath.getParent();
        String libraryName = libraryPath.getFileName().toString();
        for (FileSystemSearchPath fsSearchPath : fsSearchPaths) {
            monitor.checkCancelled();
            try {
                Path combinedParentPath = ObjectUtils.allNotNull((Object[])new Object[]{fsSearchPath.fsPath(), libraryParentPath}) ? fsSearchPath.fsPath().resolve(libraryParentPath) : (Path)ObjectUtils.firstNonNull((Object[])new Path[]{fsSearchPath.fsPath(), libraryParentPath});
                FSRL resolvedFsrl = this.resolveLibraryFile(fsSearchPath.fsRef().getFilesystem(), combinedParentPath, libraryName);
                if (resolvedFsrl != null) {
                    results.add(resolvedFsrl);
                    continue;
                }
                if (libraryParentPath != null && libraryParentPath.isAbsolute() && (resolvedFsrl = this.resolveLibraryFile(fsService.getLocalFS(), libraryParentPath, libraryName)) != null) {
                    results.add(resolvedFsrl);
                    continue;
                }
                resolvedFsrl = this.resolveLibraryFile(fsSearchPath.fsRef().getFilesystem(), fsSearchPath.fsPath(), libraryName);
                if (resolvedFsrl == null) continue;
                results.add(resolvedFsrl);
            }
            catch (IOException e) {
                log.appendException((Throwable)e);
            }
        }
        return results;
    }

    private Program loadLibrary(String libraryName, FSRL libraryFsrl, LoadSpec desiredLoadSpec, List<String> libraryNameList, List<Option> options, Object consumer, MessageLog log, TaskMonitor monitor) throws CancelledException, IOException {
        try (ByteProvider provider = this.createLibraryByteProvider(libraryFsrl, desiredLoadSpec, log, monitor);){
            LoadSpec libLoadSpec = this.matchSupportedLoadSpec(desiredLoadSpec, provider);
            if (libLoadSpec == null) {
                log.appendMsg("Skipping library which is the wrong architecture: " + String.valueOf(libraryFsrl));
                Program program = null;
                return program;
            }
            Program program = this.doLoad(provider, libraryName, libLoadSpec, libraryNameList, options, consumer, log, monitor);
            return program;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Program doLoad(ByteProvider provider, String programName, LoadSpec loadSpec, List<String> libraryNameList, List<Option> options, Object consumer, MessageLog log, TaskMonitor monitor) throws CancelledException, IOException {
        LanguageCompilerSpecPair pair = loadSpec.getLanguageCompilerSpec();
        Language language = this.getLanguageService().getLanguage(pair.languageID);
        CompilerSpec compilerSpec = language.getCompilerSpecByID(pair.compilerSpecID);
        monitor.setMessage(provider.getName());
        Address imageBaseAddr = language.getAddressFactory().getDefaultAddressSpace().getAddress(loadSpec.getDesiredImageBase());
        Program program = this.createProgram(provider, programName, imageBaseAddr, this.getName(), language, compilerSpec, consumer);
        int transactionID = program.startTransaction("Loading");
        boolean success = false;
        try {
            log.appendMsg("Loading %s...".formatted(provider.getFSRL()));
            this.load(provider, loadSpec, options, program, monitor, log);
            this.createDefaultMemoryBlocks(program, language, log);
            ExternalManager extMgr = program.getExternalManager();
            Program externalNames = extMgr.getExternalLibraryNames();
            Comparator<String> comparator = this.getLibraryNameComparator();
            Arrays.sort(externalNames, comparator);
            for (String name : externalNames) {
                if (comparator.compare(name, provider.getName()) == 0 || comparator.compare(name, program.getName()) == 0 || "<EXTERNAL>".equals(name)) continue;
                libraryNameList.add(name);
            }
            success = true;
            Program program2 = program;
            return program2;
        }
        finally {
            program.endTransaction(transactionID, true);
            if (!success) {
                program.release(consumer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fixupExternalLibraries(List<Loaded<Program>> loadedPrograms, List<DomainFolder> searchFolders, MessageLog messageLog, TaskMonitor monitor) throws CancelledException, IOException {
        monitor.initialize((long)loadedPrograms.size());
        for (Loaded<Program> loadedProgram : loadedPrograms) {
            monitor.increment();
            Program program = loadedProgram.getDomainObject();
            ExternalManager extManager = program.getExternalManager();
            String[] extLibNames = extManager.getExternalLibraryNames();
            if (extLibNames.length == 0 || extLibNames.length == 1 && "<EXTERNAL>".equals(extLibNames[0])) continue;
            monitor.setMessage("Resolving..." + program.getName());
            int id = program.startTransaction("Resolving external references");
            try {
                this.resolveExternalLibraries(program, loadedPrograms, searchFolders, monitor, messageLog);
            }
            finally {
                program.endTransaction(id, true);
            }
        }
    }

    private void resolveExternalLibraries(Program program, List<Loaded<Program>> loadedPrograms, List<DomainFolder> searchFolders, TaskMonitor monitor, MessageLog messageLog) throws CancelledException {
        ExternalManager extManager = program.getExternalManager();
        String[] extLibNames = extManager.getExternalLibraryNames();
        messageLog.appendMsg("Linking the External Programs of '%s' to imported libraries...".formatted(program.getName()));
        for (String externalLibName : extLibNames) {
            if ("<EXTERNAL>".equals(externalLibName)) continue;
            monitor.checkCancelled();
            try {
                Loaded<Program> matchingExtProgram = this.findLibrary(loadedPrograms, externalLibName);
                if (matchingExtProgram != null) {
                    String path = matchingExtProgram.getProjectFolderPath() + matchingExtProgram.getName();
                    extManager.setExternalPath(externalLibName, path, false);
                    messageLog.appendMsg("  [" + externalLibName + "] -> [" + path + "]");
                    continue;
                }
                boolean found = false;
                for (DomainFolder searchFolder : searchFolders) {
                    DomainFile alreadyImportedLib = this.findLibrary(externalLibName, searchFolder);
                    if (alreadyImportedLib == null) continue;
                    extManager.setExternalPath(externalLibName, alreadyImportedLib.getPathname(), false);
                    messageLog.appendMsg("  [" + externalLibName + "] -> [" + alreadyImportedLib.getPathname() + "] (previously imported)");
                    found = true;
                    break;
                }
                if (found) continue;
                messageLog.appendMsg("  [" + externalLibName + "] -> not found in project");
            }
            catch (InvalidInputException e) {
                Msg.error((Object)this, (Object)("Bad library name: " + externalLibName), (Throwable)e);
            }
        }
        messageLog.appendMsg("------------------------------------------------\n");
    }

    private Queue<UnprocessedLibrary> createUnprocessedQueue(List<String> libraryNames, int depth) {
        return libraryNames.stream().map(name -> new UnprocessedLibrary((String)name, depth)).collect(Collectors.toCollection(LinkedList::new));
    }

    protected List<FileSystemSearchPath> getCustomLibrarySearchPaths(ByteProvider provider, List<Option> options, MessageLog log, TaskMonitor monitor) throws CancelledException {
        return List.of();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<FileSystemSearchPath> getLibrarySearchPaths(ByteProvider provider, List<Option> options, MessageLog log, TaskMonitor monitor) throws CancelledException {
        if (!this.isLoadLibraries(options) && !this.shouldSearchAllPaths(options)) {
            return List.of();
        }
        FileSystemService fsService = FileSystemService.getInstance();
        ArrayList<FileSystemSearchPath> result = new ArrayList<FileSystemSearchPath>();
        boolean success = false;
        try {
            for (FSRL fsrl : LibrarySearchPathManager.getLibraryFsrlList(provider, log, monitor)) {
                Closeable fileRef;
                if (fsService.isLocal(fsrl)) {
                    try {
                        fileRef = fsService.probeFileForFilesystem(fsrl, monitor, null);
                        if (fileRef == null) continue;
                        result.add(new FileSystemSearchPath((FileSystemRef)fileRef, null));
                    }
                    catch (IOException e) {
                        log.appendMsg(e.getMessage());
                    }
                    continue;
                }
                try {
                    fileRef = fsService.getRefdFile(fsrl, monitor);
                    try {
                        if (fileRef == null) continue;
                        File f = new File(((RefdFile)fileRef).file.getPath());
                        result.add(new FileSystemSearchPath(((RefdFile)fileRef).fsRef.dup(), f.toPath()));
                    }
                    finally {
                        if (fileRef == null) continue;
                        ((RefdFile)fileRef).close();
                    }
                }
                catch (IOException e) {
                    log.appendMsg(e.getMessage());
                }
            }
            success = true;
        }
        finally {
            if (!success) {
                result.forEach(fsSearchPath -> fsSearchPath.fsRef().close());
            }
        }
        return result;
    }

    private Loaded<Program> findLibrary(List<Loaded<Program>> loadedPrograms, String libraryName) {
        Comparator<String> comparator = this.getLibraryNameComparator();
        boolean noExtension = FilenameUtils.getExtension((String)libraryName).equals("");
        boolean absolute = libraryName.startsWith("/");
        for (Loaded<Program> loadedProgram : loadedPrograms) {
            String loadedProgramPath;
            String candidateName = loadedProgram.getName();
            if (this.isOptionalLibraryFilenameExtensions() && noExtension) {
                candidateName = FilenameUtils.getBaseName((String)candidateName);
            }
            if (!(absolute ? (loadedProgramPath = loadedProgram.getProjectFolderPath() + candidateName).endsWith(libraryName) : comparator.compare(candidateName, libraryName) == 0)) continue;
            return loadedProgram;
        }
        return null;
    }

    protected LoadSpec matchSupportedLoadSpec(LoadSpec desiredLoadSpec, ByteProvider provider) throws IOException {
        LanguageCompilerSpecPair desiredPair = desiredLoadSpec.getLanguageCompilerSpec();
        Collection<LoadSpec> supportedLoadSpecs = this.findSupportedLoadSpecs(provider);
        if (supportedLoadSpecs != null) {
            for (LoadSpec supportedLoadSpec : supportedLoadSpecs) {
                if (!desiredPair.equals((Object)supportedLoadSpec.getLanguageCompilerSpec())) continue;
                return supportedLoadSpec;
            }
        }
        return null;
    }

    protected FSRL resolveLibraryFile(GFileSystem fs, Path libraryParentPath, String libraryName) throws IOException {
        boolean compareWithoutExtension;
        GFile libraryParentDir = fs.lookup(libraryParentPath != null ? FilenameUtils.separatorsToUnix((String)libraryParentPath.toString()) : null);
        boolean bl = compareWithoutExtension = this.isOptionalLibraryFilenameExtensions() && FilenameUtils.getExtension((String)libraryName).equals("");
        if (libraryParentDir != null) {
            Comparator<String> libNameComparator = this.getLibraryNameComparator();
            for (GFile file : fs.getListing(libraryParentDir)) {
                if (file.isDirectory()) continue;
                String compareName = file.getName();
                if (compareWithoutExtension) {
                    compareName = FilenameUtils.getBaseName((String)compareName);
                }
                if (libNameComparator.compare(libraryName, compareName) != 0) continue;
                return file.getFSRL();
            }
        }
        return null;
    }

    private Comparator<String> getLibraryNameComparator() {
        return this.isCaseInsensitiveLibraryFilenames() ? String.CASE_INSENSITIVE_ORDER : (s1, s2) -> s1.compareTo((String)s2);
    }

    private Path getCheckedPath(String str) throws InvalidInputException {
        try {
            return Path.of(str, new String[0]);
        }
        catch (InvalidPathException e) {
            throw new InvalidInputException(e.getMessage());
        }
    }

    private record UnprocessedLibrary(String name, int depth) {
    }

    protected record FileSystemSearchPath(FileSystemRef fsRef, Path fsPath) {
    }
}

