/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.opinion;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.format.macho.dyld.DyldArchitecture;
import ghidra.app.util.bin.format.macho.dyld.DyldCacheHeader;
import ghidra.app.util.bin.format.macho.dyld.DyldCacheLocalSymbolsInfo;
import ghidra.app.util.bin.format.macho.dyld.DyldSubcacheEntry;
import ghidra.app.util.importer.MessageLog;
import ghidra.formats.gfilesystem.FSRL;
import ghidra.formats.gfilesystem.FileSystemRef;
import ghidra.formats.gfilesystem.FileSystemService;
import ghidra.formats.gfilesystem.GFile;
import ghidra.formats.gfilesystem.GFileSystem;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class DyldCacheUtils {
    public static final boolean isDyldCache(Program program) {
        if (program == null) {
            return false;
        }
        if (program.getMemory().getSize() < 16L) {
            return false;
        }
        byte[] bytes = new byte[16];
        try {
            Address address = program.getMinAddress();
            program.getMemory().getBytes(address, bytes);
        }
        catch (MemoryAccessException e) {
            return false;
        }
        return DyldCacheUtils.isDyldCache(new String(bytes).trim());
    }

    public static final boolean isDyldCache(ByteProvider provider) {
        if (provider == null) {
            return false;
        }
        byte[] bytes = new byte[16];
        try {
            bytes = provider.readBytes(0L, 16L);
        }
        catch (IOException e) {
            return false;
        }
        return DyldCacheUtils.isDyldCache(new String(bytes).trim());
    }

    public static final boolean isDyldCache(String signature) {
        for (DyldArchitecture architecture : DyldArchitecture.ARCHITECTURES) {
            if (!architecture.getSignature().equals(signature)) continue;
            return true;
        }
        return false;
    }

    public static class SplitDyldCache
    implements Closeable {
        private List<ByteProvider> providers = new ArrayList<ByteProvider>();
        private List<DyldCacheHeader> headers = new ArrayList<DyldCacheHeader>();
        private List<String> names = new ArrayList<String>();
        private FileSystemService fsService;

        public SplitDyldCache(ByteProvider baseProvider, boolean shouldProcessLocalSymbols, MessageLog log, TaskMonitor monitor) throws IOException, CancelledException {
            monitor.setMessage("Parsing " + baseProvider.getName() + " headers...");
            this.providers.add(baseProvider);
            DyldCacheHeader baseHeader = new DyldCacheHeader(new BinaryReader(baseProvider, true));
            baseHeader.parseFromFile(shouldProcessLocalSymbols, log, monitor);
            this.headers.add(baseHeader);
            this.names.add(baseProvider.getName());
            if (baseHeader.getSubcacheEntries().size() == 0 && baseHeader.getSymbolFileUUID() == null) {
                return;
            }
            this.fsService = FileSystemService.getInstance();
            HashMap<String, FSRL> uuidToFileMap = new HashMap<String, FSRL>();
            for (FSRL splitFSRL : this.findSplitDyldCacheFiles(baseProvider.getFSRL(), monitor)) {
                monitor.setMessage("Parsing " + splitFSRL.getName() + " headers...");
                ByteProvider splitProvider = this.fsService.getByteProvider(splitFSRL, false, monitor);
                if (!DyldCacheUtils.isDyldCache(splitProvider)) {
                    splitProvider.close();
                    continue;
                }
                this.providers.add(splitProvider);
                DyldCacheHeader splitHeader = new DyldCacheHeader(new BinaryReader(splitProvider, true));
                splitHeader.parseFromFile(shouldProcessLocalSymbols, log, monitor);
                this.headers.add(splitHeader);
                this.names.add(splitFSRL.getName());
                uuidToFileMap.put(splitHeader.getUUID(), splitFSRL);
            }
            for (DyldSubcacheEntry subcacheEntry : baseHeader.getSubcacheEntries()) {
                String uuid = subcacheEntry.getUuid();
                String extension = subcacheEntry.getCacheExtension();
                FSRL fsrl = (FSRL)uuidToFileMap.get(uuid);
                if (fsrl == null) {
                    throw new IOException("Missing subcache: %s%s".formatted(extension != null ? baseProvider.getName() + extension + " - " : "", uuid));
                }
                log.appendMsg("Including subcache: " + fsrl.getName() + " - " + uuid);
            }
            String symbolUUID = baseHeader.getSymbolFileUUID();
            if (symbolUUID != null) {
                FSRL symbolFSRL = (FSRL)uuidToFileMap.get(symbolUUID);
                if (symbolFSRL == null) {
                    throw new IOException("Missing symbols subcache: %s.symbols - %s".formatted(baseProvider.getName(), symbolUUID));
                }
                log.appendMsg("Including symbols subcache: " + symbolFSRL.getName() + " - " + symbolUUID);
            }
        }

        public ByteProvider getProvider(int i) {
            return this.providers.get(i);
        }

        public DyldCacheHeader getDyldCacheHeader(int i) {
            return this.headers.get(i);
        }

        public String getName(int i) {
            return this.names.get(i);
        }

        public int size() {
            return this.providers.size();
        }

        public long getBaseAddress() {
            return this.headers.get(0).getBaseAddress();
        }

        public DyldCacheLocalSymbolsInfo getLocalSymbolInfo() {
            return this.headers.stream().map(h -> h.getLocalSymbolsInfo()).filter(info -> info != null).findAny().orElse(null);
        }

        @Override
        public void close() throws IOException {
            for (int i = 1; i < this.providers.size(); ++i) {
                this.providers.get(i).close();
            }
        }

        private List<FSRL> findSplitDyldCacheFiles(FSRL baseFSRL, TaskMonitor monitor) throws CancelledException, IOException {
            if (baseFSRL == null) {
                return Collections.emptyList();
            }
            try (FileSystemRef fsRef = this.fsService.getFilesystem(baseFSRL.getFS(), monitor);){
                GFileSystem fs = fsRef.getFilesystem();
                GFile baseFile = fs.lookup(baseFSRL.getPath());
                String baseName = baseFile.getName();
                ArrayList<FSRL> ret = new ArrayList<FSRL>();
                for (GFile f : fs.getListing(baseFile.getParentFile())) {
                    if (!f.getName().startsWith(baseName + ".") || f.getName().toLowerCase().endsWith(".map")) continue;
                    ret.add(f.getFSRL());
                }
                ret.sort((f1, f2) -> f1.getName().compareTo(f2.getName()));
                ArrayList<FSRL> arrayList = ret;
                return arrayList;
            }
        }
    }
}

