/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.opinion;

import ghidra.app.util.MemoryBlockUtils;
import ghidra.app.util.Option;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.ByteProviderWrapper;
import ghidra.app.util.bin.format.golang.rtti.GoRttiMapper;
import ghidra.app.util.bin.format.macho.CpuTypes;
import ghidra.app.util.bin.format.macho.MachConstants;
import ghidra.app.util.bin.format.macho.MachException;
import ghidra.app.util.bin.format.macho.MachHeader;
import ghidra.app.util.bin.format.swift.SwiftUtils;
import ghidra.app.util.bin.format.ubi.FatArch;
import ghidra.app.util.bin.format.ubi.FatHeader;
import ghidra.app.util.bin.format.ubi.UbiException;
import ghidra.app.util.importer.MessageLog;
import ghidra.app.util.opinion.AbstractLibrarySupportLoader;
import ghidra.app.util.opinion.LoadSpec;
import ghidra.app.util.opinion.Loader;
import ghidra.app.util.opinion.MachoPrelinkProgramBuilder;
import ghidra.app.util.opinion.MachoPrelinkUtils;
import ghidra.app.util.opinion.MachoProgramBuilder;
import ghidra.app.util.opinion.QueryOpinionService;
import ghidra.app.util.opinion.QueryResult;
import ghidra.formats.gfilesystem.FSRL;
import ghidra.formats.gfilesystem.GFile;
import ghidra.formats.gfilesystem.GFileSystem;
import ghidra.program.database.mem.FileBytes;
import ghidra.program.model.listing.Program;
import ghidra.util.LittleEndianDataConverter;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class MachoLoader
extends AbstractLibrarySupportLoader {
    public static final String MACH_O_NAME = "Mac OS X Mach-O";
    private static final long MIN_BYTE_LENGTH = 4L;

    @Override
    public Collection<LoadSpec> findSupportedLoadSpecs(ByteProvider provider) throws IOException {
        ArrayList<LoadSpec> loadSpecs = new ArrayList<LoadSpec>();
        if (provider.length() < 4L) {
            return loadSpecs;
        }
        byte[] magicBytes = provider.readBytes(0L, 4L);
        if (!MachConstants.isMagic(LittleEndianDataConverter.INSTANCE.getInt(magicBytes))) {
            return loadSpecs;
        }
        try {
            MachHeader machHeader = new MachHeader(provider);
            String magic = CpuTypes.getMagicString(machHeader.getCpuType(), machHeader.getCpuSubType());
            String compiler = this.detectCompilerName(machHeader);
            List<QueryResult> results = QueryOpinionService.query(MACH_O_NAME, magic, compiler);
            for (QueryResult result : results) {
                loadSpecs.add(new LoadSpec((Loader)this, machHeader.getImageBase(), result));
            }
            if (loadSpecs.isEmpty()) {
                loadSpecs.add(new LoadSpec((Loader)this, machHeader.getImageBase(), true));
            }
        }
        catch (MachException machException) {
            // empty catch block
        }
        return loadSpecs;
    }

    private String detectCompilerName(MachHeader machHeader) throws IOException {
        List<String> sectionNames = machHeader.parseSegments().stream().flatMap(seg -> seg.getSections().stream()).map(section -> section.getSectionName()).toList();
        if (SwiftUtils.isSwift(sectionNames)) {
            return "swift";
        }
        if (GoRttiMapper.hasGolangSections(sectionNames)) {
            return "golang";
        }
        return null;
    }

    @Override
    public void load(ByteProvider provider, LoadSpec loadSpec, List<Option> options, Program program, TaskMonitor monitor, MessageLog log) throws IOException {
        try {
            FileBytes fileBytes = MemoryBlockUtils.createFileBytes(program, provider, monitor);
            if (MachoPrelinkUtils.isMachoPrelink(provider, monitor) || MachoPrelinkUtils.isMachoFileset(provider)) {
                MachoPrelinkProgramBuilder.buildProgram(program, provider, fileBytes, log, monitor);
            } else {
                MachoProgramBuilder.buildProgram(program, provider, fileBytes, log, monitor);
            }
        }
        catch (CancelledException e) {
            return;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public String getName() {
        return MACH_O_NAME;
    }

    @Override
    protected ByteProvider createLibraryByteProvider(FSRL libFsrl, LoadSpec loadSpec, MessageLog log, TaskMonitor monitor) throws IOException, CancelledException {
        ByteProvider provider = super.createLibraryByteProvider(libFsrl, loadSpec, log, monitor);
        try {
            FatHeader header = new FatHeader(provider);
            List<FatArch> architectures = header.getArchitectures();
            if (architectures.isEmpty()) {
                log.appendMsg("WARNING! No archives found in the UBI: " + String.valueOf(libFsrl));
                return null;
            }
            for (FatArch architecture : architectures) {
                ByteProviderWrapper bp = new ByteProviderWrapper(this, provider, (long)architecture.getOffset(), architecture.getSize()){

                    @Override
                    public void close() throws IOException {
                        this.provider.close();
                    }
                };
                LoadSpec libLoadSpec = this.matchSupportedLoadSpec(loadSpec, bp);
                if (libLoadSpec == null) continue;
                return bp;
            }
        }
        catch (MachException | UbiException exception) {
            // empty catch block
        }
        return provider;
    }

    @Override
    protected FSRL resolveLibraryFile(GFileSystem fs, Path libraryParentPath, String libraryName) throws IOException {
        GFile libraryParentDir = fs.lookup(libraryParentPath != null ? libraryParentPath.toString() : null);
        if (libraryParentDir != null) {
            for (GFile file : fs.getListing(libraryParentDir)) {
                if (file.isDirectory() && file.getName().equals("Versions")) {
                    GFile specificVersionDir;
                    Path versionsPath = libraryParentPath.resolve(file.getName());
                    List<GFile> versionListion = fs.getListing(file);
                    if (!versionListion.isEmpty() && (specificVersionDir = versionListion.get(0)).isDirectory()) {
                        return this.resolveLibraryFile(fs, versionsPath.resolve(specificVersionDir.getName()), libraryName);
                    }
                } else if (file.isDirectory()) continue;
                if (!file.getName().equals(libraryName)) continue;
                return file.getFSRL();
            }
        }
        return null;
    }
}

