/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.opinion;

import ghidra.app.util.MemoryBlockUtils;
import ghidra.app.util.Option;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.format.omf.AbstractOmfRecordFactory;
import ghidra.app.util.bin.format.omf.OmfException;
import ghidra.app.util.bin.format.omf.OmfRecord;
import ghidra.app.util.bin.format.omf.OmfUtils;
import ghidra.app.util.bin.format.omf.omf51.Omf51RecordFactory;
import ghidra.app.util.importer.MessageLog;
import ghidra.app.util.opinion.AbstractProgramWrapperLoader;
import ghidra.app.util.opinion.LoadSpec;
import ghidra.app.util.opinion.Loader;
import ghidra.app.util.opinion.QueryOpinionService;
import ghidra.app.util.opinion.QueryResult;
import ghidra.program.database.mem.FileBytes;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataUtilities;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Omf51Loader
extends AbstractProgramWrapperLoader {
    public static final String OMF51_NAME = "Object Module Format (OMF-51)";
    public static final long MIN_BYTE_LENGTH = 11L;

    @Override
    public Collection<LoadSpec> findSupportedLoadSpecs(ByteProvider provider) throws IOException {
        ArrayList<LoadSpec> loadSpecs = new ArrayList<LoadSpec>();
        if (provider.length() < 11L) {
            return loadSpecs;
        }
        Omf51RecordFactory factory = new Omf51RecordFactory(provider);
        try {
            OmfRecord first = ((AbstractOmfRecordFactory)factory).readNextRecord();
            if (((AbstractOmfRecordFactory)factory).getStartRecordTypes().contains(first.getRecordType()) && first.validCheckSum()) {
                List<QueryResult> results = QueryOpinionService.query(this.getName(), "8051", null);
                for (QueryResult result : results) {
                    loadSpecs.add(new LoadSpec((Loader)this, 0L, result));
                }
                if (loadSpecs.isEmpty()) {
                    loadSpecs.add(new LoadSpec((Loader)this, 0L, true));
                }
            }
        }
        catch (OmfException | IOException exception) {
            // empty catch block
        }
        return loadSpecs;
    }

    @Override
    protected void load(ByteProvider provider, LoadSpec loadSpec, List<Option> options, Program program, TaskMonitor monitor, MessageLog log) throws IOException, CancelledException {
        FileBytes fileBytes = MemoryBlockUtils.createFileBytes(program, provider, monitor);
        Omf51RecordFactory factory = new Omf51RecordFactory(provider);
        try {
            List<OmfRecord> records = OmfUtils.readRecords(factory);
            this.markupRecords(program, fileBytes, records, log, monitor);
        }
        catch (OmfException e) {
            throw new IOException(e);
        }
    }

    private void markupRecords(Program program, FileBytes fileBytes, List<OmfRecord> records, MessageLog log, TaskMonitor monitor) {
        monitor.setMessage("Marking up records...");
        int size = records.stream().mapToInt(r -> r.getRecordLength() + 3).sum();
        try {
            Address recordSpaceAddr = AddressSpace.OTHER_SPACE.getAddress(0L);
            MemoryBlock headerBlock = MemoryBlockUtils.createInitializedBlock(program, true, "RECORDS", recordSpaceAddr, fileBytes, 0L, size, "", "", false, false, false, log);
            Address start = headerBlock.getStart();
            for (OmfRecord record : records) {
                DataUtilities.createData((Program)program, (Address)start.add(record.getRecordOffset()), (DataType)record.toDataType(), (int)-1, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CHECK_FOR_SPACE);
            }
        }
        catch (Exception e) {
            log.appendMsg("Failed to markup records");
        }
    }

    @Override
    public String getName() {
        return OMF51_NAME;
    }
}

