/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.field;

import docking.widgets.fieldpanel.field.AttributedString;
import ghidra.app.nav.Navigatable;
import ghidra.app.util.viewer.field.AnnotatedStringHandler;
import ghidra.app.util.viewer.field.AnnotationException;
import ghidra.app.util.viewer.field.InvalidAnnotatedStringHandler;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.listing.Program;
import ghidra.util.classfinder.ClassSearcher;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Annotation {
    public static final String ESCAPABLE_CHARS = "{}\"\\";
    private static List<AnnotatedStringHandler> ANNOTATED_STRING_HANDLERS;
    private static Map<String, AnnotatedStringHandler> ANNOTATED_STRING_MAP;
    private String annotationText;
    private String[] annotationParts;
    private AnnotatedStringHandler annotatedStringHandler;
    private AttributedString displayString;

    public static List<AnnotatedStringHandler> getAnnotatedStringHandlers() {
        if (ANNOTATED_STRING_HANDLERS == null) {
            ANNOTATED_STRING_HANDLERS = Annotation.getSupportedAnnotationHandlers();
        }
        return ANNOTATED_STRING_HANDLERS;
    }

    private static Map<String, AnnotatedStringHandler> getAnnotatedStringHandlerMap() {
        if (ANNOTATED_STRING_MAP == null) {
            ANNOTATED_STRING_MAP = Annotation.createAnnotatedStringHandlerMap();
        }
        return ANNOTATED_STRING_MAP;
    }

    private static Map<String, AnnotatedStringHandler> createAnnotatedStringHandlerMap() {
        HashMap<String, AnnotatedStringHandler> map = new HashMap<String, AnnotatedStringHandler>();
        for (AnnotatedStringHandler instance : Annotation.getAnnotatedStringHandlers()) {
            String[] supportedAnnotations;
            for (String supportedAnnotation : supportedAnnotations = instance.getSupportedAnnotations()) {
                map.put(supportedAnnotation, instance);
            }
        }
        return Collections.unmodifiableMap(map);
    }

    private static List<AnnotatedStringHandler> getSupportedAnnotationHandlers() {
        ArrayList<AnnotatedStringHandler> list = new ArrayList<AnnotatedStringHandler>();
        for (AnnotatedStringHandler h : ClassSearcher.getInstances(AnnotatedStringHandler.class)) {
            if (h.getSupportedAnnotations().length == 0) continue;
            list.add(h);
        }
        return Collections.unmodifiableList(list);
    }

    public Annotation(String annotationText, AttributedString prototypeString, Program program) {
        this.annotationText = annotationText;
        this.annotationParts = this.parseAnnotationText(annotationText);
        this.annotatedStringHandler = this.getHandler(this.annotationParts);
        try {
            this.displayString = this.annotatedStringHandler.createAnnotatedString(prototypeString, this.annotationParts, program);
        }
        catch (AnnotationException ae) {
            this.annotatedStringHandler = new InvalidAnnotatedStringHandler("Annotation Exception: " + ae.getMessage());
            this.displayString = this.annotatedStringHandler.createAnnotatedString(prototypeString, this.annotationParts, program);
        }
    }

    private AnnotatedStringHandler getHandler(String[] annotationPieces) {
        if (annotationPieces.length <= 1) {
            return new InvalidAnnotatedStringHandler("Invalid annotation format. Expected at least two strings.");
        }
        String keyword = annotationPieces[0];
        AnnotatedStringHandler handler = Annotation.getAnnotatedStringHandlerMap().get(keyword);
        if (handler == null) {
            return new InvalidAnnotatedStringHandler("Invalid annotation keyword: " + keyword);
        }
        return handler;
    }

    String[] getAnnotationParts() {
        return this.annotationParts;
    }

    AnnotatedStringHandler getHandler() {
        return this.annotatedStringHandler;
    }

    public AttributedString getDisplayString() {
        return this.displayString;
    }

    public boolean handleMouseClick(Navigatable sourceNavigatable, ServiceProvider serviceProvider) {
        return this.annotatedStringHandler.handleMouseClick(this.annotationParts, sourceNavigatable, serviceProvider);
    }

    public String getAnnotationText() {
        return this.annotationText;
    }

    public String toString() {
        return this.annotationText;
    }

    static Set<String> getAnnotationNames() {
        return Collections.unmodifiableSet(Annotation.getAnnotatedStringHandlerMap().keySet());
    }

    private String[] parseAnnotationText(String text) {
        String trimmed = text.substring(2, text.length() - 1);
        ArrayList<String> tokens = new ArrayList<String>();
        List<TextPart> parts = this.parseText(trimmed);
        for (TextPart part : parts) {
            part.grabTokens(tokens);
        }
        return tokens.toArray(new String[tokens.size()]);
    }

    private List<TextPart> parseText(String text) {
        ArrayList<TextPart> textParts = new ArrayList<TextPart>();
        boolean escaped = false;
        boolean inQuote = false;
        int partStart = 0;
        int n = text.length();
        for (int i = 0; i < n; ++i) {
            boolean wasEscaped = escaped;
            escaped = false;
            int prev = 0;
            if (i != 0 && !wasEscaped) {
                prev = text.charAt(i - 1);
            }
            char c = text.charAt(i);
            if (prev == 92 && ESCAPABLE_CHARS.indexOf(c) != -1) {
                escaped = true;
                continue;
            }
            if (c != '\"') continue;
            if (inQuote) {
                s = text.substring(partStart, i + 1);
                textParts.add(new QuotedTextPart(this, s));
                partStart = i + 1;
            } else if (i != 0) {
                s = text.substring(partStart, i);
                textParts.add(new TextPart(this, s));
                partStart = i;
            }
            inQuote = !inQuote;
        }
        if (partStart < n) {
            String s = text.substring(partStart, n);
            textParts.add(new TextPart(this, s));
        }
        return textParts;
    }

    private static String removeEscapeChars(String text) {
        boolean escaped = false;
        StringBuilder buffy = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            boolean wasEscaped = escaped;
            escaped = false;
            if (c != '\\') {
                buffy.append(c);
                continue;
            }
            int next = 0;
            if (i != text.length() - 1 && !wasEscaped) {
                next = text.charAt(i + 1);
            }
            if (ESCAPABLE_CHARS.indexOf(next) != -1) {
                escaped = true;
                continue;
            }
            buffy.append(c);
        }
        return buffy.toString();
    }

    private class TextPart {
        protected String text;

        TextPart(Annotation annotation, String text) {
            this.text = text;
        }

        public void grabTokens(List<String> tokens) {
            String[] strings;
            String escaped = Annotation.removeEscapeChars(this.text);
            for (String string : strings = escaped.split("\\s")) {
                if (string.length() <= 0) continue;
                tokens.add(string);
            }
        }

        public String toString() {
            return this.text;
        }
    }

    private class QuotedTextPart
    extends TextPart {
        QuotedTextPart(Annotation annotation, String text) {
            super(annotation, text);
        }

        @Override
        public void grabTokens(List<String> tokens) {
            String unquoted = this.text.substring(1, this.text.length() - 1);
            String escaped = Annotation.removeEscapeChars(unquoted);
            tokens.add(escaped);
        }
    }
}

