/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.field;

import docking.widgets.fieldpanel.field.AbstractTextFieldElement;
import docking.widgets.fieldpanel.field.AttributedString;
import docking.widgets.fieldpanel.field.CompositeFieldElement;
import docking.widgets.fieldpanel.field.FieldElement;
import docking.widgets.fieldpanel.support.FieldLocation;
import docking.widgets.fieldpanel.support.RowColLocation;
import ghidra.app.util.ColorAndStyle;
import ghidra.app.util.ListingHighlightProvider;
import ghidra.app.util.SymbolInspector;
import ghidra.app.util.viewer.field.BrowserCodeUnitFormat;
import ghidra.app.util.viewer.field.FieldFactory;
import ghidra.app.util.viewer.field.ImageFactoryField;
import ghidra.app.util.viewer.field.ListingColors;
import ghidra.app.util.viewer.field.ListingField;
import ghidra.app.util.viewer.field.ListingTextField;
import ghidra.app.util.viewer.field.ResourceFieldLocation;
import ghidra.app.util.viewer.format.FieldFormatModel;
import ghidra.app.util.viewer.options.OptionsGui;
import ghidra.app.util.viewer.proxy.ProxyObj;
import ghidra.framework.options.Options;
import ghidra.framework.options.ToolOptions;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataImage;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.Playable;
import ghidra.program.model.data.Union;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.LabelString;
import ghidra.program.model.listing.OperandRepresentationList;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.Variable;
import ghidra.program.model.listing.VariableOffset;
import ghidra.program.model.scalar.Scalar;
import ghidra.program.model.symbol.Equate;
import ghidra.program.model.symbol.EquateTable;
import ghidra.program.model.symbol.ExternalLocation;
import ghidra.program.model.symbol.ExternalManager;
import ghidra.program.model.symbol.ExternalReference;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceManager;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.util.EquateOperandFieldLocation;
import ghidra.program.util.OperandFieldLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.util.HelpLocation;
import java.awt.Color;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.ChangeListener;

abstract class OperandFieldHelper
extends FieldFactory {
    private static final String ENABLE_WORD_WRAP_OPTION = "Operands Field.Enable Word Wrapping";
    private static final String MAX_DISPLAY_LINES_OPTION = "Operands Field.Maximum Lines To Display";
    private static final String UNDERLINE_OPTION = "Operands Field.Underline References";
    private static final String SPACE_AFTER_SEPARATOR_OPTION = "Operands Field.Add Space After Separator";
    private static final String WRAP_ON_SEMICOLON_OPTION = "Operands Field.Wrap on Semicolons";
    private static final OperandFieldElement LINE_BREAK = new OperandFieldElement(null, 0, 0, 0);
    private SymbolInspector inspector;
    private ColorStyleAttributes addressAttributes = new ColorStyleAttributes(this);
    private ColorStyleAttributes externalRefAttributes = new ColorStyleAttributes(this);
    private ColorStyleAttributes badRefAttributes = new ColorStyleAttributes(this);
    private ColorStyleAttributes separatorAttributes = new ColorStyleAttributes(this);
    private ColorStyleAttributes scalarAttributes = new ColorStyleAttributes(this);
    private ColorStyleAttributes variableRefAttributes = new ColorStyleAttributes(this);
    private ColorStyleAttributes registerAttributes = new ColorStyleAttributes(this);
    private UNDERLINE_CHOICE underlineChoice = UNDERLINE_CHOICE.Hidden;
    private boolean isWordWrap = false;
    private int maxDisplayLines = 2;
    private boolean spaceAfterSeparator = false;
    private boolean wrapOnSemicolon = false;
    protected BrowserCodeUnitFormat codeUnitFormat;
    private ChangeListener codeUnitFormatListener = e -> this.model.update();

    OperandFieldHelper(String name) {
        super(name);
    }

    OperandFieldHelper(String name, FieldFormatModel model, ListingHighlightProvider hlProvider, ToolOptions displayOptions, ToolOptions fieldOptions) {
        super(name, model, hlProvider, (Options)displayOptions, (Options)fieldOptions);
        this.setOptions((Options)displayOptions);
        HelpLocation hl = new HelpLocation("CodeBrowserPlugin", "Operands_Field");
        fieldOptions.registerOption(ENABLE_WORD_WRAP_OPTION, (Object)false, hl, "Enables word wrapping of strings in the operands field.");
        fieldOptions.registerOption(MAX_DISPLAY_LINES_OPTION, (Object)2, hl, "The maximum number of lines used to display the strings in the operands field.");
        fieldOptions.registerOption(UNDERLINE_OPTION, (Object)UNDERLINE_CHOICE.Hidden, hl, "Select 'All' to underline any operand field that has a reference; select 'Hidden' to underline operand fields that have non-primary references;\nselect 'None' for no underlines.");
        fieldOptions.registerOption(SPACE_AFTER_SEPARATOR_OPTION, (Object)false, hl, "Add space between separator and next operand");
        fieldOptions.registerOption(WRAP_ON_SEMICOLON_OPTION, (Object)false, hl, "Wrap operand field on semicolons");
        this.setMaximumLinesToDisplay(fieldOptions.getInt(MAX_DISPLAY_LINES_OPTION, 2), (Options)fieldOptions);
        this.isWordWrap = fieldOptions.getBoolean(ENABLE_WORD_WRAP_OPTION, false);
        this.underlineChoice = (UNDERLINE_CHOICE)fieldOptions.getEnum(UNDERLINE_OPTION, (Enum)UNDERLINE_CHOICE.Hidden);
        this.spaceAfterSeparator = fieldOptions.getBoolean(SPACE_AFTER_SEPARATOR_OPTION, false);
        this.wrapOnSemicolon = fieldOptions.getBoolean(WRAP_ON_SEMICOLON_OPTION, false);
        this.inspector = new SymbolInspector(displayOptions, null);
        this.codeUnitFormat = new BrowserCodeUnitFormat(fieldOptions, true);
        this.codeUnitFormat.addChangeListener(this.codeUnitFormatListener);
    }

    @Override
    public void displayOptionsChanged(Options options, String optionName, Object oldValue, Object newValue) {
        this.setOptions(options);
        super.displayOptionsChanged(options, optionName, oldValue, newValue);
    }

    @Override
    public void fieldOptionsChanged(Options options, String optionName, Object oldValue, Object newValue) {
        boolean updateModel = false;
        switch (optionName) {
            case "Operands Field.Maximum Lines To Display": {
                this.setMaximumLinesToDisplay((Integer)newValue, options);
                updateModel = true;
                break;
            }
            case "Operands Field.Enable Word Wrapping": {
                this.isWordWrap = (Boolean)newValue;
                updateModel = true;
                break;
            }
            case "Operands Field.Underline References": {
                this.underlineChoice = (UNDERLINE_CHOICE)((Object)newValue);
                updateModel = true;
                break;
            }
            case "Operands Field.Add Space After Separator": {
                this.spaceAfterSeparator = (Boolean)newValue;
                updateModel = true;
                break;
            }
            case "Operands Field.Wrap on Semicolons": {
                this.wrapOnSemicolon = (Boolean)newValue;
                updateModel = true;
            }
        }
        if (updateModel) {
            this.model.update();
        }
    }

    private void setMaximumLinesToDisplay(int maxLines, Options options) {
        if (maxLines < 1) {
            maxLines = 1;
            options.setInt(MAX_DISPLAY_LINES_OPTION, maxLines);
        }
        this.maxDisplayLines = maxLines;
    }

    FieldLocation getFieldLocation(BigInteger index, int fieldNum, ListingField field, int opIndex, int column) {
        if (field instanceof ListingTextField) {
            ListingTextField listingField = (ListingTextField)field;
            RowColLocation rcl = listingField.dataToScreenLocation(opIndex, column);
            return new FieldLocation(index, fieldNum, rcl.row(), rcl.col());
        }
        if (field instanceof ImageFactoryField) {
            return new FieldLocation(index, fieldNum, 0, 0);
        }
        return null;
    }

    ListingField getField(Object obj, ProxyObj<?> proxy, int varWidth) {
        if (!this.enabled) {
            return null;
        }
        if (obj instanceof Instruction) {
            return this.getFieldForInstruction((Instruction)obj, proxy, varWidth);
        }
        if (obj instanceof Data) {
            return this.getFieldForData((Data)obj, proxy, varWidth);
        }
        return null;
    }

    @Override
    public ProgramLocation getProgramLocation(int row, int col, ListingField lf) {
        Data data;
        Object obj = lf.getProxy().getObject();
        if (lf instanceof ImageFactoryField && (data = (Data)obj).getValue() instanceof DataImage) {
            return new ResourceFieldLocation(data.getProgram(), data.getMinAddress(), data.getComponentPath(), this.codeUnitFormat.getDataValueRepresentationString(data), 0, col, data);
        }
        if (!(lf instanceof ListingTextField)) {
            return null;
        }
        ListingTextField btf = (ListingTextField)lf;
        FieldElement fieldElement = btf.getFieldElement(row, col);
        if (!(fieldElement instanceof OperandFieldElement)) {
            return null;
        }
        OperandFieldElement element = (OperandFieldElement)fieldElement;
        int opIndex = element.getOperandIndex();
        int subOpIndex = element.getOperandSubIndex();
        RowColLocation translatedLocation = btf.screenToDataLocation(row, col);
        if (obj instanceof Instruction) {
            Instruction inst = (Instruction)obj;
            OperandRepresentationList operandRepresentationList = this.codeUnitFormat.getOperandRepresentationList((CodeUnit)inst, opIndex);
            String repStr = "<UNSUPPORTED>";
            Address refAddr = null;
            VariableOffset variableOffset = null;
            Program program = inst.getProgram();
            if (operandRepresentationList == null) {
                return new OperandFieldLocation(program, inst.getMinAddress(), variableOffset, refAddr, repStr, opIndex, subOpIndex, translatedLocation.col());
            }
            repStr = operandRepresentationList.toString();
            if (subOpIndex >= 0 && operandRepresentationList.size() > subOpIndex) {
                Object rep = operandRepresentationList.get(subOpIndex);
                if (rep instanceof Address) {
                    refAddr = (Address)rep;
                } else {
                    int extendedRefIndex = repStr.indexOf("=>");
                    if (extendedRefIndex < 0 || translatedLocation.col() <= extendedRefIndex) {
                        variableOffset = this.getVariableOffset(rep);
                    }
                    if ((refAddr = inst.getAddress(opIndex)) == null) {
                        refAddr = this.getVariableStorageAddress(inst, operandRepresentationList, element.getText());
                    }
                    if (rep instanceof Equate) {
                        Equate equate = (Equate)rep;
                        return new EquateOperandFieldLocation(program, inst.getMinAddress(), refAddr, repStr, equate, opIndex, subOpIndex, translatedLocation.col());
                    }
                }
            }
            return new OperandFieldLocation(program, inst.getMinAddress(), variableOffset, refAddr, repStr, opIndex, subOpIndex, translatedLocation.col());
        }
        if (obj instanceof Data) {
            Data data2 = (Data)obj;
            Address refAddr = null;
            Program program = data2.getProgram();
            ReferenceManager referenceManager = program.getReferenceManager();
            Address minAddress = data2.getMinAddress();
            Reference primaryReference = referenceManager.getPrimaryReferenceFrom(minAddress, 0);
            Object value = data2.getValue();
            if (primaryReference != null) {
                refAddr = primaryReference.getToAddress();
            } else if (value instanceof Address) {
                refAddr = (Address)value;
            }
            if (value instanceof Scalar) {
                Scalar scalar = (Scalar)value;
                EquateTable equateTable = program.getEquateTable();
                Equate equate = equateTable.getEquate(minAddress, opIndex, scalar.getValue());
                if (equate != null) {
                    return new EquateOperandFieldLocation(program, minAddress, refAddr, equate.getDisplayName(), equate, opIndex, subOpIndex, translatedLocation.col());
                }
            }
            return new OperandFieldLocation(program, minAddress, data2.getComponentPath(), refAddr, this.codeUnitFormat.getDataValueRepresentationString(data2), 0, col);
        }
        return null;
    }

    private VariableOffset getVariableOffset(Object representation) {
        if (representation instanceof VariableOffset) {
            return (VariableOffset)representation;
        }
        if (representation instanceof OperandRepresentationList) {
            OperandRepresentationList list = (OperandRepresentationList)representation;
            for (Object innerRepresentation : list) {
                if (!(innerRepresentation instanceof VariableOffset)) continue;
                return (VariableOffset)innerRepresentation;
            }
        }
        return null;
    }

    private Address getVariableStorageAddress(Instruction inst, OperandRepresentationList opList, String string) {
        this.flattenList((List<Object>)opList);
        for (Object obj : opList) {
            Variable var;
            if (!(obj instanceof VariableOffset) || !string.equals(obj.toString()) || (var = ((VariableOffset)obj).getVariable()) == null) continue;
            return var.getMinAddress();
        }
        return null;
    }

    private void flattenList(List<Object> list) {
        int i = 0;
        while (i < list.size()) {
            Object obj = list.get(i);
            if (obj instanceof List) {
                List subList = (List)list.remove(i);
                int n = i;
                for (Object subObj : subList) {
                    list.add(n++, subObj);
                }
                continue;
            }
            ++i;
        }
    }

    private ListingField getFieldForData(Data data, ProxyObj<?> proxy, int varWidth) {
        Object value = data.getValue();
        if (value instanceof DataImage) {
            return new ImageFactoryField(this, ((DataImage)value).getImageIcon(), proxy, this.getMetrics(), this.startX + varWidth, this.width);
        }
        if (value instanceof Playable) {
            return new ImageFactoryField(this, ((Playable)value).getImageIcon(), proxy, this.getMetrics(), this.startX + varWidth, this.width);
        }
        OperandRepresentationList dataValueRepresentation = this.codeUnitFormat.getDataValueRepresentation(data);
        boolean underline = this.isUnderlined((CodeUnit)data, 0, dataValueRepresentation.isPrimaryReferenceHidden());
        ColorStyleAttributes attributes = dataValueRepresentation.hasError() ? this.badRefAttributes : this.getAttributesForData(data, value);
        AttributedString as = new AttributedString(dataValueRepresentation.toString(), attributes.colorAttribute, this.getMetrics(attributes.styleAttribute), underline, (Color)ListingColors.UNDERLINE);
        OperandFieldElement field = new OperandFieldElement(as, 0, 0, 0);
        if (this.shouldWordWrap(data, dataValueRepresentation)) {
            return ListingTextField.createWordWrappedTextField(this, proxy, (FieldElement)field, this.startX + varWidth, this.width, this.maxDisplayLines, this.hlProvider);
        }
        return ListingTextField.createSingleLineTextField(this, proxy, (FieldElement)field, this.startX + varWidth, this.width, this.hlProvider);
    }

    private boolean shouldWordWrap(Data data, OperandRepresentationList dataValueRepresentation) {
        if (dataValueRepresentation.hasError()) {
            return true;
        }
        if (!this.isWordWrap) {
            return false;
        }
        Object value = data.getValue();
        if (value instanceof String) {
            return true;
        }
        DataType dt = data.getDataType();
        return dt instanceof ghidra.program.model.data.Enum;
    }

    private ColorStyleAttributes getAttributesForData(Data data, Object value) {
        boolean parentIsaUnion;
        Data parentData = data.getParent();
        if (this.isInvalidEquate(data)) {
            return this.badRefAttributes;
        }
        boolean bl = parentIsaUnion = parentData != null && parentData.getDataType() instanceof Union;
        if (parentIsaUnion && !data.isPointer()) {
            return value instanceof Address ? this.addressAttributes : this.scalarAttributes;
        }
        return this.getOpAttributes((CodeUnit)data, 0, data.getProgram());
    }

    private ListingField getFieldForInstruction(Instruction inst, ProxyObj<?> proxy, int varWidth) {
        int numOperands = inst.getNumOperands();
        if (numOperands == 0) {
            return null;
        }
        ArrayList<OperandFieldElement> elements = new ArrayList<OperandFieldElement>();
        int characterOffset = this.createSeparatorFieldElement(inst, 0, 0, 0, 0, elements);
        for (int opIndex = 0; opIndex < numOperands; ++opIndex) {
            OperandRepresentationList operandRepresentationList = this.codeUnitFormat.getOperandRepresentationList((CodeUnit)inst, opIndex);
            characterOffset = this.addElementsForOperand(inst, elements, opIndex, operandRepresentationList, characterOffset);
            characterOffset = 0;
        }
        if (elements.isEmpty()) {
            return null;
        }
        if (this.wrapOnSemicolon) {
            List<FieldElement> lines = this.breakIntoLines(elements);
            if (lines.size() == 1) {
                return ListingTextField.createSingleLineTextField(this, proxy, lines.get(0), this.startX + varWidth, this.width, this.hlProvider);
            }
            return ListingTextField.createMultilineTextField(this, proxy, lines, this.startX, this.width, this.hlProvider);
        }
        return ListingTextField.createSingleLineTextField(this, proxy, (FieldElement)new CompositeFieldElement(elements), this.startX + varWidth, this.width, this.hlProvider);
    }

    private List<FieldElement> breakIntoLines(List<OperandFieldElement> elements) {
        ArrayList<FieldElement> fieldElements = new ArrayList<FieldElement>();
        ArrayList<OperandFieldElement> lineElements = new ArrayList<OperandFieldElement>();
        for (OperandFieldElement operandFieldElement : elements) {
            if (operandFieldElement == LINE_BREAK) {
                if (lineElements.isEmpty()) continue;
                fieldElements.add((FieldElement)new CompositeFieldElement(lineElements));
                lineElements.clear();
                continue;
            }
            lineElements.add(operandFieldElement);
        }
        if (!lineElements.isEmpty()) {
            fieldElements.add((FieldElement)new CompositeFieldElement(lineElements));
            lineElements.clear();
        }
        return fieldElements;
    }

    private int addElementsForOperand(Instruction inst, List<OperandFieldElement> elements, int opIndex, OperandRepresentationList opRepList, int characterOffset) {
        int subOpIndex;
        if (opRepList == null || opRepList.hasError()) {
            AttributedString as = new AttributedString(opRepList != null ? opRepList.toString() : "<UNSUPPORTED>", this.badRefAttributes.colorAttribute, this.getMetrics(this.badRefAttributes.styleAttribute), false, (Color)ListingColors.UNDERLINE);
            elements.add(new OperandFieldElement(as, opIndex, subOpIndex, characterOffset));
            characterOffset += as.length();
        } else {
            boolean underline = this.isUnderlined((CodeUnit)inst, opIndex, opRepList.isPrimaryReferenceHidden());
            for (subOpIndex = 0; subOpIndex < opRepList.size(); ++subOpIndex) {
                characterOffset = this.addElement(inst, elements, opRepList.get(subOpIndex), underline, opIndex, subOpIndex, characterOffset);
            }
        }
        return this.createSeparatorFieldElement(inst, opIndex + 1, opIndex, subOpIndex - 1, characterOffset, elements);
    }

    private int addElements(Instruction inst, List<OperandFieldElement> elements, List<?> objList, int opIndex, int subOpIndex, boolean underline, int characterOffset) {
        for (Object element : objList) {
            characterOffset = this.addElement(inst, elements, element, underline, opIndex, subOpIndex, characterOffset);
        }
        return characterOffset;
    }

    private int addElement(Instruction inst, List<OperandFieldElement> elements, Object opElem, boolean underline, int opIndex, int subOpIndex, int characterOffset) {
        Character c;
        if (opElem instanceof VariableOffset) {
            List objList = ((VariableOffset)opElem).getObjects();
            return this.addElements(inst, elements, objList, opIndex, subOpIndex, underline, characterOffset);
        }
        if (opElem instanceof List) {
            return this.addElements(inst, elements, (List)opElem, opIndex, subOpIndex, underline, characterOffset);
        }
        ColorStyleAttributes attributes = this.getOpAttributes(opElem, inst, opIndex);
        AttributedString as = new AttributedString(opElem.toString(), attributes.colorAttribute, this.getMetrics(attributes.styleAttribute), underline, (Color)ListingColors.UNDERLINE);
        elements.add(new OperandFieldElement(as, opIndex, subOpIndex, characterOffset));
        if (this.wrapOnSemicolon && opElem instanceof Character && (c = (Character)opElem).charValue() == ';') {
            elements.add(LINE_BREAK);
        }
        return characterOffset + as.length();
    }

    private int createSeparatorFieldElement(Instruction instruction, int separatorIndex, int opIndex, int subOpIndex, int characterOffset, List<OperandFieldElement> elements) {
        Object separator = instruction.getSeparator(separatorIndex);
        if (separator == null) {
            return characterOffset;
        }
        if (this.spaceAfterSeparator) {
            separator = (String)separator + " ";
        }
        AttributedString as = new AttributedString((String)separator, this.separatorAttributes.colorAttribute, this.getMetrics(this.separatorAttributes.styleAttribute));
        OperandFieldElement fieldElement = new OperandFieldElement(as, opIndex, subOpIndex, characterOffset);
        elements.add(fieldElement);
        return characterOffset + fieldElement.length();
    }

    private boolean isUnderlined(CodeUnit codeUnit, int opIndex, boolean primaryReferenceHidden) {
        if (this.underlineChoice == UNDERLINE_CHOICE.None) {
            return false;
        }
        if (primaryReferenceHidden) {
            return true;
        }
        Reference[] refs = codeUnit.getOperandReferences(opIndex);
        if (this.underlineChoice == UNDERLINE_CHOICE.Hidden) {
            return this.containsNonPrimary(refs);
        }
        return refs.length > 0;
    }

    private boolean containsNonPrimary(Reference[] refs) {
        for (Reference ref : refs) {
            if (ref.isPrimary()) continue;
            return true;
        }
        return false;
    }

    private ColorStyleAttributes getOpAttributes(CodeUnit cu, int opIndex, Program p) {
        ColorStyleAttributes attributes = this.getRefAttributes(cu, opIndex, p);
        if (attributes == null) {
            attributes = this.scalarAttributes;
        }
        return attributes;
    }

    private ColorStyleAttributes getOpAttributes(Object opObject, Instruction inst, int opIndex) {
        if (opObject instanceof String) {
            return this.getOpAttributes((CodeUnit)inst, opIndex, inst.getProgram());
        }
        if (opObject instanceof Register) {
            return this.registerAttributes;
        }
        if (opObject instanceof Scalar) {
            return this.scalarAttributes;
        }
        if (opObject instanceof Address) {
            return this.addressAttributes;
        }
        if (opObject instanceof Character) {
            return this.separatorAttributes;
        }
        if (opObject instanceof Equate) {
            Equate equate = (Equate)opObject;
            if (equate.isValidUUID()) {
                return this.scalarAttributes;
            }
            return this.badRefAttributes;
        }
        if (opObject instanceof LabelString) {
            LabelString label = (LabelString)opObject;
            LabelString.LabelType labelType = label.getLabelType();
            if (labelType == LabelString.LabelType.VARIABLE) {
                return this.variableRefAttributes;
            }
            return this.getOpAttributes((CodeUnit)inst, opIndex, inst.getProgram());
        }
        return this.separatorAttributes;
    }

    private ColorStyleAttributes getRefAttributes(CodeUnit cu, int opIndex, Program p) {
        Reference[] refs;
        ReferenceManager refMgr = p.getReferenceManager();
        for (Reference element : refs = refMgr.getReferencesFrom(cu.getMinAddress(), opIndex)) {
            ExternalLocation extLoc;
            if (!element.isExternalReference()) continue;
            ExternalManager extMgr = p.getExternalManager();
            String path = extMgr.getExternalLibraryPath((extLoc = ((ExternalReference)element).getExternalLocation()).getLibraryName());
            if (path != null && path.length() > 0) {
                return this.externalRefAttributes;
            }
            return this.badRefAttributes;
        }
        Reference mr = refMgr.getPrimaryReferenceFrom(cu.getMinAddress(), opIndex);
        if (mr != null) {
            return this.getAddressAttributes(cu, mr.getToAddress(), opIndex, p);
        }
        return null;
    }

    private boolean isInvalidEquate(Data data) {
        Program program = data.getProgram();
        if (program != null) {
            Scalar scalar = data.getScalar(0);
            Address address = data.getAddress();
            if (scalar == null || address == null) {
                return false;
            }
            Equate equate = program.getEquateTable().getEquate(address, 0, scalar.getValue());
            if (equate != null && !equate.isValidUUID()) {
                return true;
            }
        }
        return false;
    }

    private ColorStyleAttributes getAddressAttributes(CodeUnit cu, Address destAddr, int opIndex, Program program) {
        ReferenceManager refMgr;
        Reference ref;
        if (destAddr == null) {
            return this.separatorAttributes;
        }
        if (destAddr.isMemoryAddress() && !program.getMemory().contains(destAddr)) {
            return this.badRefAttributes;
        }
        SymbolTable st = program.getSymbolTable();
        Symbol sym = st.getSymbol(ref = (refMgr = program.getReferenceManager()).getReference(cu.getMinAddress(), destAddr, opIndex));
        if (sym != null) {
            this.inspector.setProgram(program);
            ColorStyleAttributes newAttributes = new ColorStyleAttributes(this);
            ColorAndStyle c = this.inspector.getColorAndStyle(sym);
            newAttributes.colorAttribute = c.getColor();
            newAttributes.styleAttribute = c.getStyle();
            return newAttributes;
        }
        return this.addressAttributes;
    }

    private void setOptions(Options options) {
        this.separatorAttributes.colorAttribute = ListingColors.SEPARATOR;
        this.scalarAttributes.colorAttribute = ListingColors.CONSTANT;
        this.variableRefAttributes.colorAttribute = ListingColors.FunctionColors.VARIABLE;
        this.addressAttributes.colorAttribute = ListingColors.ADDRESS;
        this.externalRefAttributes.colorAttribute = ListingColors.EXT_REF_RESOLVED;
        this.badRefAttributes.colorAttribute = ListingColors.REF_BAD;
        this.registerAttributes.colorAttribute = ListingColors.REGISTER;
        this.separatorAttributes.styleAttribute = options.getInt(OptionsGui.SEPARATOR.getStyleOptionName(), -1);
        this.scalarAttributes.styleAttribute = options.getInt(OptionsGui.CONSTANT.getStyleOptionName(), -1);
        this.variableRefAttributes.styleAttribute = options.getInt(OptionsGui.VARIABLE.getStyleOptionName(), -1);
        this.addressAttributes.styleAttribute = options.getInt(OptionsGui.ADDRESS.getStyleOptionName(), -1);
        this.externalRefAttributes.styleAttribute = options.getInt(OptionsGui.EXT_REF_RESOLVED.getStyleOptionName(), -1);
        this.badRefAttributes.styleAttribute = options.getInt(OptionsGui.BAD_REF_ADDR.getStyleOptionName(), -1);
        this.registerAttributes.styleAttribute = options.getInt(OptionsGui.REGISTERS.getStyleOptionName(), -1);
    }

    private class ColorStyleAttributes {
        private Color colorAttribute;
        private int styleAttribute;

        private ColorStyleAttributes(OperandFieldHelper operandFieldHelper) {
        }
    }

    public static enum UNDERLINE_CHOICE {
        Hidden,
        All,
        None;

    }

    static class OperandFieldElement
    extends AbstractTextFieldElement {
        private int operandSubIndex;

        OperandFieldElement(AttributedString as, int operandIndex, int operandSubIndex, int characterOffset) {
            super(as, operandIndex, characterOffset);
            this.operandSubIndex = operandSubIndex;
        }

        int getOperandSubIndex() {
            return this.operandSubIndex;
        }

        int getOperandIndex() {
            return this.row;
        }

        public FieldElement substring(int start, int end) {
            AttributedString as = this.attributedString.substring(start, end);
            if (as == this.attributedString) {
                return this;
            }
            return new OperandFieldElement(as, this.row, this.operandSubIndex, this.column + start);
        }

        public FieldElement replaceAll(char[] targets, char replacement) {
            return new OperandFieldElement(this.attributedString.replaceAll(targets, replacement), this.row, this.operandSubIndex, this.column);
        }
    }
}

