/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.field;

import docking.widgets.fieldpanel.field.AttributedString;
import docking.widgets.fieldpanel.field.FieldElement;
import docking.widgets.fieldpanel.field.TextFieldElement;
import docking.widgets.fieldpanel.support.FieldLocation;
import docking.widgets.fieldpanel.support.FieldUtils;
import generic.theme.GColor;
import ghidra.app.util.ListingHighlightProvider;
import ghidra.app.util.viewer.field.CommentUtils;
import ghidra.app.util.viewer.field.FieldFactory;
import ghidra.app.util.viewer.field.ListingColors;
import ghidra.app.util.viewer.field.ListingField;
import ghidra.app.util.viewer.field.ListingTextField;
import ghidra.app.util.viewer.format.FieldFormatModel;
import ghidra.app.util.viewer.options.OptionsGui;
import ghidra.app.util.viewer.proxy.ProxyObj;
import ghidra.framework.options.Options;
import ghidra.framework.options.ToolOptions;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.FlowOverride;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.InstructionPcodeOverride;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.program.model.pcode.PcodeOverride;
import ghidra.program.model.symbol.FlowType;
import ghidra.program.model.symbol.RefType;
import ghidra.program.util.CommentFieldLocation;
import ghidra.program.util.PostCommentFieldLocation;
import ghidra.program.util.ProgramLocation;
import java.awt.Color;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class PostCommentFieldFactory
extends FieldFactory {
    private static String[] EMPTY_STRING_ARRAY = new String[0];
    public static final String FIELD_NAME = "Post-Comment";
    private static final String GROUP_TITLE = "Format Code";
    private static final String FIELD_GROUP_TITLE = "Post-comments Field";
    public static final String ENABLE_WORD_WRAP_MSG = "Post-comments Field.Enable Word Wrapping";
    public static final String ENABLE_ALWAYS_SHOW_AUTOMATIC_MSG = "Post-comments Field.Always Show the Automatic Comment";
    static final String FLAG_FUNCTION_EXIT_OPTION = "Format Code.Flag Function Exits";
    static final String FLAG_TERMINATOR_OPTION = "Format Code.Flag Jumps and Returns";
    static final String LINES_AFTER_BLOCKS_OPTION = "Format Code.Lines After Basic Blocks";
    static String DEFAULT_FLAG_COMMENT;
    static final String FUN_EXIT_FLAG_LEADER = "********** ";
    static final String FUN_EXIT_FLAG_TAIL = " Exit ********** ";
    private boolean flagJMPsRETs;
    private boolean flagFunctionExits;
    private int nLinesAfterBlocks;
    private boolean isWordWrap;
    private boolean alwaysShowAutomatic;
    private int automaticCommentStyle;

    public PostCommentFieldFactory() {
        super(FIELD_NAME);
    }

    private PostCommentFieldFactory(FieldFormatModel model, ListingHighlightProvider hlProvider, Options displayOptions, Options fieldOptions) {
        super(FIELD_NAME, model, hlProvider, displayOptions, fieldOptions);
        fieldOptions.registerOption(FLAG_FUNCTION_EXIT_OPTION, (Object)false, null, "Toggles the display of a post-comment for a function exit");
        fieldOptions.registerOption(FLAG_TERMINATOR_OPTION, (Object)false, null, "Toggles the display of a jump/return post-comments");
        fieldOptions.registerOption(LINES_AFTER_BLOCKS_OPTION, (Object)0, null, "The number of lines to display after basic blocks");
        this.flagFunctionExits = fieldOptions.getBoolean(FLAG_FUNCTION_EXIT_OPTION, false);
        this.flagJMPsRETs = fieldOptions.getBoolean(FLAG_TERMINATOR_OPTION, false);
        this.nLinesAfterBlocks = fieldOptions.getInt(LINES_AFTER_BLOCKS_OPTION, 0);
        this.automaticCommentStyle = displayOptions.getInt(OptionsGui.COMMENT_AUTO.getStyleOptionName(), -1);
        this.init(fieldOptions);
    }

    @Override
    public ListingField getField(ProxyObj<?> proxy, int varWidth) {
        Data data;
        Object obj = proxy.getObject();
        if (!this.enabled || !(obj instanceof CodeUnit)) {
            return null;
        }
        int x = this.startX + varWidth;
        CodeUnit cu = (CodeUnit)obj;
        if (cu instanceof Data && (data = (Data)cu).getNumComponents() > 0) {
            return null;
        }
        String[] autoComment = this.getAutoPostComment(cu);
        String[] comments = cu.getCommentAsArray(2);
        if (comments != null && comments.length > 0 && cu instanceof Data) {
            return this.getTextField(comments, autoComment, proxy, x, false);
        }
        if (cu instanceof Instruction) {
            Instruction instr = (Instruction)cu;
            if (instr.getDelaySlotDepth() > 0) {
                if (comments != null && comments.length > 0) {
                    return this.getTextField(comments, null, proxy, x, false);
                }
                return null;
            }
            return this.getTextFieldForOptions(instr, comments, autoComment, proxy, x);
        }
        return null;
    }

    private String[] getAutoPostComment(CodeUnit cu) {
        InstructionPcodeOverride pCodeOverride;
        FlowOverride flowOverride;
        if (!(cu instanceof Instruction)) {
            return null;
        }
        Instruction instr = (Instruction)cu;
        LinkedList<Object> comments = new LinkedList<Object>();
        if (instr.isInDelaySlot()) {
            int delaySlotPosition = 0;
            while (instr.isInDelaySlot()) {
                ++delaySlotPosition;
                instr = instr.getPrevious();
            }
            if (instr.getDelaySlotDepth() != delaySlotPosition) {
                return null;
            }
        }
        if (instr.isLengthOverridden() || instr.isFallThroughOverridden()) {
            Address fallThrough = instr.getFallThrough();
            String fallthroughComment = "-- Fallthrough" + (instr.isFallThroughOverridden() ? " Override" : "") + ": " + (fallThrough != null ? fallThrough.toString() : "NO-FALLTHROUGH");
            comments.addFirst(fallthroughComment);
        }
        if (instr.isLengthOverridden()) {
            String lengthOverrideComment = "-- Length Override: " + instr.getLength() + " (actual length is " + instr.getParsedLength() + ")";
            comments.addFirst(lengthOverrideComment);
        }
        if ((flowOverride = instr.getFlowOverride()) != FlowOverride.NONE) {
            String flowOverrideComment = "-- Flow Override: " + String.valueOf(flowOverride) + " (" + instr.getFlowType().getName() + ")";
            comments.addFirst(flowOverrideComment);
        }
        if ((pCodeOverride = new InstructionPcodeOverride(instr)).hasPotentialOverride()) {
            PcodeOp[] pcodeOps = instr.getPcode();
            OverrideCommentData overrideData = null;
            if (pCodeOverride.getPrimaryCallReference() == null && (overrideData = this.getOverrideCommentData(instr, (RefType)RefType.CALL_OVERRIDE_UNCONDITIONAL, pcodeOps, (PcodeOverride)pCodeOverride)) != null) {
                String callOverrideComment = "-- Call Destination Override: " + this.getOverridingCommentDestString(overrideData.getOverridingRef(), instr.getProgram());
                comments.addFirst(callOverrideComment);
            }
            if ((overrideData = this.getOverrideCommentData(instr, (RefType)RefType.JUMP_OVERRIDE_UNCONDITIONAL, pcodeOps, (PcodeOverride)pCodeOverride)) != null) {
                String jumpOverrideComment = "-- Jump Destination Override: " + this.getOverridingCommentDestString(overrideData.getOverridingRef(), instr.getProgram());
                comments.addFirst(jumpOverrideComment);
            }
            if ((overrideData = this.getOverrideCommentData(instr, (RefType)RefType.CALLOTHER_OVERRIDE_CALL, pcodeOps, (PcodeOverride)pCodeOverride)) != null) {
                String outputWarningString;
                String callOtherCallOverrideComment = "-- CALLOTHER(" + overrideData.getOverriddenCallOther() + ") Call Override: " + this.getOverridingCommentDestString(overrideData.getOverridingRef(), instr.getProgram());
                if (overrideData.hasMultipleCallOthers()) {
                    comments.addFirst("-- WARNING: additional CALLOTHER ops present");
                }
                if ((outputWarningString = overrideData.getOutputWarningString()) != null) {
                    comments.addFirst(outputWarningString);
                } else {
                    comments.addFirst(callOtherCallOverrideComment);
                }
            } else {
                overrideData = this.getOverrideCommentData(instr, (RefType)RefType.CALLOTHER_OVERRIDE_JUMP, pcodeOps, (PcodeOverride)pCodeOverride);
                if (overrideData != null) {
                    String outputWarningString;
                    String callOtherJumpOverrideComment = "-- CALLOTHER(" + overrideData.getOverriddenCallOther() + ") Jump Override: " + this.getOverridingCommentDestString(overrideData.getOverridingRef(), instr.getProgram());
                    if (overrideData.hasMultipleCallOthers()) {
                        comments.addFirst("-- WARNING: additional CALLOTHER ops present");
                    }
                    if ((outputWarningString = overrideData.getOutputWarningString()) != null) {
                        comments.addFirst(outputWarningString);
                    } else {
                        comments.addFirst(callOtherJumpOverrideComment);
                    }
                }
            }
        }
        if (comments.size() > 0) {
            return comments.toArray(new String[0]);
        }
        return null;
    }

    private String getOverridingCommentDestString(Address address, Program program) {
        StringBuilder sb = new StringBuilder();
        String symbol = program.getSymbolTable().getPrimarySymbol(address).getName(true);
        if (!StringUtils.isEmpty((CharSequence)symbol)) {
            sb.append(symbol);
            sb.append(" ");
        }
        sb.append("(");
        sb.append(address.toString());
        sb.append(")");
        return sb.toString();
    }

    @Override
    public ProgramLocation getProgramLocation(int row, int col, ListingField bf) {
        Object obj = bf.getProxy().getObject();
        if (!(obj instanceof CodeUnit)) {
            return null;
        }
        CodeUnit cu = (CodeUnit)obj;
        String[] comment = cu.getCommentAsArray(2);
        int[] cpath = null;
        if (cu instanceof Data) {
            cpath = ((Data)cu).getComponentPath();
        }
        return new PostCommentFieldLocation(cu.getProgram(), cu.getMinAddress(), cpath, comment, row, col);
    }

    @Override
    public FieldLocation getFieldLocation(ListingField bf, BigInteger index, int fieldNum, ProgramLocation programLoc) {
        if (!(programLoc instanceof CommentFieldLocation)) {
            return null;
        }
        CommentFieldLocation loc = (CommentFieldLocation)programLoc;
        if (loc.getCommentType() != 2) {
            return null;
        }
        return new FieldLocation(index, fieldNum, loc.getRow(), loc.getCharOffset());
    }

    @Override
    public boolean acceptsType(int category, Class<?> proxyObjectClass) {
        if (!CodeUnit.class.isAssignableFrom(proxyObjectClass)) {
            return false;
        }
        return category == 4 || category == 5;
    }

    @Override
    public FieldFactory newInstance(FieldFormatModel formatModel, ListingHighlightProvider provider, ToolOptions toolOptions, ToolOptions fieldOptions) {
        return new PostCommentFieldFactory(formatModel, provider, (Options)toolOptions, (Options)fieldOptions);
    }

    @Override
    public void fieldOptionsChanged(Options options, String optionName, Object oldValue, Object newValue) {
        if (optionName.equals(FLAG_FUNCTION_EXIT_OPTION)) {
            this.flagFunctionExits = (Boolean)newValue;
            this.model.update();
        } else if (optionName.equals(FLAG_TERMINATOR_OPTION)) {
            this.flagJMPsRETs = (Boolean)newValue;
            this.model.update();
        } else if (optionName.equals(LINES_AFTER_BLOCKS_OPTION)) {
            this.nLinesAfterBlocks = (Integer)newValue;
            if (this.nLinesAfterBlocks < 0) {
                this.nLinesAfterBlocks = 0;
            }
            this.model.update();
        } else if (optionName.equals(ENABLE_WORD_WRAP_MSG)) {
            this.isWordWrap = (Boolean)newValue;
        } else if (optionName.equals(ENABLE_ALWAYS_SHOW_AUTOMATIC_MSG)) {
            this.alwaysShowAutomatic = (Boolean)newValue;
        }
    }

    @Override
    public void displayOptionsChanged(Options options, String optionName, Object oldValue, Object newValue) {
        this.adjustAutomaticCommentDisplayOptions(options, optionName, oldValue, newValue);
        super.displayOptionsChanged(options, optionName, oldValue, newValue);
    }

    private void adjustAutomaticCommentDisplayOptions(Options options, String optionName, Object oldValue, Object newValue) {
        String automaticCommentStyleName = OptionsGui.COMMENT_AUTO.getStyleOptionName();
        if (optionName.equals(automaticCommentStyleName)) {
            this.automaticCommentStyle = options.getInt(automaticCommentStyleName, -1);
        }
    }

    private ListingTextField getTextFieldForOptions(Instruction instr, String[] comments, String[] autoComment, ProxyObj<?> proxy, int xStart) {
        Listing listing = instr.getProgram().getListing();
        Address addr = instr.getMinAddress();
        FlowType flowType = instr.getFlowType();
        GColor color = ListingColors.CommentColors.POST;
        if (comments == null || comments.length == 0) {
            Function function;
            if (this.flagFunctionExits && (function = listing.getFunctionContaining(addr)) != null && this.flagFunctionExits && flowType.isTerminal()) {
                String[] str = new String[]{FUN_EXIT_FLAG_LEADER + function.getName() + FUN_EXIT_FLAG_TAIL};
                return this.getTextField(str, autoComment, proxy, xStart, true);
            }
            if (this.flagJMPsRETs && !instr.hasFallthrough()) {
                String[] str = new String[]{DEFAULT_FLAG_COMMENT};
                return this.getTextField(str, autoComment, proxy, xStart, true);
            }
        }
        if (this.nLinesAfterBlocks > 0 || this.flagJMPsRETs) {
            boolean endOfBlock;
            boolean bl = endOfBlock = !instr.hasFallthrough() || instr.isInDelaySlot();
            if (endOfBlock && this.flagJMPsRETs && (comments == null || comments.length == 0)) {
                comments = new String[]{DEFAULT_FLAG_COMMENT};
            }
            if (!endOfBlock) {
                boolean deferEndOfBlock = false;
                CodeUnit nextCu = this.getNextCodeUnit((CodeUnit)instr);
                if (nextCu instanceof Instruction) {
                    Instruction nextInstr = (Instruction)nextCu;
                    FlowType nextFlowType = nextInstr.getFlowType();
                    boolean bl2 = deferEndOfBlock = !nextInstr.hasFallthrough() || nextFlowType == RefType.CONDITIONAL_JUMP || nextFlowType == RefType.CONDITIONAL_TERMINATOR;
                }
                if (!(deferEndOfBlock || flowType != RefType.CONDITIONAL_JUMP && flowType != RefType.CONDITIONAL_TERMINATOR)) {
                    endOfBlock = true;
                }
            }
            if (endOfBlock) {
                if (comments == null) {
                    comments = EMPTY_STRING_ARRAY;
                }
                if (autoComment == null) {
                    autoComment = EMPTY_STRING_ARRAY;
                }
                int nLinesAutoComment = comments.length == 0 || this.alwaysShowAutomatic ? autoComment.length : 0;
                AttributedString prototypeString = new AttributedString("prototype", (Color)color, this.getMetrics());
                int commentLineCount = comments.length + this.nLinesAfterBlocks + nLinesAutoComment;
                ArrayList<FieldElement> elements = new ArrayList<FieldElement>(commentLineCount);
                if (commentLineCount > 0) {
                    int i;
                    for (i = 0; i < nLinesAutoComment; ++i) {
                        AttributedString as = new AttributedString(autoComment[i], (Color)ListingColors.CommentColors.AUTO, this.getMetrics(this.automaticCommentStyle), false, null);
                        elements.add((FieldElement)new TextFieldElement(as, i, 0));
                    }
                    for (i = 0; i < comments.length; ++i) {
                        int index = nLinesAutoComment + i;
                        elements.add(CommentUtils.parseTextForAnnotations(comments[i], instr.getProgram(), prototypeString, index));
                    }
                    for (i = commentLineCount - this.nLinesAfterBlocks; i < commentLineCount; ++i) {
                        AttributedString as = new AttributedString("", (Color)color, this.getMetrics());
                        elements.add((FieldElement)new TextFieldElement(as, i, 0));
                    }
                    return ListingTextField.createMultilineTextField(this, proxy, elements, xStart, this.width, this.hlProvider);
                }
            }
        }
        return this.getTextField(comments, autoComment, proxy, xStart, false);
    }

    private ListingTextField getTextField(String[] comments, String[] autoComment, ProxyObj<?> proxy, int xStart, boolean useLinesAfterBlock) {
        int nLinesAutoComment;
        if (comments == null) {
            comments = EMPTY_STRING_ARRAY;
        }
        if (autoComment == null) {
            autoComment = EMPTY_STRING_ARRAY;
        }
        int n = nLinesAutoComment = comments.length == 0 && !useLinesAfterBlock || this.alwaysShowAutomatic ? autoComment.length : 0;
        if (!useLinesAfterBlock && comments.length == 0 && nLinesAutoComment == 0) {
            return null;
        }
        CodeUnit cu = (CodeUnit)proxy.getObject();
        Program program = cu.getProgram();
        AttributedString prototypeString = new AttributedString("prototype", (Color)ListingColors.CommentColors.POST, this.getMetrics());
        List<FieldElement> fields = new ArrayList<Object>();
        for (int i = 0; i < nLinesAutoComment; ++i) {
            AttributedString as = new AttributedString(autoComment[i], (Color)ListingColors.CommentColors.AUTO, this.getMetrics(this.automaticCommentStyle), false, null);
            fields.add((FieldElement)new TextFieldElement(as, i, 0));
        }
        for (String comment : comments) {
            fields.add(CommentUtils.parseTextForAnnotations(comment, program, prototypeString, fields.size()));
        }
        if (this.isWordWrap) {
            fields = FieldUtils.wrap(fields, (int)this.width);
        }
        if (useLinesAfterBlock) {
            for (int i = 0; i < this.nLinesAfterBlocks; ++i) {
                AttributedString as = new AttributedString("", (Color)ListingColors.CommentColors.POST, this.getMetrics());
                fields.add((FieldElement)new TextFieldElement(as, fields.size(), 0));
            }
        }
        return ListingTextField.createMultilineTextField(this, proxy, fields, xStart, this.width, this.hlProvider);
    }

    private void init(Options options) {
        options.registerOption(ENABLE_WORD_WRAP_MSG, (Object)false, null, "Enables word wrapping.  When on, each line of text is wrapped as needed to fit within the current width.  When off, comments are displayed as entered by the user.  Lines that are too long for the field are truncated.");
        options.registerOption(FLAG_FUNCTION_EXIT_OPTION, (Object)false, null, "Toggle for whether a post comment should be displayed at the exit of a function.");
        options.registerOption(FLAG_TERMINATOR_OPTION, (Object)false, null, "Toggle for whether a post comment should be displayed at a jump or a return instruction.");
        options.registerOption(LINES_AFTER_BLOCKS_OPTION, (Object)0, null, "Number of lines to display in the post comment after a code block.");
        options.registerOption(ENABLE_ALWAYS_SHOW_AUTOMATIC_MSG, (Object)true, null, "Toggles the display of the automatic post-comment");
        this.isWordWrap = options.getBoolean(ENABLE_WORD_WRAP_MSG, false);
        this.alwaysShowAutomatic = options.getBoolean(ENABLE_ALWAYS_SHOW_AUTOMATIC_MSG, true);
        if (DEFAULT_FLAG_COMMENT != null) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < 80; ++i) {
            sb.append("-");
        }
        DEFAULT_FLAG_COMMENT = sb.toString();
    }

    private CodeUnit getNextCodeUnit(CodeUnit cu) {
        CodeUnit next = null;
        try {
            Address nextAddr = cu.getMaxAddress().addNoWrap(1L);
            if (nextAddr != null) {
                next = cu.getProgram().getListing().getCodeUnitAt(nextAddr);
            }
            return next;
        }
        catch (AddressOverflowException addressOverflowException) {
            return null;
        }
    }

    private OverrideCommentData getOverrideCommentData(Instruction inst, RefType type, PcodeOp[] pcodeOps, PcodeOverride pcodeOverride) {
        Address ref;
        HashSet<Integer> ops = new HashSet<Integer>();
        if (type.equals((Object)RefType.CALL_OVERRIDE_UNCONDITIONAL)) {
            ops.add(7);
            ops.add(8);
        } else if (type.equals((Object)RefType.JUMP_OVERRIDE_UNCONDITIONAL)) {
            ops.add(4);
            ops.add(5);
        } else if (type.equals((Object)RefType.CALLOTHER_OVERRIDE_CALL) || type.equals((Object)RefType.CALLOTHER_OVERRIDE_JUMP)) {
            ops.add(9);
        } else {
            return null;
        }
        boolean hasAppropriatePcodeOp = false;
        boolean hasMultipleCallOthers = false;
        String callOtherName = null;
        String outputWarningString = null;
        for (PcodeOp op : pcodeOps) {
            if (!ops.contains(op.getOpcode())) continue;
            hasAppropriatePcodeOp = true;
            if (op.getOpcode() != 9) continue;
            if (callOtherName == null) {
                callOtherName = inst.getProgram().getLanguage().getUserDefinedOpName((int)op.getInput(0).getOffset());
                if (op.getOutput() == null) continue;
                outputWarningString = "WARNING: Output of " + callOtherName + " destroyed by override!";
                continue;
            }
            hasMultipleCallOthers = true;
        }
        if (!hasAppropriatePcodeOp) {
            return null;
        }
        if (type.equals((Object)RefType.CALL_OVERRIDE_UNCONDITIONAL)) {
            ref = pcodeOverride.getOverridingReference(type);
            if (ref != null) {
                return new OverrideCommentData(this, ref, null, false, outputWarningString);
            }
            return null;
        }
        if (type.equals((Object)RefType.JUMP_OVERRIDE_UNCONDITIONAL)) {
            ref = pcodeOverride.getOverridingReference(type);
            if (ref != null) {
                return new OverrideCommentData(this, ref, null, false, outputWarningString);
            }
            return null;
        }
        if (type.equals((Object)RefType.CALLOTHER_OVERRIDE_CALL)) {
            ref = pcodeOverride.getOverridingReference(type);
            if (ref != null) {
                return new OverrideCommentData(this, ref, callOtherName, hasMultipleCallOthers, outputWarningString);
            }
            return null;
        }
        ref = pcodeOverride.getOverridingReference((RefType)RefType.CALLOTHER_OVERRIDE_CALL);
        if (ref != null) {
            return null;
        }
        ref = pcodeOverride.getOverridingReference((RefType)RefType.CALLOTHER_OVERRIDE_JUMP);
        if (ref == null) {
            return null;
        }
        return new OverrideCommentData(this, ref, callOtherName, hasMultipleCallOthers, outputWarningString);
    }

    private class OverrideCommentData {
        private Address overridingRef;
        private String overriddenCallOther;
        private boolean hasMultipleCallOthers;
        private String outputWarningString = null;

        OverrideCommentData(PostCommentFieldFactory postCommentFieldFactory, Address overridingRef, String overriddenCallOther, boolean multipleCallOthers, String outputWarningString) {
            this.overridingRef = overridingRef;
            this.overriddenCallOther = overriddenCallOther;
            this.hasMultipleCallOthers = multipleCallOthers;
            this.outputWarningString = outputWarningString;
        }

        Address getOverridingRef() {
            return this.overridingRef;
        }

        String getOverriddenCallOther() {
            return this.overriddenCallOther;
        }

        boolean hasMultipleCallOthers() {
            return this.hasMultipleCallOthers;
        }

        String getOutputWarningString() {
            return this.outputWarningString;
        }
    }
}

