/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.format;

import docking.widgets.fieldpanel.support.Highlight;
import ghidra.app.util.ListingHighlightProvider;
import ghidra.app.util.template.TemplateSimplifier;
import ghidra.app.util.viewer.field.ArrayElementPropertyEditor;
import ghidra.app.util.viewer.field.ArrayElementWrappedOption;
import ghidra.app.util.viewer.field.DummyFieldFactory;
import ghidra.app.util.viewer.field.FieldFactory;
import ghidra.app.util.viewer.field.ListingField;
import ghidra.app.util.viewer.field.SpacerFieldFactory;
import ghidra.app.util.viewer.field.SubDataFieldFactory;
import ghidra.app.util.viewer.format.FieldFormatModel;
import ghidra.app.util.viewer.format.FormatModelListener;
import ghidra.framework.options.CustomOption;
import ghidra.framework.options.OptionType;
import ghidra.framework.options.Options;
import ghidra.framework.options.OptionsChangeListener;
import ghidra.framework.options.SaveState;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.AbstractIntegerDataType;
import ghidra.program.model.data.Array;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DefaultDataType;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Variable;
import ghidra.util.classfinder.ClassExclusionFilter;
import ghidra.util.classfinder.ClassFilter;
import ghidra.util.classfinder.ClassSearcher;
import ghidra.util.datastruct.WeakDataStructureFactory;
import ghidra.util.datastruct.WeakSet;
import ghidra.util.exception.AssertException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jdom.Content;
import org.jdom.Element;

public class FormatManager
implements OptionsChangeListener {
    public static final String ARRAY_OPTIONS_GROUP = "Array Options";
    private static final String HIGHLIGHT_GROUP = "Cursor Text Highlight";
    public static final String HIGHLIGHT_COLOR_NAME = "Cursor Text Highlight.Highlight Color";
    public static final String HIGHLIGHT_ALT_COLOR_NAME = "Cursor Text Highlight.Alternate Highlight Color";
    public static final String ARRAY_DISPLAY_OPTIONS = "Array Options.Array Display Options";
    public static final String ARRAY_DISPLAY_DESCRIPTION = "Adjusts the Array Field display";
    private static final int NUM_MODELS = 7;
    private static final String[] NAMES = new String[]{"Address Break", "Plate", "Function", "Variable", "Instruction/Data", "Open Data", "Array"};
    private static final Class<?>[] PROXY_CLASSES = new Class[]{Address.class, CodeUnit.class, Function.class, Variable.class, CodeUnit.class, CodeUnit.class, CodeUnit.class};
    private FieldFormatModel[] models = new FieldFormatModel[7];
    private WeakSet<FormatModelListener> formatListeners = WeakDataStructureFactory.createSingleThreadAccessWeakSet();
    private int maxNumRows = 0;
    private FieldFactory[] factorys;
    private ToolOptions fieldOptions;
    private ToolOptions displayOptions;
    private boolean initialized = false;
    private MultipleHighlighterProvider highlightProvider;
    private ServiceProvider serviceProvider;
    private int arrayValuesPerLine = 1;
    private boolean groupArrayElements = true;
    TemplateSimplifier templateSimplifier;

    public FormatManager(ToolOptions displayOptions, ToolOptions fieldOptions) {
        this.fieldOptions = fieldOptions;
        this.displayOptions = displayOptions;
        this.templateSimplifier = new TemplateSimplifier(fieldOptions);
        this.highlightProvider = new MultipleHighlighterProvider(this);
        this.getFactorys();
        for (int i = 0; i < 7; ++i) {
            this.models[i] = new FieldFormatModel(this, NAMES[i], i, PROXY_CLASSES[i], this.factorys);
            this.models[i].restoreFromXml(this.getDefaultModel(i));
        }
        this.initialized = true;
        this.setRowIDs();
        displayOptions.addOptionsChangeListener((OptionsChangeListener)this);
        fieldOptions.addOptionsChangeListener((OptionsChangeListener)this);
        this.getArrayDisplayOptions((Options)fieldOptions);
    }

    private void getArrayDisplayOptions(Options options) {
        options.registerOption(ARRAY_DISPLAY_OPTIONS, OptionType.CUSTOM_TYPE, (Object)new ArrayElementWrappedOption(), null, ARRAY_DISPLAY_DESCRIPTION, () -> new ArrayElementPropertyEditor());
        CustomOption option = options.getCustomOption(ARRAY_DISPLAY_OPTIONS, null);
        if (option instanceof ArrayElementWrappedOption) {
            ArrayElementWrappedOption arrayOption = (ArrayElementWrappedOption)option;
            this.arrayValuesPerLine = arrayOption.getArrayElementsPerLine();
            this.groupArrayElements = arrayOption.showMultipleArrayElementPerLine();
        }
    }

    public FormatManager createClone() {
        FormatManager newManager = new FormatManager(this.displayOptions, this.fieldOptions);
        SaveState saveState = new SaveState();
        this.saveState(saveState);
        newManager.readState(saveState);
        return newManager;
    }

    public void dispose() {
        this.fieldOptions.removeOptionsChangeListener((OptionsChangeListener)this);
        this.displayOptions.removeOptionsChangeListener((OptionsChangeListener)this);
    }

    public void setServiceProvider(ServiceProvider provider) {
        this.serviceProvider = provider;
        this.notifyServicesChanged();
    }

    private void notifyServicesChanged() {
        for (int i = 0; i < 7; ++i) {
            this.models[i].servicesChanged();
        }
    }

    private void getFactorys() {
        ClassExclusionFilter filter = new ClassExclusionFilter(new Class[]{DummyFieldFactory.class, SpacerFieldFactory.class, SubDataFieldFactory.class});
        List instances = ClassSearcher.getInstances(FieldFactory.class, (ClassFilter)filter);
        ArrayList<FieldFactory> list = new ArrayList<FieldFactory>();
        for (FieldFactory fieldFactory : instances) {
            if (fieldFactory instanceof SpacerFieldFactory) continue;
            list.add(fieldFactory);
        }
        this.factorys = new FieldFactory[list.size()];
        list.toArray(this.factorys);
    }

    public void addFormatModelListener(FormatModelListener listener) {
        if (listener != null) {
            this.formatListeners.add((Object)listener);
        }
    }

    public void removeFormatModleListener(FormatModelListener listener) {
        this.formatListeners.remove((Object)listener);
    }

    public int getNumModels() {
        return 7;
    }

    public FieldFormatModel getModel(int index) {
        return this.models[index];
    }

    public FieldFormatModel getDividerModel() {
        return this.models[0];
    }

    public FieldFormatModel getPlateFormat() {
        return this.models[1];
    }

    public FieldFormatModel getFunctionFormat() {
        return this.models[2];
    }

    public FieldFormatModel getFunctionVarFormat() {
        return this.models[3];
    }

    public FieldFormatModel getCodeUnitFormat() {
        return this.models[4];
    }

    public FieldFormatModel getOpenDataFormat(Data data) {
        if (this.groupArrayElements && this.isPrimitiveArrayElement(data)) {
            if (data.getComponentIndex() % this.arrayValuesPerLine == 0) {
                return this.models[6];
            }
            return null;
        }
        return this.models[5];
    }

    private boolean isPrimitiveArrayElement(Data data) {
        Data parent = data.getParent();
        if (parent == null) {
            return false;
        }
        if (!(parent.getDataType() instanceof Array)) {
            return false;
        }
        DataType type = data.getBaseDataType();
        return type.getLength() > 0 && type instanceof AbstractIntegerDataType || type instanceof DefaultDataType;
    }

    public void update() {
        this.modelChanged(null);
    }

    public ToolOptions getDisplayOptions() {
        return this.displayOptions;
    }

    public ToolOptions getFieldOptions() {
        return this.fieldOptions;
    }

    public TemplateSimplifier getTemplateSimplifier() {
        return this.templateSimplifier;
    }

    public void modelChanged(FieldFormatModel model) {
        if (!this.initialized) {
            return;
        }
        for (FormatModelListener l : this.formatListeners) {
            l.formatModelChanged(model);
        }
        this.setRowIDs();
    }

    public int getMaxWidth() {
        int maxWidth = 0;
        for (FieldFormatModel element : this.models) {
            maxWidth = Math.max(maxWidth, element.getWidth());
        }
        return maxWidth;
    }

    public int getMaxRowCount() {
        int maxRowCount = 0;
        for (FieldFormatModel element : this.models) {
            maxRowCount = Math.max(maxRowCount, element.getNumRows());
        }
        return maxRowCount;
    }

    private Element getDefaultModel(int modelID) {
        switch (modelID) {
            case 0: {
                return this.getDefaultDividerFormat();
            }
            case 1: {
                return this.getDefaultPlateFormat();
            }
            case 2: {
                return this.getDefaultFunctionFormat();
            }
            case 3: {
                return this.getDefaultVariableFormat();
            }
            case 4: {
                return this.getDefaultCodeFormat();
            }
            case 5: {
                return this.getDefaultSubDataFormat();
            }
            case 6: {
                return this.getDefaultArrayFormat();
            }
        }
        return null;
    }

    private Element getDefaultDividerFormat() {
        Element root = new Element("FORMAT");
        Element rowElem = new Element("ROW");
        Element colElem = new Element("FIELD");
        colElem.setAttribute("NAME", "Separator");
        colElem.setAttribute("WIDTH", "80");
        colElem.setAttribute("ENABLED", "true");
        rowElem.addContent((Content)colElem);
        root.addContent((Content)rowElem);
        return root;
    }

    private Element getDefaultPlateFormat() {
        Element root = new Element("FORMAT");
        Element rowElem = new Element("ROW");
        Element colElem = new Element("FIELD");
        colElem.setAttribute("WIDTH", "200");
        colElem.setAttribute("ENABLED", "true");
        rowElem.addContent((Content)colElem);
        colElem = new Element("FIELD");
        colElem.setAttribute("NAME", "Memory Block Start");
        colElem.setAttribute("WIDTH", "440");
        colElem.setAttribute("ENABLED", "true");
        rowElem.addContent((Content)colElem);
        root.addContent((Content)rowElem);
        rowElem = new Element("ROW");
        colElem = new Element("FIELD");
        colElem.setAttribute("WIDTH", "200");
        colElem.setAttribute("ENABLED", "true");
        rowElem.addContent((Content)colElem);
        colElem = new Element("FIELD");
        colElem.setAttribute("NAME", "Plate Comment");
        colElem.setAttribute("WIDTH", "440");
        colElem.setAttribute("ENABLED", "true");
        rowElem.addContent((Content)colElem);
        root.addContent((Content)rowElem);
        return root;
    }

    private Element getDefaultFunctionFormat() {
        Element root = new Element("FORMAT");
        Element rowElem = new Element("ROW");
        Element colElem = new Element("FIELD");
        colElem.setAttribute("WIDTH", "200");
        colElem.setAttribute("ENABLED", "true");
        rowElem.addContent((Content)colElem);
        colElem = new Element("FIELD");
        colElem.setAttribute("NAME", "Function Signature");
        colElem.setAttribute("WIDTH", "410");
        colElem.setAttribute("ENABLED", "true");
        rowElem.addContent((Content)colElem);
        colElem = new Element("FIELD");
        colElem.setAttribute("NAME", "Function Repeatable Comment");
        colElem.setAttribute("WIDTH", "300");
        colElem.setAttribute("ENABLED", "true");
        rowElem.addContent((Content)colElem);
        root.addContent((Content)rowElem);
        rowElem = new Element("ROW");
        colElem = new Element("FIELD");
        colElem.setAttribute("WIDTH", "220");
        colElem.setAttribute("ENABLED", "true");
        rowElem.addContent((Content)colElem);
        colElem = new Element("FIELD");
        colElem.setAttribute("NAME", "Thunked-Function");
        colElem.setAttribute("WIDTH", "300");
        colElem.setAttribute("ENABLED", "true");
        rowElem.addContent((Content)colElem);
        root.addContent((Content)rowElem);
        rowElem = new Element("ROW");
        colElem = new Element("FIELD");
        colElem.setAttribute("WIDTH", "220");
        colElem.setAttribute("ENABLED", "true");
        rowElem.addContent((Content)colElem);
        colElem = new Element("FIELD");
        colElem.setAttribute("NAME", "Function Call-Fixup");
        colElem.setAttribute("WIDTH", "300");
        colElem.setAttribute("ENABLED", "true");
        rowElem.addContent((Content)colElem);
        root.addContent((Content)rowElem);
        rowElem = new Element("ROW");
        colElem = new Element("FIELD");
        colElem.setAttribute("WIDTH", "220");
        colElem.setAttribute("ENABLED", "true");
        rowElem.addContent((Content)colElem);
        colElem = new Element("FIELD");
        colElem.setAttribute("NAME", "Function Tags");
        colElem.setAttribute("WIDTH", "300");
        colElem.setAttribute("ENABLED", "true");
        rowElem.addContent((Content)colElem);
        root.addContent((Content)rowElem);
        rowElem = new Element("ROW");
        colElem = new Element("FIELD");
        colElem.setAttribute("WIDTH", "220");
        colElem.setAttribute("ENABLED", "true");
        rowElem.addContent((Content)colElem);
        colElem = new Element("FIELD");
        colElem.setAttribute("NAME", "Register");
        colElem.setAttribute("WIDTH", "300");
        colElem.setAttribute("ENABLED", "true");
        rowElem.addContent((Content)colElem);
        root.addContent((Content)rowElem);
        return root;
    }

    private Element getDefaultVariableFormat() {
        Element root = new Element("FORMAT");
        Element rowElem = new Element("ROW");
        Element colElem = new Element("FIELD");
        colElem.setAttribute("WIDTH", "90");
        colElem.setAttribute("ENABLED", "true");
        rowElem.addContent((Content)colElem);
        colElem = new Element("FIELD");
        colElem.setAttribute("NAME", "Variable Type");
        colElem.setAttribute("WIDTH", "110");
        colElem.setAttribute("ENABLED", "true");
        rowElem.addContent((Content)colElem);
        colElem = new Element("FIELD");
        colElem.setAttribute("NAME", "Variable Location");
        colElem.setAttribute("WIDTH", "120");
        colElem.setAttribute("ENABLED", "true");
        rowElem.addContent((Content)colElem);
        colElem = new Element("FIELD");
        colElem.setAttribute("NAME", "Variable Name");
        colElem.setAttribute("WIDTH", "280");
        colElem.setAttribute("ENABLED", "true");
        rowElem.addContent((Content)colElem);
        colElem = new Element("FIELD");
        colElem.setAttribute("NAME", "Variable XRef Header");
        colElem.setAttribute("WIDTH", "90");
        colElem.setAttribute("ENABLED", "true");
        rowElem.addContent((Content)colElem);
        colElem = new Element("FIELD");
        colElem.setAttribute("NAME", "Variable XRef");
        colElem.setAttribute("WIDTH", "130");
        colElem.setAttribute("ENABLED", "true");
        rowElem.addContent((Content)colElem);
        colElem = new Element("FIELD");
        colElem.setAttribute("NAME", "Variable Comment");
        colElem.setAttribute("WIDTH", "110");
        colElem.setAttribute("ENABLED", "true");
        rowElem.addContent((Content)colElem);
        root.addContent((Content)rowElem);
        return root;
    }

    private Element getDefaultCodeFormat() {
        Element root = new Element("FORMAT");
        Element rowElem = new Element("ROW");
        Element colElem = new Element("FIELD");
        colElem.setAttribute("WIDTH", "90");
        colElem.setAttribute("ENABLED", "true");
        rowElem.addContent((Content)colElem);
        colElem = new Element("FIELD");
        colElem.setAttribute("NAME", "Register Transition");
        colElem.setAttribute("WIDTH", "300");
        colElem.setAttribute("ENABLED", "true");
        rowElem.addContent((Content)colElem);
        root.addContent((Content)rowElem);
        rowElem = new Element("ROW");
        colElem = new Element("FIELD");
        colElem.setAttribute("WIDTH", "200");
        colElem.setAttribute("ENABLED", "true");
        rowElem.addContent((Content)colElem);
        colElem = new Element("FIELD");
        colElem.setAttribute("NAME", "Pre-Comment");
        colElem.setAttribute("WIDTH", "440");
        colElem.setAttribute("ENABLED", "true");
        rowElem.addContent((Content)colElem);
        root.addContent((Content)rowElem);
        rowElem = new Element("ROW");
        colElem = new Element("FIELD");
        colElem.setAttribute("WIDTH", "188");
        colElem.setAttribute("ENABLED", "true");
        rowElem.addContent((Content)colElem);
        colElem = new Element("FIELD");
        colElem.setAttribute("NAME", "Label");
        colElem.setAttribute("WIDTH", "350");
        colElem.setAttribute("ENABLED", "true");
        rowElem.addContent((Content)colElem);
        colElem = new Element("FIELD");
        colElem.setAttribute("NAME", "XRef Header");
        colElem.setAttribute("WIDTH", "90");
        colElem.setAttribute("ENABLED", "true");
        rowElem.addContent((Content)colElem);
        colElem = new Element("FIELD");
        colElem.setAttribute("NAME", "XRef");
        colElem.setAttribute("WIDTH", "240");
        colElem.setAttribute("ENABLED", "true");
        rowElem.addContent((Content)colElem);
        root.addContent((Content)rowElem);
        rowElem = new Element("ROW");
        colElem = new Element("FIELD");
        colElem.setAttribute("NAME", "+");
        colElem.setAttribute("WIDTH", "20");
        colElem.setAttribute("ENABLED", "true");
        rowElem.addContent((Content)colElem);
        colElem = new Element("FIELD");
        colElem.setAttribute("NAME", "Address");
        colElem.setAttribute("WIDTH", "100");
        colElem.setAttribute("ENABLED", "true");
        rowElem.addContent((Content)colElem);
        colElem = new Element("FIELD");
        colElem.setAttribute("NAME", "Bytes");
        colElem.setAttribute("WIDTH", "80");
        colElem.setAttribute("ENABLED", "true");
        rowElem.addContent((Content)colElem);
        colElem = new Element("FIELD");
        colElem.setAttribute("WIDTH", "10");
        colElem.setAttribute("ENABLED", "true");
        rowElem.addContent((Content)colElem);
        colElem = new Element("FIELD");
        colElem.setAttribute("NAME", "Parallel ||");
        colElem.setAttribute("WIDTH", "20");
        colElem.setAttribute("ENABLED", "true");
        rowElem.addContent((Content)colElem);
        colElem = new Element("FIELD");
        colElem.setAttribute("NAME", "Mnemonic");
        colElem.setAttribute("WIDTH", "70");
        colElem.setAttribute("ENABLED", "true");
        rowElem.addContent((Content)colElem);
        colElem = new Element("FIELD");
        colElem.setAttribute("WIDTH", "10");
        colElem.setAttribute("ENABLED", "true");
        rowElem.addContent((Content)colElem);
        colElem = new Element("FIELD");
        colElem.setAttribute("NAME", "Operands");
        colElem.setAttribute("WIDTH", "340");
        colElem.setAttribute("ENABLED", "true");
        rowElem.addContent((Content)colElem);
        colElem = new Element("FIELD");
        colElem.setAttribute("NAME", "EOL Comment");
        colElem.setAttribute("WIDTH", "240");
        colElem.setAttribute("ENABLED", "true");
        rowElem.addContent((Content)colElem);
        root.addContent((Content)rowElem);
        rowElem = new Element("ROW");
        colElem = new Element("FIELD");
        colElem.setAttribute("WIDTH", "380");
        colElem.setAttribute("ENABLED", "true");
        rowElem.addContent((Content)colElem);
        colElem = new Element("FIELD");
        colElem.setAttribute("NAME", "PCode");
        colElem.setAttribute("WIDTH", "400");
        colElem.setAttribute("ENABLED", "false");
        rowElem.addContent((Content)colElem);
        root.addContent((Content)rowElem);
        rowElem = new Element("ROW");
        colElem = new Element("FIELD");
        colElem.setAttribute("WIDTH", "200");
        colElem.setAttribute("ENABLED", "true");
        rowElem.addContent((Content)colElem);
        colElem = new Element("FIELD");
        colElem.setAttribute("NAME", "Post-Comment");
        colElem.setAttribute("WIDTH", "440");
        colElem.setAttribute("ENABLED", "true");
        rowElem.addContent((Content)colElem);
        root.addContent((Content)rowElem);
        rowElem = new Element("ROW");
        colElem = new Element("FIELD");
        colElem.setAttribute("NAME", "Space");
        colElem.setAttribute("WIDTH", "640");
        colElem.setAttribute("ENABLED", "true");
        rowElem.addContent((Content)colElem);
        root.addContent((Content)rowElem);
        return root;
    }

    private Element getDefaultSubDataFormat() {
        Element root = new Element("FORMAT");
        Element rowElem = new Element("ROW");
        Element colElem = new Element("FIELD");
        colElem.setAttribute("NAME", "+");
        colElem.setAttribute("WIDTH", "20");
        colElem.setAttribute("ENABLED", "true");
        rowElem.addContent((Content)colElem);
        colElem = new Element("FIELD");
        colElem.setAttribute("NAME", "Address");
        colElem.setAttribute("WIDTH", "100");
        colElem.setAttribute("ENABLED", "true");
        rowElem.addContent((Content)colElem);
        colElem = new Element("FIELD");
        colElem.setAttribute("NAME", "Bytes");
        colElem.setAttribute("WIDTH", "110");
        colElem.setAttribute("ENABLED", "true");
        rowElem.addContent((Content)colElem);
        colElem = new Element("FIELD");
        colElem.setAttribute("NAME", "Mnemonic");
        colElem.setAttribute("WIDTH", "70");
        colElem.setAttribute("ENABLED", "true");
        rowElem.addContent((Content)colElem);
        colElem = new Element("FIELD");
        colElem.setAttribute("NAME", "Operands");
        colElem.setAttribute("WIDTH", "170");
        colElem.setAttribute("ENABLED", "true");
        rowElem.addContent((Content)colElem);
        colElem = new Element("FIELD");
        colElem.setAttribute("NAME", "Field Name");
        colElem.setAttribute("WIDTH", "100");
        colElem.setAttribute("ENABLED", "true");
        rowElem.addContent((Content)colElem);
        colElem = new Element("FIELD");
        colElem.setAttribute("NAME", "EOL Comment");
        colElem.setAttribute("WIDTH", "140");
        colElem.setAttribute("ENABLED", "true");
        rowElem.addContent((Content)colElem);
        colElem = new Element("FIELD");
        colElem.setAttribute("NAME", "XRef Header");
        colElem.setAttribute("WIDTH", "90");
        colElem.setAttribute("ENABLED", "true");
        rowElem.addContent((Content)colElem);
        colElem = new Element("FIELD");
        colElem.setAttribute("NAME", "XRef");
        colElem.setAttribute("WIDTH", "240");
        colElem.setAttribute("ENABLED", "true");
        rowElem.addContent((Content)colElem);
        root.addContent((Content)rowElem);
        return root;
    }

    private Element getDefaultArrayFormat() {
        Element root = new Element("FORMAT");
        Element rowElem = new Element("ROW");
        Element colElem = new Element("FIELD");
        colElem.setAttribute("NAME", "+");
        colElem.setAttribute("WIDTH", "20");
        colElem.setAttribute("ENABLED", "true");
        rowElem.addContent((Content)colElem);
        colElem = new Element("FIELD");
        colElem.setAttribute("NAME", "Address");
        colElem.setAttribute("WIDTH", "100");
        colElem.setAttribute("ENABLED", "true");
        rowElem.addContent((Content)colElem);
        colElem = new Element("FIELD");
        colElem.setAttribute("NAME", "Field Name");
        colElem.setAttribute("WIDTH", "100");
        colElem.setAttribute("ENABLED", "true");
        rowElem.addContent((Content)colElem);
        colElem = new Element("FIELD");
        colElem.setAttribute("NAME", "Array Values");
        colElem.setAttribute("WIDTH", "600");
        colElem.setAttribute("ENABLED", "true");
        rowElem.addContent((Content)colElem);
        root.addContent((Content)rowElem);
        return root;
    }

    private void setRowIDs() {
        int baseRowID = 0;
        for (FieldFormatModel element : this.models) {
            element.setBaseRowID(baseRowID);
            baseRowID += element.getNumRows();
        }
        this.maxNumRows = baseRowID;
    }

    public int getMaxNumRows() {
        return this.maxNumRows;
    }

    public void setDefaultFormat(int modelID) {
        if (modelID < 7) {
            this.models[modelID].restoreFromXml(this.getDefaultModel(modelID));
        }
    }

    public void setDefaultFormats() {
        for (int i = 0; i < 7; ++i) {
            this.models[i].restoreFromXml(this.getDefaultModel(i));
        }
    }

    public void addHighlightProvider(ListingHighlightProvider provider) {
        if (provider instanceof MultipleHighlighterProvider) {
            throw new AssertException("Cannot set FormatManager's internal highlight provider on another FormatManager!");
        }
        this.highlightProvider.addHighlightProvider(provider);
    }

    public void removeHighlightProvider(ListingHighlightProvider provider) {
        this.highlightProvider.removeHighlightProvider(provider);
    }

    public List<ListingHighlightProvider> getHighlightProviders() {
        return this.highlightProvider.getHighlightProviders();
    }

    public ListingHighlightProvider getFormatHighlightProvider() {
        return this.highlightProvider;
    }

    public void optionsChanged(ToolOptions options, String name, Object oldValue, Object newValue) {
        if (options == this.displayOptions) {
            for (int i = 0; i < 7; ++i) {
                this.models[i].displayOptionsChanged((Options)options, name, oldValue, newValue);
            }
        } else if (options == this.fieldOptions) {
            this.templateSimplifier.fieldOptionsChanged((Options)options, name, oldValue, newValue);
            for (int i = 0; i < 7; ++i) {
                this.models[i].fieldOptionsChanged((Options)options, name, oldValue, newValue);
            }
            this.getArrayDisplayOptions((Options)options);
        }
        this.modelChanged(null);
    }

    public void saveState(SaveState saveState) {
        for (int i = 0; i < 7; ++i) {
            saveState.putXmlElement(this.models[i].getName(), this.models[i].saveToXml());
        }
    }

    public void readState(SaveState saveState) {
        this.initialized = false;
        for (int i = 0; i < 7; ++i) {
            if (saveState.hasValue(this.models[i].getName())) {
                this.models[i].restoreFromXml(saveState.getXmlElement(this.models[i].getName()));
                continue;
            }
            this.models[i].restoreFromXml(this.getDefaultModel(i));
        }
        this.initialized = true;
        this.modelChanged(null);
    }

    public ServiceProvider getServiceProvider() {
        return this.serviceProvider;
    }

    private class MultipleHighlighterProvider
    implements ListingHighlightProvider {
        private List<ListingHighlightProvider> highlightProviders = new CopyOnWriteArrayList<ListingHighlightProvider>();

        private MultipleHighlighterProvider(FormatManager formatManager) {
        }

        @Override
        public Highlight[] createHighlights(String text, ListingField field, int cursorTextOffset) {
            ArrayList<Highlight> list = new ArrayList<Highlight>();
            int size = this.highlightProviders.size();
            for (int i = size - 1; i >= 0; --i) {
                Highlight[] highlights;
                ListingHighlightProvider provider = this.highlightProviders.get(i);
                for (Highlight highlight : highlights = provider.createHighlights(text, field, cursorTextOffset)) {
                    list.add(highlight);
                }
            }
            return list.toArray(new Highlight[list.size()]);
        }

        List<ListingHighlightProvider> getHighlightProviders() {
            return new ArrayList<ListingHighlightProvider>(this.highlightProviders);
        }

        void addHighlightProvider(ListingHighlightProvider provider) {
            if (!this.highlightProviders.contains(provider)) {
                this.highlightProviders.add(provider);
            }
        }

        void removeHighlightProvider(ListingHighlightProvider provider) {
            this.highlightProviders.remove(provider);
        }
    }
}

