/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.xml;

import ghidra.app.util.CommentTypes;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressFormatException;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.CodeUnitIterator;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.util.XmlProgramUtilities;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import ghidra.util.xml.XmlAttributes;
import ghidra.util.xml.XmlWriter;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlPullParser;

class CommentsXmlMgr {
    private Program program;
    private MessageLog log;
    private AddressFactory factory;
    private Listing listing;
    private static int[] COMMENT_TYPES = CommentTypes.getTypes();
    private static String[] COMMENT_TAGS = new String[COMMENT_TYPES.length];

    CommentsXmlMgr(Program program, MessageLog log) {
        this.program = program;
        this.log = log;
        this.factory = program.getAddressFactory();
        this.listing = program.getListing();
    }

    void read(XmlPullParser parser, TaskMonitor monitor) throws AddressFormatException, CancelledException {
        XmlElement element = parser.next();
        while (true) {
            if (monitor.isCancelled()) {
                throw new CancelledException();
            }
            element = parser.next();
            if (!element.getName().equals("COMMENT")) break;
            if (!element.isStart()) continue;
            this.processComment(element, parser);
        }
    }

    void write(XmlWriter writer, AddressSetView set, TaskMonitor monitor) throws CancelledException {
        monitor.setMessage("Writing COMMENTS ...");
        if (set == null) {
            set = this.program.getMemory();
        }
        writer.startElement("COMMENTS");
        CodeUnitIterator iter = this.listing.getCodeUnitIterator("COMMENT__GHIDRA_", set, true);
        while (iter.hasNext()) {
            if (monitor.isCancelled()) {
                throw new CancelledException();
            }
            CodeUnit cu = iter.next();
            for (int i = 0; i < COMMENT_TYPES.length; ++i) {
                if (monitor.isCancelled()) {
                    return;
                }
                String comments = cu.getComment(COMMENT_TYPES[i]);
                if (comments == null) continue;
                this.writeComment(writer, cu.getMinAddress(), COMMENT_TAGS[i], comments);
            }
        }
        writer.endElement("COMMENTS");
    }

    private void processComment(XmlElement element, XmlPullParser parser) throws AddressFormatException {
        String addrStr = element.getAttribute("ADDRESS");
        Address addr = XmlProgramUtilities.parseAddress((AddressFactory)this.factory, (String)addrStr);
        if (addr == null) {
            throw new AddressFormatException("Incompatible Comment Address: " + addrStr);
        }
        try {
            String typeStr = element.getAttribute("TYPE");
            int commentType = this.getCommentType(typeStr);
            if (commentType < 0) {
                this.log.appendMsg("Unknown comment type: " + typeStr);
                parser.discardSubTree(element);
                return;
            }
            element = parser.next();
            String comments = element.getText();
            CodeUnit cu = this.listing.getCodeUnitAt(addr);
            if (cu != null) {
                String currCmt = cu.getComment(commentType);
                if (currCmt == null || currCmt.length() == 0) {
                    cu.setComment(commentType, comments);
                } else if (currCmt.indexOf(comments) < 0) {
                    this.log.appendMsg("Merged " + typeStr + " comment at " + String.valueOf(addr));
                    cu.setComment(commentType, currCmt + "\n\n" + comments);
                }
            }
        }
        catch (Exception e) {
            this.log.appendException((Throwable)e);
            parser.discardSubTree(element);
        }
    }

    private void writeComment(XmlWriter writer, Address addr, String typeStr, String comments) {
        XmlAttributes attrs = new XmlAttributes();
        attrs.addAttribute("ADDRESS", XmlProgramUtilities.toString((Address)addr));
        attrs.addAttribute("TYPE", typeStr);
        writer.writeElement("COMMENT", attrs, comments);
    }

    private int getCommentType(String typeStr) {
        for (int i = 0; i < COMMENT_TAGS.length; ++i) {
            if (!COMMENT_TAGS[i].equals(typeStr)) continue;
            return COMMENT_TYPES[i];
        }
        return -1;
    }

    static {
        block7: for (int i = 0; i < COMMENT_TAGS.length; ++i) {
            switch (COMMENT_TYPES[i]) {
                case 1: {
                    CommentsXmlMgr.COMMENT_TAGS[i] = "pre";
                    continue block7;
                }
                case 2: {
                    CommentsXmlMgr.COMMENT_TAGS[i] = "post";
                    continue block7;
                }
                case 0: {
                    CommentsXmlMgr.COMMENT_TAGS[i] = "end-of-line";
                    continue block7;
                }
                case 3: {
                    CommentsXmlMgr.COMMENT_TAGS[i] = "plate";
                    continue block7;
                }
                case 4: {
                    CommentsXmlMgr.COMMENT_TAGS[i] = "repeatable";
                }
            }
        }
    }
}

