/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.base.codecompare.listing;

import ghidra.features.base.codecompare.panel.ComparisonData;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ListingAddressCorrelation;
import ghidra.util.datastruct.Duo;

public class LinearAddressCorrelation
implements ListingAddressCorrelation {
    private Duo<ComparisonData> comparisonData;

    public LinearAddressCorrelation(Duo<ComparisonData> comparisonData) {
        this.comparisonData = comparisonData;
    }

    public Program getProgram(Duo.Side side) {
        return ((ComparisonData)this.comparisonData.get(Duo.Side.LEFT)).getProgram();
    }

    public AddressSetView getAddresses(Duo.Side side) {
        return ((ComparisonData)this.comparisonData.get(Duo.Side.LEFT)).getAddressSet();
    }

    public Function getFunction(Duo.Side side) {
        return null;
    }

    public Address getAddress(Duo.Side side, Address otherAddress) {
        Duo.Side otherSide = side.otherSide();
        if (!this.isValidAddress(otherSide, otherAddress) || !this.isCodeUnitStart(otherSide, otherAddress)) {
            return null;
        }
        AddressSetView otherSet = ((ComparisonData)this.comparisonData.get(otherSide)).getAddressSet();
        Address minOtherAddress = otherSet.getMinAddress();
        long offset = otherAddress.subtract(minOtherAddress);
        Address minAddress = ((ComparisonData)this.comparisonData.get(side)).getAddressSet().getMinAddress();
        Address address = minAddress.addWrap(offset);
        if (!this.isValidAddress(side, address)) {
            return null;
        }
        return this.normalizeToCodeUnitStart(side, address);
    }

    private boolean isValidAddress(Duo.Side side, Address address) {
        AddressSetView addresses = ((ComparisonData)this.comparisonData.get(side)).getAddressSet();
        return addresses.contains(address);
    }

    private boolean isCodeUnitStart(Duo.Side side, Address address) {
        Listing listing = this.getListing(side);
        CodeUnit cu = listing.getCodeUnitAt(address);
        return cu != null;
    }

    private Address normalizeToCodeUnitStart(Duo.Side side, Address address) {
        Listing listing = this.getListing(side);
        CodeUnit cu = listing.getCodeUnitContaining(address);
        Address minAddress = cu.getMinAddress();
        if (this.isValidAddress(side, minAddress)) {
            return minAddress;
        }
        return null;
    }

    private Listing getListing(Duo.Side side) {
        return ((ComparisonData)this.comparisonData.get(side)).getProgram().getListing();
    }
}

