/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.base.codecompare.listing;

import docking.DockingWindowManager;
import ghidra.app.nav.Navigatable;
import ghidra.app.services.GoToOverrideService;
import ghidra.app.services.GoToService;
import ghidra.app.services.GoToServiceListener;
import ghidra.app.services.QueryData;
import ghidra.app.util.viewer.listingpanel.ListingPanel;
import ghidra.app.util.viewer.util.AddressIndexMap;
import ghidra.features.base.codecompare.listing.ListingDisplayNavigator;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.ExternalLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.util.Msg;
import ghidra.util.task.TaskMonitor;

class ListingDisplayGoToService
implements GoToService {
    private ListingPanel listingPanel;

    ListingDisplayGoToService(ListingPanel listingPanel) {
        this.listingPanel = listingPanel;
    }

    @Override
    public GoToOverrideService getOverrideService() {
        return null;
    }

    @Override
    public boolean goTo(ProgramLocation loc) {
        return this.doGoTo(loc);
    }

    @Override
    public boolean goTo(Navigatable navigatable, Program program, Address address, Address refAddress) {
        return this.doGoTo(new ProgramLocation(program, address));
    }

    @Override
    public boolean goTo(ProgramLocation loc, Program program) {
        return this.doGoTo(loc);
    }

    @Override
    public boolean goTo(Navigatable navigatable, ProgramLocation loc, Program program) {
        return this.doGoTo(loc);
    }

    @Override
    public boolean goTo(Navigatable navigatable, Address goToAddress) {
        return this.doGoTo(goToAddress);
    }

    @Override
    public boolean goTo(Address currentAddress, Address goToAddress) {
        return this.doGoTo(goToAddress);
    }

    @Override
    public boolean goTo(Address goToAddress) {
        return this.doGoTo(goToAddress);
    }

    @Override
    public boolean goTo(Address goToAddress, Program program) {
        return this.doGoTo(goToAddress);
    }

    @Override
    public boolean goToExternalLocation(ExternalLocation extLoc, boolean checkNavigationOption) {
        Msg.showError((Object)this, null, (String)"Go To Failed!", (Object)"Can't naviagate to an external function from here");
        return false;
    }

    @Override
    public boolean goToExternalLocation(Navigatable navigatable, ExternalLocation extLoc, boolean checkNavigationOption) {
        Msg.showError((Object)this, null, (String)"Go To Failed!", (Object)"Can't naviagate to an external function from here");
        return false;
    }

    @Override
    public boolean goToQuery(Address fromAddr, QueryData queryData, GoToServiceListener listener, TaskMonitor monitor) {
        throw new UnsupportedOperationException("Go To Address or Label Query is not allowed in a dual listing view.");
    }

    @Override
    public boolean goToQuery(Navigatable navigatable, Address fromAddr, QueryData queryData, GoToServiceListener listener, TaskMonitor monitor) {
        throw new UnsupportedOperationException("Go To Address or Label Query is not allowed in a dual listing view.");
    }

    @Override
    public void setOverrideService(GoToOverrideService override) {
    }

    @Override
    public Navigatable getDefaultNavigatable() {
        return new ListingDisplayNavigator(this.listingPanel, this);
    }

    private boolean doGoTo(Address addr) {
        if (!this.validateAddress(addr)) {
            return false;
        }
        return this.listingPanel.goTo(addr);
    }

    private boolean doGoTo(ProgramLocation loc) {
        if (loc == null) {
            return false;
        }
        if (!this.validateAddress(loc.getAddress())) {
            return false;
        }
        return this.listingPanel.goTo(loc);
    }

    private boolean validateAddress(Address addr) {
        if (addr == null) {
            return false;
        }
        AddressIndexMap map = this.listingPanel.getAddressIndexMap();
        AddressSetView addresses = map.getOriginalAddressSet();
        if (!addresses.contains(addr)) {
            DockingWindowManager.getActiveInstance().setStatusText("\"" + addr.toString() + "\" is outside the current listing's view.");
            return false;
        }
        return true;
    }
}

