/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.base.codecompare.model;

import ghidra.features.base.codecompare.model.AbstractFunctionComparisonModel;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.util.datastruct.Duo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class AnyToAnyFunctionComparisonModel
extends AbstractFunctionComparisonModel {
    private Set<Function> functions = new HashSet<Function>();

    public AnyToAnyFunctionComparisonModel(Collection<Function> functions) {
        this.functions.addAll(functions);
        List<Function> orderedFunctions = this.getOrderedFunctions();
        if (orderedFunctions.size() == 1) {
            this.setActiveFunction(Duo.Side.LEFT, orderedFunctions.get(0));
            this.setActiveFunction(Duo.Side.RIGHT, orderedFunctions.get(0));
        } else if (orderedFunctions.size() > 1) {
            this.setActiveFunction(Duo.Side.LEFT, orderedFunctions.get(0));
            this.setActiveFunction(Duo.Side.RIGHT, orderedFunctions.get(1));
        }
    }

    public AnyToAnyFunctionComparisonModel(Function ... functions) {
        this(Arrays.asList(functions));
    }

    @Override
    public List<Function> getFunctions(Duo.Side side) {
        return this.getOrderedFunctions();
    }

    @Override
    public void removeFunction(Function function) {
        this.removeFunctions(Set.of(function));
    }

    @Override
    public void removeFunctions(Collection<Function> functionsToRemove) {
        int beforeSize = this.functions.size();
        this.functions.removeAll(functionsToRemove);
        int afterSize = this.functions.size();
        if (beforeSize != afterSize) {
            this.fixupActiveFunctions();
            this.fireModelDataChanged();
        }
    }

    @Override
    public void removeFunctions(Program program) {
        Set<Function> functionsToRemove = this.functions.stream().filter(f -> f.getProgram().equals((Object)program)).collect(Collectors.toSet());
        this.removeFunctions(functionsToRemove);
    }

    @Override
    public boolean isEmpty() {
        return this.functions.isEmpty();
    }

    public void addFunctions(Collection<Function> additionalFunctions) {
        if (additionalFunctions.isEmpty()) {
            return;
        }
        this.functions.addAll(additionalFunctions);
        this.fireModelDataChanged();
        this.setActiveFunction(Duo.Side.RIGHT, additionalFunctions.iterator().next());
    }

    public void addFunction(Function function) {
        this.addFunctions(List.of(function));
    }

    @Override
    protected boolean containsFunction(Duo.Side side, Function function) {
        return this.functions.contains(function);
    }

    private List<Function> getOrderedFunctions() {
        ArrayList<Function> functionsList = new ArrayList<Function>(this.functions);
        Collections.sort(functionsList, FUNCTION_COMPARATOR);
        return functionsList;
    }

    private void fixupActiveFunctions() {
        Function firstFunction;
        Function left = this.getActiveFunction(Duo.Side.LEFT);
        Function right = this.getActiveFunction(Duo.Side.RIGHT);
        boolean containsLeft = this.functions.contains(left);
        boolean containsRight = this.functions.contains(right);
        if (containsLeft && containsRight) {
            return;
        }
        Function function = firstFunction = this.functions.isEmpty() ? null : this.getOrderedFunctions().get(0);
        if (!containsLeft) {
            left = firstFunction;
        }
        if (!containsRight) {
            right = firstFunction;
        }
        this.activeFunctions = new Duo((Object)left, (Object)right);
    }
}

