/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.base.codecompare.panel;

import ghidra.features.base.codecompare.panel.ComparisonData;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.util.HTMLUtilities;
import java.awt.Color;
import java.util.Objects;

public class AddressSetComparisonData
implements ComparisonData {
    private Program program;
    private AddressSetView addresses;

    public AddressSetComparisonData(Program program, AddressSetView addresses) {
        this.program = Objects.requireNonNull(program);
        this.addresses = Objects.requireNonNull(addresses);
    }

    @Override
    public Function getFunction() {
        return null;
    }

    @Override
    public AddressSetView getAddressSet() {
        return this.addresses;
    }

    @Override
    public Program getProgram() {
        return this.program;
    }

    @Override
    public String getShortDescription() {
        Address minAddress = this.addresses.getMinAddress();
        Address maxAddress = this.addresses.getMinAddress();
        if (minAddress == null) {
            return "Empty";
        }
        return String.valueOf(minAddress) + ":" + String.valueOf(maxAddress);
    }

    @Override
    public String getDescription() {
        StringBuffer buf = new StringBuffer();
        String padStr = HTMLUtilities.spaces((int)4);
        buf.append(padStr);
        String programStr = HTMLUtilities.friendlyEncodeHTML((String)this.program.getDomainFile().getPathname());
        String specialProgramStr = HTMLUtilities.colorString((Color)FG_COLOR_TITLE, (String)programStr);
        buf.append(specialProgramStr);
        buf.append(padStr);
        return HTMLUtilities.wrapAsHTML((String)buf.toString());
    }

    @Override
    public boolean isEmpty() {
        return this.addresses.isEmpty();
    }
}

