/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.base.codecompare.panel;

import ghidra.features.base.codecompare.panel.ComparisonData;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.util.HTMLUtilities;
import java.awt.Color;
import java.util.Objects;

public class DataComparisonData
implements ComparisonData {
    private final Data data;
    private final AddressSet addresses;

    public DataComparisonData(Data data, int otherLength) {
        this.data = Objects.requireNonNull(data);
        int size = Math.max(data.getLength(), otherLength);
        this.addresses = new AddressSet(data.getMinAddress(), this.getEndAddress(size));
    }

    @Override
    public AddressSetView getAddressSet() {
        return this.addresses;
    }

    @Override
    public Program getProgram() {
        return this.data.getProgram();
    }

    @Override
    public Function getFunction() {
        return null;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public String getShortDescription() {
        return this.data.getDataType().getName();
    }

    @Override
    public String getDescription() {
        StringBuffer buf = new StringBuffer();
        String padStr = HTMLUtilities.spaces((int)4);
        buf.append(padStr);
        String dataLabel = this.data.getLabel();
        if (dataLabel == null) {
            Address address = this.data.getAddress();
            dataLabel = address.toString();
        }
        String dataStr = HTMLUtilities.friendlyEncodeHTML((String)dataLabel);
        String specialDataStr = HTMLUtilities.bold((String)dataStr);
        buf.append(specialDataStr);
        Program program = this.data.getProgram();
        if (program != null) {
            buf.append(" in ");
            String programStr = HTMLUtilities.friendlyEncodeHTML((String)program.getDomainFile().getPathname());
            String specialProgramStr = HTMLUtilities.colorString((Color)FG_COLOR_TITLE, (String)programStr);
            buf.append(specialProgramStr);
            buf.append(padStr);
        }
        return HTMLUtilities.wrapAsHTML((String)buf.toString());
    }

    private Address getEndAddress(int size) {
        Address endAddress;
        Address minAddress = this.data.getMinAddress();
        if (minAddress.isExternalAddress()) {
            return minAddress;
        }
        MemoryBlock block = this.data.getProgram().getMemory().getBlock(minAddress);
        Address blockEnd = block.getEnd();
        try {
            endAddress = minAddress.add((long)size);
            if (endAddress.compareTo((Object)blockEnd) > 0) {
                endAddress = blockEnd;
            }
        }
        catch (AddressOutOfBoundsException e) {
            endAddress = blockEnd;
        }
        return endAddress;
    }
}

