/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.base.memsearch.format;

import ghidra.features.base.memsearch.format.SearchFormat;
import ghidra.features.base.memsearch.gui.SearchSettings;
import ghidra.features.base.memsearch.matcher.ByteMatcher;
import ghidra.features.base.memsearch.matcher.InvalidByteMatcher;
import ghidra.features.base.memsearch.matcher.MaskedByteSequenceByteMatcher;
import ghidra.util.StringUtilities;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

class StringSearchFormat
extends SearchFormat {
    private final byte CASE_INSENSITIVE_MASK = (byte)-33;

    StringSearchFormat() {
        super("String");
    }

    @Override
    public ByteMatcher parse(String input, SearchSettings settings) {
        if ((input = input.trim()).isBlank()) {
            return new InvalidByteMatcher("");
        }
        boolean isBigEndian = settings.isBigEndian();
        int inputLength = input.length();
        Charset charset = settings.getStringCharset();
        if (charset == StandardCharsets.UTF_16) {
            Charset charset2 = charset = isBigEndian ? StandardCharsets.UTF_16BE : StandardCharsets.UTF_16LE;
        }
        if (settings.useEscapeSequences() && inputLength >= 2) {
            input = StringUtilities.convertEscapeSequences((String)input);
        }
        byte[] bytes = input.getBytes(charset);
        byte[] maskArray = new byte[bytes.length];
        Arrays.fill(maskArray, (byte)-1);
        if (!settings.isCaseSensitive()) {
            this.createCaseInsensitiveBytesAndMasks(charset, bytes, maskArray);
        }
        return new MaskedByteSequenceByteMatcher(input, bytes, maskArray, settings);
    }

    private void createCaseInsensitiveBytesAndMasks(Charset encodingCharSet, byte[] bytes, byte[] masks) {
        int i = 0;
        while (i < bytes.length) {
            if (encodingCharSet == StandardCharsets.US_ASCII && Character.isLetter(bytes[i])) {
                masks[i] = -33;
                bytes[i] = (byte)(bytes[i] & 0xFFFFFFDF);
                ++i;
                continue;
            }
            if (encodingCharSet == StandardCharsets.UTF_8) {
                int numBytes = this.bytesPerCharUTF8(bytes[i]);
                if (numBytes == 1 && Character.isLetter(bytes[i])) {
                    masks[i] = -33;
                    bytes[i] = (byte)(bytes[i] & 0xFFFFFFDF);
                }
                i += numBytes;
                continue;
            }
            if (encodingCharSet == StandardCharsets.UTF_16BE) {
                if (bytes[i] == 0 && Character.isLetter(bytes[i + 1])) {
                    masks[i + 1] = -33;
                    bytes[i + 1] = (byte)(bytes[i + 1] & 0xFFFFFFDF);
                }
                i += 2;
                continue;
            }
            if (encodingCharSet == StandardCharsets.UTF_16LE) {
                if (bytes[i + 1] == 0 && Character.isLetter(bytes[i])) {
                    masks[i] = -33;
                    bytes[i] = (byte)(bytes[i] & 0xFFFFFFDF);
                }
                i += 2;
                continue;
            }
            ++i;
        }
    }

    private int bytesPerCharUTF8(byte zByte) {
        int offset = 1;
        while ((zByte & 0x80) != 0) {
            zByte = (byte)(zByte << 1);
            ++offset;
        }
        return offset;
    }

    @Override
    public String getToolTip() {
        return "Interpret value as a sequence of characters.";
    }

    @Override
    public String getValueString(byte[] bytes, SearchSettings settings) {
        boolean isBigEndian = settings.isBigEndian();
        Charset charset = settings.getStringCharset();
        if (charset == StandardCharsets.UTF_16) {
            charset = isBigEndian ? StandardCharsets.UTF_16BE : StandardCharsets.UTF_16LE;
        }
        return new String(bytes, charset);
    }

    @Override
    public String convertText(String text, SearchSettings oldSettings, SearchSettings newSettings) {
        return this.isValidText(text, newSettings) ? text : "";
    }

    @Override
    public SearchFormat.SearchFormatType getFormatType() {
        return SearchFormat.SearchFormatType.STRING_TYPE;
    }
}

