/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.base.memsearch.gui;

import ghidra.app.nav.Navigatable;
import ghidra.features.base.memsearch.bytesource.AddressableByteSource;
import ghidra.features.base.memsearch.combiner.Combiner;
import ghidra.features.base.memsearch.gui.CombinedMatchTableLoader;
import ghidra.features.base.memsearch.gui.EmptyMemoryMatchTableLoader;
import ghidra.features.base.memsearch.gui.MemoryMatchTableLoader;
import ghidra.features.base.memsearch.gui.MemoryMatchTableModel;
import ghidra.features.base.memsearch.gui.MemorySearchProvider;
import ghidra.features.base.memsearch.gui.NewSearchTableLoader;
import ghidra.features.base.memsearch.gui.RefreshResultsTableLoader;
import ghidra.features.base.memsearch.gui.SearchMarkers;
import ghidra.features.base.memsearch.scan.Scanner;
import ghidra.features.base.memsearch.searcher.MemoryMatch;
import ghidra.features.base.memsearch.searcher.MemorySearcher;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.Address;
import ghidra.util.Msg;
import ghidra.util.Swing;
import ghidra.util.exception.CancelledException;
import ghidra.util.table.GhidraTable;
import ghidra.util.table.GhidraTableFilterPanel;
import ghidra.util.table.GhidraThreadedTablePanel;
import ghidra.util.task.Task;
import ghidra.util.task.TaskLauncher;
import ghidra.util.task.TaskMonitor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableModelEvent;

class MemorySearchResultsPanel
extends JPanel {
    private GhidraThreadedTablePanel<MemoryMatch> threadedTablePanel;
    private GhidraTableFilterPanel<MemoryMatch> tableFilterPanel;
    private GhidraTable table;
    private MemoryMatchTableModel tableModel;
    private MemorySearchProvider provider;
    private SearchMarkers markers;

    MemorySearchResultsPanel(MemorySearchProvider provider, SearchMarkers markers) {
        super(new BorderLayout());
        this.provider = provider;
        this.markers = markers;
        Navigatable navigatable = provider.getNavigatable();
        this.tableModel = new MemoryMatchTableModel((ServiceProvider)provider.getTool(), navigatable.getProgram());
        this.threadedTablePanel = new GhidraThreadedTablePanel<MemoryMatch>(this.tableModel);
        this.table = this.threadedTablePanel.getTable();
        this.table.setActionsEnabled(true);
        this.table.installNavigation((ServiceProvider)provider.getTool(), navigatable);
        this.tableModel.addTableModelListener(this::tableChanged);
        this.add((Component)((Object)this.threadedTablePanel), "Center");
        this.add((Component)this.createFilterFieldPanel(), "South");
        ListSelectionModel selectionModel = this.threadedTablePanel.getTable().getSelectionModel();
        selectionModel.addListSelectionListener(this::selectionChanged);
    }

    private void tableChanged(TableModelEvent event) {
        this.markers.loadMarkers(this.provider.getTitle(), this.tableModel.getModelData());
    }

    void providerActivated() {
        this.markers.makeActiveMarkerSet();
    }

    private void selectionChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        this.provider.tableSelectionChanged();
    }

    private JComponent createFilterFieldPanel() {
        this.tableFilterPanel = new GhidraTableFilterPanel((JTable)((Object)this.table), this.tableModel);
        this.tableFilterPanel.setToolTipText("Filter search results");
        return this.tableFilterPanel;
    }

    public void search(MemorySearcher searcher, Combiner combiner) {
        MemoryMatchTableLoader loader = this.createLoader(searcher, combiner);
        this.tableModel.addInitialLoadListener(cancelled -> this.provider.searchAllCompleted(loader.hasResults(), (boolean)cancelled, loader.didTerminateEarly()));
        this.tableModel.setLoader(loader);
    }

    public void searchOnce(MemorySearcher searcher, Address address, boolean forward) {
        SearchOnceTask task = new SearchOnceTask(forward, searcher, address);
        TaskLauncher.launch((Task)task);
    }

    public void refreshAndMaybeScanForChanges(AddressableByteSource byteSource, Scanner scanner) {
        RefreshAndScanTask task = new RefreshAndScanTask(byteSource, scanner);
        TaskLauncher.launch((Task)task);
    }

    private MemoryMatchTableLoader createLoader(MemorySearcher searcher, Combiner combiner) {
        if (this.hasResults() && combiner != Combiner.REPLACE) {
            List previousResults = this.tableModel.getModelData();
            return new CombinedMatchTableLoader(searcher, previousResults, combiner);
        }
        return new NewSearchTableLoader(searcher);
    }

    public boolean hasResults() {
        return this.tableModel.getRowCount() > 0;
    }

    public void clearResults() {
        this.tableModel.addInitialLoadListener(b -> this.provider.searchAllCompleted(true, false, false));
        this.tableModel.setLoader(new EmptyMemoryMatchTableLoader());
    }

    public int getMatchCount() {
        return this.tableModel.getRowCount();
    }

    void select(MemoryMatch match) {
        int rowIndex = this.tableModel.getRowIndex(match);
        if (rowIndex >= 0) {
            this.threadedTablePanel.getTable().selectRow(rowIndex);
        }
    }

    GhidraTable getTable() {
        return this.table;
    }

    public MemoryMatch getSelectedMatch() {
        int row = this.table.getSelectedRow();
        return row < 0 ? null : (MemoryMatch)this.tableModel.getRowObject(row);
    }

    public void dispose() {
        this.markers.dispose();
        this.tableFilterPanel.dispose();
    }

    MemoryMatchTableModel getTableModel() {
        return this.tableModel;
    }

    private class SearchOnceTask
    extends Task {
        private boolean forward;
        private MemorySearcher searcher;
        private Address start;

        public SearchOnceTask(boolean forward, MemorySearcher searcher, Address start) {
            super(forward ? "Search Next" : "Search Previous", true, true, true);
            this.forward = forward;
            this.searcher = searcher;
            this.start = start;
        }

        private void tableLoadComplete(MemoryMatch match, boolean wasCancelled) {
            int rowIndex = MemorySearchResultsPanel.this.tableModel.getRowIndex(match);
            if (rowIndex >= 0) {
                MemorySearchResultsPanel.this.table.selectRow(rowIndex);
                MemorySearchResultsPanel.this.table.scrollToSelectedRow();
                MemorySearchResultsPanel.this.provider.searchOnceCompleted(match, wasCancelled);
            }
        }

        public void run(TaskMonitor monitor) throws CancelledException {
            try {
                MemoryMatch match = this.searcher.findOnce(this.start, this.forward, monitor);
                if (match != null) {
                    MemorySearchResultsPanel.this.tableModel.addInitialLoadListener(b -> this.tableLoadComplete(match, (boolean)b));
                    MemorySearchResultsPanel.this.tableModel.addObject(match);
                    return;
                }
            }
            catch (Throwable t) {
                Msg.showError((Object)((Object)this), null, (String)"Unexpected error refreshing bytes", (Object)t);
            }
            Swing.runLater(() -> MemorySearchResultsPanel.this.provider.searchOnceCompleted(null, monitor.isCancelled()));
        }
    }

    private class RefreshAndScanTask
    extends Task {
        private AddressableByteSource byteSource;
        private Scanner scanner;

        public RefreshAndScanTask(AddressableByteSource byteSource, Scanner scanner) {
            super("Refreshing", true, true, true);
            this.byteSource = byteSource;
            this.scanner = scanner;
        }

        private void tableLoadComplete(MemoryMatch match) {
            int rowIndex;
            if (match == null) {
                MemorySearchResultsPanel.this.provider.refreshAndScanCompleted(null);
            }
            if ((rowIndex = MemorySearchResultsPanel.this.tableModel.getRowIndex(match)) >= 0) {
                MemorySearchResultsPanel.this.table.selectRow(rowIndex);
                MemorySearchResultsPanel.this.table.scrollToSelectedRow();
            }
            MemorySearchResultsPanel.this.provider.refreshAndScanCompleted(match);
        }

        public void run(TaskMonitor monitor) throws CancelledException {
            List matches = MemorySearchResultsPanel.this.tableModel.getModelData();
            if (this.refreshByteValues(monitor, matches) && this.scanner != null) {
                this.performScanFiltering(monitor, matches);
            } else {
                MemorySearchResultsPanel.this.tableModel.fireTableDataChanged();
                MemorySearchResultsPanel.this.provider.refreshAndScanCompleted(null);
            }
        }

        private boolean refreshByteValues(TaskMonitor monitor, List<MemoryMatch> matches) {
            try {
                this.byteSource.invalidate();
                monitor.initialize((long)matches.size(), "Refreshing...");
                for (MemoryMatch match : matches) {
                    byte[] bytes = new byte[match.getLength()];
                    this.byteSource.getBytes(match.getAddress(), bytes, bytes.length);
                    match.updateBytes(bytes);
                    monitor.incrementProgress();
                    if (!monitor.isCancelled()) continue;
                    return false;
                }
                return true;
            }
            catch (Throwable t) {
                Msg.showError((Object)((Object)this), null, (String)"Unexpected error refreshing bytes", (Object)t);
                return false;
            }
        }

        private void performScanFiltering(TaskMonitor monitor, List<MemoryMatch> matches) {
            monitor.initialize((long)matches.size(), "Scanning for changes...");
            ArrayList<MemoryMatch> scanResults = new ArrayList<MemoryMatch>();
            for (MemoryMatch match : matches) {
                if (this.scanner.accept(match)) {
                    scanResults.add(match);
                }
                if (!monitor.isCancelled()) continue;
                break;
            }
            MemoryMatch firstIfReduced = this.getFirstMatchIfReduced(matches, scanResults);
            MemorySearchResultsPanel.this.tableModel.addInitialLoadListener(b -> this.tableLoadComplete(firstIfReduced));
            MemorySearchResultsPanel.this.tableModel.setLoader(new RefreshResultsTableLoader(scanResults));
        }

        private MemoryMatch getFirstMatchIfReduced(List<MemoryMatch> matches, List<MemoryMatch> scanResults) {
            MemoryMatch firstIfReduced = null;
            if (!scanResults.isEmpty() && scanResults.size() != matches.size()) {
                firstIfReduced = scanResults.isEmpty() ? null : scanResults.getFirst();
            }
            return firstIfReduced;
        }
    }
}

