/*
 * Decompiled with CFR 0.152.
 */
package ghidra.formats.gfilesystem;

import ghidra.app.util.bin.ByteProvider;
import ghidra.formats.gfilesystem.FSRL;
import ghidra.formats.gfilesystem.FSRLRoot;
import ghidra.formats.gfilesystem.FSUtilities;
import ghidra.formats.gfilesystem.FileSystemRefManager;
import ghidra.formats.gfilesystem.GFile;
import ghidra.formats.gfilesystem.GFileHashProvider;
import ghidra.formats.gfilesystem.GFileLocal;
import ghidra.formats.gfilesystem.GFileSystem;
import ghidra.formats.gfilesystem.LocalFileSystem;
import ghidra.formats.gfilesystem.fileinfo.FileAttributes;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class LocalFileSystemSub
implements GFileSystem,
GFileHashProvider {
    private final FSRLRoot fsFSRL;
    private final LocalFileSystem rootFS;
    private File localfsRootDir;
    private FileSystemRefManager refManager = new FileSystemRefManager(this);
    private GFileLocal rootGFile;

    public LocalFileSystemSub(File rootDir, LocalFileSystem rootFS) throws IOException {
        this.rootFS = rootFS;
        this.localfsRootDir = rootDir.getCanonicalFile();
        FSRL containerFSRL = rootFS.getLocalFSRL(this.localfsRootDir);
        this.fsFSRL = FSRLRoot.nestedFS(containerFSRL, rootFS.getFSRL().getProtocol());
        this.rootGFile = new GFileLocal(this.localfsRootDir, "/", containerFSRL, this, null);
    }

    @Override
    public String getType() {
        return this.rootFS.getType();
    }

    @Override
    public String getDescription() {
        return "Local filesystem subdirectory";
    }

    @Override
    public void close() {
        this.refManager.onClose();
        this.localfsRootDir = null;
    }

    @Override
    public boolean isClosed() {
        return this.localfsRootDir == null;
    }

    @Override
    public boolean isStatic() {
        return false;
    }

    private File getFileFromGFile(GFile gf) throws IOException {
        if (gf == null) {
            return this.localfsRootDir;
        }
        if (!(gf instanceof GFileLocal)) {
            throw new IOException("Unexpected GFile class: " + String.valueOf(gf.getClass()));
        }
        return ((GFileLocal)gf).getLocalFile();
    }

    @Override
    public List<GFile> getListing(GFile directory) throws IOException {
        if (directory == null) {
            directory = this.rootGFile;
        }
        if (!directory.isDirectory()) {
            return List.of();
        }
        File localDir = this.getFileFromGFile(directory);
        if (FSUtilities.isSymlink(localDir)) {
            return List.of();
        }
        File[] localFiles = localDir.listFiles();
        if (localFiles == null) {
            return List.of();
        }
        ArrayList<GFile> tmp = new ArrayList<GFile>(localFiles.length);
        FSRL dirFSRL = directory.getFSRL();
        String relPath = FSUtilities.normalizeNativePath(directory.getPath());
        for (File f : localFiles) {
            boolean isSymlink = FSUtilities.isSymlink(f);
            if (!isSymlink && !f.isFile() && !f.isDirectory()) continue;
            String name = f.getName();
            GFileLocal gf = new GFileLocal(f, FSUtilities.appendPath(relPath, name), dirFSRL.appendPath(name), this, directory);
            tmp.add(gf);
        }
        return tmp;
    }

    @Override
    public FileAttributes getFileAttributes(GFile file, TaskMonitor monitor) {
        try {
            File localFile = this.getFileFromGFile(file);
            return this.rootFS.getFileAttributes(localFile);
        }
        catch (IOException iOException) {
            return FileAttributes.EMPTY;
        }
    }

    @Override
    public String getName() {
        return "Subdir " + this.localfsRootDir.getPath();
    }

    @Override
    public FSRLRoot getFSRL() {
        return this.fsFSRL;
    }

    @Override
    public GFile getRootDir() {
        return this.rootGFile;
    }

    @Override
    public GFile lookup(String path) throws IOException {
        File f = LocalFileSystem.lookupFile(this.localfsRootDir, path, null);
        if (f == null) {
            return null;
        }
        GFile result = this.getGFile(f);
        return result;
    }

    private GFile getGFile(File f) throws IOException {
        List<File> parts = LocalFileSystem.getFilePathParts(f);
        int rootDirIndex = this.findRootDirIndex(parts);
        if (rootDirIndex < 0) {
            throw new IOException("Invalid directory " + String.valueOf(f));
        }
        GFileLocal current = this.rootGFile;
        for (int i = rootDirIndex - 1; i >= 0; --i) {
            File part = parts.get(i);
            FSRL childFSRL = current.getFSRL().appendPath(part.getName());
            String childPath = FSUtilities.appendPath(current.getPath(), part.getName());
            current = new GFileLocal(part, childPath, childFSRL, this, current);
        }
        return current;
    }

    private int findRootDirIndex(List<File> dirList) {
        for (int i = 0; i < dirList.size(); ++i) {
            if (!this.localfsRootDir.equals(dirList.get(i))) continue;
            return i;
        }
        return -1;
    }

    @Override
    public InputStream getInputStream(GFile file, TaskMonitor monitor) throws IOException, CancelledException {
        return this.rootFS.getInputStream(file.getFSRL(), monitor);
    }

    @Override
    public FileSystemRefManager getRefManager() {
        return this.refManager;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public ByteProvider getByteProvider(GFile file, TaskMonitor monitor) throws IOException, CancelledException {
        return this.rootFS.getByteProvider(file.getFSRL(), monitor);
    }

    @Override
    public String getMD5Hash(GFile file, boolean required, TaskMonitor monitor) throws CancelledException, IOException {
        return this.rootFS.getMD5Hash(file.getFSRL(), required, monitor);
    }

    @Override
    public GFile resolveSymlinks(GFile file) throws IOException {
        File canonicalFile;
        File f = this.getFileFromGFile(file);
        if (f.equals(canonicalFile = f.getCanonicalFile())) {
            return file;
        }
        return this.getGFile(canonicalFile);
    }
}

