/*
 * Decompiled with CFR 0.152.
 */
package ghidra.plugin.importer;

import ghidra.formats.gfilesystem.FSRL;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainFolder;
import ghidra.framework.model.DomainFolderChangeListener;
import ghidra.framework.model.Project;
import ghidra.framework.model.ProjectData;
import ghidra.framework.model.ProjectDataUtils;
import ghidra.util.Swing;
import ghidra.util.task.TaskMonitor;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;

public class ProjectIndexService
implements DomainFolderChangeListener {
    private Project project;
    private List<IndexInfo> indexes = List.of(new IndexInfo(IndexType.MD5, this::getMD5), new IndexInfo(IndexType.FSRL, this::getFSRL));

    public static ProjectIndexService getInstance() {
        return SingletonHolder.instance;
    }

    private ProjectIndexService() {
    }

    public synchronized void clearProject() {
        if (this.project != null) {
            this.project.getProjectData().removeDomainFolderChangeListener((DomainFolderChangeListener)this);
            for (IndexInfo index : this.indexes) {
                index.indexedFiles.clear();
            }
            this.project = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProject(Project newProject, TaskMonitor monitor) {
        ProjectIndexService projectIndexService = this;
        synchronized (projectIndexService) {
            if (newProject == this.project) {
                return;
            }
            this.clearProject();
            this.project = newProject;
            if (this.project != null) {
                this.indexes = List.of(new IndexInfo(IndexType.MD5, this::getMD5), new IndexInfo(IndexType.FSRL, this::getFSRL));
                ProjectData projectData = this.project.getProjectData();
                projectData.removeDomainFolderChangeListener((DomainFolderChangeListener)this);
                projectData.addDomainFolderChangeListener((DomainFolderChangeListener)this);
            }
        }
        if (newProject != null) {
            this.indexProject(newProject.getProjectData(), monitor);
        }
    }

    public void domainFileAdded(DomainFile file) {
        this.indexFile(file);
    }

    public void domainFileRemoved(DomainFolder parent, String name, String fileID) {
        this.removeFile(fileID);
    }

    private void indexProject(ProjectData projectData, TaskMonitor monitor) {
        int fileCount = projectData.getFileCount();
        if (fileCount < 0) {
            return;
        }
        monitor.initialize((long)fileCount, "Indexing Project Metadata");
        for (DomainFile df : ProjectDataUtils.descendantFiles((DomainFolder)projectData.getRootFolder())) {
            monitor.incrementProgress();
            if (monitor.isCancelled()) break;
            this.indexFile(df);
            if (monitor.getProgress() % 10L != 0L) continue;
            Swing.allowSwingToProcessEvents();
        }
    }

    private String getMD5(DomainFile file, Map<String, String> metadata) {
        return metadata.get(IndexType.MD5.metadataKey);
    }

    private FSRL getFSRL(DomainFile file, Map<String, String> metadata) {
        String fsrlStr = metadata.get(IndexType.FSRL.metadataKey);
        try {
            return fsrlStr != null ? FSRL.fromString(fsrlStr).withMD5(null) : null;
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public synchronized List<DomainFile> lookupFiles(IndexType keyType, Object keyValue) {
        List<Object> fileIds;
        IndexInfo index = this.indexes.get(keyType.ordinal());
        Object fileInfo = index.indexedFiles.get(keyValue);
        if (fileInfo instanceof String) {
            String fileIdStr = (String)fileInfo;
            fileIds = List.of(fileIdStr);
        } else if (fileInfo instanceof List) {
            List fileInfoList = (List)fileInfo;
            fileIds = fileInfoList;
        } else {
            fileIds = List.of();
        }
        return fileIds.stream().map(fileId -> this.project.getProjectData().getFileByID(fileId)).filter(Objects::nonNull).toList();
    }

    public DomainFile findFirstByFSRL(FSRL fsrl) {
        List<DomainFile> files = this.lookupFiles(IndexType.FSRL, fsrl = fsrl.withMD5(null));
        return !files.isEmpty() ? files.get(0) : null;
    }

    private synchronized void indexFile(DomainFile file) {
        Map metadata = file.getMetadata();
        for (IndexInfo index : this.indexes) {
            Object indexedValue = index.mappingFunc.apply(file, metadata);
            if (indexedValue == null) continue;
            Object fileInfo = index.indexedFiles.get(indexedValue);
            if (fileInfo == null) {
                index.indexedFiles.put(indexedValue, file.getFileID());
                continue;
            }
            if (fileInfo instanceof List) {
                List fileInfoList = (List)fileInfo;
                fileInfoList.add(file.getFileID());
                continue;
            }
            if (!(fileInfo instanceof String)) continue;
            String prevFileId = (String)fileInfo;
            String newFileId = file.getFileID();
            if (newFileId.equals(prevFileId)) continue;
            ArrayList<String> fileInfoList = new ArrayList<String>();
            fileInfoList.add(prevFileId);
            fileInfoList.add(newFileId);
            index.indexedFiles.put(indexedValue, fileInfoList);
        }
    }

    private synchronized void removeFile(String fileId) {
        for (IndexInfo index : this.indexes) {
            Iterator<Object> it = index.indexedFiles.values().iterator();
            while (it.hasNext()) {
                String fileIdStr;
                Object fileInfo = it.next();
                if (fileInfo instanceof String && (fileIdStr = (String)fileInfo).equals(fileId)) {
                    it.remove();
                    continue;
                }
                if (!(fileInfo instanceof List)) continue;
                List fileInfoList = (List)fileInfo;
                fileInfoList.remove(fileId);
                if (!fileInfoList.isEmpty()) continue;
                it.remove();
            }
        }
    }

    private static class SingletonHolder {
        private static final ProjectIndexService instance = new ProjectIndexService();

        private SingletonHolder() {
        }
    }

    record IndexInfo(IndexType indexType, BiFunction<DomainFile, Map<String, String>, Object> mappingFunc, Map<Object, Object> indexedFiles) {
        IndexInfo(IndexType indexType, BiFunction<DomainFile, Map<String, String>, Object> mappingFunc) {
            this(indexType, mappingFunc, new HashMap<Object, Object>());
        }
    }

    public static enum IndexType {
        MD5("Executable MD5"),
        FSRL("FSRL");

        private String metadataKey;

        private IndexType(String metadataKey) {
            this.metadataKey = metadataKey;
        }

        public String getMetadataKey() {
            return this.metadataKey;
        }
    }
}

