/*
 * Decompiled with CFR 0.152.
 */
package ghidra.plugins.fsbrowser;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.Tool;
import docking.WindowPosition;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.actions.PopupActionProvider;
import docking.event.mouse.GMouseListenerAdapter;
import docking.widgets.tree.GTree;
import docking.widgets.tree.GTreeNode;
import docking.widgets.tree.support.GTreeRenderer;
import generic.theme.GThemeDefaults;
import ghidra.app.services.ProgramManager;
import ghidra.app.util.bin.ByteProvider;
import ghidra.formats.gfilesystem.FSRL;
import ghidra.formats.gfilesystem.FSUtilities;
import ghidra.formats.gfilesystem.FileSystemEventListener;
import ghidra.formats.gfilesystem.FileSystemProbeConflictResolver;
import ghidra.formats.gfilesystem.FileSystemRef;
import ghidra.formats.gfilesystem.FileSystemRefManager;
import ghidra.formats.gfilesystem.FileSystemService;
import ghidra.formats.gfilesystem.GFile;
import ghidra.formats.gfilesystem.GFileSystem;
import ghidra.formats.gfilesystem.fileinfo.FileAttributeType;
import ghidra.formats.gfilesystem.fileinfo.FileAttributes;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainObject;
import ghidra.framework.model.Project;
import ghidra.framework.plugintool.ComponentProviderAdapter;
import ghidra.plugin.importer.ImporterUtilities;
import ghidra.plugin.importer.ProjectIndexService;
import ghidra.plugins.fsbrowser.FSBActionContext;
import ghidra.plugins.fsbrowser.FSBDirNode;
import ghidra.plugins.fsbrowser.FSBFileHandler;
import ghidra.plugins.fsbrowser.FSBFileHandlerContext;
import ghidra.plugins.fsbrowser.FSBFileNode;
import ghidra.plugins.fsbrowser.FSBIcons;
import ghidra.plugins.fsbrowser.FSBNode;
import ghidra.plugins.fsbrowser.FSBRootNode;
import ghidra.plugins.fsbrowser.FileSystemBrowserPlugin;
import ghidra.plugins.fsbrowser.OpenWithTarget;
import ghidra.program.model.listing.Program;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.Swing;
import ghidra.util.classfinder.ClassSearcher;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.CryptoException;
import ghidra.util.task.MonitoredRunnable;
import ghidra.util.task.TaskMonitor;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.TreePath;

public class FSBComponentProvider
extends ComponentProviderAdapter
implements FileSystemEventListener,
PopupActionProvider {
    private static final String TITLE = "Filesystem Viewer";
    private FSBIcons fsbIcons = FSBIcons.getInstance();
    private FileSystemService fsService = FileSystemService.getInstance();
    private ProjectIndexService projectIndex = ProjectIndexService.getInstance();
    private FileSystemBrowserPlugin plugin;
    private GTree gTree;
    private FSBRootNode rootNode;
    private List<FSBFileHandler> fileHandlers = List.of();
    private ProgramManager pm;

    public FSBComponentProvider(FileSystemBrowserPlugin plugin, FileSystemRef fsRef) {
        super(plugin.getTool(), fsRef.getFilesystem().getName(), plugin.getName());
        this.plugin = plugin;
        this.rootNode = new FSBRootNode(fsRef);
        this.pm = (ProgramManager)plugin.getTool().getService(ProgramManager.class);
        this.setTransient();
        this.setIcon(FSBIcons.PHOTO);
        this.initTree();
        fsRef.getFilesystem().getRefManager().addListener(this);
        this.initFileHandlers();
        this.setHelpLocation(new HelpLocation("FileSystemBrowserPlugin", "FileSystemBrowserIntroduction"));
    }

    void initFileHandlers() {
        FSBFileHandlerContext context = new FSBFileHandlerContext(this.plugin, this, this.fsService, this.projectIndex);
        this.fileHandlers = ClassSearcher.getInstances(FSBFileHandler.class);
        for (FSBFileHandler fileHandler : this.fileHandlers) {
            fileHandler.init(context);
        }
        this.fileHandlers.add(new DefaultFileHandler());
        this.plugin.getTool().addPopupActionProvider((PopupActionProvider)this);
    }

    void initTree() {
        this.gTree = new GTree((GTreeNode)this.rootNode);
        this.gTree.getSelectionModel().setSelectionMode(4);
        this.gTree.getSelectionModel().addTreeSelectionListener(e -> {
            this.tool.contextChanged((ComponentProvider)this);
            TreePath[] paths = this.gTree.getSelectionPaths();
            if (paths.length == 1) {
                GTreeNode clickedNode = (GTreeNode)paths[0].getLastPathComponent();
                this.handleSingleClick(clickedNode);
            }
        });
        this.gTree.addMouseListener((MouseListener)new GMouseListenerAdapter(){

            public void doubleClickTriggered(MouseEvent e) {
                if (FSBComponentProvider.this.handleDoubleClick(FSBComponentProvider.this.gTree.getNodeForLocation(e.getX(), e.getY()))) {
                    e.consume();
                }
            }

            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                if (!e.isConsumed()) {
                    FSBComponentProvider.this.handleSingleClick(FSBComponentProvider.this.gTree.getNodeForLocation(e.getX(), e.getY()));
                }
            }
        });
        this.gTree.setCellRenderer(new GTreeRenderer(){

            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
                if (value instanceof FSBRootNode) {
                    FSBRootNode fsRootNode = (FSBRootNode)((Object)value);
                    this.renderFS(fsRootNode, selected);
                } else if (!(value instanceof FSBDirNode) && value instanceof FSBFileNode) {
                    FSBFileNode fileNode = (FSBFileNode)((Object)value);
                    this.renderFile(fileNode, selected);
                }
                return this;
            }

            private void renderFS(FSBRootNode node, boolean selected) {
                FileSystemRef nodeFSRef = node.getFSRef();
                if (nodeFSRef == null || nodeFSRef.getFilesystem() == null) {
                    return;
                }
                Icon image = FSBComponentProvider.this.fsbIcons.getIcon(node.getContainerName(), List.of(FSBIcons.FILESYSTEM_OVERLAY_ICON));
                this.setIcon(image);
            }

            private void renderFile(FSBFileNode node, boolean selected) {
                FSRL fsrl = node.getFSRL();
                String filename = fsrl.getName();
                ArrayList<Icon> overlays = new ArrayList<Icon>(4);
                DomainFile df = FSBComponentProvider.this.projectIndex.findFirstByFSRL(fsrl);
                if (df != null) {
                    overlays.add(FSBIcons.IMPORTED_OVERLAY_ICON);
                    if (FSBComponentProvider.this.plugin.isOpen(df)) {
                        this.setForeground((Color)(selected ? GThemeDefaults.Colors.Palette.CYAN : GThemeDefaults.Colors.Palette.MAGENTA));
                    }
                }
                if (FSBComponentProvider.this.fsService.isFilesystemMountedAt(fsrl)) {
                    overlays.add(FSBIcons.FILESYSTEM_OVERLAY_ICON);
                }
                if (node.isSymlink()) {
                    overlays.add(FSBIcons.LINK_OVERLAY_ICON);
                }
                if (node.hasMissingPassword()) {
                    overlays.add(FSBIcons.MISSING_PASSWORD_OVERLAY_ICON);
                }
                Icon icon = FSBComponentProvider.this.fsbIcons.getIcon(filename, overlays);
                this.setIcon(icon);
            }
        });
    }

    public FileSystemBrowserPlugin getPlugin() {
        return this.plugin;
    }

    public GTree getGTree() {
        return this.gTree;
    }

    FSRL getFSRL() {
        return this.rootNode != null ? this.rootNode.getFSRL() : null;
    }

    public ProjectIndexService getProjectIndex() {
        return this.projectIndex;
    }

    void dispose() {
        this.plugin.getTool().removePopupActionProvider((PopupActionProvider)this);
        if (this.rootNode != null && this.rootNode.getFSRef() != null && !this.rootNode.getFSRef().isClosed()) {
            this.rootNode.getFSRef().getFilesystem().getRefManager().removeListener(this);
        }
        this.fileHandlers.clear();
        if (this.gTree != null) {
            this.gTree.setCellRenderer(null);
            this.gTree.dispose();
        }
        this.removeFromTool();
        this.rootNode = null;
        this.plugin = null;
        this.gTree = null;
    }

    public void componentHidden() {
        if (this.plugin != null) {
            this.plugin.removeFileSystemBrowserComponent(this);
            this.dispose();
        }
    }

    public List<DockingActionIf> getPopupActions(Tool tool, ActionContext context) {
        ArrayList<DockingActionIf> results = new ArrayList<DockingActionIf>();
        for (FSBFileHandler fileHandler : this.fileHandlers) {
            List<DockingAction> actions = fileHandler.getPopupProviderActions();
            results.addAll(actions);
        }
        return results;
    }

    public void afterAddedToTool() {
        this.fileHandlers.stream().flatMap(fh -> fh.createActions().stream()).forEach(arg_0 -> ((FSBComponentProvider)this).addLocalAction(arg_0));
        this.setProject(this.tool.getProject());
    }

    public void setProject(Project project) {
        this.gTree.runTask(monitor -> {
            this.projectIndex.setProject(project, monitor);
            Swing.runLater(() -> this.gTree.repaint());
        });
    }

    @Override
    public void onFilesystemClose(GFileSystem fs) {
        Msg.info((Object)this, (Object)("File system " + String.valueOf(fs.getFSRL()) + " was closed! Closing browser window"));
        Swing.runIfSwingOrRunLater(() -> this.componentHidden());
    }

    @Override
    public void onFilesystemRefChange(GFileSystem fs, FileSystemRefManager refManager) {
    }

    public void runTask(MonitoredRunnable runnableTask) {
        this.gTree.runTask(runnableTask);
    }

    private boolean handleSingleClick(GTreeNode clickedNode) {
        if (clickedNode instanceof FSBFileNode) {
            FSBFileNode fileNode = (FSBFileNode)clickedNode;
            for (FSBFileHandler handler : this.fileHandlers) {
                if (!handler.fileFocused(fileNode)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean handleDoubleClick(GTreeNode clickedNode) {
        if (clickedNode instanceof FSBFileNode) {
            FSBFileNode fileNode = (FSBFileNode)clickedNode;
            for (FSBFileHandler handler : this.fileHandlers) {
                if (!handler.fileDefaultAction(fileNode)) continue;
                return true;
            }
        }
        return false;
    }

    public FSBActionContext getActionContext(MouseEvent event) {
        return new FSBActionContext(this, this.getSelectedNodes(event), event, this.gTree);
    }

    private List<FSBNode> getSelectedNodes(MouseEvent event) {
        int y;
        int x;
        GTreeNode nodeAtEventLocation;
        JTree sourceTree;
        Object source;
        FSBNode fsbNode;
        TreePath[] selectionPaths = this.gTree.getSelectionPaths();
        ArrayList<FSBNode> list = new ArrayList<FSBNode>(selectionPaths.length);
        for (TreePath selectionPath : selectionPaths) {
            Object lastPathComponent = selectionPath.getLastPathComponent();
            if (!(lastPathComponent instanceof FSBNode)) continue;
            fsbNode = (FSBNode)((Object)lastPathComponent);
            list.add(fsbNode);
        }
        if (list.isEmpty() && event != null && (source = event.getSource()) instanceof JTree && this.gTree.isMyJTree(sourceTree = (JTree)source) && (nodeAtEventLocation = this.gTree.getNodeForLocation(x = event.getX(), y = event.getY())) != null && nodeAtEventLocation instanceof FSBNode) {
            fsbNode = (FSBNode)nodeAtEventLocation;
            list.add(fsbNode);
        }
        return list;
    }

    public JComponent getComponent() {
        return this.gTree;
    }

    public String getName() {
        return TITLE;
    }

    public WindowPosition getDefaultWindowPosition() {
        return WindowPosition.WINDOW;
    }

    public boolean ensureFileAccessable(FSRL fsrl, FSBNode node, TaskMonitor monitor) {
        boolean bl;
        block11: {
            FSBFileNode fileNode = node instanceof FSBFileNode ? (FSBFileNode)node : null;
            monitor.initialize(0L);
            monitor.setMessage("Testing file access");
            boolean wasMissingPasword = fileNode != null ? fileNode.hasMissingPassword() : false;
            ByteProvider bp = this.fsService.getByteProvider(fsrl, false, monitor);
            try {
                if (wasMissingPasword) {
                    this.doRefreshInfo(List.of(fileNode), monitor);
                }
                bl = true;
                if (bp == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (bp != null) {
                        try {
                            bp.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (CryptoException e) {
                    Msg.showWarn((Object)this, (Component)this.gTree, (String)"Crypto / Password Error", (Object)("Unable to access the specified file.\nThis could be caused by not entering the correct password or because of missing crypto information.\n\n" + e.getMessage()));
                    return false;
                }
                catch (IOException e) {
                    Msg.showError((Object)this, (Component)this.gTree, (String)"File IO Error", (Object)("Unable to access the specified file.\n\n" + e.getMessage()), (Throwable)e);
                    return false;
                }
                catch (CancelledException e) {
                    return false;
                }
            }
            bp.close();
        }
        return bl;
    }

    public boolean openFileSystem(FSBNode node, boolean nested) {
        FSBFileNode fileNode;
        if (!(node instanceof FSBFileNode) || (fileNode = (FSBFileNode)node).getFSRL() == null) {
            return false;
        }
        FSRL fsrl = fileNode.getFSRL();
        this.gTree.runTask(monitor -> {
            if (!this.ensureFileAccessable(fsrl, fileNode, monitor)) {
                return;
            }
            if (!this.doOpenFileSystem(fsrl, fileNode, nested, monitor)) {
                return;
            }
        });
        return true;
    }

    boolean doOpenFileSystem(FSRL containerFSRL, FSBFileNode node, boolean nested, TaskMonitor monitor) {
        try {
            monitor.setMessage("Probing " + containerFSRL.getName() + " for filesystems");
            FileSystemRef ref = this.fsService.probeFileForFilesystem(containerFSRL, monitor, FileSystemProbeConflictResolver.GUI_PICKER);
            if (ref == null) {
                Msg.showWarn((Object)this, (Component)this.plugin.getTool().getActiveWindow(), (String)"Open Filesystem", (Object)("No filesystem detected in " + containerFSRL.getName()));
                return false;
            }
            Swing.runLater(() -> {
                if (nested) {
                    FSBFileNode modelFileNode = (FSBFileNode)this.gTree.getModelNodeForPath(node.getTreePath());
                    FSBRootNode nestedRootNode = new FSBRootNode(ref, modelFileNode);
                    int indexInParent = modelFileNode.getIndexInParent();
                    GTreeNode parent = modelFileNode.getParent();
                    parent.removeNode((GTreeNode)modelFileNode);
                    parent.addNode(indexInParent, (GTreeNode)nestedRootNode);
                    this.gTree.expandPath((GTreeNode)nestedRootNode);
                    try {
                        nestedRootNode.init(monitor);
                    }
                    catch (CancelledException e) {
                        Msg.warn((Object)this, (Object)"Failed to populate FSB root node with children");
                    }
                    this.contextChanged();
                } else {
                    this.plugin.createNewFileSystemBrowser(ref, true);
                }
            });
            return true;
        }
        catch (CancelledException | IOException e) {
            FSUtilities.displayException(this, this.plugin.getTool().getActiveWindow(), "Open Filesystem", "Error opening filesystem for " + containerFSRL.getName(), e);
            return false;
        }
    }

    void doRefreshInfo(List<FSBNode> nodes, TaskMonitor monitor) {
        try {
            for (FSBNode node : nodes) {
                node.refreshNode(monitor);
            }
            this.gTree.refilterLater();
        }
        catch (CancelledException cancelledException) {
            // empty catch block
        }
        Swing.runLater(() -> this.gTree.repaint());
    }

    private class DefaultFileHandler
    implements FSBFileHandler {
        private DefaultFileHandler() {
        }

        @Override
        public void init(FSBFileHandlerContext context) {
        }

        @Override
        public List<DockingAction> createActions() {
            return List.of();
        }

        @Override
        public boolean fileFocused(FSBFileNode fileNode) {
            FSRL fsrl = fileNode.getFSRL();
            if (fsrl != null) {
                DomainObject domObj;
                DomainFile df;
                if (FSBComponentProvider.this.pm != null && (df = FSBComponentProvider.this.projectIndex.findFirstByFSRL(fsrl)) != null && (domObj = df.getOpenedDomainObject((Object)this)) != null) {
                    domObj.release((Object)this);
                    if (domObj instanceof Program) {
                        Program program = (Program)domObj;
                        FSBComponentProvider.this.runTask(monitor -> FSBComponentProvider.this.pm.setCurrentProgram(program));
                    }
                    return true;
                }
                if (fileNode.hasMissingPassword()) {
                    FSBComponentProvider.this.runTask(monitor -> FSBComponentProvider.this.doRefreshInfo(List.of(fileNode), monitor));
                }
            }
            return false;
        }

        @Override
        public boolean fileDefaultAction(FSBFileNode fileNode) {
            FSRL fsrl = fileNode.getFSRL();
            if (fsrl == null) {
                return false;
            }
            if (fileNode.isSymlink()) {
                this.gotoSymlinkDest(fileNode);
                return true;
            }
            if (!fileNode.isLeaf()) {
                return false;
            }
            FSBComponentProvider.this.runTask(monitor -> {
                if (!FSBComponentProvider.this.ensureFileAccessable(fsrl, fileNode, monitor)) {
                    return;
                }
                try {
                    FSRL fullFsrl = FSBComponentProvider.this.fsService.getFullyQualifiedFSRL(fsrl, monitor);
                    if (FSBComponentProvider.this.fsService.isFileFilesystemContainer(fullFsrl, monitor)) {
                        FSBComponentProvider.this.doOpenFileSystem(fullFsrl, fileNode, true, monitor);
                        return;
                    }
                    DomainFile df = FSBComponentProvider.this.projectIndex.findFirstByFSRL(fsrl);
                    OpenWithTarget openWithTarget = OpenWithTarget.getDefault(FSBComponentProvider.this.plugin.getTool());
                    if (df != null && openWithTarget != null) {
                        Swing.runLater(() -> openWithTarget.open(List.of(df)));
                        return;
                    }
                    ImporterUtilities.showImportSingleFileDialog(fullFsrl, null, fileNode.getFormattedTreePath(), FSBComponentProvider.this.plugin.getTool(), openWithTarget.getPm(), monitor);
                }
                catch (CancelledException | IOException throwable) {
                    // empty catch block
                }
            });
            return true;
        }

        private void gotoSymlinkDest(FSBFileNode fileNode) {
            GFile file = fileNode.file;
            try {
                FSBRootNode fsRootNode = fileNode.getFSBRootNode();
                GFile destFile = file.getFilesystem().resolveSymlinks(file);
                if (destFile != null && fsRootNode != null) {
                    FSBComponentProvider.this.gTree.runTask(monitor -> {
                        FSBNode destNode = fsRootNode.getGFileFSBNode(destFile, monitor);
                        if (destNode != null) {
                            Swing.runLater(() -> FSBComponentProvider.this.gTree.setSelectedNodes(new GTreeNode[]{destNode}));
                        }
                    });
                    return;
                }
            }
            catch (IOException fsRootNode) {
                // empty catch block
            }
            FileAttributes fattrs = file.getFilesystem().getFileAttributes(file, null);
            String symlinkDest = fattrs.get(FileAttributeType.SYMLINK_DEST_ATTR, String.class, null);
            FSBComponentProvider.this.plugin.getTool().setStatusInfo("Unable to resolve symlink [%s]".formatted(symlinkDest), true);
        }
    }
}

