/*
 * Decompiled with CFR 0.152.
 */
package ghidra.plugins.fsbrowser;

import generic.theme.GIcon;
import generic.theme.GThemeValueMap;
import generic.theme.Gui;
import generic.theme.IconValue;
import generic.theme.ThemeManager;
import ghidra.formats.gfilesystem.FSUtilities;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import resources.MultiIcon;

public class FSBIcons {
    public static final Icon COPY = new GIcon("icon.plugin.fsbrowser.copy");
    public static final Icon CUT = new GIcon("icon.plugin.fsbrowser.cut");
    public static final Icon DELETE = new GIcon("icon.plugin.fsbrowser.delete");
    public static final Icon FONT = new GIcon("icon.plugin.fsbrowser.font");
    public static final Icon LOCKED = new GIcon("icon.plugin.fsbrowser.locked");
    public static final Icon NEW = new GIcon("icon.plugin.fsbrowser.new");
    public static final Icon PASTE = new GIcon("icon.plugin.fsbrowser.paste");
    public static final Icon REDO = new GIcon("icon.plugin.fsbrowser.redo");
    public static final Icon RENAME = new GIcon("icon.plugin.fsbrowser.rename");
    public static final Icon REFRESH = new GIcon("icon.plugin.fsbrowser.refresh");
    public static final Icon SAVE = new GIcon("icon.plugin.fsbrowser.save");
    public static final Icon SAVE_AS = new GIcon("icon.plugin.fsbrowser.save.as");
    public static final Icon UNDO = new GIcon("icon.plugin.fsbrowser.undo");
    public static final Icon UNLOCKED = new GIcon("icon.plugin.fsbrowser.unlocked");
    public static final Icon CLOSE = new GIcon("icon.plugin.fsbrowser.close");
    public static final Icon COLLAPSE_ALL = new GIcon("icon.plugin.fsbrowser.collapse.all");
    public static final Icon COMPRESS = new GIcon("icon.plugin.fsbrowser.compress");
    public static final Icon CREATE_FIRMWARE = new GIcon("icon.plugin.fsbrowser.create.firmware");
    public static final Icon EXPAND_ALL = new GIcon("icon.plugin.fsbrowser.expand.all");
    public static final Icon EXTRACT = new GIcon("icon.plugin.fsbrowser.extract");
    public static final Icon INFO = new GIcon("icon.plugin.fsbrowser.info");
    public static final Icon OPEN = new GIcon("icon.plugin.fsbrowser.open");
    public static final Icon OPEN_AS_BINARY = new GIcon("icon.plugin.fsbrowser.open.as.binary");
    public static final Icon OPEN_IN_LISTING = new GIcon("icon.plugin.fsbrowser.open.in.listing");
    public static final Icon OPEN_FILE_SYSTEM = new GIcon("icon.plugin.fsbrowser.open.file.system");
    public static final Icon PHOTO = new GIcon("icon.plugin.fsbrowser.photo");
    public static final Icon VIEW_AS_IMAGE = new GIcon("icon.plugin.fsbrowser.view.as.image");
    public static final Icon VIEW_AS_TEXT = new GIcon("icon.plugin.fsbrowser.view.as.text");
    public static final Icon ECLIPSE = new GIcon("icon.plugin.fsbrowser.eclipse");
    public static final Icon JAR = new GIcon("icon.plugin.fsbrowser.jar");
    public static final Icon IMPORT = new GIcon("icon.plugin.fsbrowser.import");
    public static final Icon iOS = new GIcon("icon.plugin.fsbrowser.ios");
    public static final Icon OPEN_ALL = new GIcon("icon.plugin.fsbrowser.open.all");
    public static final Icon LIST_MOUNTED = new GIcon("icon.plugin.fsbrowser.list.mounted");
    public static final Icon LIBRARY = new GIcon("icon.plugin.fsbrowser.library");
    public static final Icon IMPORTED_OVERLAY_ICON = new GIcon("icon.fsbrowser.file.overlay.imported");
    public static final Icon FILESYSTEM_OVERLAY_ICON = new GIcon("icon.fsbrowser.file.overlay.filesystem");
    public static final Icon MISSING_PASSWORD_OVERLAY_ICON = new GIcon("icon.fsbrowser.file.overlay.missing.password");
    public static final Icon LINK_OVERLAY_ICON = new GIcon("icon.fsbrowser.file.overlay.link");
    public static final Icon DEFAULT_ICON = new GIcon("icon.fsbrowser.file.extension.default");
    private static final String EXTENSION_ICON_PREFIX = "icon.fsbrowser.file.extension";
    private static final String SUBSTRING_ICON_PREFIX = "icon.fsbrowser.file.substring";
    private Map<String, Icon> substringToIconMap = this.createSubstringMap();

    public static FSBIcons getInstance() {
        return Singleton.INSTANCE;
    }

    private FSBIcons() {
    }

    private Map<String, Icon> createSubstringMap() {
        HashMap<String, Icon> results = new HashMap<String, Icon>();
        GThemeValueMap values = ThemeManager.getInstance().getCurrentValues();
        List icons = values.getIcons();
        for (IconValue iconValue : icons) {
            String id = iconValue.getId();
            if (!id.startsWith(SUBSTRING_ICON_PREFIX)) continue;
            String substring = id.substring(SUBSTRING_ICON_PREFIX.length());
            results.put(substring, (Icon)new GIcon(id));
        }
        return results;
    }

    public Icon getIcon(String fileName, List<Icon> overlays) {
        String iconId;
        String ext = FSUtilities.getExtension(fileName = fileName.toLowerCase(), 1);
        if (ext != null && Gui.hasIcon((String)(iconId = EXTENSION_ICON_PREFIX + ext))) {
            GIcon base = new GIcon(iconId);
            return this.buildIcon((Icon)base, overlays);
        }
        for (String substring : this.substringToIconMap.keySet()) {
            if (fileName.indexOf(substring) == -1) continue;
            return this.buildIcon(this.substringToIconMap.get(substring), overlays);
        }
        return this.buildIcon(DEFAULT_ICON, overlays);
    }

    private Icon buildIcon(Icon base, List<Icon> overlays) {
        if (overlays == null || overlays.isEmpty()) {
            return base;
        }
        MultiIcon multiIcon = new MultiIcon(base);
        for (Icon overlay : overlays) {
            if (overlay == null) continue;
            multiIcon.addIcon(overlay);
        }
        return multiIcon;
    }

    private static final class Singleton {
        private static final FSBIcons INSTANCE = new FSBIcons();

        private Singleton() {
        }
    }
}

