/*
 * Decompiled with CFR 0.152.
 */
package ghidra.plugins.fsbrowser;

import docking.widgets.tree.GTreeNode;
import ghidra.formats.gfilesystem.FSRL;
import ghidra.formats.gfilesystem.FSUtilities;
import ghidra.formats.gfilesystem.FileSystemRef;
import ghidra.formats.gfilesystem.FileSystemService;
import ghidra.formats.gfilesystem.GFile;
import ghidra.formats.gfilesystem.GFileSystem;
import ghidra.formats.gfilesystem.GFileSystemProgramProvider;
import ghidra.plugins.fsbrowser.FSBFileNode;
import ghidra.plugins.fsbrowser.FSBNode;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class FSBRootNode
extends FSBNode {
    private FileSystemRef fsRef;
    private FSBFileNode prevNode;
    private FSBRootNode modelNode;
    private boolean cryptoStatusUpdated;

    FSBRootNode(FileSystemRef fsRef) {
        this(fsRef, null);
    }

    FSBRootNode(FileSystemRef fsRef, FSBFileNode prevNode) {
        this.fsRef = fsRef;
        this.prevNode = prevNode;
        this.modelNode = this;
    }

    public GTreeNode clone() throws CloneNotSupportedException {
        FSBRootNode clone = (FSBRootNode)super.clone();
        clone.fsRef = null;
        return clone;
    }

    public void dispose() {
        this.releaseFSRefIfModelNode();
        super.dispose();
    }

    @Override
    public void init(TaskMonitor monitor) throws CancelledException {
        this.setChildren(this.generateChildren(monitor));
    }

    public void setCryptoStatusUpdated(boolean cryptoStatusUpdated) {
        this.cryptoStatusUpdated = cryptoStatusUpdated;
    }

    boolean isCryptoStatusUpdated() {
        return this.cryptoStatusUpdated;
    }

    public void swapBackPrevModelNodeAndDispose() {
        if (this != this.modelNode) {
            this.modelNode.swapBackPrevModelNodeAndDispose();
            return;
        }
        int indexInParent = this.getIndexInParent();
        GTreeNode parent = this.getParent();
        parent.removeNode((GTreeNode)this);
        parent.addNode(indexInParent, (GTreeNode)this.prevNode);
        this.dispose();
    }

    @Override
    public GFile getGFile() {
        return this.fsRef.getFilesystem().getRootDir();
    }

    public FileSystemRef getFSRef() {
        return this.modelNode.fsRef;
    }

    private void releaseFSRefIfModelNode() {
        if (this != this.modelNode) {
            return;
        }
        FileSystemService.getInstance().releaseFileSystemImmediate(this.fsRef);
        this.fsRef = null;
    }

    @Override
    public void refreshNode(TaskMonitor monitor) throws CancelledException {
        if (this != this.modelNode) {
            this.modelNode.refreshNode(monitor);
            return;
        }
        this.refreshChildren(monitor);
        if (this.cryptoStatusUpdated) {
            // empty if block
        }
    }

    @Override
    public String getName() {
        return this.modelNode.fsRef != null && !this.modelNode.fsRef.isClosed() ? this.modelNode.fsRef.getFilesystem().getName() : " Missing ";
    }

    @Override
    public String getToolTip() {
        return this.getName();
    }

    public boolean isLeaf() {
        return false;
    }

    public List<GTreeNode> generateChildren(TaskMonitor monitor) throws CancelledException {
        if (this.fsRef != null) {
            try {
                return FSBNode.createNodesFromFileList(this.fsRef.getFilesystem().getListing(null), monitor);
            }
            catch (IOException e) {
                FSUtilities.displayException((Object)this, null, "Error Opening File System", "Problem generating children at root of file system", e);
            }
        }
        return List.of();
    }

    @Override
    public FSRL getFSRL() {
        return this.modelNode != null && this.modelNode.fsRef != null ? this.modelNode.fsRef.getFilesystem().getFSRL() : null;
    }

    public FSBNode getGFileFSBNode(GFile file, TaskMonitor monitor) {
        List<GFile> pathParts = this.splitGFilePath(file);
        FSBNode fileNode = this;
        for (int i = 1; fileNode != null && i < pathParts.size(); fileNode = fileNode.findMatchingNode(pathParts.get(i), monitor), ++i) {
            try {
                continue;
            }
            catch (CancelledException e) {
                return null;
            }
        }
        return fileNode;
    }

    public FSRL getContainer() {
        return this.fsRef != null ? this.fsRef.getFilesystem().getRootDir().getFSRL().getFS().getContainer() : null;
    }

    public String getContainerName() {
        return this.prevNode != null ? this.prevNode.getName() : "/";
    }

    private List<GFile> splitGFilePath(GFile f) {
        ArrayList<GFile> result = new ArrayList<GFile>();
        while (f != null) {
            result.add(0, f);
            f = f.getParentFile();
        }
        return result;
    }

    public FSRL getProgramProviderFSRL(FSRL fsrl) {
        GFileSystem fs = this.fsRef.getFilesystem();
        if (fs instanceof GFileSystemProgramProvider) {
            GFileSystemProgramProvider programProviderFS = (GFileSystemProgramProvider)((Object)fs);
            try {
                GFile gfile = fs.lookup(fsrl.getPath());
                if (gfile != null && programProviderFS.canProvideProgram(gfile)) {
                    return fsrl;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public FSRL getLoadableFSRL() {
        FSRL ppFSRL = this.getProgramProviderFSRL(this.getFSRL());
        if (ppFSRL != null) {
            return ppFSRL;
        }
        return this.getContainer();
    }
}

