/*
 * Decompiled with CFR 0.152.
 */
package ghidra.plugins.fsbrowser.filehandlers;

import docking.action.DockingAction;
import docking.action.builder.ActionBuilder;
import docking.widgets.label.GIconLabel;
import ghidra.formats.gfilesystem.FSRL;
import ghidra.formats.gfilesystem.FSUtilities;
import ghidra.formats.gfilesystem.GIconProvider;
import ghidra.formats.gfilesystem.RefdFile;
import ghidra.plugins.fsbrowser.FSBActionContext;
import ghidra.plugins.fsbrowser.FSBComponentProvider;
import ghidra.plugins.fsbrowser.FSBFileHandler;
import ghidra.plugins.fsbrowser.FSBFileHandlerContext;
import ghidra.plugins.fsbrowser.FSBFileNode;
import ghidra.plugins.fsbrowser.FSBIcons;
import ghidra.util.Msg;
import ghidra.util.Swing;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.awt.Component;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import org.apache.commons.io.FilenameUtils;

public class ImageFSBFileHandler
implements FSBFileHandler {
    public static final String FSB_VIEW_AS_IMAGE = "FSB View As Image";
    private static final Set<String> COMMON_IMAGE_EXTENSIONS = Set.of("png", "jpg", "jpeg", "gif");
    private FSBFileHandlerContext context;

    @Override
    public void init(FSBFileHandlerContext context) {
        this.context = context;
    }

    @Override
    public boolean fileDefaultAction(FSBFileNode fileNode) {
        FSRL fsrl = fileNode.getFSRL();
        String extension = FilenameUtils.getExtension((String)fsrl.getName().toLowerCase());
        if (COMMON_IMAGE_EXTENSIONS.contains(extension)) {
            FSBComponentProvider fsbComponent = this.context.fsbComponent();
            fsbComponent.runTask(monitor -> this.doViewAsImage(fileNode.getFSRL(), fsbComponent.getComponent(), monitor));
            return true;
        }
        return false;
    }

    @Override
    public List<DockingAction> createActions() {
        DockingAction action = (DockingAction)new ActionBuilder(FSB_VIEW_AS_IMAGE, this.context.plugin().getName()).withContext(FSBActionContext.class).enabledWhen(ac -> ac.notBusy() && ac.getFileFSRL() != null).popupMenuIcon(FSBIcons.VIEW_AS_IMAGE).popupMenuPath(new String[]{"View As", "Image"}).popupMenuGroup("G").onAction(ac -> {
            FSRL fsrl = ac.getFileFSRL();
            if (fsrl != null) {
                ac.getTree().runTask(monitor -> this.doViewAsImage(fsrl, (Component)ac.getSourceComponent(), monitor));
            }
        }).build();
        action.getPopupMenuData().setParentMenuGroup("C");
        return List.of(action);
    }

    void doViewAsImage(FSRL fsrl, Component parent, TaskMonitor monitor) {
        try (RefdFile refdFile = this.context.fsService().getRefdFile(fsrl, monitor);){
            Icon icon = GIconProvider.getIconForFile(refdFile.file, monitor);
            if (icon == null) {
                Msg.showError((Object)this, (Component)parent, (String)"Unable To View Image", (Object)("Unable to view " + fsrl.getName() + " as an image."));
                return;
            }
            Swing.runLater(() -> {
                GIconLabel label = new GIconLabel(icon);
                JOptionPane.showMessageDialog(null, label, "Image Viewer: " + fsrl.getName(), 1);
            });
        }
        catch (CancelledException | IOException e) {
            FSUtilities.displayException(this, parent, "Error Viewing Image File", e.getMessage(), e);
        }
    }
}

