/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.util;

import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.address.DefaultAddressFactory;
import ghidra.program.model.address.GenericAddressSpace;
import ghidra.program.model.listing.Program;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.DuplicateNameException;

class OffsetAddressFactory
extends DefaultAddressFactory {
    private int curMaxID = 0;

    OffsetAddressFactory(Program program) {
        super(program.getLanguage().getAddressFactory().getAllAddressSpaces(), program.getLanguage().getAddressFactory().getDefaultAddressSpace());
        for (AddressSpace space : program.getAddressFactory().getAllAddressSpaces()) {
            if (!space.isLoadedMemorySpace() || this.getAddressSpace(space.getName()) != null) continue;
            try {
                this.addAddressSpace(space);
            }
            catch (DuplicateNameException e) {
                throw new AssertException("Duplicate name should not occur.");
            }
        }
        try {
            GenericAddressSpace suspectConstspc = new GenericAddressSpace("SuspectConst", 64, 6, 0);
            this.addAddressSpace((AddressSpace)suspectConstspc);
        }
        catch (DuplicateNameException e) {
            throw new AssertException("Duplicate name should not occur.");
        }
        try {
            this.addAddressSpace(AddressSpace.EXTERNAL_SPACE);
        }
        catch (DuplicateNameException e) {
            throw new AssertException("Duplicate name should not occur.");
        }
    }

    private int getNextUniqueID() {
        if (this.curMaxID == 0) {
            AddressSpace[] spaces;
            for (AddressSpace space : spaces = this.getAllAddressSpaces()) {
                this.curMaxID = Math.max(this.curMaxID, space.getUnique());
            }
        }
        ++this.curMaxID;
        return this.curMaxID;
    }

    public AddressSpace createNewOffsetSpace(String name) {
        AddressSpace space = null;
        try {
            space = new GenericAddressSpace(name, this.getConstantSpace().getSize(), 9, this.getNextUniqueID());
            super.addAddressSpace(space);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        catch (DuplicateNameException e) {
            space = this.getAddressSpace(name);
        }
        return space;
    }

    public static boolean isSymbolSpace(int spaceID) {
        int type = 0xF & spaceID;
        return type == 9;
    }
}

