/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.table;

import docking.widgets.table.GTable;
import docking.widgets.table.WrappingTableModel;
import ghidra.app.nav.Navigatable;
import ghidra.app.services.GoToService;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.framework.plugintool.ServiceProviderStub;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.ProgramSelection;
import ghidra.util.Msg;
import ghidra.util.table.GhidraTableCellRenderer;
import ghidra.util.table.PreviewDataTableCellRenderer;
import ghidra.util.table.PreviewTableCellData;
import ghidra.util.table.ProgramTableModel;
import java.awt.Point;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class GhidraTable
extends GTable {
    private Navigatable navigatable;
    private ServiceProvider serviceProvider;
    private boolean navigateOnSelection;
    private KeyListener navigationKeyListener;
    private MouseListener navigationMouseListener;
    private ListSelectionListener navigationSelectionListener;

    public GhidraTable() {
    }

    public GhidraTable(TableModel model) {
        super(model);
    }

    protected void initDefaultRenderers() {
        super.initDefaultRenderers();
        GhidraTableCellRenderer ghidraTableCellRenderer = new GhidraTableCellRenderer();
        this.setDefaultRenderer(String.class, (TableCellRenderer)((Object)ghidraTableCellRenderer));
        this.setDefaultRenderer(Enum.class, (TableCellRenderer)((Object)ghidraTableCellRenderer));
        PreviewDataTableCellRenderer previewRenderer = new PreviewDataTableCellRenderer();
        this.setDefaultRenderer(PreviewTableCellData.class, (TableCellRenderer)((Object)previewRenderer));
    }

    @Deprecated
    public void installNavigation(GoToService goToService, Navigatable nav) {
        this.installNavigation((ServiceProvider)new GoToServiceProvider(this, goToService), nav);
    }

    public void installNavigation(ServiceProvider sp, Navigatable nav) {
        if (nav == null) {
            Msg.debug((Object)((Object)this), (Object)"Attempted to install navigation on a table using a null Navigatable");
        }
        this.navigatable = nav;
        this.installNavigation(sp);
    }

    public void installNavigation(ServiceProvider sp) {
        if (sp == null) {
            Msg.error((Object)((Object)this), (Object)"Attempt to install navigation on this table failed; service provider is null");
            return;
        }
        if (this.navigationKeyListener == null) {
            this.navigationKeyListener = new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 10) {
                        int selectedRow = GhidraTable.this.getSelectedRow();
                        int selectedColumn = GhidraTable.this.getSelectedColumn();
                        if (selectedRow < 0 || selectedColumn < 0) {
                            return;
                        }
                        GhidraTable.this.navigate(selectedRow, selectedColumn);
                        e.consume();
                    }
                }
            };
            this.addKeyListener(this.navigationKeyListener);
            this.navigationMouseListener = new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent e) {
                    if (e.getClickCount() == 2 && !GhidraTable.this.isEditing()) {
                        Point point = e.getPoint();
                        GhidraTable.this.navigate(GhidraTable.this.rowAtPoint(point), GhidraTable.this.columnAtPoint(point));
                    }
                }
            };
            this.addMouseListener(this.navigationMouseListener);
            this.navigationSelectionListener = new SelectionListener();
            this.selectionModel.addListSelectionListener(this.navigationSelectionListener);
        }
        this.serviceProvider = sp;
    }

    public void removeNavigation() {
        this.removeKeyListener(this.navigationKeyListener);
        this.removeMouseListener(this.navigationMouseListener);
        this.selectionModel.removeListSelectionListener(this.navigationSelectionListener);
        this.serviceProvider = null;
        this.navigatable = null;
    }

    public ProgramSelection getProgramSelection() {
        ProgramTableModel programTableModel = this.getProgramTableModel(this.dataModel);
        if (programTableModel == null) {
            return null;
        }
        int[] viewRows = this.getSelectedRows();
        int[] modelRows = new int[viewRows.length];
        for (int i = 0; i < viewRows.length; ++i) {
            modelRows[i] = this.getModelRow(viewRows[i]);
        }
        return programTableModel.getProgramSelection(modelRows);
    }

    public Program getProgram() {
        ProgramTableModel programTableModel = this.getProgramTableModel(this.dataModel);
        if (programTableModel == null) {
            return null;
        }
        return programTableModel.getProgram();
    }

    private ProgramTableModel getProgramTableModel(TableModel model) {
        TableModel baseModel = this.getUnwrappedTableModel();
        if (baseModel instanceof ProgramTableModel) {
            return (ProgramTableModel)((Object)baseModel);
        }
        return null;
    }

    public void navigate(int row, int column) {
        if (this.serviceProvider == null) {
            return;
        }
        int modelColumn = this.convertColumnIndexToModel(column);
        if (row < 0 || column < 0) {
            return;
        }
        ProgramTableModel programModel = this.getProgramTableModel(this.dataModel);
        if (programModel == null) {
            return;
        }
        GoToService goToService = (GoToService)this.serviceProvider.getService(GoToService.class);
        if (goToService == null) {
            return;
        }
        int modelRow = this.getModelRow(row);
        ProgramLocation loc = programModel.getProgramLocation(modelRow, modelColumn);
        if (loc != null && loc.getAddress().isExternalAddress()) {
            goToService.goTo(loc.getAddress(), programModel.getProgram());
            return;
        }
        Program program = programModel.getProgram();
        goToService.goTo(this.navigatable, loc, program);
    }

    private int getModelRow(int viewRow) {
        if (this.dataModel instanceof WrappingTableModel) {
            return ((WrappingTableModel)this.dataModel).getModelRow(viewRow);
        }
        return viewRow;
    }

    private void navigateOnCurrentSelection(int row, int column) {
        if (!this.navigateOnSelection) {
            return;
        }
        if (!this.isFocusOwner()) {
            return;
        }
        this.navigate(row, column);
    }

    public void setNavigateOnSelectionEnabled(boolean enabled) {
        this.navigateOnSelection = enabled;
    }

    public void setValueAt(Object aValue, int row, int column) {
        if (this.programIsClosed()) {
            return;
        }
        super.setValueAt(aValue, row, column);
    }

    private boolean programIsClosed() {
        if (!(this.dataModel instanceof ProgramTableModel)) {
            return false;
        }
        ProgramTableModel ptm = (ProgramTableModel)((Object)this.dataModel);
        Program program = ptm.getProgram();
        return program == null;
    }

    public void selectRow(int row) {
        super.selectRow(row);
        this.navigateOnCurrentSelection(row, 0);
    }

    public void dispose() {
        super.dispose();
        this.navigationKeyListener = null;
        this.navigationMouseListener = null;
        this.navigationSelectionListener = null;
    }

    private class GoToServiceProvider
    extends ServiceProviderStub {
        private GoToService goToService;

        GoToServiceProvider(GhidraTable ghidraTable, GoToService goToService) {
            this.goToService = goToService;
            if (goToService == null) {
                Msg.error((Object)((Object)this), (Object)"Attempt to install the GoToService on this table failed; service is null");
            }
        }

        public <T> T getService(Class<T> serviceClass) {
            if (serviceClass == GoToService.class) {
                return (T)this.goToService;
            }
            return null;
        }
    }

    private class SelectionListener
    implements ListSelectionListener {
        private SelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            if (GhidraTable.this.getSelectedRowCount() != 1) {
                return;
            }
            int column = Math.max(0, GhidraTable.this.getSelectedColumn());
            GhidraTable.this.navigateOnCurrentSelection(GhidraTable.this.getSelectedRow(), column);
        }
    }
}

