/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.elf.relocation;

import ghidra.app.util.MemoryBlockUtils;
import ghidra.app.util.bin.format.elf.ElfLoadHelper;
import ghidra.app.util.bin.format.elf.ElfRelocation;
import ghidra.app.util.bin.format.elf.ElfSymbol;
import ghidra.app.util.bin.format.elf.relocation.ElfRelocationContext;
import ghidra.app.util.bin.format.elf.relocation.ElfRelocationHandler;
import ghidra.app.util.bin.format.elf.relocation.MIPS_Elf64Relocation;
import ghidra.app.util.bin.format.elf.relocation.MIPS_ElfRelocationHandler;
import ghidra.app.util.bin.format.elf.relocation.MIPS_ElfRelocationType;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.reloc.Relocation;
import ghidra.program.model.reloc.RelocationResult;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolUtilities;
import ghidra.util.BigEndianDataConverter;
import ghidra.util.LittleEndianDataConverter;
import ghidra.util.exception.AssertException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

class MIPS_ElfRelocationContext
extends ElfRelocationContext<MIPS_ElfRelocationHandler> {
    private LinkedList<MIPS_ElfRelocationHandler.MIPS_DeferredRelocation> hi16list = new LinkedList();
    private LinkedList<MIPS_ElfRelocationHandler.MIPS_DeferredRelocation> got16list = new LinkedList();
    private AddressRange sectionGotLimits;
    private Address sectionGotAddress;
    private Address lastSectionGotEntryAddress;
    private Address nextSectionGotEntryAddress;
    private Map<Long, Address> gotMap;
    boolean saveValueForNextReloc;
    boolean useSavedAddend = false;
    boolean savedAddendHasError = false;
    long savedAddend;
    ElfSymbol lastElfSymbol;
    Address lastSymbolAddr;

    MIPS_ElfRelocationContext(MIPS_ElfRelocationHandler handler, ElfLoadHelper loadHelper, Map<ElfSymbol, Address> symbolMap) {
        super((ElfRelocationHandler)handler, loadHelper, symbolMap);
    }

    protected RelocationResult processRelocation(ElfRelocation relocation, ElfSymbol elfSymbol, Address relocationAddress) throws MemoryAccessException {
        this.lastSymbolAddr = null;
        this.lastElfSymbol = null;
        int typeId = relocation.getType();
        int symbolIndex = relocation.getSymbolIndex();
        this.saveValueForNextReloc = this.nextRelocationHasSameOffset(relocation);
        RelocationResult lastResult = RelocationResult.FAILURE;
        if (this.getElfHeader().is64Bit()) {
            MIPS_Elf64Relocation mips64Relocation = (MIPS_Elf64Relocation)relocation;
            for (int n = 0; n < 3; ++n) {
                RelocationResult result;
                int nextRelocType;
                symbolIndex = n == 1 ? mips64Relocation.getSpecialSymbolIndex() : 0;
                int relocType = typeId & 0xFF;
                int n2 = nextRelocType = n < 2 ? (typeId >>= 8) & 0xFF : 0;
                if (nextRelocType == MIPS_ElfRelocationType.R_MIPS_NONE.typeId) {
                    this.saveValueForNextReloc = false;
                }
                if ((result = this.doRelocate(mips64Relocation, relocationAddress, relocType, symbolIndex)).status() == Relocation.Status.FAILURE || result.status() == Relocation.Status.UNSUPPORTED) {
                    return result;
                }
                lastResult = result;
                if (nextRelocType == MIPS_ElfRelocationType.R_MIPS_NONE.typeId) break;
            }
            return lastResult;
        }
        return this.doRelocate(relocation, relocationAddress, typeId, symbolIndex);
    }

    private RelocationResult doRelocate(ElfRelocation relocation, Address relocationAddress, int relocType, int symbolIndex) throws MemoryAccessException {
        if (relocType == 0) {
            return RelocationResult.SKIPPED;
        }
        ElfSymbol elfSymbol = this.getSymbol(symbolIndex);
        Address symbolAddr = this.getSymbolAddress(elfSymbol);
        long symbolValue = this.getSymbolValue(elfSymbol);
        String symbolName = elfSymbol != null ? elfSymbol.getNameAsString() : null;
        MIPS_ElfRelocationType relocationType = (MIPS_ElfRelocationType)((MIPS_ElfRelocationHandler)this.handler).getRelocationType(relocType);
        if (relocationType == null) {
            ((MIPS_ElfRelocationHandler)this.handler).markAsUndefined(this.program, relocationAddress, relocType, symbolName, symbolIndex, this.getLog());
            return RelocationResult.UNSUPPORTED;
        }
        return ((MIPS_ElfRelocationHandler)this.handler).relocate(this, relocation, relocationType, relocationAddress, this.getSymbol(symbolIndex), symbolAddr, symbolValue, symbolName);
    }

    public void endRelocationTableProcessing() {
        for (MIPS_ElfRelocationHandler.MIPS_DeferredRelocation reloc : this.hi16list) {
            reloc.markUnprocessed(this, "LO16 Relocation");
        }
        this.hi16list.clear();
        for (MIPS_ElfRelocationHandler.MIPS_DeferredRelocation reloc : this.got16list) {
            reloc.markUnprocessed(this, "LO16 Relocation");
        }
        this.got16list.clear();
        this.createGot();
        this.sectionGotLimits = null;
        this.sectionGotAddress = null;
        this.lastSectionGotEntryAddress = null;
        this.nextSectionGotEntryAddress = null;
        this.gotMap = null;
        this.useSavedAddend = false;
        this.savedAddendHasError = false;
        this.lastSymbolAddr = null;
        this.lastElfSymbol = null;
        super.endRelocationTableProcessing();
    }

    private void allocateSectionGot() {
        int alignment = this.getLoadAdapter().getLinkageBlockAlignment();
        this.sectionGotLimits = this.getLoadHelper().allocateLinkageBlock(alignment, 65536, this.getSectionGotName());
        this.nextSectionGotEntryAddress = this.sectionGotAddress = this.sectionGotLimits != null ? this.sectionGotLimits.getMinAddress() : Address.NO_ADDRESS;
        if (this.sectionGotLimits == null) {
            this.loadHelper.log("Failed to allocate " + this.getSectionGotName() + " block required for relocation processing");
        } else {
            this.loadHelper.log("Created " + this.getSectionGotName() + " block required for relocation processing (gp=0x" + Long.toHexString(this.getGPValue()) + ")");
        }
    }

    private Address getNextSectionGotEntryAddress() {
        Address addr;
        block6: {
            if (this.nextSectionGotEntryAddress == null) {
                this.allocateSectionGot();
            }
            if ((addr = this.nextSectionGotEntryAddress) != Address.NO_ADDRESS) {
                try {
                    int pointerSize = this.loadHelper.getProgram().getDefaultPointerSize();
                    Address lastAddr = this.nextSectionGotEntryAddress.addNoWrap((long)(pointerSize - 1));
                    if (this.sectionGotLimits.contains(lastAddr)) {
                        this.lastSectionGotEntryAddress = lastAddr;
                        this.nextSectionGotEntryAddress = this.lastSectionGotEntryAddress.addNoWrap(1L);
                        if (!this.sectionGotLimits.contains(this.nextSectionGotEntryAddress)) {
                            this.nextSectionGotEntryAddress = Address.NO_ADDRESS;
                        }
                        break block6;
                    }
                    this.nextSectionGotEntryAddress = Address.NO_ADDRESS;
                    return Address.NO_ADDRESS;
                }
                catch (AddressOverflowException e) {
                    this.nextSectionGotEntryAddress = Address.NO_ADDRESS;
                }
            }
        }
        return addr != Address.NO_ADDRESS ? addr : null;
    }

    public long getGPValue() {
        long gp = this.getAdjustedGPValue();
        if (gp == -1L) {
            if (this.sectionGotAddress == null) {
                this.allocateSectionGot();
            }
            if (this.sectionGotAddress == Address.NO_ADDRESS) {
                return -1L;
            }
            return this.sectionGotAddress.getOffset() + 32752L;
        }
        return gp;
    }

    public boolean extractAddend() {
        return !this.relocationTable.hasAddendRelocations() && !this.useSavedAddend;
    }

    boolean nextRelocationHasSameOffset(ElfRelocation relocation) {
        ElfRelocation[] relocations = this.relocationTable.getRelocations();
        int relocIndex = relocation.getRelocationIndex();
        if (relocIndex < 0 || relocIndex >= relocations.length - 1) {
            return false;
        }
        return relocations[relocIndex].getOffset() == relocations[relocIndex + 1].getOffset() && relocations[relocIndex + 1].getType() != MIPS_ElfRelocationType.R_MIPS_NONE.typeId;
    }

    public Address getSectionGotAddress(long symbolValue) {
        Address addr = null;
        if (this.gotMap == null) {
            this.gotMap = new HashMap<Long, Address>();
        } else {
            addr = this.gotMap.get(symbolValue);
        }
        if (addr == null) {
            addr = this.getNextSectionGotEntryAddress();
            if (addr == null) {
                return null;
            }
            this.gotMap.put(symbolValue, addr);
        }
        return addr;
    }

    private String getSectionGotName() {
        String sectionName = this.relocationTable.getSectionToBeRelocated().getNameAsString();
        return "%got" + sectionName;
    }

    private void createGot() {
        if (this.lastSectionGotEntryAddress == null) {
            return;
        }
        int size = (int)this.lastSectionGotEntryAddress.subtract(this.sectionGotAddress) + 1;
        String blockName = this.getSectionGotName();
        try {
            MemoryBlock block = MemoryBlockUtils.createInitializedBlock((Program)this.program, (boolean)false, (String)blockName, (Address)this.sectionGotAddress, (long)size, (String)"NOTE: This block is artificial and allows ELF Relocations to work correctly", (String)"Elf Loader", (boolean)true, (boolean)false, (boolean)false, (MessageLog)this.loadHelper.getLog());
            block.setArtificial(true);
            BigEndianDataConverter converter = this.program.getMemory().isBigEndian() ? BigEndianDataConverter.INSTANCE : LittleEndianDataConverter.INSTANCE;
            for (long symbolValue : this.gotMap.keySet()) {
                Address addr = this.gotMap.get(symbolValue);
                byte[] bytes = this.program.getDefaultPointerSize() == 4 ? converter.getBytes((int)symbolValue) : converter.getBytes(symbolValue);
                block.putBytes(addr, bytes);
                this.loadHelper.createData(addr, (DataType)PointerDataType.dataType);
            }
        }
        catch (MemoryAccessException e) {
            throw new AssertException((Throwable)e);
        }
    }

    long getAdjustedGPValue() {
        Symbol symbol = SymbolUtilities.getLabelOrFunctionSymbol((Program)this.program, (String)"_mips_gp_value", err -> this.getLog().appendMsg("MIPS_ELF", err));
        if (symbol == null) {
            return -1L;
        }
        return symbol.getAddress().getOffset();
    }

    long getGP0Value() {
        Symbol symbol = SymbolUtilities.getLabelOrFunctionSymbol((Program)this.program, (String)"_mips_gp0_value", err -> this.getLog().appendMsg("MIPS_ELF", err));
        if (symbol == null) {
            return -1L;
        }
        return symbol.getAddress().getOffset();
    }

    public long getSymbolValue(ElfSymbol symbol) {
        if ("__gnu_local_gp".equals(symbol.getNameAsString())) {
            return this.getAdjustedGPValue();
        }
        return super.getSymbolValue(symbol);
    }

    Iterator<MIPS_ElfRelocationHandler.MIPS_DeferredRelocation> iterateHi16() {
        return this.hi16list.iterator();
    }

    void addHI16Relocation(MIPS_ElfRelocationHandler.MIPS_DeferredRelocation hi16reloc) {
        this.hi16list.add(hi16reloc);
    }

    Iterator<MIPS_ElfRelocationHandler.MIPS_DeferredRelocation> iterateGot16() {
        return this.got16list.iterator();
    }

    void addGOT16Relocation(MIPS_ElfRelocationHandler.MIPS_DeferredRelocation got16reloc) {
        this.got16list.add(got16reloc);
    }
}

