/*
 * Decompiled with CFR 0.152.
 */
package sarif;

import com.contrastsecurity.sarif.Location;
import com.contrastsecurity.sarif.Result;
import com.contrastsecurity.sarif.SarifSchema210;
import docking.widgets.table.ObjectSelectedListener;
import ghidra.app.plugin.core.colorizer.ColorizingService;
import ghidra.app.services.GraphDisplayBroker;
import ghidra.framework.plugintool.Plugin;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.BookmarkManager;
import ghidra.program.model.listing.Program;
import ghidra.service.graph.AttributedGraph;
import ghidra.service.graph.EmptyGraphType;
import ghidra.service.graph.GraphDisplay;
import ghidra.service.graph.GraphDisplayOptions;
import ghidra.service.graph.GraphType;
import ghidra.util.Msg;
import ghidra.util.classfinder.ClassSearcher;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.GraphException;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import resources.ResourceManager;
import sarif.SarifPlugin;
import sarif.SarifUtils;
import sarif.handlers.SarifResultHandler;
import sarif.handlers.SarifRunHandler;
import sarif.managers.ProgramSarifMgr;
import sarif.model.SarifDataFrame;
import sarif.view.ImageArtifactDisplay;
import sarif.view.SarifResultsTableProvider;

public class SarifController
implements ObjectSelectedListener<Map<String, Object>> {
    private SarifPlugin plugin;
    private Program program;
    private ColorizingService coloringService;
    private BookmarkManager bookmarkManager;
    private ProgramSarifMgr programManager;
    private Set<SarifResultsTableProvider> providers = new HashSet<SarifResultsTableProvider>();
    public Set<ImageArtifactDisplay> artifacts = new HashSet<ImageArtifactDisplay>();
    public Set<GraphDisplay> graphs = new HashSet<GraphDisplay>();

    public Set<SarifResultHandler> getSarifResultHandlers() {
        HashSet<SarifResultHandler> set = new HashSet<SarifResultHandler>();
        set.addAll(ClassSearcher.getInstances(SarifResultHandler.class));
        return set;
    }

    public Set<SarifRunHandler> getSarifRunHandlers() {
        HashSet<SarifRunHandler> set = new HashSet<SarifRunHandler>();
        set.addAll(ClassSearcher.getInstances(SarifRunHandler.class));
        return set;
    }

    public SarifController(Program program, SarifPlugin plugin) {
        this.program = program;
        this.plugin = plugin;
        this.coloringService = (ColorizingService)plugin.getTool().getService(ColorizingService.class);
        this.programManager = new ProgramSarifMgr(program);
    }

    public SarifController(ProgramSarifMgr manager) {
        this.program = null;
        this.plugin = null;
        this.coloringService = null;
        this.programManager = manager;
    }

    public void dispose() {
        HashSet<SarifResultsTableProvider> copyProviders = new HashSet<SarifResultsTableProvider>();
        copyProviders.addAll(this.providers);
        for (SarifResultsTableProvider p : copyProviders) {
            p.dispose();
        }
        HashSet<ImageArtifactDisplay> copyArtifacts = new HashSet<ImageArtifactDisplay>();
        copyArtifacts.addAll(this.artifacts);
        for (ImageArtifactDisplay a : copyArtifacts) {
            a.dispose();
        }
        for (GraphDisplay g : this.graphs) {
            g.close();
        }
    }

    public void showTable(boolean makeVisible) {
        for (SarifResultsTableProvider p : this.providers) {
            p.setVisible(makeVisible);
        }
    }

    public void showTable(String logName, SarifSchema210 sarif) {
        SarifDataFrame df = new SarifDataFrame(sarif, this, false);
        SarifResultsTableProvider provider = new SarifResultsTableProvider(logName, (Plugin)this.plugin, this, df);
        provider.filterTable.addSelectionListener((ObjectSelectedListener)this);
        provider.addToTool();
        provider.setVisible(true);
        provider.setTitle(logName);
        if (!this.providers.contains((Object)provider)) {
            this.providers.add(provider);
        }
    }

    public void showImage(String key, BufferedImage img) {
        if (this.plugin.displayArtifacts()) {
            ImageArtifactDisplay display = new ImageArtifactDisplay(this.plugin.getTool(), key, "Sarif Parse", img);
            display.setVisible(true);
            this.artifacts.add(display);
        }
    }

    public void showGraph(AttributedGraph graph) {
        try {
            GraphDisplayBroker service = (GraphDisplayBroker)this.plugin.getTool().getService(GraphDisplayBroker.class);
            boolean append = this.plugin.appendToGraph();
            GraphDisplay display = service.getDefaultGraphDisplay(append, null);
            GraphDisplayOptions graphOptions = new GraphDisplayOptions((GraphType)new EmptyGraphType());
            graphOptions.setMaxNodeCount(this.plugin.getGraphSize());
            if (this.plugin.displayGraphs()) {
                display.setGraph(graph, graphOptions, graph.getDescription(), append, null);
                this.graphs.add(display);
            }
        }
        catch (CancelledException | GraphException e) {
            Msg.error((Object)this, (Object)("showGraph failed " + e.getMessage()));
        }
    }

    public void handleListingAction(Result result, String key, Object value) {
        List<Address> addrs = this.getListingAddresses(result);
        for (Address addr : addrs) {
            switch (key) {
                case "comment": {
                    String comment = (String)value;
                    this.getProgram().getListing().setComment(addr, 3, comment);
                    break;
                }
                case "highlight": {
                    Color color = Color.decode((String)value);
                    this.coloringService.setBackgroundColor(addr, addr, color);
                    break;
                }
                case "bookmark": {
                    String bookmark = (String)value;
                    this.getProgram().getBookmarkManager().setBookmark(addr, "Sarif", result.getRuleId(), bookmark);
                }
            }
        }
    }

    public void colorBackground(AddressSetView set, Color color) {
        this.coloringService.setBackgroundColor(set, color);
    }

    public void colorBackground(Address addr, Color color) {
        this.coloringService.setBackgroundColor(addr, addr, color);
    }

    public List<Address> getListingAddresses(Result result) {
        ArrayList<Address> addrs = new ArrayList<Address>();
        if (result.getLocations() != null && result.getLocations().size() > 0) {
            List locations = result.getLocations();
            for (Location loc : locations) {
                Address addr = this.locationToAddress(loc);
                if (addr == null) continue;
                addrs.add(addr);
            }
        }
        return addrs;
    }

    public Address locationToAddress(Location location) {
        return SarifUtils.locationToAddress(location, this.program);
    }

    public void objectSelected(Map<String, Object> row) {
        if (row != null) {
            if (row.containsKey("CodeFlows")) {
                for (List flow : (List)row.get("CodeFlows")) {
                    this.plugin.makeSelection(flow);
                }
            }
            if (row.containsKey("Graphs")) {
                for (AttributedGraph graph : (List)row.get("Graphs")) {
                    this.showGraph(graph);
                }
            }
        }
    }

    public void removeProvider(SarifResultsTableProvider provider) {
        this.providers.remove((Object)provider);
    }

    public ProgramSarifMgr getProgramSarifMgr() {
        return this.programManager;
    }

    public Program getProgram() {
        return this.program;
    }

    public void setProgram(Program program) {
        this.program = program;
        this.bookmarkManager = program.getBookmarkManager();
        this.bookmarkManager.defineType("Sarif", (Icon)ResourceManager.loadImage((String)"images/peach_16.png"), Color.pink, 0);
    }
}

