/*
 * Decompiled with CFR 0.152.
 */
package sarif;

import ghidra.app.plugin.core.analysis.AnalysisWorker;
import ghidra.app.plugin.core.analysis.AutoAnalysisManager;
import ghidra.app.util.Option;
import ghidra.app.util.OptionException;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.importer.MessageLog;
import ghidra.app.util.opinion.AbstractProgramLoader;
import ghidra.app.util.opinion.LoadException;
import ghidra.app.util.opinion.LoadSpec;
import ghidra.app.util.opinion.Loaded;
import ghidra.app.util.opinion.Loader;
import ghidra.app.util.opinion.LoaderTier;
import ghidra.framework.model.DomainObject;
import ghidra.framework.model.Project;
import ghidra.program.model.address.Address;
import ghidra.program.model.lang.CompilerSpec;
import ghidra.program.model.lang.CompilerSpecDescription;
import ghidra.program.model.lang.CompilerSpecNotFoundException;
import ghidra.program.model.lang.Endian;
import ghidra.program.model.lang.ExternalLanguageCompilerSpecQuery;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.LanguageCompilerSpecPair;
import ghidra.program.model.lang.LanguageDescription;
import ghidra.program.model.lang.LanguageNotFoundException;
import ghidra.program.model.listing.Program;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import sarif.SarifProgramOptions;
import sarif.export.SarifObject;
import sarif.managers.ProgramInfo;
import sarif.managers.ProgramSarifMgr;

public class SarifLoader
extends AbstractProgramLoader {
    private static final String FILE_EXTENSION = SarifObject.SARIF ? ".sarif" : ".json";
    public static final String SARIF_SRC_NAME = "SARIF Input Format";
    private static Pattern ADDRESS_MODEL_PATTERN = Pattern.compile("(\\d+)-bit");

    public LoaderTier getTier() {
        return LoaderTier.SPECIALIZED_TARGET_LOADER;
    }

    public int getTierPriority() {
        return 50;
    }

    public boolean supportsLoadIntoProgram() {
        return true;
    }

    public Collection<LoadSpec> findSupportedLoadSpecs(ByteProvider provider) throws IOException {
        ArrayList<LoadSpec> loadSpecs;
        block14: {
            loadSpecs = new ArrayList<LoadSpec>();
            this.getLanguageService();
            ParseResult result = this.parse(provider);
            ProgramInfo info = result.lastInfo;
            if (info == null) {
                return loadSpecs;
            }
            if (info.languageID != null) {
                try {
                    LanguageDescription languageDescription = this.getLanguageService().getLanguageDescription(info.languageID);
                    boolean preferred = false;
                    if (info.compilerSpecID == null) {
                        for (CompilerSpecDescription csd : languageDescription.getCompatibleCompilerSpecDescriptions()) {
                            LanguageCompilerSpecPair pair = new LanguageCompilerSpecPair(languageDescription.getLanguageID(), csd.getCompilerSpecID());
                            loadSpecs.add(new LoadSpec((Loader)this, 0L, pair, preferred));
                        }
                        break block14;
                    }
                    languageDescription.getCompilerSpecDescriptionByID(info.compilerSpecID);
                    LanguageCompilerSpecPair pair = new LanguageCompilerSpecPair(info.languageID, info.compilerSpecID);
                    preferred = true;
                    loadSpecs.add(new LoadSpec((Loader)this, 0L, pair, preferred));
                }
                catch (CompilerSpecNotFoundException | LanguageNotFoundException languageDescription) {}
            } else if (info.processorName != null) {
                Integer size = this.extractSize(info.addressModel);
                Endian endian = Endian.toEndian((String)info.endian);
                ExternalLanguageCompilerSpecQuery broadQuery = new ExternalLanguageCompilerSpecQuery(info.processorName, info.getNormalizedExternalToolName(), endian, size, info.compilerSpecID);
                List pairs = this.getLanguageService().getLanguageCompilerSpecPairs(broadQuery);
                if (!pairs.isEmpty()) {
                    boolean preferred = false;
                    if (pairs.size() == 1) {
                        preferred = true;
                    }
                    for (LanguageCompilerSpecPair pair : pairs) {
                        loadSpecs.add(new LoadSpec((Loader)this, 0L, pair, preferred));
                    }
                }
            }
        }
        if (loadSpecs.isEmpty() && provider.getName().endsWith(FILE_EXTENSION)) {
            List languageDescriptions = this.getLanguageService().getLanguageDescriptions(false);
            for (LanguageDescription languageDescription : languageDescriptions) {
                Collection compilerSpecDescriptions = languageDescription.getCompatibleCompilerSpecDescriptions();
                for (CompilerSpecDescription compilerSpecDescription : compilerSpecDescriptions) {
                    LanguageCompilerSpecPair pair;
                    pair = new LanguageCompilerSpecPair(languageDescription.getLanguageID(), compilerSpecDescription.getCompilerSpecID());
                    loadSpecs.add(new LoadSpec((Loader)this, 0L, pair, false));
                }
            }
        }
        return loadSpecs;
    }

    private Integer extractSize(String addressModel) {
        Matcher matcher;
        if (addressModel != null && (matcher = ADDRESS_MODEL_PATTERN.matcher(addressModel)).find()) {
            return Integer.parseInt(matcher.group(1));
        }
        return null;
    }

    public String getPreferredFileName(ByteProvider provider) {
        String name = provider.getName();
        if (name.toLowerCase().endsWith(FILE_EXTENSION)) {
            return name.substring(0, name.length() - FILE_EXTENSION.length());
        }
        return name;
    }

    protected List<Loaded<Program>> loadProgram(ByteProvider provider, String programName, Project project, String programFolderPath, LoadSpec loadSpec, List<Option> options, MessageLog log, Object consumer, TaskMonitor monitor) throws IOException, LoadException, CancelledException {
        LanguageCompilerSpecPair pair = loadSpec.getLanguageCompilerSpec();
        Language importerLanguage = this.getLanguageService().getLanguage(pair.languageID);
        CompilerSpec importerCompilerSpec = importerLanguage.getCompilerSpecByID(pair.compilerSpecID);
        ParseResult result = this.parse(provider);
        Address imageBase = null;
        if (result.lastInfo.imageBase != null) {
            imageBase = importerLanguage.getAddressFactory().getAddress(result.lastInfo.imageBase);
        }
        Program prog = this.createProgram(provider, programName, imageBase, this.getName(), importerLanguage, importerCompilerSpec, consumer);
        List<Loaded<Program>> loadedList = List.of(new Loaded((DomainObject)prog, programName, programFolderPath));
        boolean success = false;
        try {
            success = this.doImport(result.lastSarifMgr, options, log, prog, monitor, false);
            if (success) {
                this.createDefaultMemoryBlocks(prog, importerLanguage, log);
                List<Loaded<Program>> list = loadedList;
                return list;
            }
            throw new LoadException("Failed to load");
        }
        finally {
            if (!success) {
                this.release(loadedList, consumer);
            }
        }
    }

    protected void loadProgramInto(ByteProvider provider, LoadSpec loadSpec, List<Option> options, MessageLog log, Program prog, TaskMonitor monitor) throws IOException, LoadException, CancelledException {
        File file = provider.getFile();
        this.doImport(new ProgramSarifMgr(prog, file), options, log, prog, monitor, true);
    }

    private boolean doImportWork(ProgramSarifMgr mgr, List<Option> options, MessageLog log, Program prog, TaskMonitor monitor, boolean isAddToProgram) throws LoadException {
        boolean success = true;
        try {
            SarifProgramOptions sarifOptions = mgr.getOptions();
            sarifOptions.setOptions(options);
            sarifOptions.setAddToProgram(isAddToProgram);
            mgr.read(prog, monitor);
            success = true;
        }
        catch (Exception e) {
            String message = "(empty)";
            if (log != null && !"".equals(log.toString())) {
                message = log.toString();
            }
            Msg.warn((Object)((Object)this), (Object)("SARIF import exception, log: " + message), (Throwable)e);
            throw new LoadException(e.getMessage());
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doImport(final ProgramSarifMgr mgr, final List<Option> options, final MessageLog log, Program prog, TaskMonitor monitor, final boolean isAddToProgram) throws IOException {
        if (!AutoAnalysisManager.hasAutoAnalysisManager((Program)prog)) {
            int txId = prog.startTransaction("SARIF Import");
            try {
                boolean bl = this.doImportWork(mgr, options, log, prog, monitor, isAddToProgram);
                return bl;
            }
            finally {
                prog.endTransaction(txId, true);
            }
        }
        AutoAnalysisManager analysisMgr = AutoAnalysisManager.getAnalysisManager((Program)prog);
        try {
            return analysisMgr.scheduleWorker(new AnalysisWorker(){

                public String getWorkerName() {
                    return "SARIF Importer";
                }

                public boolean analysisWorkerCallback(Program program, Object workerContext, TaskMonitor taskMonitor) throws Exception, CancelledException {
                    return SarifLoader.this.doImportWork(mgr, options, log, program, taskMonitor, isAddToProgram);
                }
            }, null, false, monitor);
        }
        catch (CancelledException e) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private ParseResult parse(ByteProvider provider) throws IOException {
        try {
            ProgramSarifMgr lastSarifMgr = new ProgramSarifMgr(provider);
            ProgramInfo lastInfo = lastSarifMgr.getProgramInfo();
            return new ParseResult(lastSarifMgr, lastInfo);
        }
        catch (Throwable e) {
            throw new IOException("Unable to parse " + provider.getName() + "as SARIF");
        }
    }

    public List<Option> getDefaultOptions(ByteProvider provider, LoadSpec loadSpec, DomainObject domainObject, boolean loadIntoProgram) {
        return new SarifProgramOptions().getOptions(loadIntoProgram);
    }

    public String getName() {
        return SARIF_SRC_NAME;
    }

    public String validateOptions(ByteProvider provider, LoadSpec loadSpec, List<Option> options, Program program) {
        try {
            new SarifProgramOptions().setOptions(options);
        }
        catch (OptionException e) {
            return e.getMessage();
        }
        return null;
    }

    private static class ParseResult {
        final ProgramSarifMgr lastSarifMgr;
        final ProgramInfo lastInfo;

        ParseResult(ProgramSarifMgr lastSarifMgr, ProgramInfo lastInfo) {
            this.lastSarifMgr = lastSarifMgr;
            this.lastInfo = lastInfo;
        }
    }
}

