/*
 * Decompiled with CFR 0.152.
 */
package sarif;

import com.contrastsecurity.sarif.Artifact;
import com.contrastsecurity.sarif.ArtifactContent;
import com.contrastsecurity.sarif.ArtifactLocation;
import com.contrastsecurity.sarif.Location;
import com.contrastsecurity.sarif.PhysicalLocation;
import com.contrastsecurity.sarif.ReportingDescriptor;
import com.contrastsecurity.sarif.ReportingDescriptorReference;
import com.contrastsecurity.sarif.Run;
import com.contrastsecurity.sarif.ToolComponent;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import ghidra.framework.store.LockException;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.address.OverlayAddressSpace;
import ghidra.program.model.listing.Program;
import ghidra.util.InvalidNameException;
import ghidra.util.exception.DuplicateNameException;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bouncycastle.util.encoders.Base64;

public class SarifUtils {
    public static JsonArray setLocations(Address min, Address max) {
        AddressSet set = new AddressSet(min, max);
        return SarifUtils.setLocations((AddressSetView)set);
    }

    public static JsonArray setLocations(AddressSetView set) {
        JsonArray locations = new JsonArray();
        AddressRangeIterator addressRanges = set.getAddressRanges();
        while (addressRanges.hasNext()) {
            JsonObject element = new JsonObject();
            locations.add((JsonElement)element);
            AddressRange next = (AddressRange)addressRanges.next();
            JsonObject ploc = new JsonObject();
            element.add("physicalLocation", (JsonElement)ploc);
            JsonObject address = new JsonObject();
            ploc.add("address", (JsonElement)address);
            address.addProperty("absoluteAddress", (Number)next.getMinAddress().getOffset());
            address.addProperty("length", (Number)next.getLength());
            Address minAddress = next.getMinAddress();
            AddressSpace addressSpace = minAddress.getAddressSpace();
            if (!addressSpace.showSpaceName()) continue;
            address.addProperty("fullyQualifiedName", addressSpace.getName());
            if (!(addressSpace instanceof OverlayAddressSpace)) continue;
            OverlayAddressSpace ospace = (OverlayAddressSpace)addressSpace;
            JsonObject artifact = new JsonObject();
            ploc.add("artifactLocation", (JsonElement)artifact);
            String name = ospace.getOverlayedSpace().getName();
            artifact.addProperty("uri", name);
        }
        return locations;
    }

    public static AddressSet getLocations(Map<String, Object> result, Program program, AddressSet set) throws AddressOverflowException {
        List locations;
        if (set == null) {
            set = new AddressSet();
        }
        if ((locations = (List)result.get("Locations")) == null) {
            return set;
        }
        for (Location location : locations) {
            AddressRange range = SarifUtils.locationToRange(location, program);
            if (range == null) continue;
            set.add(range);
        }
        return set;
    }

    public static AddressRange locationToRange(Location location, Program program) throws AddressOverflowException {
        PhysicalLocation physicalLocation = location.getPhysicalLocation();
        long len = physicalLocation.getAddress().getLength();
        Address addr = SarifUtils.locationToAddress(location, program);
        return addr == null ? null : new AddressRangeImpl(addr, len);
    }

    public static Address locationToAddress(Location location, Program program) {
        if (location.getPhysicalLocation() != null) {
            AddressFactory af = program.getAddressFactory();
            AddressSpace base = af.getDefaultAddressSpace();
            PhysicalLocation physicalLocation = location.getPhysicalLocation();
            Long addr = physicalLocation.getAddress().getAbsoluteAddress();
            String fqn = physicalLocation.getAddress().getFullyQualifiedName();
            if (fqn == null) {
                return SarifUtils.longToAddress(base, addr);
            }
            if (fqn.equals("NO ADDRESS")) {
                return null;
            }
            ArtifactLocation artifact = physicalLocation.getArtifactLocation();
            if (artifact == null) {
                AddressSpace space = SarifUtils.getAddressSpace(program, fqn, base);
                return SarifUtils.longToAddress(space, addr);
            }
            String uri = artifact.getUri();
            base = program.getAddressFactory().getAddressSpace(uri);
            if (base == null) {
                try {
                    base = program.createOverlaySpace(fqn, base);
                }
                catch (LockException | InvalidNameException | DuplicateNameException | IllegalStateException e) {
                    throw new RuntimeException("Attempt to create " + fqn + " failed!");
                }
            }
            AddressSpace space = SarifUtils.getAddressSpace(program, fqn, base);
            return SarifUtils.longToAddress(space, addr);
        }
        return null;
    }

    private static AddressSpace getAddressSpace(Program program, String fqn, AddressSpace base) {
        AddressSpace space = program.getAddressFactory().getAddressSpace(fqn);
        if (space != null) {
            return space;
        }
        try {
            space = program.createOverlaySpace(fqn, base);
        }
        catch (LockException | InvalidNameException | DuplicateNameException | IllegalStateException e) {
            throw new RuntimeException("Attempt to create " + fqn + " failed!");
        }
        return space;
    }

    public static Address longToAddress(AddressSpace space, Long addr) {
        return space.getAddressInThisSpaceOnly(addr.longValue());
    }

    public static ByteArrayInputStream getArtifactContent(Artifact artifact) {
        ArtifactContent content = artifact.getContents();
        String b64 = content.getBinary();
        byte[] decoded = Base64.decode((String)b64);
        return new ByteArrayInputStream(decoded);
    }

    public static ReportingDescriptor getTaxaValue(ReportingDescriptorReference taxa, ToolComponent taxonomy) {
        ArrayList view = new ArrayList(taxonomy.getTaxa());
        return (ReportingDescriptor)view.get(taxa.getIndex().intValue());
    }

    public static ToolComponent getTaxonomy(ReportingDescriptorReference taxa, Set<ToolComponent> taxonomies) {
        Long idx = taxa.getToolComponent().getIndex();
        if (idx == null) {
            ArrayList<ToolComponent> view = new ArrayList<ToolComponent>(taxonomies);
            idx = taxa.getIndex();
            return (ToolComponent)view.get(idx instanceof Long ? idx.intValue() : ((Integer)((Object)idx)).intValue());
        }
        for (ToolComponent taxonomy : taxonomies) {
            if (!taxonomy.getName().equals(taxa.getToolComponent().getName())) continue;
            return taxonomy;
        }
        return null;
    }

    public static List<String> getTaxonomyNames(Run sarifRun) {
        ArrayList<String> names = new ArrayList<String>();
        Set taxonomies = sarifRun.getTaxonomies();
        if (taxonomies != null) {
            for (ToolComponent taxonomy : sarifRun.getTaxonomies()) {
                names.add(taxonomy.getName());
            }
        }
        return names;
    }
}

