/*
 * Decompiled with CFR 0.152.
 */
package sarif.managers;

import com.google.gson.JsonArray;
import generic.stl.Pair;
import ghidra.app.util.CommentTypes;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFormatException;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.CodeUnitIterator;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Program;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskLauncher;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import sarif.SarifProgramOptions;
import sarif.export.SarifWriterTask;
import sarif.export.comments.SarifCommentWriter;
import sarif.managers.SarifMgr;

public class CommentsSarifMgr
extends SarifMgr {
    public static String KEY = "COMMENTS";
    public static String SUBKEY = "Comment";
    public static int[] COMMENT_TYPES;
    public static String[] COMMENT_TAGS;
    public static String[] COMMENT_TAGS2;

    CommentsSarifMgr(Program program, MessageLog log) {
        super(KEY, program, log);
    }

    @Override
    public boolean read(Map<String, Object> result, SarifProgramOptions options, TaskMonitor monitor) throws AddressFormatException, CancelledException {
        this.processComment(result);
        return true;
    }

    private void processComment(Map<String, Object> result) throws AddressFormatException {
        try {
            Address addr = this.getLocation(result);
            String typeStr = (String)result.get("kind");
            String comment = (String)result.get("value");
            boolean standard = (Boolean)result.get("standard");
            int commentType = this.getCommentType(typeStr);
            if (commentType < 0) {
                this.log.appendMsg("Unknown comment type: " + typeStr);
                return;
            }
            if (standard) {
                CodeUnit cu = this.listing.getCodeUnitContaining(addr);
                if (cu != null) {
                    String currCmt = cu.getComment(commentType);
                    if (currCmt == null || currCmt.length() == 0) {
                        cu.setComment(commentType, comment);
                    } else if (currCmt.indexOf(comment) < 0) {
                        this.log.appendMsg("Merged " + typeStr + " comment at " + String.valueOf(addr));
                        cu.setComment(commentType, currCmt + "\n" + comment);
                    }
                }
            } else {
                String currCmt = this.listing.getComment(commentType, addr);
                if (currCmt == null || currCmt.length() == 0) {
                    this.listing.setComment(addr, commentType, comment);
                } else if (currCmt.indexOf(comment) < 0) {
                    this.log.appendMsg("Merged " + typeStr + " comment at " + String.valueOf(addr));
                    this.listing.setComment(addr, commentType, currCmt + "\n" + comment);
                }
            }
        }
        catch (Exception e) {
            this.log.appendException((Throwable)e);
        }
    }

    private int getCommentType(String typeStr) {
        for (int i = 0; i < COMMENT_TAGS.length; ++i) {
            if (!COMMENT_TAGS[i].equals(typeStr)) continue;
            return COMMENT_TYPES[i];
        }
        return -1;
    }

    void write(JsonArray results, AddressSetView set, TaskMonitor monitor) throws IOException, CancelledException {
        int i;
        monitor.setMessage("Writing COMMENTS ...");
        if (set == null) {
            set = this.program.getMemory();
        }
        ArrayList<Pair<CodeUnit, Pair<String, String>>> request0 = new ArrayList<Pair<CodeUnit, Pair<String, String>>>();
        CodeUnitIterator iter = this.listing.getCodeUnitIterator("COMMENT__GHIDRA_", set, true);
        while (iter.hasNext()) {
            monitor.checkCancelled();
            CodeUnit cu = iter.next();
            for (i = 0; i < COMMENT_TYPES.length; ++i) {
                String[] comments;
                for (String c : comments = cu.getCommentAsArray(COMMENT_TYPES[i])) {
                    Pair pair = new Pair((Object)COMMENT_TAGS[i], (Object)c);
                    request0.add((Pair<CodeUnit, Pair<String, String>>)new Pair((Object)cu, (Object)pair));
                }
            }
        }
        CommentsSarifMgr.writeAsSARIF0(request0, results);
        ArrayList<Pair<Address, Pair<String, String>>> request1 = new ArrayList<Pair<Address, Pair<String, String>>>();
        for (i = 0; i < COMMENT_TAGS2.length; ++i) {
            AddressIterator aiter = this.listing.getCommentAddressIterator(i, set, true);
            while (aiter.hasNext()) {
                monitor.checkCancelled();
                Address a = aiter.next();
                CodeUnit cu = this.listing.getCodeUnitContaining(a);
                if (!(cu instanceof Instruction) || a.equals((Object)cu.getMinAddress())) continue;
                String c = this.listing.getComment(i, a);
                Pair pair = new Pair((Object)COMMENT_TAGS2[i], (Object)c);
                request1.add((Pair<Address, Pair<String, String>>)new Pair((Object)a, (Object)pair));
            }
        }
        CommentsSarifMgr.writeAsSARIF1(request1, results);
    }

    public static void writeAsSARIF0(List<Pair<CodeUnit, Pair<String, String>>> request, JsonArray results) throws IOException {
        SarifCommentWriter writer = new SarifCommentWriter(request, null);
        new TaskLauncher((Task)new SarifWriterTask(SUBKEY, writer, results), null);
    }

    public static void writeAsSARIF1(List<Pair<Address, Pair<String, String>>> request, JsonArray results) throws IOException {
        SarifCommentWriter writer = new SarifCommentWriter(null, request);
        new TaskLauncher((Task)new SarifWriterTask(SUBKEY, writer, results), null);
    }

    static {
        COMMENT_TAGS2 = new String[]{"end-of-line", "pre", "post", "plate", "repeatable"};
        COMMENT_TYPES = CommentTypes.getTypes();
        COMMENT_TAGS = new String[COMMENT_TYPES.length];
        block7: for (int i = 0; i < COMMENT_TAGS.length; ++i) {
            switch (COMMENT_TYPES[i]) {
                case 1: {
                    CommentsSarifMgr.COMMENT_TAGS[i] = "pre";
                    continue block7;
                }
                case 2: {
                    CommentsSarifMgr.COMMENT_TAGS[i] = "post";
                    continue block7;
                }
                case 0: {
                    CommentsSarifMgr.COMMENT_TAGS[i] = "end-of-line";
                    continue block7;
                }
                case 3: {
                    CommentsSarifMgr.COMMENT_TAGS[i] = "plate";
                    continue block7;
                }
                case 4: {
                    CommentsSarifMgr.COMMENT_TAGS[i] = "repeatable";
                }
            }
        }
    }
}

