/*
 * Decompiled with CFR 0.152.
 */
package sarif.managers;

import com.google.gson.JsonArray;
import ghidra.app.util.importer.MessageLog;
import ghidra.docking.settings.Settings;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeInstance;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.ProgramBasedDataTypeManager;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.CodeUnitIterator;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.DataIterator;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.DumbMemBufferImpl;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskLauncher;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import sarif.SarifProgramOptions;
import sarif.export.SarifWriterTask;
import sarif.export.dd.SarifDataWriter;
import sarif.managers.DtParser;
import sarif.managers.SarifMgr;

public class DefinedDataSarifMgr
extends SarifMgr {
    public static String KEY = "DEFINED_DATA";
    public static String SUBKEY = "Defined Data";

    DefinedDataSarifMgr(Program program, MessageLog log) {
        super(KEY, program, log);
    }

    @Override
    public boolean read(Map<String, Object> result, SarifProgramOptions options, TaskMonitor monitor) throws CancelledException {
        Listing listing = this.program.getListing();
        ProgramBasedDataTypeManager dataManager = this.program.getDataTypeManager();
        try {
            String typeLocation;
            CategoryPath path;
            DtParser dtParser = new DtParser((DataTypeManager)dataManager);
            AddressSet set = this.getLocations(result, null);
            Address addr = set.getMinAddress();
            if (addr == null) {
                return false;
            }
            int size = (int)set.getMaxAddress().subtract(addr) + 1;
            String dataTypeName = (String)result.get("typeName");
            DataType dt = dtParser.parseDataType(dataTypeName, path = (typeLocation = (String)result.get("typeLocation")) != null ? new CategoryPath(typeLocation) : CategoryPath.ROOT, size);
            if (dt == null && dataTypeName.contains(" ")) {
                dataTypeName = dataTypeName.substring(0, dataTypeName.indexOf(" "));
                dt = dtParser.parseDataType(dataTypeName, path, size);
            }
            if (dt == null) {
                this.log.appendMsg("Defined root: unknown datatype: " + dataTypeName + " in category: " + String.valueOf(path));
                return false;
            }
            try {
                if (options == null || options.isOverwriteDataConflicts()) {
                    this.clearExistingData(addr, size, dt, listing);
                }
                Data data = listing.createData(addr, dt, size);
                this.processSettings(result, data);
                Map comments = (Map)result.get("nested");
                this.processComment(comments, data);
            }
            catch (CodeUnitInsertionException e) {
                Data d = listing.getDefinedDataAt(addr);
                if (d == null || !d.getDataType().isEquivalent(dt)) {
                    this.log.appendMsg(e.getMessage());
                }
            }
            catch (Exception e) {
                this.log.appendException((Throwable)e);
            }
        }
        catch (AddressOverflowException e1) {
            this.log.appendException((Throwable)e1);
        }
        return true;
    }

    private void processSettings(Map<String, Object> res, Data data) {
        List settingsMap = (List)res.get("settings");
        if (settingsMap == null) {
            return;
        }
        for (Map map : settingsMap) {
            Settings settings = data.getDefaultSettings();
            if (map == null) continue;
            String name = (String)map.get("name");
            String kind = (String)map.get("kind");
            String value = (String)map.get("value");
            Object existing = settings.getValue(name);
            if (existing != null && existing.toString().equals(value)) continue;
            settings.setValue(name, kind.equals("long") ? Long.valueOf(Long.parseLong(value)) : value);
        }
    }

    private void processComment(Map<String, Object> c, Data data) {
        Map embedded;
        List localSettings;
        if (c == null || c.isEmpty()) {
            return;
        }
        List localComments = (List)c.get("comment");
        if (localComments != null) {
            for (Object lmap : localComments) {
                String comment = (String)lmap.get("comment");
                int type = (int)((Double)lmap.get("commentType")).doubleValue();
                String existing = data.getComment(type);
                if (existing != null && existing.equals(comment)) continue;
                data.setComment(type, comment);
            }
        }
        if ((localSettings = (List)c.get("setting")) != null) {
            for (Map lmap : localSettings) {
                String name = (String)lmap.get("name");
                String kind = (String)lmap.get("kind");
                String value = (String)lmap.get("value");
                Object existing = data.getValue(name);
                if (existing != null && existing.toString().equals(value)) continue;
                data.setValue(name, kind.equals("long") ? Long.valueOf(Long.parseLong(value)) : value);
            }
        }
        if ((embedded = (Map)c.get("embedded")) != null) {
            for (String index : embedded.keySet()) {
                Data component = data.getComponent(Integer.parseInt(index));
                Map c2 = (Map)embedded.get(index);
                this.processComment(c2, component);
            }
        }
    }

    private void clearExistingData(Address addr, int size, DataType dt, Listing listing) {
        DumbMemBufferImpl buf = new DumbMemBufferImpl(this.program.getMemory(), addr);
        DataTypeInstance dti = DataTypeInstance.getDataTypeInstance((DataType)dt, (MemBuffer)buf, (int)size, (boolean)false);
        if (dti != null) {
            boolean doClear = false;
            Address maxAddr = addr.add((long)(dti.getLength() - 1));
            CodeUnitIterator codeUnits = listing.getCodeUnitIterator("DEFINED_DATA__GHIDRA_", (AddressSetView)new AddressSet(addr, maxAddr), true);
            while (codeUnits.hasNext()) {
                CodeUnit cu = codeUnits.next();
                if (cu instanceof Data) {
                    if (!((Data)cu).isDefined()) continue;
                    doClear = true;
                    continue;
                }
                return;
            }
            if (doClear) {
                listing.clearCodeUnits(addr, maxAddr, false);
            }
        }
    }

    void write(JsonArray results, AddressSetView addrset, TaskMonitor monitor) throws IOException, CancelledException {
        monitor.setMessage("Writing DATA ...");
        ArrayList<Data> request = new ArrayList<Data>();
        Listing listing = this.program.getListing();
        DataIterator iter = listing.getDefinedData(addrset, true);
        while (iter.hasNext()) {
            request.add(iter.next());
        }
        DefinedDataSarifMgr.writeAsSARIF(this.program, request, results);
    }

    public static void writeAsSARIF(Program program, List<Data> request, JsonArray results) throws IOException {
        SarifDataWriter writer = new SarifDataWriter(request, null);
        new TaskLauncher((Task)new SarifWriterTask("DefinedData", writer, results), null);
    }
}

