/*
 * Decompiled with CFR 0.152.
 */
package sarif.managers;

import com.google.gson.JsonArray;
import ghidra.app.util.importer.MessageLog;
import ghidra.framework.options.ActionTrigger;
import ghidra.framework.options.CustomOption;
import ghidra.framework.options.OptionType;
import ghidra.framework.options.Options;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Bookmark;
import ghidra.program.model.listing.BookmarkManager;
import ghidra.program.model.listing.Program;
import ghidra.program.model.util.IntPropertyMap;
import ghidra.program.model.util.LongPropertyMap;
import ghidra.program.model.util.ObjectPropertyMap;
import ghidra.program.model.util.PropertyMap;
import ghidra.program.model.util.PropertyMapManager;
import ghidra.program.model.util.StringPropertyMap;
import ghidra.program.model.util.VoidPropertyMap;
import ghidra.util.ColorUtils;
import ghidra.util.Saveable;
import ghidra.util.SaveableColor;
import ghidra.util.SaveablePoint;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskLauncher;
import ghidra.util.task.TaskMonitor;
import java.awt.Color;
import java.awt.Font;
import java.awt.Point;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.KeyStroke;
import sarif.SarifProgramOptions;
import sarif.export.SarifWriterTask;
import sarif.export.props.SarifPropertyListWriter;
import sarif.export.props.SarifPropertyMapWriter;
import sarif.managers.SarifMgr;

public class PropertiesSarifMgr
extends SarifMgr {
    public static String KEY = "PROPERTIES";
    public static String SUBKEY = "Property";
    private static final String PROPERTY_LIST_CATEGORY_DELIMITER = Options.DELIMITER_STRING;
    private PropertyMapManager propMapMgr;

    PropertiesSarifMgr(Program program, MessageLog log) {
        super(KEY, program, log);
        this.propMapMgr = program.getUsrPropertyManager();
    }

    @Override
    public boolean read(Map<String, Object> result, SarifProgramOptions options, TaskMonitor monitor) throws CancelledException {
        this.processProperty(result, options == null || options.isOverwritePropertyConflicts());
        return true;
    }

    private void processProperty(Map<String, Object> result, boolean overwrite) {
        String name = (String)result.get("name");
        try {
            Address addr = this.getLocation(result);
            if (addr != null) {
                this.processPropertyMapEntry(addr, name, result, overwrite);
            } else {
                this.processPropertyListEntry(name, result, overwrite);
            }
        }
        catch (Exception e) {
            this.log.appendException((Throwable)e);
        }
    }

    private void processPropertyMapEntry(Address addr, String name, Map<String, Object> result, boolean overwrite) throws DuplicateNameException {
        PropertyMap map;
        String type = (String)result.get("type");
        if (type != null) {
            type = type.toLowerCase();
        }
        if (!overwrite && !"bookmarks".equals(type) && (map = this.propMapMgr.getPropertyMap(name)) != null && map.hasProperty(addr)) {
            this.log.appendMsg("Conflicting '" + name + "' PROPERTY ignored at: " + String.valueOf(addr));
            return;
        }
        String val = (String)result.get("value");
        if (type == null || "void".equals(type)) {
            VoidPropertyMap voidMap;
            if (val != null) {
                this.log.appendMsg("VALUE attribute ignored for void property");
            }
            if ((voidMap = this.propMapMgr.getVoidPropertyMap(name)) == null) {
                voidMap = this.propMapMgr.createVoidPropertyMap(name);
            }
            voidMap.add(addr);
        } else if ("int".equals(type)) {
            int value = Integer.parseInt(val, 16);
            IntPropertyMap intMap = this.propMapMgr.getIntPropertyMap(name);
            if (intMap == null) {
                intMap = this.propMapMgr.createIntPropertyMap(name);
            }
            intMap.add(addr, value);
        } else if ("long".equals(type)) {
            long value = Long.parseLong(val, 16);
            LongPropertyMap longMap = this.propMapMgr.getLongPropertyMap(name);
            if (longMap == null) {
                longMap = this.propMapMgr.createLongPropertyMap(name);
            }
            longMap.add(addr, value);
        } else if ("string".equals(type)) {
            String str = val;
            StringPropertyMap strMap = this.propMapMgr.getStringPropertyMap(name);
            if (strMap == null) {
                strMap = this.propMapMgr.createStringPropertyMap(name);
            }
            strMap.add(addr, str);
        } else if ("color".equals(type)) {
            ObjectPropertyMap objMap = this.propMapMgr.getObjectPropertyMap(name);
            if (objMap == null) {
                objMap = this.propMapMgr.createObjectPropertyMap(name, SaveableColor.class);
            }
            objMap.add(addr, (Saveable)new SaveableColor(Color.decode(val)));
        } else if ("point".equals(type)) {
            String xstr = val.substring(val.indexOf("[x="), val.indexOf(","));
            String ystr = val.substring(val.indexOf("y="), val.indexOf("]"));
            ObjectPropertyMap objMap = this.propMapMgr.getObjectPropertyMap(name);
            if (objMap == null) {
                objMap = this.propMapMgr.createObjectPropertyMap(name, SaveablePoint.class);
            }
            objMap.add(addr, (Saveable)new SaveablePoint(new Point(Integer.parseInt(xstr), Integer.parseInt(ystr))));
        } else if ("bookmarks".equals(type)) {
            Bookmark[] bookmarks;
            BookmarkManager bmMgr = this.program.getBookmarkManager();
            if (!overwrite && (bookmarks = bmMgr.getBookmarks(addr, "Note")).length != 0) {
                this.log.appendMsg("Conflicting BOOKMARK ignored at: " + String.valueOf(addr));
                return;
            }
            bmMgr.setBookmark(addr, "Note", name, val);
        } else {
            this.log.appendMsg("Unsupported PROPERTY usage");
        }
    }

    private String getPropertyList(String path) {
        StringTokenizer st = new StringTokenizer(path, PROPERTY_LIST_CATEGORY_DELIMITER);
        if (st.hasMoreElements()) {
            return st.nextToken();
        }
        return null;
    }

    private String getPropertyName(String path) {
        int ix = path.indexOf(PROPERTY_LIST_CATEGORY_DELIMITER);
        if (ix >= 0) {
            if (path.length() > ix + 1) {
                return path.substring(ix + 1);
            }
            return null;
        }
        return path;
    }

    private void processPropertyListEntry(String pathname, Map<String, Object> result, boolean overwrite) throws Exception {
        String listName = this.getPropertyList(pathname);
        String name = this.getPropertyName(pathname);
        if (listName == null || name == null) {
            this.log.appendMsg("Property NAME attribute must contain both category prefix and property name");
            return;
        }
        Options list = this.program.getOptions(listName);
        if (!overwrite && list.contains(name)) {
            this.log.appendMsg("Conflicting PROPERTY ignored: " + pathname);
            return;
        }
        String type = (String)result.get("type");
        if (type != null) {
            type = type.toLowerCase();
        }
        Object val = result.get("value");
        if (type == null || "void".equals(type)) {
            this.log.appendMsg("Unsupported PROPERTY usage");
        } else if ("int".equals(type)) {
            list.setInt(name, Integer.parseInt((String)val, 16));
        } else if ("long".equals(type)) {
            list.setLong(name, Long.parseLong((String)val, 16));
        } else if ("double".equals(type)) {
            list.setDouble(name, Double.parseDouble((String)val));
        } else if ("float".equals(type)) {
            list.setFloat(name, Float.parseFloat((String)val));
        } else if ("bool".equals(type)) {
            list.setBoolean(name, Boolean.parseBoolean((String)val));
        } else if ("string".equals(type)) {
            list.setString(name, (String)val);
        } else if ("date".equals(type)) {
            list.setDate(name, new Date(Long.parseLong((String)val, 16)));
        } else if ("color".equals(type)) {
            Color color = ColorUtils.getColor((int)((Integer)val));
            list.setColor(name, color);
        } else if ("file".equals(type)) {
            File file = new File((String)val);
            list.setFile(name, file);
        } else if ("enum".equals(type)) {
            String sarifString = PropertiesSarifMgr.unEscapeElementEntities((String)val);
            Enum enuum = (Enum)OptionType.ENUM_TYPE.convertStringToObject(sarifString);
            list.setEnum(name, enuum);
        } else if ("font".equals(type)) {
            String sarifString = PropertiesSarifMgr.unEscapeElementEntities((String)val);
            Font font = (Font)OptionType.FONT_TYPE.convertStringToObject(sarifString);
            list.setFont(name, font);
        } else if ("keyStroke".equals(type)) {
            String sarifString = PropertiesSarifMgr.unEscapeElementEntities((String)val);
            KeyStroke keyStroke = (KeyStroke)OptionType.KEYSTROKE_TYPE.convertStringToObject(sarifString);
            ActionTrigger trigger = null;
            if (keyStroke != null) {
                trigger = new ActionTrigger(keyStroke);
            }
            list.setActionTrigger(name, trigger);
        } else if ("actionTrigger".equals(type)) {
            String sarifString = PropertiesSarifMgr.unEscapeElementEntities((String)val);
            ActionTrigger actionTrigger = (ActionTrigger)OptionType.ACTION_TRIGGER.convertStringToObject(sarifString);
            list.setActionTrigger(name, actionTrigger);
        } else if ("custom".equals(type)) {
            String sarifString = PropertiesSarifMgr.unEscapeElementEntities((String)val);
            CustomOption custom = (CustomOption)OptionType.CUSTOM_TYPE.convertStringToObject(sarifString);
            list.setCustomOption(name, custom);
        } else if ("bytes".equals(type)) {
            String sarifString = PropertiesSarifMgr.unEscapeElementEntities((String)val);
            byte[] bytes = (byte[])OptionType.BYTE_ARRAY_TYPE.convertStringToObject(sarifString);
            list.setByteArray(name, bytes);
        } else {
            this.log.appendMsg("Unsupported PROPERTY usage");
        }
    }

    void write(JsonArray results, AddressSetView set, TaskMonitor monitor) throws IOException, CancelledException {
        monitor.setMessage("Writing PROPERTIES ...");
        List request = this.program.getOptionsNames();
        PropertiesSarifMgr.writeAsSARIF(this.program, request, results);
        ArrayList mapRequest = new ArrayList();
        Iterator mapNames = this.propMapMgr.propertyManagers();
        while (mapNames.hasNext()) {
            monitor.checkCancelled();
            mapRequest.add(this.propMapMgr.getPropertyMap((String)mapNames.next()));
        }
        PropertiesSarifMgr.writeAsSARIF(this.program, set, mapRequest, results);
    }

    public static void writeAsSARIF(Program program, List<String> request, JsonArray results) throws IOException {
        SarifPropertyListWriter writer = new SarifPropertyListWriter(program, request, null);
        new TaskLauncher((Task)new SarifWriterTask(SUBKEY, writer, results), null);
    }

    public static void writeAsSARIF(Program program, AddressSetView set, List<PropertyMap<?>> request, JsonArray results) throws IOException {
        SarifPropertyMapWriter writer = new SarifPropertyMapWriter(request, program, set, null);
        new TaskLauncher((Task)new SarifWriterTask(SUBKEY, writer, results), null);
    }
}

