/*
 * Decompiled with CFR 0.152.
 */
package sarif.managers;

import com.google.gson.JsonArray;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolIterator;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.model.symbol.SymbolUtilities;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskLauncher;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import sarif.SarifProgramOptions;
import sarif.export.SarifWriterTask;
import sarif.export.symbols.SarifSymbolWriter;
import sarif.managers.SarifMgr;

public class SymbolTableSarifMgr
extends SarifMgr {
    public static String KEY = "SYMBOLS";
    public static String SUBKEY = "Symbols";
    private SymbolTable symbolTable;
    private boolean overwritePrimary;
    private boolean preFunction;

    SymbolTableSarifMgr(Program program, MessageLog log, boolean preFunction) {
        super(KEY, program, log);
        this.preFunction = preFunction;
        this.symbolTable = program.getSymbolTable();
    }

    @Override
    public boolean read(Map<String, Object> result, SarifProgramOptions options, TaskMonitor monitor) throws CancelledException {
        this.overwritePrimary = options == null || options.isOverwriteSymbolConflicts();
        this.processSymbol(result, this.preFunction);
        return true;
    }

    private void processSymbol(Map<String, Object> result, boolean firstPass) {
        try {
            String kind = (String)result.get("kind");
            boolean isLocal = kind != null && kind.equalsIgnoreCase("local");
            String type = (String)result.get("type");
            boolean isPrimary = (Boolean)result.get("primary");
            boolean isPinned = (Boolean)result.get("pinned");
            String sourceTypeString = (String)result.get("sourceType");
            SourceType sourceType = this.getSourceType(sourceTypeString);
            String name = (String)result.get("name");
            boolean processFirstPass = true;
            if (isLocal && type == null) {
                processFirstPass = false;
            }
            if (sourceType.equals((Object)SourceType.DEFAULT)) {
                processFirstPass = false;
            }
            if (firstPass && !processFirstPass) {
                return;
            }
            if (!firstPass && processFirstPass) {
                return;
            }
            Address addr = this.getLocation(result);
            String namespace = (String)result.get("location");
            Boolean isClass = (Boolean)result.get("namespaceIsClass");
            Namespace scope = this.program.getGlobalNamespace();
            Namespace namespace2 = scope = isLocal ? this.walkNamespace(scope, namespace, addr, sourceType, isClass) : scope;
            if (scope == null) {
                return;
            }
            if (type != null) {
                if (type.equals("namespace")) {
                    if (this.symbolTable.getNamespace(name, scope) == null) {
                        this.symbolTable.createNameSpace(scope, name, sourceType);
                    }
                    return;
                }
                if (type.equals("class")) {
                    if (this.symbolTable.getClassSymbol(name, scope) == null) {
                        this.symbolTable.createClass(scope, name, sourceType);
                    }
                    return;
                }
                if (type.equals("library")) {
                    if (this.symbolTable.getLibrarySymbol(name) == null) {
                        this.symbolTable.createExternalLibrary(name, sourceType);
                    }
                    return;
                }
            }
            if (this.symbolTable.getSymbol(name, addr, scope) == null) {
                Symbol s = SymbolUtilities.createPreferredLabelOrFunctionSymbol((Program)this.program, (Address)addr, (Namespace)scope, (String)name, (SourceType)sourceType);
                if (s != null && isPrimary && this.overwritePrimary) {
                    s.setPrimary();
                }
                if (isPinned) {
                    s.setPinned(true);
                }
            }
        }
        catch (Exception e) {
            this.log.appendException((Throwable)e);
        }
    }

    void write(JsonArray results, AddressSetView set, TaskMonitor monitor) throws IOException, CancelledException {
        monitor.setMessage("Writing SYMBOL TABLE ...");
        SymbolIterator iter = this.symbolTable.getSymbolIterator();
        ArrayList<Symbol> request = new ArrayList<Symbol>();
        while (iter.hasNext()) {
            request.add(iter.next());
        }
        SymbolTableSarifMgr.writeAsSARIF(this.program, request, results);
    }

    public static void writeAsSARIF(Program program, List<Symbol> request, JsonArray results) throws IOException {
        SarifSymbolWriter writer = new SarifSymbolWriter(request, null);
        new TaskLauncher((Task)new SarifWriterTask("Symbols", writer, results), null);
    }
}

