/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.gui.filters;

import docking.DialogComponentProvider;
import docking.widgets.DataToStringConverter;
import docking.widgets.table.AbstractDynamicTableColumn;
import docking.widgets.table.DynamicTableColumn;
import docking.widgets.table.GDynamicColumnTableModel;
import docking.widgets.table.GFilterTable;
import docking.widgets.table.RowObjectTableModel;
import docking.widgets.table.TableColumnDescriptor;
import ghidra.docking.settings.Settings;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.framework.plugintool.ServiceProviderStub;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class MultiChoiceSelectionDialog<T>
extends DialogComponentProvider {
    private List<T> selectedChoices;
    private GFilterTable<ChoiceRowObject> filterTable;
    private ChoiceTableModel model;

    public MultiChoiceSelectionDialog(String dataTitle, List<T> choices, Set<T> selected) {
        this(dataTitle, choices, selected, t -> t.toString());
    }

    public MultiChoiceSelectionDialog(String dataTitle, List<T> choices, Set<T> selected, DataToStringConverter<T> dataConverter) {
        super(dataTitle + " Chooser");
        this.addWorkPanel(this.buildMainPanel(choices, selected, dataConverter, dataTitle));
        this.addOKButton();
        this.addCancelButton();
    }

    private JComponent buildMainPanel(List<T> choices, Set<T> selected, DataToStringConverter<T> dataConverter, String dataTitle) {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.model = new ChoiceTableModel(choices, selected, dataConverter, dataTitle);
        this.filterTable = new GFilterTable((RowObjectTableModel)this.model);
        panel.add((Component)this.filterTable);
        return panel;
    }

    protected void okCallback() {
        this.selectedChoices = this.getSelectedChoicesFromTable();
        this.close();
    }

    private List<T> getSelectedChoicesFromTable() {
        return this.model.getSelectedData();
    }

    public List<T> getSelectedChoices() {
        return this.selectedChoices;
    }

    class ChoiceTableModel
    extends GDynamicColumnTableModel<ChoiceRowObject, Object> {
        private List<ChoiceRowObject> rows;
        private DataToStringConverter<T> stringConverter;
        private String dataColumnTitle;

        ChoiceTableModel(List<T> data, Set<T> selected, DataToStringConverter<T> stringConverter, String dataColumnTitle) {
            super((ServiceProvider)new ServiceProviderStub());
            this.rows = new ArrayList<ChoiceRowObject>();
            this.stringConverter = stringConverter;
            this.dataColumnTitle = dataColumnTitle;
            for (Object t : data) {
                this.rows.add(new ChoiceRowObject(MultiChoiceSelectionDialog.this, t, selected.contains(t)));
            }
        }

        public String getName() {
            return "Chooser";
        }

        public List<T> getSelectedData() {
            ArrayList selected = new ArrayList();
            for (ChoiceRowObject row : this.rows) {
                if (!row.isSelected()) continue;
                selected.add(row.getData());
            }
            return selected;
        }

        public List<ChoiceRowObject> getModelData() {
            return this.rows;
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 0;
        }

        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            boolean b = (Boolean)aValue;
            this.rows.get(rowIndex).setSelected(b);
        }

        protected TableColumnDescriptor<ChoiceRowObject> createTableColumnDescriptor() {
            TableColumnDescriptor descriptor = new TableColumnDescriptor();
            descriptor.addVisibleColumn((DynamicTableColumn)new SelectedColumn(this));
            descriptor.addVisibleColumn((DynamicTableColumn)new DataColumn(), 1, true);
            return descriptor;
        }

        public Object getDataSource() {
            return null;
        }

        private class SelectedColumn
        extends AbstractDynamicTableColumn<ChoiceRowObject, Boolean, Object> {
            private SelectedColumn(ChoiceTableModel choiceTableModel) {
            }

            public String getColumnName() {
                return "Selected";
            }

            public Boolean getValue(ChoiceRowObject rowObject, Settings settings, Object data, ServiceProvider provider) throws IllegalArgumentException {
                return rowObject.isSelected();
            }

            public int getColumnPreferredWidth() {
                return 40;
            }
        }

        private class DataColumn
        extends AbstractDynamicTableColumn<ChoiceRowObject, String, Object> {
            private DataColumn() {
            }

            public String getColumnName() {
                return ChoiceTableModel.this.dataColumnTitle;
            }

            public String getValue(ChoiceRowObject rowObject, Settings settings, Object data, ServiceProvider provider) throws IllegalArgumentException {
                return ChoiceTableModel.this.stringConverter.getString(rowObject.getData());
            }

            public int getColumnPreferredWidth() {
                return 300;
            }
        }
    }

    class ChoiceRowObject {
        private T data;
        private boolean selected;

        ChoiceRowObject(MultiChoiceSelectionDialog this$0, T data, boolean selected) {
            this.data = data;
            this.selected = selected;
        }

        public boolean isSelected() {
            return this.selected;
        }

        public T getData() {
            return this.data;
        }

        public void setSelected(boolean b) {
            this.selected = b;
        }
    }
}

