/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.gui.search.dialog;

import docking.ActionContext;
import docking.DialogComponentProvider;
import docking.DockingWindowManager;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.ToggleDockingAction;
import docking.action.ToolBarData;
import docking.action.builder.ActionBuilder;
import docking.action.builder.ToggleActionBuilder;
import docking.widgets.OptionDialog;
import docking.widgets.PasswordChangeDialog;
import docking.widgets.table.GFilterTable;
import docking.widgets.table.GTable;
import docking.widgets.table.RowObjectTableModel;
import generic.theme.GIcon;
import ghidra.features.bsim.gui.BSimServerManager;
import ghidra.features.bsim.gui.search.dialog.BSimServerTableModel;
import ghidra.features.bsim.gui.search.dialog.ConnectionPoolStatus;
import ghidra.features.bsim.gui.search.dialog.CreateBsimServerInfoDialog;
import ghidra.features.bsim.query.BSimClientFactory;
import ghidra.features.bsim.query.BSimJDBCDataSource;
import ghidra.features.bsim.query.BSimServerInfo;
import ghidra.features.bsim.query.FunctionDatabase;
import ghidra.framework.plugintool.PluginTool;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.Swing;
import java.awt.BorderLayout;
import java.awt.Component;
import java.sql.Connection;
import java.sql.SQLException;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.bouncycastle.util.Arrays;
import resources.Icons;

public class BSimServerDialog
extends DialogComponentProvider {
    private PluginTool tool;
    private BSimServerManager serverManager;
    private BSimServerTableModel serverTableModel;
    private GFilterTable<BSimServerInfo> serverTable;
    private BSimServerInfo lastAdded = null;
    private ToggleDockingAction dbConnectionAction;

    public BSimServerDialog(PluginTool tool, BSimServerManager serverManager) {
        super("BSim Server Manager");
        this.tool = tool;
        this.serverManager = serverManager;
        this.addWorkPanel(this.buildMainPanel());
        this.createToolbarActions();
        this.addDismissButton();
        this.setPreferredSize(600, 400);
        this.notifyContextChanged();
        this.setHelpLocation(new HelpLocation("BSimSearchPlugin", "BSim_Servers_Dialog"));
    }

    protected void dismissCallback() {
        this.serverTableModel.dispose();
        super.dismissCallback();
    }

    private void createToolbarActions() {
        HelpLocation help = new HelpLocation("BSimSearchPlugin", "Manage_Servers_Actions");
        DockingAction addServerAction = ((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Add BSim Database", "Dialog").toolBarIcon(Icons.ADD_ICON)).helpLocation(help)).onAction(e -> this.defineBsimServer())).build();
        this.addAction((DockingActionIf)addServerAction);
        DockingAction removeServerAction = ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Delete BSim Database", "Dialog").toolBarIcon(Icons.DELETE_ICON)).helpLocation(help)).onAction(e -> this.deleteBsimServer())).enabledWhen(c -> this.hasSelection())).build();
        this.addAction((DockingActionIf)removeServerAction);
        this.dbConnectionAction = ((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)new ToggleActionBuilder("Toggle Database Connection", "Dialog").helpLocation(help)).toolBarIcon((Icon)new GIcon("icon.bsim.disconnected"))).onAction(e -> this.toggleSelectedJDBCDataSourceConnection())).enabledWhen(c -> this.isNonActiveJDBCDataSourceSelected((ActionContext)c))).build();
        this.addAction((DockingActionIf)this.dbConnectionAction);
        DockingAction changePasswordAction = ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Change User Password", "Dialog").helpLocation(help)).toolBarIcon((Icon)new GIcon("icon.bsim.change.password"))).onAction(e -> this.changePassword())).enabledWhen(c -> this.canChangePassword())).build();
        this.addAction((DockingActionIf)changePasswordAction);
    }

    private void toggleSelectedJDBCDataSourceConnection() {
        BSimServerInfo serverInfo = (BSimServerInfo)this.serverTable.getSelectedRowObject();
        if (serverInfo == null || serverInfo.getDBType() == BSimServerInfo.DBType.elastic) {
            return;
        }
        BSimJDBCDataSource dataSource = BSimServerManager.getDataSourceIfExists(serverInfo);
        if (dataSource == null) {
            dataSource = BSimServerManager.getDataSource(serverInfo);
            try {
                Connection connection = dataSource.getConnection();
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                Msg.showError((Object)((Object)this), (Component)this.rootPanel, (String)"BSim Connection Failure", (Object)e.getMessage());
            }
        } else {
            dataSource.dispose();
        }
        this.serverTableModel.fireTableDataChanged();
        this.notifyContextChanged();
    }

    private boolean isNonActiveJDBCDataSourceSelected(ActionContext c) {
        BSimServerInfo serverInfo = (BSimServerInfo)this.serverTable.getSelectedRowObject();
        if (serverInfo == null) {
            return false;
        }
        this.dbConnectionAction.setDescription(this.dbConnectionAction.getName());
        ConnectionPoolStatus status = this.serverTableModel.getConnectionPoolStatus(serverInfo);
        if (status.isActive) {
            this.dbConnectionAction.setToolBarData(new ToolBarData((Icon)new GIcon("icon.bsim.connected"), null));
            this.dbConnectionAction.setSelected(true);
            this.dbConnectionAction.setDescription("Disconnect idle BSim Database connection");
            return status.activeCount == 0;
        }
        this.dbConnectionAction.setToolBarData(new ToolBarData((Icon)new GIcon("icon.bsim.disconnected"), null));
        this.dbConnectionAction.setSelected(false);
        this.dbConnectionAction.setDescription("Connect BSim Database");
        return serverInfo.getDBType() != BSimServerInfo.DBType.elastic;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void changePassword() {
        block24: {
            block23: {
                block22: {
                    serverInfo = (BSimServerInfo)this.serverTable.getSelectedRowObject();
                    if (serverInfo == null) {
                        return;
                    }
                    pwd = null;
                    try {
                        db = BSimClientFactory.buildClient(serverInfo, true);
                        if (!db.initialize()) {
                            lastError = db.getLastError();
                            if (lastError.category != FunctionDatabase.ErrorCategory.AuthenticationCancelled) {
                                Msg.showError((Object)this, (Component)this.getComponent(), (String)"BSim DB Connection Failed", (Object)lastError.message);
                            }
                            if (db != null) {
                                db.close();
                            }
                            if (pwd == null) return;
                            break block22;
                        }
                        ** GOTO lbl-1000
                    }
                    catch (Throwable var6_9) {
                        if (pwd == null) throw var6_9;
                        Arrays.fill(pwd, (char)'\u0000');
                        throw var6_9;
                    }
                }
                Arrays.fill(pwd, (char)'\u0000');
                return;
lbl-1000:
                // 1 sources

                {
                    if (db.isPasswordChangeAllowed()) ** GOTO lbl-1000
                    Msg.showError((Object)this, (Component)this.getComponent(), (String)"Unsupported Operation", (Object)"BSim DB password change not supported");
                    if (db != null) {
                        db.close();
                    }
                    if (pwd == null) return;
                }
                Arrays.fill(pwd, (char)'\u0000');
                return;
lbl-1000:
                // 1 sources

                {
                    dlg = new PasswordChangeDialog("Change Password", "BSim DB", serverInfo.toString(), db.getUserName());
                    this.tool.showDialog((DialogComponentProvider)dlg);
                    pwd = dlg.getPassword();
                    if (pwd != null) break block23;
                    if (db != null) {
                        db.close();
                    }
                    if (pwd == null) return;
                }
                Arrays.fill((char[])pwd, (char)'\u0000');
                return;
            }
            ** try [egrp 7[TRYBLOCK] [3 : 195->245)] { 
lbl44:
            // 1 sources

            resp = db.changePassword(db.getUserName(), pwd);
            if (resp == null) {
                Msg.showInfo((Object)this, (Component)this.getComponent(), (String)"Password Changed", (Object)"BSim DB password successfully changed");
                break block24;
            } else {
                Msg.showError((Object)this, (Component)this.getComponent(), (String)"Password Changed Failed", (Object)resp);
            }
            break block24;
lbl50:
            // 1 sources

            finally {
                if (db != null) {
                    db.close();
                }
            }
        }
        if (pwd == null) return;
        Arrays.fill((char[])pwd, (char)'\u0000');
    }

    private boolean canChangePassword() {
        BSimServerInfo serverInfo = (BSimServerInfo)this.serverTable.getSelectedRowObject();
        return serverInfo != null && serverInfo.getDBType() != BSimServerInfo.DBType.file;
    }

    private void deleteBsimServer() {
        int answer;
        BSimServerInfo selected = (BSimServerInfo)this.serverTable.getSelectedRowObject();
        if (selected != null && (answer = OptionDialog.showYesNoDialog((Component)this.getComponent(), (String)"Delete Server Configuration?", (String)("Are you sure you want to delete: " + String.valueOf(selected) + "?"))) == 1 && !this.serverManager.removeServer(selected, false) && (answer = OptionDialog.showOptionDialogWithCancelAsDefaultButton((Component)this.getComponent(), (String)"Active Server Configuration!", (String)"Database connections are still active!\nAre you sure you want to terminate connections and delete server?", (String)"Yes", (int)2)) == 1) {
            this.serverManager.removeServer(selected, true);
        }
    }

    private void defineBsimServer() {
        CreateBsimServerInfoDialog dialog = new CreateBsimServerInfoDialog();
        DockingWindowManager.showDialog((DialogComponentProvider)dialog);
        BSimServerInfo newServerInfo = dialog.getBsimServerInfo();
        if (newServerInfo != null) {
            this.serverManager.addServer(newServerInfo);
            this.lastAdded = newServerInfo;
            Swing.runLater(() -> this.serverTable.setSelectedRowObject((Object)newServerInfo));
        }
    }

    private JComponent buildMainPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.serverTableModel = new BSimServerTableModel(this.serverManager);
        this.serverTable = new GFilterTable((RowObjectTableModel)this.serverTableModel);
        GTable table = this.serverTable.getTable();
        table.setSelectionMode(0);
        table.getSelectionModel().addListSelectionListener(e -> this.notifyContextChanged());
        panel.add((Component)this.serverTable, "Center");
        if (this.serverTableModel.getRowCount() > 0) {
            table.setRowSelectionInterval(0, 0);
        }
        return panel;
    }

    private boolean hasSelection() {
        return this.serverTable.getSelectedRowObject() != null;
    }

    public BSimServerInfo getLastAdded() {
        return this.lastAdded;
    }
}

