/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.gui.search.results;

import docking.widgets.HyperlinkComponent;
import docking.widgets.table.AbstractDynamicTableColumn;
import docking.widgets.table.DiscoverableTableUtils;
import docking.widgets.table.DynamicTableColumn;
import docking.widgets.table.GDynamicColumnTableModel;
import docking.widgets.table.TableColumnDescriptor;
import generic.theme.GThemeDefaults;
import ghidra.app.plugin.core.table.TableComponentProvider;
import ghidra.app.util.query.TableService;
import ghidra.docking.settings.Settings;
import ghidra.features.bsim.query.facade.SFQueryResult;
import ghidra.features.bsim.query.protocol.SimilarityResult;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.database.symbol.FunctionSymbol;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.util.Msg;
import ghidra.util.datastruct.Accumulator;
import ghidra.util.exception.CancelledException;
import ghidra.util.table.AddressBasedTableModel;
import ghidra.util.table.GhidraProgramTableModel;
import ghidra.util.table.field.AbstractProgramBasedDynamicTableColumn;
import ghidra.util.table.field.AddressTableColumn;
import ghidra.util.table.field.FunctionSignatureTableColumn;
import ghidra.util.table.field.LabelTableColumn;
import ghidra.util.task.TaskMonitor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;

class DisplayFunctionsPanel
extends JPanel {
    private static final String SHOW_TABLE_HREF_NAME = "ShowTable";
    private static final Color MARKER_COLOR = GThemeDefaults.Colors.Palette.getColor((String)"lightskyblue");
    private HyperlinkComponent functionsHTMLComponent;
    private TableComponentProvider<?> tableProvider;
    private final ServiceProvider serviceProvider;
    private Set<FunctionSymbol> selectedFunctions;
    private Map<String, Integer> functionMatchMap = new HashMap<String, Integer>();
    private String description;

    DisplayFunctionsPanel(ServiceProvider serviceProvider, String desc) {
        super(new BorderLayout());
        this.serviceProvider = serviceProvider;
        this.description = desc;
        this.functionsHTMLComponent = new HyperlinkComponent(this.getNoFunctionsSelectedMessage());
        this.functionsHTMLComponent.addHyperlinkListener(SHOW_TABLE_HREF_NAME, e -> {
            if (e.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
                return;
            }
            this.showAllSelectedFunctionsTable();
        });
        this.add((Component)this.functionsHTMLComponent, "Center");
    }

    public void loadQueryResults(SFQueryResult queryResult) {
        this.parseFunctionMatchCounts(queryResult);
    }

    private String getNoFunctionsSelectedMessage() {
        StringBuilder buffy = new StringBuilder();
        buffy.append("<html><font color=\"" + String.valueOf(GThemeDefaults.Colors.Palette.GRAY) + "\"><i>No functions selected</i></font>");
        return buffy.toString();
    }

    void close() {
        if (this.tableProvider != null) {
            this.tableProvider.removeFromTool();
            this.tableProvider = null;
        }
        this.selectedFunctions = null;
    }

    void setSelectedFunctions(Set<FunctionSymbol> functions) {
        this.selectedFunctions = functions;
        if (this.tableProvider != null && this.tableProvider.isInTool()) {
            this.tableProvider.removeFromTool();
            this.tableProvider = null;
        }
        if (functions.isEmpty()) {
            this.functionsHTMLComponent.setText(this.getNoFunctionsSelectedMessage());
            return;
        }
        String text = this.createTextForSelectedFunctions(functions);
        this.functionsHTMLComponent.setText(text);
    }

    private String createTextForSelectedFunctions(Set<FunctionSymbol> functions) {
        if (functions.isEmpty()) {
            return "";
        }
        StringBuilder buffy = new StringBuilder();
        int count = functions.size();
        Function firstFunc = (Function)functions.iterator().next().getObject();
        String programName = firstFunc.getProgram().getDomainFile().getPathname();
        buffy.append(this.description).append(" ");
        buffy.append(firstFunc.getName());
        if (count > 1) {
            buffy.append(" and ");
            buffy.append(count - 1);
            buffy.append(" other function");
        }
        if (count > 2) {
            buffy.append("s");
        }
        buffy.append(" from ");
        buffy.append(programName);
        buffy.append(" <a href=\"").append(SHOW_TABLE_HREF_NAME).append("\">");
        buffy.append("<font color=\"" + String.valueOf(GThemeDefaults.Colors.Palette.BLUE) + "\">");
        buffy.append(" (show table) ");
        buffy.append("</font>");
        buffy.append("</a>");
        return buffy.toString();
    }

    private void showAllSelectedFunctionsTable() {
        TableService tableService;
        if (this.tableProvider != null) {
            if (this.tableProvider.isInTool()) {
                this.tableProvider.setVisible(true);
                return;
            }
            this.tableProvider = null;
        }
        if ((tableService = (TableService)this.serviceProvider.getService(TableService.class)) == null) {
            Msg.showWarn(this.getClass(), (Component)this, (String)"No Table Service Found", (Object)"Unable to locate the Table Service.  Make sure the plugin is installed.");
            return;
        }
        FunctionSymbol arbitraryFunction = this.selectedFunctions.iterator().next();
        Program program = arbitraryFunction.getProgram();
        SelectedFunctionsModel model = new SelectedFunctionsModel(program, this.serviceProvider, this.selectedFunctions);
        this.tableProvider = tableService.showTableWithMarkers("Selected Query Functions", "QueryDialogTable", (GhidraProgramTableModel)model, MARKER_COLOR, null, "Selected Query Functions", null);
    }

    private void parseFunctionMatchCounts(SFQueryResult queryResult) {
        List<SimilarityResult> results = queryResult.getSimilarityResults();
        for (SimilarityResult result : results) {
            String funcName = result.getBase().getFunctionName();
            this.functionMatchMap.put(funcName, result.getTotalCount());
        }
    }

    private class SelectedFunctionsModel
    extends AddressBasedTableModel<Function> {
        private final List<FunctionSymbol> functions;

        SelectedFunctionsModel(Program program, ServiceProvider serviceProvider, Set<FunctionSymbol> functions) {
            super("Selected Query Functions", serviceProvider, program, null);
            this.functions = new ArrayList<FunctionSymbol>(functions);
        }

        protected TableColumnDescriptor<Function> createTableColumnDescriptor() {
            TableColumnDescriptor descriptor = new TableColumnDescriptor();
            descriptor.addVisibleColumn(DiscoverableTableUtils.adaptColumForModel((GDynamicColumnTableModel)this, (AbstractDynamicTableColumn)new LabelTableColumn()));
            descriptor.addVisibleColumn(DiscoverableTableUtils.adaptColumForModel((GDynamicColumnTableModel)this, (AbstractDynamicTableColumn)new AddressTableColumn()), 1, true);
            descriptor.addVisibleColumn(DiscoverableTableUtils.adaptColumForModel((GDynamicColumnTableModel)this, (AbstractDynamicTableColumn)new FunctionSignatureTableColumn()));
            descriptor.addVisibleColumn((DynamicTableColumn)new MatchCountTableColumn());
            return descriptor;
        }

        public Address getAddress(int row) {
            Function function = (Function)this.getRowObject(row);
            return function.getEntryPoint();
        }

        protected void doLoad(Accumulator<Function> accumulator, TaskMonitor monitor) throws CancelledException {
            for (FunctionSymbol sym : this.functions) {
                Object obj = sym.getObject();
                if (obj == null) continue;
                accumulator.add((Object)((Function)obj));
            }
        }

        public ProgramLocation getProgramLocation(int row, int column) {
            return null;
        }
    }

    private class MatchCountTableColumn
    extends AbstractProgramBasedDynamicTableColumn<Function, Integer> {
        private MatchCountTableColumn() {
        }

        public String getColumnName() {
            return "Matches";
        }

        public Integer getValue(Function rowObject, Settings settings, Program program, ServiceProvider serviceProvider) throws IllegalArgumentException {
            if (DisplayFunctionsPanel.this.functionMatchMap == null) {
                return 0;
            }
            return DisplayFunctionsPanel.this.functionMatchMap.get(rowObject.getName());
        }
    }
}

