/*
 * Decompiled with CFR 0.152.
 */
package ghidra.dbg.jdi.model;

import ghidra.dbg.DebuggerObjectModel;
import ghidra.dbg.jdi.model.JdiModelTargetObjectImpl;
import ghidra.dbg.jdi.model.JdiModelTargetReferenceType;
import ghidra.dbg.jdi.model.JdiModelTargetSectionContainer;
import ghidra.dbg.target.TargetMemoryRegion;
import ghidra.dbg.target.TargetSection;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetElementType;
import ghidra.dbg.target.schema.TargetObjectSchema;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import ghidra.program.model.address.AddressRange;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

@TargetObjectSchemaInfo(name="ConstantPool", elements={@TargetElementType(type=Void.class)}, elementResync=TargetObjectSchema.ResyncMode.ONCE, attributes={@TargetAttributeType(type=Void.class)}, canonicalContainer=true)
public class JdiModelTargetConstantPool
extends JdiModelTargetObjectImpl
implements TargetMemoryRegion,
TargetSection {
    private AddressRange range;
    private byte[] pool;

    public JdiModelTargetConstantPool(JdiModelTargetSectionContainer parent, byte[] pool, boolean isElement) {
        super(parent, "Constant Pool", pool, isElement);
        this.pool = pool;
        this.range = this.impl.getAddressRange(this.getClassType(), pool.length);
        this.changeAttributes(List.of(), List.of(), Map.of("_display", this.getDisplay(), "_module", parent.getClassType(), "_readable", true, "_memory", parent, "_range", this.range), "Initialized");
    }

    public CompletableFuture<Void> requestAttributes(DebuggerObjectModel.RefreshBehavior refresh) {
        this.range = this.impl.getAddressRange(this.getClassType(), this.pool.length);
        if (this.range != null) {
            this.changeAttributes(List.of(), List.of(), Map.of(), "Initialized");
        }
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> init() {
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public String getDisplay() {
        JdiModelTargetReferenceType classType = this.getClassType();
        return classType.getName() + ": ConstPool" + String.valueOf(this.range);
    }

    private JdiModelTargetReferenceType getClassType() {
        JdiModelTargetReferenceType classType = ((JdiModelTargetSectionContainer)this.parent).getClassType();
        return classType;
    }

    public AddressRange getRange() {
        return this.range;
    }

    public byte[] getPool() {
        return this.pool;
    }
}

