/*
 * Decompiled with CFR 0.152.
 */
package ghidra.dbg.jdi.model;

import com.sun.jdi.Method;
import ghidra.async.AsyncFence;
import ghidra.dbg.DebuggerObjectModel;
import ghidra.dbg.jdi.model.JdiModelTargetMethod;
import ghidra.dbg.jdi.model.JdiModelTargetObjectImpl;
import ghidra.dbg.jdi.model.JdiModelTargetReferenceType;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetElementType;
import ghidra.dbg.target.schema.TargetObjectSchema;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

@TargetObjectSchemaInfo(name="TargetMethodContainer", elements={@TargetElementType(type=JdiModelTargetMethod.class)}, elementResync=TargetObjectSchema.ResyncMode.ONCE, attributes={@TargetAttributeType(type=Void.class)}, canonicalContainer=true)
public class JdiModelTargetMethodContainer
extends JdiModelTargetObjectImpl {
    protected final JdiModelTargetReferenceType reftype;
    private final Map<String, JdiModelTargetMethod> methodsByName = new HashMap<String, JdiModelTargetMethod>();
    private boolean useAll;

    public JdiModelTargetMethodContainer(JdiModelTargetReferenceType reftype, boolean all) {
        super(reftype, all ? "Methods (All)" : "Methods");
        this.reftype = reftype;
        this.useAll = all;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CompletableFuture<Void> updateUsingMethods(Map<String, Method> byName) {
        List methods;
        JdiModelTargetMethodContainer jdiModelTargetMethodContainer = this;
        synchronized (jdiModelTargetMethodContainer) {
            methods = byName.values().stream().map(this::getTargetMethod).collect(Collectors.toList());
        }
        AsyncFence fence = new AsyncFence();
        for (JdiModelTargetMethod m : methods) {
            fence.include(m.init());
        }
        return fence.ready().thenAccept(__ -> this.changeElements(List.of(), methods, Map.of(), "Refreshed"));
    }

    protected CompletableFuture<Void> requestElements(DebuggerObjectModel.RefreshBehavior refresh) {
        HashMap<String, Method> map = new HashMap<String, Method>();
        List<Method> methods = this.useAll ? this.reftype.reftype.allMethods() : this.reftype.reftype.methods();
        for (Method var : methods) {
            map.put(var.name(), var);
        }
        this.getMethodsByName().keySet().retainAll(map.keySet());
        return this.updateUsingMethods(map);
    }

    protected synchronized JdiModelTargetMethod getTargetMethod(Method method) {
        return this.getMethodsByName().computeIfAbsent(method.name(), n -> (JdiModelTargetMethod)this.getInstance(method));
    }

    public synchronized JdiModelTargetMethod getTargetMethodIfPresent(String name) {
        return this.getMethodsByName().get(name);
    }

    @Override
    public CompletableFuture<Void> init() {
        AsyncFence fence = new AsyncFence();
        for (JdiModelTargetMethod method : this.methodsByName.values()) {
            fence.include(method.init());
        }
        return fence.ready();
    }

    public Map<String, JdiModelTargetMethod> getMethodsByName() {
        return this.methodsByName;
    }
}

