/*
 * Decompiled with CFR 0.152.
 */
package ghidra.dbg.jdi.model;

import com.sun.jdi.Mirror;
import ghidra.dbg.DebuggerObjectModel;
import ghidra.dbg.agent.AbstractDebuggerObjectModel;
import ghidra.dbg.agent.DefaultTargetObject;
import ghidra.dbg.jdi.manager.JdiCause;
import ghidra.dbg.jdi.manager.JdiStateListener;
import ghidra.dbg.jdi.model.JdiModelImpl;
import ghidra.dbg.jdi.model.JdiModelTargetSectionContainer;
import ghidra.dbg.jdi.model.JdiModelTargetVM;
import ghidra.dbg.jdi.model.iface2.JdiModelTargetObject;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.util.PathUtils;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public class JdiModelTargetObjectImpl
extends DefaultTargetObject<TargetObject, JdiModelTargetObject>
implements JdiModelTargetObject {
    protected final JdiModelImpl impl;
    protected final Mirror mirror;
    protected final Object object;
    protected String display;
    protected final JdiStateListener accessListener = this::checkExited;
    protected JdiModelTargetVM targetVM;
    private boolean modified;

    public static String keyObject(String id) {
        return PathUtils.makeKey((String)id);
    }

    public JdiModelTargetObjectImpl(JdiModelTargetObject parent, String id) {
        super((AbstractDebuggerObjectModel)parent.getModelImpl(), (TargetObject)parent, id, "Object");
        this.impl = parent.getModelImpl();
        this.mirror = (Mirror)parent.getObject();
        this.object = null;
        this.display = id;
        if (this.mirror != null) {
            this.targetVM = this.impl.getTargetVM(this.mirror);
            this.targetVM.setTargetObject(String.valueOf(parent) + ":" + id, null, this);
        }
        this.display = this.getDisplay();
        this.changeAttributes(List.of(), List.of(), Map.of("_display", this.display), "Initialized");
    }

    public JdiModelTargetObjectImpl(JdiModelTargetObject parent, String id, Object object, boolean isElement) {
        super((AbstractDebuggerObjectModel)parent.getModelImpl(), (TargetObject)parent, isElement ? JdiModelTargetObjectImpl.keyObject(id) : id, "Object");
        this.impl = parent.getModelImpl();
        this.mirror = object instanceof Mirror ? (Mirror)object : null;
        this.object = object;
        this.display = id;
        if (this.mirror != null) {
            this.targetVM = this instanceof JdiModelTargetVM ? (JdiModelTargetVM)this : this.impl.getTargetVM(this.mirror);
            this.targetVM.setTargetObject(id, object == null ? id : object, this);
        }
        this.display = this.getDisplay();
        this.changeAttributes(List.of(), List.of(), Map.of("_display", this.display), "Initialized");
    }

    public JdiModelTargetObjectImpl(JdiModelTargetSectionContainer parent) {
        super((AbstractDebuggerObjectModel)parent.getModelImpl(), (TargetObject)parent, JdiModelTargetObjectImpl.keyObject("NULL_SPACE"), "Object");
        this.impl = parent.getModelImpl();
        this.mirror = parent.mirror;
        this.display = "NULL_SPACE";
        this.object = this.display;
    }

    public CompletableFuture<Void> init() {
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public JdiModelImpl getModelImpl() {
        return this.impl;
    }

    public String getDisplay() {
        return this.display;
    }

    @Override
    public Object getObject() {
        return this.object;
    }

    @Override
    public JdiModelTargetObject getTargetObject(Object obj) {
        if (this.targetVM != null) {
            return this.targetVM.getTargetObject(obj);
        }
        return null;
    }

    protected void checkExited(Integer state, JdiCause cause) {
        switch (state) {
            case 5: {
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                this.onStopped();
                break;
            }
            case 0: {
                break;
            }
            case 2: {
                break;
            }
            case 1: {
                this.resetModified();
                this.onRunning();
                break;
            }
        }
    }

    protected void onRunning() {
    }

    protected void onStopped() {
        Map existingAttributes = this.getCachedAttributes();
        Boolean autoupdate = (Boolean)existingAttributes.get("autoupdate");
        if (autoupdate != null && autoupdate.booleanValue()) {
            this.requestAttributes(DebuggerObjectModel.RefreshBehavior.REFRESH_ALWAYS);
            this.requestElements(DebuggerObjectModel.RefreshBehavior.REFRESH_ALWAYS);
        }
    }

    public void setModified(boolean modified) {
        if (modified) {
            this.changeAttributes(List.of(), List.of(), Map.of("_modified", modified), "Refreshed");
        }
    }

    public void resetModified() {
        this.changeAttributes(List.of(), List.of(), Map.of("_modified", false), "Refreshed");
    }

    public TargetObject searchForSuitable(Class<? extends TargetObject> type) {
        List pathToClass = this.model.getRootSchema().searchForSuitable(type, this.path);
        return this.model.getModelObject(pathToClass);
    }
}

