/*
 * Decompiled with CFR 0.152.
 */
package ghidra.dbg.jdi.model;

import com.sun.jdi.Location;
import ghidra.dbg.DebuggerObjectModel;
import ghidra.dbg.jdi.model.JdiModelTargetLocation;
import ghidra.dbg.jdi.model.JdiModelTargetObjectImpl;
import ghidra.dbg.jdi.model.JdiModelTargetRegisterContainer;
import ghidra.dbg.jdi.model.iface2.JdiModelTargetObject;
import ghidra.dbg.target.TargetRegister;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetElementType;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import ghidra.dbg.util.ConversionUtils;
import ghidra.program.model.address.Address;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

@TargetObjectSchemaInfo(name="RegisterDescriptor", elements={@TargetElementType(type=Void.class)}, attributes={@TargetAttributeType(name="_container", type=JdiModelTargetRegisterContainer.class), @TargetAttributeType(type=Void.class)})
public class JdiModelTargetRegister
extends JdiModelTargetObjectImpl
implements TargetRegister {
    protected final String name;
    protected Address addr;

    public JdiModelTargetRegister(JdiModelTargetObject parent, String name, boolean isElement) {
        super(parent, name, name, isElement);
        this.name = name;
        this.changeAttributes(List.of(), List.of(), Map.of("_display", this.getDisplay(), "_container", parent, "_length", 64), "Initialized");
    }

    public CompletableFuture<Void> requestAttributes(DebuggerObjectModel.RefreshBehavior refresh) {
        this.changeAttributes(List.of(), List.of(), Map.of("_display", this.getDisplay()), "Initialized");
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> init() {
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public String getDisplay() {
        if (this.name == null) {
            return super.getDisplay();
        }
        return this.addr == null ? this.name : this.name + ":" + String.valueOf(this.addr);
    }

    public byte[] readRegister(Location location) {
        Address oldval = (Address)this.getCachedAttribute("_value");
        this.addr = JdiModelTargetLocation.getAddressFromLocation(this.impl, location);
        this.changeAttributes(List.of(), List.of(), Map.of("_display", this.getDisplay(), "_value", this.addr), "Initialized");
        this.setModified(!this.addr.equals((Object)oldval));
        byte[] bytes = ConversionUtils.bigIntegerToBytes((int)(this.getBitLength() / 8), (BigInteger)this.addr.getOffsetAsBigInteger());
        return bytes;
    }
}

