/*
 * Decompiled with CFR 0.152.
 */
package ghidra.dbg.jdi.model;

import com.sun.jdi.Location;
import ghidra.dbg.DebuggerObjectModel;
import ghidra.dbg.jdi.model.JdiModelTargetLocation;
import ghidra.dbg.jdi.model.JdiModelTargetObjectImpl;
import ghidra.dbg.jdi.model.JdiModelTargetRegister;
import ghidra.dbg.jdi.model.JdiModelTargetStackFrame;
import ghidra.dbg.jdi.model.JdiModelTargetThread;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.TargetRegisterBank;
import ghidra.dbg.target.TargetRegisterContainer;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetElementType;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import ghidra.util.Msg;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

@TargetObjectSchemaInfo(name="TargetRegisterContainer", elements={@TargetElementType(type=JdiModelTargetRegister.class)}, attributes={@TargetAttributeType(type=Void.class)}, canonicalContainer=true)
public class JdiModelTargetRegisterContainer
extends JdiModelTargetObjectImpl
implements TargetRegisterBank,
TargetRegisterContainer {
    private final Map<String, JdiModelTargetRegister> registersByName = new HashMap<String, JdiModelTargetRegister>();
    private JdiModelTargetThread thread;
    private JdiModelTargetRegister pc;
    private JdiModelTargetRegister sp;
    private JdiModelTargetRegister retAddr;

    public JdiModelTargetRegisterContainer(JdiModelTargetThread thread) {
        super(thread, "Registers");
        this.thread = thread;
        this.pc = new JdiModelTargetRegister(this, "PC", true);
        this.sp = new JdiModelTargetRegister(this, "SP", true);
        this.retAddr = new JdiModelTargetRegister(this, "return_address", true);
        this.registersByName.put(this.pc.getName(), this.pc);
        this.registersByName.put(this.sp.getName(), this.sp);
        this.registersByName.put(this.retAddr.getName(), this.retAddr);
        this.changeElements(List.of(), List.of(this.pc, this.sp, this.retAddr), "Initialized");
        this.changeAttributes(List.of(), List.of(), Map.of("_display", this.getName(), "_descriptions", this), "Initialized");
    }

    protected synchronized JdiModelTargetRegister getTargetRegister(String rname) {
        return this.registersByName.computeIfAbsent(rname, n -> new JdiModelTargetRegister(this, rname, true));
    }

    public synchronized JdiModelTargetRegister getTargetMethodIfPresent(String rname) {
        return this.registersByName.get(rname);
    }

    public CompletableFuture<? extends Map<String, byte[]>> readRegistersNamed(Collection<String> names) {
        byte[] bytes;
        JdiModelTargetLocation loc;
        HashMap<String, byte[]> map = new HashMap<String, byte[]>();
        Location pcLoc = this.thread.getLocation();
        Object spLoc = null;
        Location raLoc = null;
        JdiModelTargetStackFrame targetFrame = this.thread.stack.getTargetFrame(1);
        if (targetFrame != null && (loc = targetFrame.location) != null) {
            raLoc = loc.location;
        }
        if (pcLoc != null) {
            bytes = this.pc.readRegister(pcLoc);
            map.put(this.pc.getIndex(), bytes);
        }
        if (raLoc != null) {
            bytes = this.retAddr.readRegister(raLoc);
            map.put(this.retAddr.getIndex(), bytes);
        }
        if (!map.isEmpty()) {
            this.broadcast().registersUpdated((TargetObject)this, map);
        }
        return CompletableFuture.completedFuture(map);
    }

    public CompletableFuture<Void> writeRegistersNamed(Map<String, byte[]> values) {
        return null;
    }

    public void invalidateRegisterCaches() {
        this.broadcast().invalidateCacheRequested((TargetObject)this);
    }

    protected CompletableFuture<?> update() {
        return this.fetchElements(DebuggerObjectModel.RefreshBehavior.REFRESH_ALWAYS).exceptionally(e -> {
            Msg.error((Object)this, (Object)("Could not update registers " + String.valueOf(this) + " on STOPPED"));
            return null;
        });
    }
}

